<?php
/**
 * Actions WPLMS Appointments
 *
 * @author      VibeThemes
 * @category    Init
 * @package     wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



class Vibe_Appointments_Actions{


    public $user_id = null;
    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Actions();
        return self::$instance;
    }
    


    function __construct(){
        add_action('bp_setup_nav',array($this,'setup_nav'));
        add_action('wp_enqueue_scripts',array($this,'enqueue_script'));
        add_action('wp_footer',array($this,'cart_checkout_script'));

        add_action('vibe_appointments_booking_confirmed',array($this,'generate_meeting'),11,2);
        

        add_action('init',array($this,'expired_slots_clear'));
        add_action('expired_slots_clear',array($this,'clear_slots'));

        add_action('vibe_appointments_booking_confirmed',array($this,'record_commissions_in_appointments'),10,2);

        add_filter('vibebp_api_get_user_from_token',function($user,$token){ //setting current class user only       
            if(!empty($user) && is_object($user) && !empty($user->id)) {
                $this->user_id = $user->id;
            }
            
            return $user;
        },999,2);

        add_filter('wplms_course_creation_tabs',array($this,'appointments_unit'));
        add_filter('bp_course_api_get_user_course_status_item_unit_meta',array($this,'bp_course_api_get_user_course_status_item_unit_meta'),10,3);
        add_filter('vibe_appointments_appointment_meta',array($this,'unit_booking_meta_update'),10,1);

        add_action('vibebp_featured_style',array($this,'appointment_instructor_block'),10,2);
        
        add_action('vibebp_featured_style',array($this,'appointment_instructor1_block'),10,2);
        add_action('vibebp_featured_style',array($this,'service_block'),10,2);
        add_action('vibebp_featured_style',array($this,'service_adblock'),10,2);        
        add_action('vibebp_featured_style',array($this,'service_type_block'),10,2);
        add_action('vibebp_featured_style',array($this,'service_type_alt_block'),10,2);
        add_action('vibebp_carousel_styles_scripts',array($this,'service_type_block_styles'),10,2);
        add_action('vibebp_get_group_data',array($this,'group_data'),10,2);
        
        add_action('vibe_appointments_booking_cancelled',array($this,'cancel_meeting'),11,2);
        add_action('vibe_appointments_booking_cancelled',array($this,'commission_reversal'),10,3);
    }  

    

    function group_data($type,$group_id){

        wp_enqueue_style('class_directory-css',plugins_url('../assets/css/class_directory.css',__FILE__),[],VIBE_APPOINTMENTS_VERSION);

        if($type == 'class_rating'){
            if(function_exists('groups_get_groupmeta')){
                $rating = groups_get_groupmeta($group_id,'rating',true);
            }
                
            if(empty($rating)){$rating = esc_html__('N.A','vibe-appointments');}

            global $wpdb;
            $count = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM {$wpdb->commentmeta} WHERE meta_key = 'group_id' AND meta_value = %d",$group_id));


            echo '<span style="display:flex;gap:0.5rem;align-items:center">';
            if(is_numeric($rating)){
                echo '<div class="instructor_star_rating_wrapper">
                                <strong class="instructor_star_rating">
                                <span class="blank_stars"><span style="width:'.round($rating*100/5,2).'%;" class="filled_stars"></span></span>
                                </strong>';    
                              echo '</div>';
            }else{
                echo '<svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="20px" height="20px" viewBox="0 0 36 36"><path fill="currentColor" d="M19.6859343,0.861782958 L24.8136328,8.05088572 C25.0669318,8.40601432 25.4299179,8.6717536 25.8489524,8.80883508 L34.592052,11.6690221 C35.6704701,12.021812 36.2532905,13.1657829 35.8938178,14.2241526 C35.8056709,14.4836775 35.6647294,14.7229267 35.4795411,14.9273903 L29.901129,21.0864353 C29.5299163,21.4962859 29.3444371,22.0366367 29.3872912,22.5833831 L30.1116131,31.8245163 C30.1987981,32.9368499 29.3506698,33.9079379 28.2172657,33.993502 C27.9437428,34.0141511 27.6687736,33.9809301 27.4085205,33.8957918 L18.6506147,31.0307612 C18.2281197,30.8925477 17.7713439,30.8925477 17.3488489,31.0307612 L8.59094317,33.8957918 C7.51252508,34.2485817 6.34688429,33.6765963 5.98741159,32.6182265 C5.90066055,32.3628116 5.86681029,32.0929542 5.88785051,31.8245163 L6.61217242,22.5833831 C6.65502653,22.0366367 6.46954737,21.4962859 6.09833466,21.0864353 L0.519922484,14.9273903 C-0.235294755,14.0935658 -0.158766688,12.8167745 0.690852706,12.0755971 C0.899189467,11.8938516 1.14297067,11.7555303 1.40741159,11.6690221 L10.1505113,8.80883508 C10.5695458,8.6717536 10.9325319,8.40601432 11.1858308,8.05088572 L16.3135293,0.861782958 C16.9654141,-0.0521682813 18.2488096,-0.274439442 19.1800736,0.365326425 C19.3769294,0.500563797 19.5481352,0.668586713 19.6859343,0.861782958 Z"></path></svg> '.$rating;
            }
            
            echo '<span>'.sprintf(__(' %d reviews for this class','vibe-appointments'),$count).'</span></span>';
        }


        if($type == 'class_instructor'){
            
            global $bp;
            if(bp_current_component() == 'group'){
                print_r($bp);
            }else{
                $post = groups_get_group($group_id);    
            }
            
            $avatar = bp_core_fetch_avatar(array(
                'item_id'   => $post->creator_id,
                'object'    => 'user',
                'type'      =>'full',
                'html'      => false
            ));
            $link = bp_core_get_user_domain($post->creator_id);
            $name = bp_core_get_user_displayname($post->creator_id);            
            if(empty($avatar)){
                $avatar = plugins_url('../assets/images/avatar.jpg',__FILE__);
            }
            $settings = vibe_appointments_get_settings();
            $average_rating = get_user_meta($post->id,'appointment_average_rating',true);

            if(empty($average_rating)){$average_rating=5;}

            if(function_exists('vibebp_plugin_update')){
                wp_enqueue_script('vibebp-members-actions',VIBEBP_PLUGIN_URL.'/assets/js/actions.js',array('wp-element','wp-data'),VIBEBP_VERSION,true);
                wp_localize_script('vibebp-members-actions','vibebpactions',apply_filters('vibebpactions_translations',array(
                    'api_url'=>apply_filters('vibebp_rest_api',get_rest_url('',Vibe_BP_API_NAMESPACE)),
                    'friends'=>bp_is_active('friends')?1:0,
                    'followers'=>vibebp_get_setting('followers','bp')?1:0,
                    'translations'=>array(
                        'message_text'=>__('Type message','vibebp'),
                        'message_subject'=>__('Message subject','vibebp'),
                        'cancel'=>__('Cancel','vibebp'),
                        'offline'=>__('Offline','vibebp'),
                    )
                )));
            }
    
        ?>
        <div class="member_featured_block_wrapper booking_instructor1_block member_'<?php echo $post->creator_id; ?> flex gap-6" >
                <div class="flex group_class_instructor_avatar">
                    <a href="<?php echo $link;?>" class="flex-1">
                        <img src="<?php echo $avatar; ?>" alt="user profile image" class="member_avatar" />
                    </a>
                </div>
                <div class="member_info flex flex-col gap-4">
                    <div class="flex flex-col flex-2 gap-2">
                        <a href="<?php echo $link;?>" class="flex-col flex">
                            <strong><?php echo esc_attr( $name ); ?></strong>
                        <?php 
                            
                            if(!empty($settings['instructor_sub_field'])){
                                $id= $settings['instructor_sub_field'];
                                if(!empty($id)){
                                    echo '<span class="text-sm">'.xprofile_get_field_data($id,$post->creator_id).'</span>';          
                                }
                            }
                        ?>
                         </a>
                         <?php
                         if(empty($rating)){$rating = 0;}

                            echo '<div class="flex gap-2 items-center"><div class="instructor_star_rating">
                                <span class="blank_stars"></span> 
                                <span class="filled_stars" style="width:'.round(100*$rating/5,2).'%"></span>
                            </div><span>('.(empty($rating)?esc_html__('N.A','vibe-appointments'):$rating).')<span></div>';
                         ?>

                         <?php 
                            if(!empty($settings['appointments_services'])){?>
                            <div class="instructor_card_services_wrapper">
                                <?php echo do_shortcode('[instructor_services user_id="'.$post->creator_id.'"]'); ?>
                            </div>
                        <?php } ?>
                    </div>
                    <div class="flex items-center gap-4">
                        <?php 
                            if(function_exists('vibebp_plugin_update')){
                                ?>
                                <a class="member_action send_message" data-member="<?php echo $post->creator_id; ?>"><span class="button is-primary"><?php echo esc_html__('Send Message','vibe-appointments'); ?></span><span class="hide"><?php echo esc_html__('Message Sent','vibe-appointments'); ?></span></a>
                                <?php
                            }
                            ?>
                    
                        <a href="<?php echo $link; ?>" class="button flex items-center justify-between "><?php echo esc_html__('View Profile','vibe-appointments'); ?> <span class="vicon vicon-arrow-right"></span></a>
                    </div>
            </div>
        </div>
        <?php
        }

        if($type == 'class_price'){

            $settings = vibe_appointments_get_settings();

            if(!empty($settings['class_price']) && function_Exists('groups_get_groupmeta')){
                $pid = groups_get_groupmeta($group_id,$settings['class_price'],true);
                $product = wc_get_product($pid);                
                if(!empty($product)){
                    echo $product->get_price_html();
                }else{
                     echo esc_html__('Request Booking','vibe-appointments');
                }
                
            }
        }



        if($type == 'class_reviews'){

            $settings = vibe_appointments_get_settings();

            if(empty($settings['number'])){$settings['number']=5;}
            if(empty($paged)){$paged=1;}

            ?>
        <div class="instructor_reviews_wrapper">
            <div class="instructor_reviews">
            
                <div class="review_breakup">
                  <?php
                    

                    global $wpdb;
                    $ratings_breakup = $wpdb->get_results($wpdb->prepare("
                        SELECT count(m.meta_value) as count,m.meta_value as rating
                        FROM {$wpdb->commentmeta} as m
                        INNER JOIN {$wpdb->commentmeta} as m1 
                        ON m.comment_id = m1.comment_id
                        WHERE m.meta_key = 'appointment_review_rating'
                        AND m1.meta_key = 'group_id'
                        AND m1.meta_value= %d
                        GROUP BY m.meta_value ",$group_id),ARRAY_A);

                  
                    
                    $breakup=[];$rating_count = $rating_total =0;
                    if(!empty($ratings_breakup)){
                        foreach($ratings_breakup as $rb){
                            $breakup[$rb['rating']]=$rb['count'];
                            $rating_total+=$rb['rating']*$rb['count'];
                            $rating_count+=$rb['count'];
                        }
                    }
                    
                  ?>
                 
                    <div class="rating_snapshot">
                      <h2><?php echo (!empty($breakup)?round($rating_total/$rating_count,2):__('N.A','vibe-appointments')); ?></h2>
                      <?php
                        if($rating_total){
                            $width = round($rating_total/$rating_count,2)*100/5;
                          echo '<div class="instructor_star_rating_wrapper">
                                <strong class="instructor_star_rating">
                                <small class="blank_stars"><small style="width:'.$width.'%;" class="filled_stars"></small></small>
                                </strong>';    
                              echo '</div>';
                              echo '<span>'.sprintf(__('%d ratings','rating count','vibe-appointments'),$rating_count).'</span>';
                        }
                      ?>
                    </div>
                    <ul class="rating_breakup">
                    <?php                     
                      for($i=5;$i>=1;$i--){
                        echo '<li class="'.(empty($breakup[$i])?'':'active').'"><span>'.sprintf(_x('%d stars','star rating','vibe-appointments'),$i).'</span><strong>
                            '.(empty($breakup[$i])?'':'<span style="width:'.round(100*($i/5),2).'%"></span>').'</strong><span>( '.(empty($breakup[$i])?0:$breakup[$i]).' )</span></li>';
                      }
                    ?>
                    </ul>
                  </div>
              
            </div>
            <div class="show_instructor_reviews">
            <?php

            $paged = 1;global $wpdb;
            if(!empty($_GET['paged']) && is_numeric($_GET['paged']) && $_GET_['paged'] <= ceil(count($comments)/$settings['number'])){
                $paged = $_GET['paged'];
            }else{
                $paged = get_query_var('paged');
            }
            if(empty($paged)){
                $paged = 1;
            }
            $comment_ids = $wpdb->get_results($wpdb->prepare("
                SELECT c.comment_ID as cid
                FROM {$wpdb->comments} as c   
                INNER JOIN {$wpdb->commentmeta} as m
                ON c.comment_ID = m.comment_id
                WHERE c.comment_agent = 'appointments' 
                AND c.comment_type = 'instructor_review' 
                AND c.comment_approved = 1
                AND m.meta_key = 'group_id'
                AND m.meta_value = %d
                LIMIT 0,999",$group_id),ARRAY_A);
             $comments = get_comments( array(
                'comment__in' =>wp_list_pluck($comment_ids,'cid'),
                'comment_agent'=>'appointments',
                'number'=>$settings['number'],
                'paged'=>$paged,
                'type' => 'instructor_review'
            ) );
            
            if (empty($comments)) {
                echo '<div id="message" class="message notice"><p>';_e('No Reviews found for instructor.','vibe-appointments');echo '</p></div>';
            }else{
                
                
            ?>

                <ol class="reviewlist commentlist"> 
                <?php 
                      wp_list_comments(array(
                         'type'        =>'instructor_review',
                         'avatar_size' =>120,
                         'per_page'=>$settings['number'],
                         'page'=>$paged,
                         'callback'    => 'vibe_appointments_instructor_reviews'
                         ),$comments
                       ); 
                    
                    echo '<div id="instructor_appointment_reviews" class="pagination">';
                    if(count($comments) > $settings['number']){
                        if($paged >1){
                            if($_GET['paged'] == ceil(count($comments)/$settings['number']) ){
                                echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                                echo '<span>'.$paged.'</span>'; 
                            }else{
                                echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                                echo '<span>'.$paged.'</span>'; 
                                echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>'; 
                            }
                            
                        }else{
                            echo '<span>1</span>';
                            echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>'; 
                        }
                        
                    }
                    
                    if($settings['number'] >= count($comments)){
                        echo '<i>'.sprintf(__('Showing %s out of %s reviews','vibe-appointments'),(($settings['number']*($paged-1))+1).'-'.(
                            (count($comments)<$settings['number']*$paged)?
                                count($comments)
                            :$settings['number']*$paged),count($comments)).'</i>';
                    }
                    echo '</div>';
                  ?>  
                </ol> 
            <?php
              }
            ?>
            </div>
        </div>
        <?php

        }
    }

    function  service_type_block_styles($style,$id = null){
         if($style == 'service_type'){
            add_action('wp_footer',[$this,'service_type_styles']);
         }
         if($style == 'service_type_alt'){
            add_action('wp_footer',[$this,'service_type_alt_styles']);
         }
         if($style == 'service_block'){
             add_action('wp_footer',[$this,'service_block_styles']);
         }
        if($style == 'service_adblock'){
            add_action('wp_footer',[$this,'service_adblock_styles']);
        }

        if($style == 'booking_tutor'){
            $this->booking_tutor_id = $id;
            add_action('wp_footer',[$this,'booking_tutor_styles']);
        }
        if($style == 'booking_tutor1'){
            $this->booking_tutor_id = $id;
            add_action('wp_footer',[$this,'booking_tutor1_styles']);
        }
    }
    
    function service_type_styles(){
        ?>
            <style>
            .service_type_term_block {
                display: flex;
                padding: 1rem 1.5rem;color: #fff;
                border-radius: 1rem;
                background-size: cover;
                display: flex;
                flex-direction: column;
                gap: 1rem;
            }.service_type_term_block a{color:#fff;}
            .service_type_term_block strong{font-size: 1.5em;}
        </style>
        <?php
    }

    function service_type_alt_styles(){
        ?>
            <style>
            .service_type_alt_term_block > a{
                display:flex;
                flex-direction:column;
                gap:0.5rem;
                justify-content:flex-start;
                align-items:center;
                border:1px solid var(--border);
                border-radius:1rem;
                background:var(--contentbg);
                padding:1.5rem 1rem;
                    font-size: 0.875rem;
            }.service_type_alt_term_block > a > strong{
                font-size: 1.16rem;
                font-wight: 600;
            }
            .service_type_alt_term_block > a > .vicon,
            .service_type_alt_term_block > a > img{font-size:3rem; width:3rem; height:auto;}
        </style>
        <?php
    }

    function service_block_styles(){
            ?>
            <style>
                .service_block_upper {
                    display: flex;
                    gap: 1rem;
                    align-items: center;
                    flex-direction: column;
                    align-items: center;
                }

                .service_block {
                    background:#fff;
                    border-radius:0.5rem;
                    border:1px solid var(--border);
                    display:flex;
                    flex-direction:column;gap:0.5rem;
                    overflow: hidden;
                }
                .service_block_upper .featured_image{
                    border-radius: 5px;
                    flex: 1;overflow: hidden;
                }
                .service_block_upper .featured_image img{transition: all 0.2s;}
                .service_block:hover .service_block_upper .featured_image img{
                    transform: scale(1.2);
                }
                .service_block_title{
                    flex: 2;
                    display: flex;
                    flex-direction: column;
                    align-items: center;
                    gap: 0.5rem;
                }
                .service_block_title h5{line-height: 1;font-size:1.2rem;font-weight:600;}
                .service_block_meta{    
                    padding: 1rem;
                    display: flex;
                    align-items: center;
                    justify-content: space-between;
                    font-size: 0.875rem;
                    border-top: 1px solid var(--border);
                }.service_block_meta span{display: flex;gap: 5px;align-items: center;}
            </style>
            <?php
        }
    
        
    function service_adblock_styles(){
            
        ?>
        <style>
            .service_adblock{border-radius: 5px;padding: 3rem 1rem 1rem;    background-size: cover !important;}
            .service_adblock_container {
                padding: 1rem;
                color: #fff;border-radius: 5px;
                background: rgba(255, 255, 255, 0.2);
                -webkit-backdrop-filter: blur(30px);
                backdrop-filter: blur(30px);
                border: 2px solid rgba(255, 255, 255, 0.1);
                box-shadow: 0 0 80px rgb(0 0 0 / 20%);
            }
            .service_adblock_container .service_block_title a{color: #fff;}
        </style>
        <?php
    }


    function booking_tutor_styles(){
            ?>
                <style>
                     .booking_instructor_block {
                        bordeR: 1px solid var(--border);
                        background: #fff;
                        border-radius: 5px;
                        display: flex;
                        flex-direction: column;
                        padding: 1rem;gap: 1rem;
                    }
                    .booking_instructor_block .instructor_star_rating{position:relative;}
                    .booking_instructor_block img.member_avatar {box-shadow: 0 2px 4px var(--border);border-radius: 5px;
                    }.booking_instructor_block .blank_stars{line-height:1;}
                    .service_block .blank_stars:before {
                        content: '★★★★★';
                        color:var(--border);
                }.instructor_star_rating_wrapper strong{font-size:1.2em;}.instructor_star_rating_wrapper small{font-size:1em;}
                    .service_block .filled_stars:before {
                        content: '★★★★★';position:absolute;left:0;top:0;
                        color: var(--bg-primary);
                    }.instructor_Card_services_wrapper {
                    display: flex;gap: 0.5rem;
                    align-items: start;
                    font-size: 0.75rem;
                    flex-direction: column;
                }ul.service_list {display: flex;flex-wrap: wrap;gap: 0.5rem;
                }ul.service_list li{    list-style-type: none !important;}
                
                .booking_instructor_block {display: flex;flex-direction: column;justify-content: space-between;height: 100%;}
                .booking_instructor_block .member_info {flex: 1;display: flex;flex-direction: column;justify-content: space-between;}
                .member_info .button.is-primary{font-size: 0.875rem;padding: 0.625rem;}
                ul.service_list span {
                    padding: 5px;
                    border-left: 3px solid;
                    box-shadow: 0 0 1px #000;
                    display: flex;background: #fff;
                    font-size: 11px;border-radius: 2px;
                    text-transform: uppercase;
                }.instructor_extras {flex: 1;display: flex;flex-direction: column;}
                .instructor_block_end{padding-top: 1rem;border-top: 1px solid rgba(0,0,0,0.1);}
                </style>
            <?php
        }
    function booking_tutor1_styles(){
            wp_enqueue_style('plyr');
            wp_enqueue_script('plyr');
            ?>
                <style>
                     .booking_instructor1_block {
                        bordeR: 1px solid var(--border);
                        background: #fff;
                        border-radius: 5px;
                        display: flex;
                        flex-direction: column;gap: 1rem;
                    }.booking_instructor1_block .member_background,.booking_instructor1_block .member_info{padding:0 1rem 1rem}.booking_instructor1_block .field_type_video iframe{height: auto;width: 100%;min-height: fit-content;}
                    .booking_instructor1_block .instructor_star_rating{position:relative;}
                    .booking_instructor1_block img.member_avatar {box-shadow: 0 1px 2px var(--border);border-radius: 5px;
                    }ul.service_list {display: flex;flex-wrap: wrap;gap: 0.5rem;
                }ul.service_list li{    list-style-type: none !important;}
                
                .booking_instructor1_block {display: flex;flex-direction: column;justify-content: space-between;}
                .booking_instructor1_block .member_info {flex: 1;display: flex;flex-direction: column;justify-content: space-between;}
                .member_info .button.is-primary{font-size: 0.875rem;padding: 0.625rem;}
                ul.service_list span {
                    padding: 5px;
                    border-left: 3px solid;
                    box-shadow: 0 0 1px #000;
                    display: flex;background: #fff;
                    font-size: 11px;border-radius: 2px;
                    text-transform: uppercase;
                }.instructor_extras {flex: 1;display: flex;border-top:1px solid var(--border);padding-top: 1rem;}
                .instructor_extras > div+div {display: flex;flex-direction: column;flex: 1;justify-content: space-between;}
                </style>
                <script>
                    document.addEventListener('DOMContentLoaded',()=>{
                        if(document.querySelector('.field_type_video')){
                            document.querySelectorAll('.field_type_video').forEach(function(el){
                                const player = new Plyr(el);    
                            })
                        }
                    })
                </script>
            <?php
        }
    

    function service_block($post,$style){

         if($style != 'service_block')
            return;
        ?>
        <div class="service_block <?php echo 'serivce_'.$post->ID; ?>">
            
                <?php $labels = get_post_meta($post->ID,'service_labels',true); 
                    if(!empty($labels)){
                        echo '<div class="labels">';
                        foreach($labels as $label){
                            //print_r($labels);
                        }
                        echo '</div>';
                    }
                ?>
            
            <div class="service_block_upper">
                <div class="featured_image">
                    <a href="<?php echo get_permalink($post->ID); ?>" title="<?php the_title_attribute(['post'=>$post]); ?>">
                        <?php echo get_the_post_thumbnail($post); ?>
                    </a>
                </div>
                <div class="service_block_title">
                    <a href="<?php echo get_permalink($post->ID); ?>">
                        <strong><?php echo $post->post_title; ?></strong>
                    </a>
                    <?php
                    echo vibe_appointments_get_instructor_service_rating($post->ID,0,'html');
                    ?>
                </div>
            </div>
            <?php
                $service_types = wp_get_post_terms($post->ID,'service-type');
                if(!empty($services_types)){
                    ?>
                    <div class="service_types"><span><?php _e('for','vibe-appointments');?></span>
                    <?php
                    foreach($service_types as $service_type){
                        ?>
                        <a href="<?php echo get_term_link($service_type,'service-type');?>"><?php echo $service_type->name; ?></a>
                        <?php
                    }
                }
            ?>
            <div class="service_block_down">
                
                    <?php 
                    
                    global $wpdb;
                    $product = $wpdb->get_row($wpdb->prepare("
                        SELECT pm.post_id as product_id,MIN (pm1.meta_value) as price
                        FROM {$wpdb->postmeta} as pm 
                        INNER JOIN {$wpdb->postmeta} as pm1 
                        ON pm.post_id = pm1.post_id 
                        WHERE pm.meta_key = '_appointments_service_id' 
                        AND pm.meta_value = '%d'
                        AND pm1.meta_key = '_price'
                        ",$post->ID),ARRAY_A);
                    ; 
                    if(!empty($product_id)){
                        echo '<div class="service_price">';
                        echo _x('from','price of service','vibe-appointments').' ';
                        $_product = wc_get_product( $product_id );
                        echo $_product->get_price();
                        echo '</div>';
                    }
                    
                    ?>
            </div>
            <div class="service_block_meta">
                <span title="<?php _ex('Number of service providers','help text on icon','vibe-appointments'); ?>"><span class="vicon vicon-user"></span><?php echo do_shortcode('[service_booking_count service="491"]'); ?></span>
                <span title="<?php _ex('Number of times service was booked','help text on icon','vibe-appointments'); ?>"><span class="vicon vicon-time"></span><?php echo vibe_appointments_service_booking_count($post->ID); ?></span>
            </div>
        </div>
        <?php
    }

    function service_adblock($post,$style){

         if($style != 'service_adblock')
            return;
        ?>
        <div class="service_adblock <?php echo 'serivce_'.$post->ID; ?>" style="background:url(<?php echo get_the_post_thumbnail_url($post,'full'); ?>);">
            
            <div class="service_adblock_container">
                <div class="service_block_title">
                    <a href="<?php echo get_permalink($post->ID); ?>">
                        <strong><?php echo $post->post_title; ?></strong>
                    </a>
                    <?php 
                        $lowest_price = get_post_meta($post->ID,'lowest_price',true);
                        if(!empty($lowest_price)){
                            echo ' <div class="service_block_down">';
                            echo sprintf(_x('starts from %s','price of service','vibe-appointments'),$lowest_price['html']);
                            echo '</div>';
                        }
                            
                    ?>
                </div>
            </div>
            
           
            
        </div>
        <?php
    }

    function service_type_block($post,$style){

         if($style != 'service_type')
            return;

        
       
        $background = apply_filters('vibe_appointments_service_type_default_bg','background:radial-gradient(27.19% 67.83% at 101.83% 2.63%, #abb3ff 0%, rgba(171,179,255,0) 100%),linear-gradient(134.39deg, #ea4c89 -6.16%, #4d44c6 85.98%)');

        
        if(!empty($post) && !empty($post->term_id)){
            $tid = get_term_meta($post->term_id,'service_type_thumbnail_id',true);
            if(!empty($tid)){
                $id = wp_get_attachment_image_src($tid,'full');
                if(is_array($id))
                    $background=  'background-image:url('.$id[0].');';
            }

            ?>
                <div class="term_featured_block_wrapper service_type_term_block <?php echo $post->taxonomy.'_'.$post->slug; ?>" style="<?php echo $background; ?>">
                    <a href="<?php echo get_term_link($post,$post->taxonomy);?>">
                        <strong><?php echo esc_attr( $post->name ); ?></strong>
                        <p><?php echo esc_attr( $post->description ); ?></p>
                    </a>
                </div>
            <?php
        }
    }

    function service_type_alt_block($post,$style){

         if($style != 'service_type_alt')
            return;

        
       
       
        if(!empty($post)){
            $tid = get_term_meta($post->term_id,'service_type_thumbnail_id',true);
            if(!empty($tid)){
                $id = wp_get_attachment_image_src($tid,'full');
                if(is_array($id)){
                    $img = $id[0];
                }
            }

            if(Empty($img)){
                $img = '<span class="vicon vicon-heart-broken"></span>';
            }

            ?>
                <div class="term_featured_block_wrapper service_type_alt_term_block <?php echo $post->taxonomy.'_'.$post->slug; ?>" >
                    <a href="<?php echo get_term_link($post,$post->taxonomy);?>">
                        <?php 
                        if(wp_http_validate_url($img)){
                            echo '<img src="'.$img.'" alt="'.$post->name.'" '.(empty($id[1])?'width="'.$id[1].'" height="'.$id[2].'"':'').' />';
                        }else{
                            echo $img;
                        }
                        ?>
                        <strong><?php echo esc_attr( $post->name ); ?></strong>
                        <p><?php echo esc_attr( $post->description ); ?></p>
                    </a>
                </div>
            <?php
        }
    }

    
    function appointment_instructor1_block($post,$style){
        
        if($style != 'booking_tutor1')
            return;

        $avatar = bp_core_fetch_avatar(array(
            'item_id'   => $post->ID,
            'object'    => 'user',
            'type'      =>'thumb',
            'html'      => false
        ));
        $link = bp_core_get_user_domain($post->ID);
        $member_type = bp_get_member_type($post->ID);
        $name = bp_core_get_user_displayname($post->ID);
        $types = bp_get_member_types(array(),'objects');

        $cover_url = bp_attachments_get_attachment(
            'url',
            array(
                'item_id' => $post->ID
            )
        );

        if(empty($avatar)){

            $avatar = plugins_url('../assets/images/avatar.jpg',__FILE__);
        }

        
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        $average_rating = get_user_meta($post->ID,'appointment_average_rating',true);

        if(empty($average_rating)){$average_rating=5;}
    
        ?>
        <div class="member_featured_block_wrapper booking_instructor1_block member_'<?php echo $post->ID; ?> flex flex-col" >
            <?php

            $this->app_settings = vibe_appointments_get_settings();
            
            if(!empty($this->app_settings['instructor_video_field'])){
                $user_id = $post->ID;
                $field_id = $this->app_settings['instructor_video_field'];
                $field = xprofile_get_field( $field_id );
                $value = xprofile_get_field_data($field_id , $user_id);
                $value = vibebp_process_profile_field_data($value,$user_id,$field,[]);

            ?>
            <div class="member_promo_video swiper-no-swiping">
                <div class="<?php echo sanitize_title($field->name).' plyr__video-embed field_type_'.$field->type;?> "><?php echo is_string($value)?do_shortcode(apply_filters('vibebp_profile_field_block_value',$value,$field)):''; ?></div>
            </div>
            <?php 
            } 
            ?>
            <div class="member_background">
                <div class="flex gap-4">
                    <a href="<?php echo $link;?>" class="flex-1 basis-12">
                        <img src="<?php echo $avatar; ?>" alt="user profile image" class="member_avatar" />
                    </a>
                    <div class="flex flex-2">
                        <a href="<?php echo $link;?>" class="flex-col flex">
                            <strong><?php echo esc_attr( $name ); ?></strong>
                        <?php 
                            
                            if(!empty($this->app_settings['instructor_sub_field'])){
                                $id= $this->app_settings['instructor_sub_field'];

                               
                                if(!empty($id)){
                                    echo '<span class="text-sm">'.xprofile_get_field_data($id,$post->id).'</span>';          
                                }
                            }
                            
                             echo do_shortcode('[instructor_labels instructor='.$user_id.']');                            
                        
                        ?>
                         </a>
                    </div>
                </div>
            </div>
            <div class="member_info flex flex-col gap-4">
                <?php 
                    if(!empty($this->settings['appointments_services'])){?>
                    <div class="instructor_Card_services_wrapper">
                        <?php echo do_shortcode('[instructor_services user_id="'.$post->id.'"]'); ?>
                    </div>
                <?php } ?>
                <span class="flex-1">
                   
                </span>
                <div class="instructor_extras">
                    <span class="flex flex-1 justify-between">
                        <span class="flex gap-2">
                        <svg width="16px" height="16px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
                        <g transform="matrix(1,0,0,1,0.188075,7.38624)">
                            <g transform="matrix(0.211691,0,0,0.216207,-58.5149,-50.4719)">
                                <path d="M318.267,265.906C318.267,258.215 324.524,251.958 332.214,251.958C339.905,251.958 346.162,258.215 346.162,265.906C346.162,273.596 339.905,279.853 332.214,279.853C324.524,279.853 318.267,273.596 318.267,265.906ZM342.704,281.755C347.838,278.346 351.233,272.518 351.233,265.906C351.233,255.418 342.702,246.887 332.214,246.887C321.727,246.887 313.195,255.418 313.195,265.906C313.195,272.518 316.59,278.346 321.725,281.755C310.106,286.042 301.784,297.195 301.784,310.284L306.855,310.284C306.855,296.3 318.231,284.925 332.214,284.925C346.198,284.925 357.573,296.3 357.573,310.284L362.645,310.284C362.645,297.195 354.322,286.042 342.704,281.755Z" style="fill-rule:nonzero;"/>
                            </g>
                            <g transform="matrix(0.211691,0,0,0.216207,-58.5149,-50.4719)">
                                <path d="M368.062,269.076C373.197,265.667 376.592,259.838 376.592,253.226C376.592,242.739 368.061,234.208 357.573,234.208C352.492,234.208 347.882,236.221 344.467,239.479C343.202,240.685 342.109,242.063 341.213,243.576C342.795,244.215 344.301,245.005 345.696,245.951C346.593,244.492 347.747,243.213 349.1,242.173C351.452,240.366 354.385,239.279 357.573,239.279C365.264,239.279 371.52,245.536 371.52,253.226C371.52,259.61 367.203,264.993 361.34,266.643C360.14,266.98 358.88,267.174 357.573,267.174C357.124,267.174 356.683,267.148 356.244,267.106C356.153,268.932 355.867,270.704 355.391,272.401C356.115,272.338 356.832,272.246 357.573,272.246C358.603,272.246 359.612,272.325 360.61,272.445C373.164,273.953 382.932,284.651 382.932,297.604L388.004,297.604C388.004,284.516 379.681,273.363 368.062,269.076Z" style="fill-opacity:0.8;fill-rule:nonzero;"/>
                            </g>
                            <g transform="matrix(0.211691,0,0,0.216207,-58.5149,-50.4719)">
                                <path d="M306.855,272.246C307.597,272.246 308.313,272.338 309.038,272.401C308.562,270.704 308.275,268.932 308.185,267.106C307.747,267.148 307.304,267.174 306.855,267.174C305.549,267.174 304.289,266.98 303.089,266.643C297.225,264.993 292.908,259.61 292.908,253.226C292.908,245.536 299.165,239.279 306.855,239.279C310.044,239.279 312.977,240.366 315.329,242.173C316.682,243.213 317.835,244.492 318.732,245.951C320.128,245.005 321.633,244.215 323.215,243.576C322.32,242.063 321.227,240.685 319.962,239.479C316.547,236.221 311.936,234.208 306.855,234.208C296.368,234.208 287.836,242.739 287.836,253.226C287.836,259.838 291.231,265.667 296.366,269.076C284.748,273.363 276.425,284.516 276.425,297.604L281.497,297.604C281.497,284.651 291.264,273.953 303.818,272.445C304.816,272.325 305.826,272.246 306.855,272.246Z" style="fill-opacity:0.8;fill-rule:nonzero;"/>
                            </g>
                        </g>
                    </svg>
                        <?php 
                                echo '<span>'.do_shortcode('[instructor_student_count user="'.$post->id.'"]').'</span>';
                        ?>
                    </span>
                    <span class="flex gap-2"><?php
                    echo sprintf(_x('From %s ','price instructor block','vibe-appointments'),'<strong>'.do_shortcode('[instructor_price user="'.$post->id.'"]').'</strong>');
                    ?></span>
                    
                </div>
            </div>
        </div>
        <?php
    }

    function appointment_instructor_block($post,$style){
        if($style != 'booking_tutor')
            return;

        $avatar = bp_core_fetch_avatar(array(
            'item_id'   => $post->id,
            'object'    => 'user',
            'type'      =>'thumb',
            'html'      => false
        ));
        $link = bp_core_get_user_domain($post->id);
        $member_type = bp_get_member_type($post->id);
        $name = bp_core_get_user_displayname($post->id);
        $types = bp_get_member_types(array(),'objects');

        $cover_url = bp_attachments_get_attachment(
            'url',
            array(
                'item_id' => $post->id
            )
        );

        if(empty($avatar)){

            $avatar = plugins_url('../assets/images/avatar.jpg',__FILE__);
        }

        
        if(empty($this->app_settings)){
            $this->app_settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        $average_rating = get_user_meta($post->id,'appointment_average_rating',true);

        if(empty($average_rating)){$average_rating=5;}
    
        ?>
        <div class="member_featured_block_wrapper booking_instructor_block member_'<?php echo $post->id; ?>" >
            
            <div class="member_background">
                <div class="flex gap-4 flex-col">
                    <a href="<?php echo $link;?>" class="flex-1">
                        <img src="<?php echo $avatar; ?>" class="member_avatar" />
                    </a>
                    <div class="flex flex-col gap-4 flex-1">
                        
                        <a href="<?php echo $link;?>" class="flex flex-col">
                            <strong><?php echo esc_attr( $name ); ?></strong>
                           
                        <?php 
                            
                            if(!empty($this->app_settings['instructor_sub_field'])){
                                $id= $this->app_settings['instructor_sub_field'];
                               
                                if(!empty($id)){
                                    echo '<span class="text-sm">'.xprofile_get_field_data($id,$post->id).'</span>';          
                                }
                            }
                            
                        
                        ?>
                         </a>
                         <?php 
                            echo do_shortcode('[instructor_labels user="'.$post->id.'"]');
                        ?>
                    </div>
                </div>
            </div>
            <div class="member_info">
                <span class="flex-1"></span>
                <div class="instructor_extras flex flex-col gap-4">
                    
                    <?php 
                    if(!empty($this->app_settings['appointments_services'])){?>
                    <div class="instructor_Card_services_wrapper">
                        <?php echo do_shortcode('[instructor_services user_id="'.$post->id.'"]'); ?>
                    </div>
                    <?php } ?>
                   <div class="instructor_block_end"><?php
                    echo sprintf(_x('From %s per hour','price instructor block','vibe-appointments'),'<strong>'.do_shortcode('[instructor_price user="'.$post->id.'"]').'</strong>');
                    ?></div>
                </div>
            </div>
        </div>
        <?php
    }
    function generate_meeting($slot,$payment=null){

        $options = vibe_appointments_get_settings();
        $db = new VIBE_APPOINTMENTS_DB;
        $metadb = new VIBE_APPOINTMENTS_META_DB;
        $metas = $metadb->get_appointments_meta(array('appointment_id'=>$slot['appointment_id']));
        if(empty($slot['type'])){
            $_slot = $db->get_appointments(array('appointment_id'=>$slot['appointment_id']));
            if(!empty($_slot)){
                $_slot = $_slot[0];
                $slot['type'] = $_slot['type'];
            }
        }


        //update total hours booked
        if(!empty($slot['author_id']) && !empty($slot['start_date'])){
            $slot['author_id'] = intval($slot['author_id']);
            $hours = intval(get_user_meta($slot['author_id'],'vibe_appointments_instructor_hours_booked',true));
            $hours = $hours + (($slot['end_date']-$slot['start_date'])/(1000*60*60));
            update_user_meta($slot['author_id'],'vibe_appointments_instructor_hours_booked',$hours);
        }
        
        if(!empty($slot['booker_id']) && !empty($slot['start_date'])){
            $slot['booker_id'] = intval($slot['booker_id']);
            $hours = intval(get_user_meta($slot['booker_id'],'vibe_appointments_user_hours_booked',true));
            $hours = $hours + (($slot['end_date']-$slot['start_date'])/(1000*60*60));
            update_user_meta($slot['booker_id'],'vibe_appointments_user_hours_booked',$hours);
        }

        if(!empty($options)){
            $id = 0;
            if (!empty($metas)) {
                foreach ($metas as $meta) {
                    if ($meta['meta_key'] == 'vibe_appointments' && !empty($meta['meta_value'])) {
                        $id = $meta['meta_value']; //if meeting edit the meeting 
                    }
                }
            }
            if(!empty($slot['item_id'])){
                $count = intval(get_post_meta(intval($slot['item_id']),'service_booking_count',true));
                $count++;
                update_post_meta(intval($slot['item_id']),'service_booking_count',$count);
            }

            global $wpdb;
            $old_meetings = $wpdb->get_results("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = 'appointment_id' && meta_value={$slot['appointment_id']}");
            $slot['end_date']=intval($slot['end_date']);
            $slot['start_date']=intval($slot['start_date']);
            if(!empty($slot['end_date']) && !empty($slot['start_date'])){
                if(!empty($old_meetings)){
                    foreach ($old_meetings as $key => $old_meeting) {
                        wp_trash_post($old_meeting->post_id);
                        $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
                        $metas = $appointments_meta_db->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'vibe_zoom'));
                        if(!empty($metas)){
                            foreach ($metas as $key => $m) {
                                $appointments_meta_db->delete_appointment_meta($m['meta_id']);
                            }
                        }

                    }
                }
                
                
            }
            
            if(empty($id) && $slot['author_id']){
                $user_appointments_details_meta = get_user_meta($slot['author_id'],'vibe_appointments_credential',true);
                if(class_exists('Vibe_Zoom') && empty($user_appointments_details_meta)){
                    $user_appointments_details_meta = get_user_meta($slot['author_id'],'vibe_zoom_credential',true);
                }
                if(empty($user_appointments_details_meta) || empty($user_appointments_details_meta['api_key'])){
                    $user_appointments_details_meta=[];
                    $option=get_option('vibe_zoom_settings');
                    if(!empty($option)){
                        $user_appointments_details_meta['api_key']    = (!empty($option['vibe_zoom_api_key'])?$option['vibe_zoom_api_key']:false);
                        $user_appointments_details_meta['api_secret']= (!empty($option['vibe_zoom_secret_key'])?$option['vibe_zoom_secret_key']:false);
                        $user_appointments_details_meta['account_id']= (!empty($option['account_id'])?$option['account_id']:false);
                        
                    }
                    
                }
                
                if(!empty($user_appointments_details_meta['api_key']) && !empty($user_appointments_details_meta['api_secret']) && class_exists('Vibe_Zoom_Video_Conferencing_Api') && defined('VIBE_ZOOM_API_NAMESPACE')){

                    $vibe_appointments_api_init = new Vibe_Zoom_Video_Conferencing_Api($user_appointments_details_meta['api_key'],$user_appointments_details_meta['api_secret'],(!empty($user_appointments_details_meta['account_id'])?$user_appointments_details_meta['account_id']:''));
                    $hosts = array();
                    if(!empty($vibe_appointments_api_init)){
                        $encoded_users = $vibe_appointments_api_init->listUsers();
                        $decoded_users = json_decode( $encoded_users );

                        if ( ! empty( $decoded_users->code ) && $decoded_users->code == 300 ) {
                            $users = false;
                        } else {
                            if(!empty($decoded_users->users)){
                                $users = $decoded_users->users;
                            }
                            
                        }
                        $new_users = array();
                        if(!empty($users)){
                            $users = (array)$users;
                            foreach ($users as $key => $value) {
                                $new_users[$value->id] = $value->first_name.' '.$value->last_name.' ('.$value->email.')';
                            }
                            $hosts = $new_users;
                        }
                    }

                    if(!empty($hosts)){

                        $hosts_keys = array_keys($hosts);
                        
                        if(!empty($hosts_keys[0])){
                            $user = get_user_by( 'id', $slot['author_id']);
                            $shared_values = array($slot['author_id']);
                            if (!empty($slot['booker_id'])) {
                                $shared_values[] = $slot['booker_id'];
                            }
                            $create_args = array(
                                'api_key' =>$user_appointments_details_meta['api_key'],
                                'api_secret'=>$user_appointments_details_meta['api_secret'],
                                'account_id'=>(!empty($user_appointments_details_meta['account_id'])?$user_appointments_details_meta['account_id']:''),
                                "post_title"=>__("Appointment Booking for ","vibe-appointments").$slot['appointment_id'],
                                "post_content"=>__("Appointment Booking for ","vibe-appointments").$slot['appointment_id'],
                                "post_author"=>$slot['author_id'],
                                "meta"=>array(
                                    "start_date"=> date('Y-m-d h:i',($slot['start_date']+$slot['start_time']*60000+get_option('gmt_offset')*60*60000)/1000),
                                    "start_time"=>$slot['start_date'],
                                    "duration"=>((($slot['end_date']-$slot['start_date'])/1000)/60),
                                    //"password"=>rand ( 1000000 , 9999999 ),
                                    "alternative_host_ids"=>[],
                                    "auto_recording"=>false,
                                    "show_recordings"=>false,
                                    "join_before_host"=>false,
                                    "multihostkey"=>"",
                                    "mute_upon_entry"=>false,
                                    "participant_video"=>false,
                                    "host"=>$hosts_keys[0],//get host id
                                    "time_zone"=>"UTC" ,//get time zone
                                    "appointment_id"=>$slot['appointment_id'],

                                ),
                                "shared"=>array(
                                    "shared_type"=>"shared",
                                    "shared_values"=>$shared_values
                                ),
                            );
                            if(!empty($slot['type']) && strpos($slot['type'], 'recurring_')!==false){
                                $days = str_replace('recurring_', '', $slot['type']);
                                $days = explode('_', $days);
                                
                                function check_no($day){
                                    $dow = array(
                                        'MO'=>2,
                                        'TU'=>3,
                                        'WE'=>4,
                                        'TH'=>5,
                                        'FR'=>6,
                                        'SA'=>7,
                                        'SU'=>1,
                                    );
                                    return $dow[$day];
                                }
                                $days = array_map('check_no',$days);
                                if(!empty($days)){
                                    $create_args['meta']['recurrence'] = array(
                                        'type'=>2,
                                        'end_date_time'=>date('Y-m-d',($slot['end_date']/1000)).'T'.date('H:i:s',($slot['end_date']/1000)).'Z',
                                        'weekly_days'=>implode(',', $days),
                                    );
                                    $create_args['meta']['type'] = 8;
                                }
                            }
                            //API request
                            $blog_id = '';
                            if(function_exists('get_current_blog_id')){
                                $blog_id = get_current_blog_id();
                            }

                            /*$post = wp_remote_post(get_rest_url($blog_id,VIBE_ZOOM_API_NAMESPACE).'/user/meetings/new',array(
                                'method'      => 'POST',
                                'timeout'     => 200,
                                'body'        => json_encode($create_args)
                            ));
            
                            $body = wp_remote_retrieve_body($post);*/

                            $api = Vibe_Zoom_API::init();
                            $api->user = (object)array(
                                'id' => $user->ID,
                                'username'=>$user->data->user_login,
                                'slug'=>$user->data->user_nicename,
                                'email'=>$user->data->user_email,
                                'member_type'=>bp_get_member_type($user->ID),
                                'displayname'=>$user->data->display_name,
                                'roles'=> $user->roles,
                                'caps'=> apply_filters('vibebp_user_caps',$user->allcaps,$user),
                                'profile_link'=>vibebp_get_profile_link($user->data->user_nicename)
                            );

                            $request = new WP_REST_Request( 'POST');
                            $request->set_header( 'content-type', 'application/json' );
                            $request->set_body( json_encode($create_args) );

                            $body = $api->new_meeting($request);
            
                            if (!empty($body)) {
                                if (!empty( $body->data) && !empty($body->data['meeting']) && !empty($body->data['meeting']['id'])) { // already meeting connected
                                 
                                    $metadb = new VIBE_APPOINTMENTS_META_DB;
                                    $metadb->add_appointment_meta(array(
                                        'appointment_id'=>$slot['appointment_id'],
                                        'meta_key'=>'vibe_zoom',
                                        'meta_value'=>$body->data['meeting']['id']
                                    ));
                                }
                            }
                        } 
                    }
                }
            }
        }

        if(function_exists('vibebp_bbb_plugin_update')){
            $id = 0;
            if (!empty($metas)) {
                foreach ($metas as $meta) {
                    if ($meta['meta_key'] == 'vibe_bbb' && !empty($meta['meta_value'])) {
                        $id = $meta['meta_value']; //if meeting edit the meeting 
                    }
                }
            }

            if($slot['author_id'] && empty($id)){
                $user = get_user_by( 'id', $slot['author_id']);
                $token = empty($token)?vibebp_generate_token($user):$token;
                $shared_values = array($slot['author_id']);
                if (!empty($slot['booker_id'])) {
                    $shared_values[] = $slot['booker_id'];
                }
                $create_args = array(
                    "post_title"=>__("Appointment Booking for ","vibe-appointments").$slot['appointment_id'],
                    "post_content"=>__("Appointment Booking for ","vibe-appointments").$slot['appointment_id'],
                    "post_author"=>$slot['author_id'],
                    "meta"=>array(
                        "bbb-room-viewer-code"=>"121",
                        "bbb-room-moderator-code"=>"121",
                        "logoutUrl"=>site_url(),
                        "start"=>$slot['start_date'],
                        "duration"=>($slot['end_time']-$slot['start_time'])<0?1440+$slot['end_time']-$slot['start_time']:$slot['end_time']-$slot['start_time'],
                        "duration_value"=>60,
                        "bbb-room-recordable"=>'true',
                        "bbb-room-wait-for-moderator"=>'true'
                    ),
                    "shared"=>array(
                        "shared_type"=>"shared",
                        "shared_values"=>$shared_values
                    ),
                    "token"=>$token
                );
                //API request
                $blog_id = '';
                if(function_exists('get_current_blog_id')){
                    $blog_id = get_current_blog_id();
                }
                
                $post = wp_remote_post(get_rest_url($blog_id,VIBE_BBB_API_NAMESPACE).'/user/meetings/new',array(
                    'method'      => 'POST',
                    'timeout'     => 45,
                    'body'        => json_encode($create_args)
                ));

                $body = wp_remote_retrieve_body($post);
                
                if (!empty($body)) {
                    $body=json_decode($body, true);
                    if (!empty($body['meeting'])) { // already meeting connected
                        $metadb = new VIBE_APPOINTMENTS_META_DB;
                        $metadb->add_appointment_meta(array(
                            'appointment_id'=>$slot['appointment_id'],
                            'meta_key'=>'vibe_bbb',
                            'meta_value'=>$body['meeting']['id']
                        ));
                    }
                }
            }
        }
  
    }

 

    function cancel_meeting($slot,$args){
        $db = new VIBE_APPOINTMENTS_DB;
        $metadb = new VIBE_APPOINTMENTS_META_DB;
        $metas = $metadb->get_appointments_meta(array('appointment_id'=>$slot['appointment_id']));
        if (!empty($metas)) {
            foreach ($metas as $meta) {
                if ($meta['meta_key'] == 'vibe_bbb' || $meta['meta_key'] == 'vibe_appointments' && !empty($meta['meta_value'])) {
                    if(!empty($args['booker_id'])){$slot['booker_id']=$args['booker_id'];}
                    delete_post_meta($meta['meta_value'],'shared_values',$slot['booker_id']); //delete user from meeting sahred_values meta
                }
            }
        }
    }

    function setup_nav(){
        global $bp;
        $slug=VIBE_APPOINTMENTS_SLUG;
        //Add VibeDrive tab in profile menu
        bp_core_new_nav_item( array( 
            'name' => __('Appointments','vibe-appointments'),
            'slug' => $slug, 
            'item_css_id' => 'appointments',
            'screen_function' => array($this,'show_screen'),
            'default_subnav_slug' => 'home', 
            'show_for_displayed_user'=>false,
            'position' => 58,
            'user_has_access' => (bp_is_my_profile() || current_user_can('manage_options'))
        ) );

        bp_core_new_subnav_item( array(
            'name'        => _x('Bookings','sub menu','vibe-appointments'),
            'slug'        => 'mybookings-upcoming',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'screen_function' => array($this,'show_screen'),
            'user_has_access' => 'read',
        ) );

        bp_core_new_subnav_item( array(
            'name'        => _x('History','sub menu','vibe-appointments'),
            'slug'        => 'mybookings-previous',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'screen_function' => array($this,'show_screen'),
            'user_has_access' => 'read',
        ) );

        bp_core_new_subnav_item( array(
            'name'        => __('Pending bookings','vibe-appointments'),
            'slug'        => 'mybookings-pending',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'screen_function' => array($this,'show_screen'),
            'user_has_access' => 'read',
        ) );

        bp_core_new_subnav_item( array(
            'name'        => __('My Reviews','vibe-appointments'),
            'slug'        => 'mybookings-reviews',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'screen_function' => array($this,'show_screen'),
            'user_has_access' => 'read',
        ) );
        bp_core_new_subnav_item( array(
            'name'        => __('Favourites','vibe-appointments'),
            'slug'        => 'favourites',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'screen_function' => array($this,'show_screen'),
            'user_has_access' => 'read',
        ) );
        bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
            'name'        => __('Manage Appointments','vibe-appointments'),
            'slug'        => 'myappointments',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));


        bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
            'name'        => __('Appointments','vibe-appointments'),
            'slug'        => 'myappointments-upcoming',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));
        bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
            'name'        => __('Past Appointments','vibe-appointments'),
            'slug'        => 'myappointments-previous',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));

        bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
            'name'        => __('Approve Appointments','vibe-appointments'),
            'slug'        => 'myappointments-pending',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));
        bp_core_new_subnav_item(apply_filters('vibe_appointments_sub_nav', array(
            'name'        => __('Cancellation Requests','vibe-appointments'),
            'slug'        => 'cancellation-requests',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));
        bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
            'name'        => __('Manage Slots','vibe-appointments'),
            'slug'        => 'myappointments-slots',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_appointments',
            'screen_function' => array($this,'show_screen'),
        )));

        
        $pricing = apply_filters('vibe_appointments_enable_priyce',true);
        if($pricing){
            bp_core_new_subnav_item( apply_filters('vibe_appointments_sub_nav',array(
                'name'        => __('Settings','vibe-appointments'),
                'slug'        => 'settings',
                'parent_slug' => $slug,
                'parent_url' => $bp->displayed_user->domain.$slug.'/',
                'user_has_access' => 'edit_appointments',
                'screen_function' => array($this,'show_screen'),
            )));
        }

        /*bp_core_new_subnav_item( array(
            'name'        => __('Reviews','vibe-appointments'),
            'slug'        => 'myappointments-reviews',
            'parent_slug' => $slug,
            'parent_url' => $bp->displayed_user->domain.$slug.'/',
            'user_has_access' => 'edit_posts',
            'screen_function' => array($this,'show_screen'),
        ));*/
    }

    function show_screen(){

    }

    function enqueue_script(){

        $vibeappointments=get_vibeappointments_script_data();

        if(function_exists('bp_is_user') && bp_is_user() || apply_filters('vibebp_enqueue_profile_script',false)){
            

            wp_enqueue_script('fullcalendar',plugins_url('../assets/js/fullcalendar.min.js',__FILE__),array(),VIBE_APPOINTMENTS_VERSION,true);

            wp_enqueue_script('fullcalendar_all_locale',plugins_url('../assets/js/locales-all.min.js',__FILE__),array('fullcalendar'),VIBE_APPOINTMENTS_VERSION,true);
            wp_enqueue_script('moment');
             wp_enqueue_script('rrule',plugins_url('../assets/js/rrule.min.js',__FILE__),array(),VIBE_APPOINTMENTS_VERSION,true);
            wp_enqueue_script('rrule-main',plugins_url('../assets/js/rrule-main.global.min.js',__FILE__),array(),VIBE_APPOINTMENTS_VERSION,true);

            wp_enqueue_script('vibeappointments',plugins_url('../assets/js/appointments.js',__FILE__),array('wp-element','wp-data','fullcalendar','moment','rrule','rrule-main'),VIBE_APPOINTMENTS_VERSION,true);





            wp_enqueue_script('vibe-appointments-favourites',plugins_url('../assets/js/favourite.js',__FILE__),array('vibeappointments'),VIBE_APPOINTMENTS_VERSION,true);


            wp_localize_script('vibeappointments','vibeappointments',$vibeappointments);

            wp_enqueue_style('fullcalendar',plugins_url('../assets/css/fullcalendar.min.css',__FILE__),array(),VIBE_APPOINTMENTS_VERSION);
            wp_enqueue_style('vibeappointments_css',plugins_url('../assets/css/appointments.css',__FILE__),array(),VIBE_APPOINTMENTS_VERSION);

            wp_enqueue_script('vibe-unit-create-appointments',plugins_url('../assets/js/create_unit.js',__FILE__),array('wp-element','wp-data','fullcalendar'),VIBE_APPOINTMENTS_VERSION,true);

            wp_enqueue_script('vibe-show-unit-appointments',plugins_url('../assets/js/show_unit.js',__FILE__),array('wp-element','wp-data','fullcalendar'),VIBE_APPOINTMENTS_VERSION,true);

            wp_enqueue_style('vibe-show-unit-appointments-css',plugins_url('../assets/css/show_unit.css',__FILE__),array('vibebp_main'),VIBE_APPOINTMENTS_VERSION);


            vibe_appointments_bookable_widget_scripts(bp_displayed_user_id(),'booking');

            $options = vibe_appointments_get_settings();
            //get appointment card
            $upload_dir   = wp_upload_dir();
            if(!empty($options['directory_member_card'])){
                wp_enqueue_style( 'elementor-frontend' );
                if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$options['directory_member_card'].'.css')){
                    
                    wp_enqueue_style('vibebp-member-card-'.$options['directory_member_card'],$upload_dir['baseurl'].'/elementor/css/post-'.$options['directory_member_card'].'.css',array());   
                }
            }else{

                wp_enqueue_style( 'elementor-frontend' );
                global $wpdb;
                $ids = $wpdb->get_results("SELECT ID FROM {$wpdb->posts} WHERE post_type='member-card' AND post_status='publish'");
                
                if(!empty($ids)){
                    $upload_dir   = wp_upload_dir();
                    foreach($ids as $id){
                        if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$id->ID.'.css')){
                            wp_enqueue_style('vibebp-member-card-'.$id->ID,$upload_dir['baseurl'].'/elementor/css/post-'.$id->ID.'.css',array());   
                        }
                    }
                }
            }
          
        }
    }

    function cart_checkout_script(){
        if(function_exists('wc')){
            if(is_page(wc_get_page_id('cart'))){
                ?>
                <script>
                    if(document.querySelector('.wplms_appointment_cart_timer')){
                        document.querySelectorAll('.wplms_appointment_cart_timer').forEach(function(el){
                                el.innerHTML = 
                            '<span class="vicon vicon-timer"></span> '+Math.floor((parseInt(document.querySelector('.wplms_appointment_cart_timer').getAttribute('data-expiry')) - Math.round(new Date().getTime()/1000))/60)+ 'm';
                        });

                        setTimeout(function(){
                            location.reload();
                        },60000);
                    }
                </script>
                <?php
            }
        }
    }

    function expired_slots_clear(){
        $options = vibe_appointments_get_settings();
        if(!empty($options['expired_slots_clear'])){
            if ( ! wp_next_scheduled( 'expired_slots_clear' ) ) {
                wp_schedule_event( time(), 'daily', 'expired_slots_clear' );
            }
        }
    }

    function clear_slots(){
        global $wpdb;
        $db = new VIBE_APPOINTMENTS_DB();
        $wpdb->query( "DELETE FROM  {$db->table_name} WHERE booker_id IS NULL AND end_date <".(time()*1000));
    }

    function record_commissions_in_appointments($appointment,$order_details=null){
        if($order_details===null)
            return;
        $commission = $order_details['payment'];
        $commission = apply_filters('vibe_appointments_commision_value',$commission,$order_details,$appointment);
        $instructor_id = $appointment['author_id'];
        if(function_exists('woocommerce_get_order_currency')){
            $commission_html = $commission.woocommerce_get_order_currency();
        }else{
            $commission_html = $commission;
        }
        
        
        $course_id = 0;

        $activity = apply_filters('bp_course_record_instructor_commission_activity',array(
            'user_id' => $instructor_id,
            'action' => _x('You earned commission','Instructor earned commission activity','wplms'),
            'content' => sprintf(_x('%s commission earned for booking ID %s','Instructor earned commission activity','wplms'),$commission_html,$appointment['appointment_id']),
            'component' => 'appointment',
            'type' => 'appointment_commission',
            'item_id' =>$appointment['appointment_id'],
            'secondary_item_id' => $order_details['item_id'],
            'hide_sitewide' => true,
        ));
        $activity_id = vibe_appointments_record_activity($activity);

        if(!empty($activity_id)){
            vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_commission'.$instructor_id,'meta_value'=>$commission));
            if(!empty($order_details['currency'])){
                vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_currency'.$instructor_id,'meta_value'=>$order_details['currency']));
            }
        }
    }


    function appointments_unit($tabs){
        $tabs['course_curriculum']['fields'][0]['curriculum_elements'][1]['types'][]= array(
            'id'=>'appointments',
            'icon'=>'<svg class="appointments_icon" xmlns="http://www.w3.org/2000/svg" version="1.0" width="64px" height="64px" viewBox="0 0 1280.000000 1280.000000" preserveAspectRatio="xMidYMid meet"><metadata> Created by potrace 1.15, written by Peter Selinger 2001-2017 </metadata><g transform="translate(0.000000,1280.000000) scale(0.100000,-0.100000)" fill="#000000" stroke="none"><path d="M6090 10754 c-528 -46 -902 -128 -1315 -291 -955 -376 -1830 -1187 -2301 -2133 -219 -441 -346 -879 -411 -1425 -25 -214 -25 -796 0 -1010 51 -425 134 -763 274 -1120 376 -955 1187 -1830 2133 -2301 441 -219 879 -346 1425 -411 214 -25 796 -25 1010 0 650 78 1191 257 1705 564 567 340 1104 859 1472 1424 378 579 579 1156 660 1894 20 186 17 770 -5 960 -50 423 -134 763 -274 1120 -376 955 -1187 1830 -2133 2301 -438 218 -882 346 -1415 409 -133 16 -708 29 -825 19z m-29 -1209 c-105 -214 -191 -398 -191 -410 0 -43 63 -330 74 -337 6 -4 55 -8 109 -8 l97 0 -2 -1126 -3 -1126 -212 -122 c-117 -66 -215 -127 -218 -134 -3 -8 46 -102 109 -210 81 -142 119 -198 133 -200 12 -2 58 19 104 46 l84 50 3 -111 c1 -61 8 -117 14 -124 16 -19 461 -19 477 0 7 9 12 102 13 272 l3 258 525 303 525 303 47 -81 c68 -117 56 -112 181 -87 l107 22 316 479 c173 264 314 487 312 496 -2 13 -16 18 -53 20 -42 3 -338 -12 -680 -33 -137 -9 -409 -25 -422 -25 -14 0 -153 -159 -153 -176 0 -6 21 -48 46 -93 25 -45 44 -86 42 -91 -2 -5 -167 -105 -368 -221 -201 -116 -380 -220 -397 -231 l-33 -20 0 981 0 981 104 0 c71 0 107 4 113 13 6 6 25 87 42 178 l32 166 -195 392 c-108 215 -196 392 -196 394 0 3 72 -1 220 -14 381 -32 835 -155 1140 -309 59 -30 61 -32 47 -53 -83 -129 -289 -540 -281 -560 7 -17 304 -191 328 -191 23 -1 168 206 288 409 39 66 73 122 74 124 6 6 101 -60 198 -138 228 -182 442 -394 621 -616 76 -95 155 -204 155 -215 0 -3 -30 -23 -67 -44 -100 -57 -462 -299 -467 -312 -6 -15 174 -332 192 -339 7 -2 101 40 210 94 178 89 241 122 339 183 l32 19 31 -61 c117 -232 233 -603 279 -895 20 -126 41 -313 41 -361 l0 -24 -137 0 c-146 -1 -495 -24 -513 -35 -14 -8 -14 -382 0 -390 18 -11 367 -34 513 -35 l137 0 0 -24 c0 -48 -21 -235 -41 -361 -46 -291 -162 -663 -279 -894 l-30 -60 -87 51 c-130 76 -484 249 -501 246 -19 -4 -206 -323 -197 -337 11 -18 338 -236 443 -295 56 -32 102 -61 102 -65 0 -12 -76 -118 -155 -216 -176 -218 -388 -430 -610 -608 -89 -71 -195 -147 -205 -147 -4 0 -36 51 -72 113 -68 117 -271 422 -289 432 -12 8 -326 -174 -334 -193 -5 -14 161 -353 244 -495 28 -49 51 -90 51 -93 0 -7 -120 -64 -228 -109 -293 -120 -628 -201 -961 -235 -57 -5 -114 -10 -127 -10 l-24 0 0 138 c0 147 -24 494 -35 511 -9 15 -381 15 -390 0 -11 -17 -35 -364 -35 -511 l0 -138 -24 0 c-48 0 -235 21 -361 41 -291 46 -663 162 -894 279 l-60 30 67 118 c92 157 236 457 229 474 -7 19 -324 201 -337 193 -17 -10 -220 -316 -288 -432 -36 -62 -68 -113 -72 -113 -10 0 -116 76 -205 147 -222 178 -434 390 -610 608 -79 98 -155 204 -155 216 0 4 46 33 103 65 104 59 431 277 442 295 9 14 -178 333 -197 337 -17 3 -371 -170 -501 -246 l-87 -51 -30 60 c-117 231 -233 603 -279 894 -20 126 -41 313 -41 361 l0 24 133 0 c143 0 489 24 506 35 15 9 15 381 0 390 -17 11 -363 35 -506 35 l-133 0 0 24 c0 48 21 235 41 361 46 292 162 663 279 895 35 69 17 71 160 -14 47 -27 168 -90 270 -139 182 -88 185 -89 201 -68 36 44 181 312 176 325 -7 17 -296 212 -432 291 -55 32 -102 60 -104 61 -6 6 60 101 138 198 182 228 394 442 616 621 95 76 204 155 215 155 3 0 23 -30 44 -67 57 -100 299 -462 312 -467 15 -6 332 174 338 191 8 21 -198 431 -281 560 -14 21 -12 23 47 53 305 154 756 276 1140 310 128 11 213 16 218 14 2 -1 -83 -176 -187 -389z"/></g></svg>',
            'label'=>__('Appointments','vibe-appointments'),
            'fields'=>array(
                array(
                    'label'=> __('Unit title','vibe-appointments' ),
                    'type'=> 'title',
                    'id' => 'post_title',
                    'from'=>'post',
                    'value_type'=>'single',
                    'style'=>'full',
                    'default'=> __('Unit Name','vibe-appointments' ),
                    'desc'=> __('This is the title of the unit which is displayed on top of every unit','vibe-appointments' )
                    ),
                array(
                    'label'=> __('Unit Tag','vibe-appointments' ),
                    'type'=> 'taxonomy',
                    'taxonomy'=> 'module-tag',
                    'from'=>'taxonomy',
                    'value_type'=>'single',
                    'style'=>'assign_cat',
                    'id' => 'module-tag',
                    'default'=> __('Select a tag','vibe-appointments' ),
                ),
                array(
                    'label'=> __('What is the unit about','vibe-appointments' ),
                    'type'=> 'editor',
                    'style'=>'',
                    'value_type'=>'single',
                    'id' => 'post_content',
                    'from'=>'post',
                    'extras' => '',
                    'default'=> __('Enter description about the unit.','vibe-appointments' ),
                ),
                array(
                    'label'=> __('Unit duration','vibe-appointments' ),
                    'type'=> 'duration',
                    'style'=>'course_duration_stick_left',
                    'id' => 'vibe_duration',
                    'from'=> 'meta',
                    'default'=> array('value'=>9999,'parameter'=>86400),
                    'from'=>'meta',
                ),
                array( 
                    'label' => __('Free Unit','vibe-appointments'),
                    'desc'  => __('Set Free unit, viewable to all','vibe-appointments'), 
                    'id'    => 'vibe_free',
                    'type'  => 'switch',
                    'default'   => 'H',
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Unit Forum','vibe-appointments'),
                    'desc'  => __('Connect Forum with Unit.','vibe-appointments'),
                    'id'    => 'vibe_forum',
                    'type'  => 'selectcpt',
                    'post_type' => 'forum',
                    'std'=>0,
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Connect Assignments','vibe-appointments'),
                    'desc'  => __('Select an Assignment which you can connect with this Unit','vibe-appointments'),
                    'id'    => 'vibe_assignment',
                    'type'  => 'selectmulticpt', 
                    'post_type' => 'assignment',
                    'from'=>'meta',
                ),
                array(
                    'label' => __('Attachments','vibe-appointments'),
                    'desc'  => __('Display these attachments below units to be downloaded by students','vibe-appointments'),
                    'id'    => 'vibe_unit_attachments', 
                    'type'  => 'multiattachments', 
                    'from'=>'meta',
                ),
                array(
                    'label'=> __('Practice Questions','wplms' ),
                    'text'=> '',
                    'type'=> 'practice_questions',
                    'from'=>'meta',
                    'post_type'=>'question',
                    'id' => 'vibe_practice_questions',
                    'default'=> __('Select a type','wplms' ),
                    'buttons' => array(
                        'question_types'=>wplms_get_question_types(),
                    )
                ),
            ),
        );
        return $tabs;
    }
    
    function bp_course_api_get_user_course_status_item_unit_meta($meta,$course_id,$item_id){
        $type = get_post_meta($item_id,'vibe_type',true);
        if($type == 'appointments' ){
            $meta['unit_type'] = 'appointments';
            global $wpdb;
            $appointments_db = new VIBE_APPOINTMENTS_DB();
            $appointments_metadb = new VIBE_APPOINTMENTS_META_DB();
            $query = "SELECT a.appointment_id 
                    FROM {$appointments_db->table_name} as a 
                    LEFT JOIN {$appointments_metadb->table_name} as m
                    ON a.appointment_id = m.appointment_id
                    LEFT JOIN {$appointments_metadb->table_name} as m1
                    ON a.appointment_id = m1.appointment_id
                    WHERE a.item_id = $course_id 
                    AND a.type = 'course'
                    AND m.meta_key = 'unit'
                    AND m.meta_value = $item_id
                    AND m1.meta_key = 'booker_id'
                    AND m1.meta_value = $this->user_id";
            $id = $wpdb->get_var($query);;
            if(!empty($id) && !is_array($id)){
                $meta['slot'] = $appointments_db->get_appointments(array('appointment_id'=>$id))[0];
                $meta['slot']['is_booked'] = !empty($this->is_booked($id))?true:false;
            }
        }
        return $meta;
    }

    function is_booked($id){
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $val = $meta->get_appointments_meta(array('appointment_id'=>$id,'meta_key'=>'booker_id','meta_value'=>$this->user_id));
        return $val;
    }

    function unit_booking_meta_update($args){
        if($args['meta_key'] == 'unit'){
            $args['label'] = _x('Connected Unit','unit appointment detail','vibe-appointments');
            $args['value'] = get_the_title($args['value']);
        }
        return $args;
    }

    function commission_reversal($appointment,$args){
       
        if(!function_exists('bp_activity_get'))
            return;
        global $wpdb,$bp;
                            
        $commission_activity_id = $wpdb->get_var($wpdb->prepare( "
                SELECT id 
                FROM {$bp->activity->table_name}
                WHERE item_id = %d
                AND type = 'appointment_commission'
                AND user_id = %d
                AND component = 'appointment'
                ORDER BY date_recorded DESC
                LIMIT 0,1
                " ,$appointment['appointment_id'],$appointment['author_id']));
 
        if(!empty($commission_activity_id) &&  !empty($args)){
            
           
            $commision_value = bp_activity_get_meta($commission_activity_id,'_commission'.$appointment['author_id'],true);
            $commision_value = intval($commision_value);
            $commision_currency = bp_activity_get_meta($commission_activity_id,'_currency'.$appointment['author_id'],true);
            if(!empty($commision_value)){

                
                if(function_exists('get_woocommerce_currency_symbol')){
                    $commission_html = '-'.get_woocommerce_currency_symbol($commision_currency).$commision_value;
                }else{
                    $commission_html = '-'.$commision_value;
                }
                if($commision_value < 0){
                    $commision_value = abs($commision_value);
                }
                if($commision_value > 0){
                    $commision_value = -1*$commision_value;
                }

                $activity = apply_filters('bp_course_record_instructor_commission_activity',array(
                    'user_id' => $appointment['author_id'],
                    'action' => _x('Commission Reversed','Instructor earned commission activity','wplms'),
                    'content' => sprintf(_x('%s commission reversed for booking ID %s','Instructor earned commission reverse activity','wplms'),$commission_html,$appointment['appointment_id']),
                    'component' => 'appointment',
                    'type' => 'appointment_commission',
                    'item_id' =>$appointment['appointment_id'],
                
                    'hide_sitewide' => true,
                ));

                if(!empty($args['order_details']) && !empty($args['item_id'])){
                    $activity['secondary_item_id']=$args['order_details']['item_id'];
                }

                $activity_id = vibe_appointments_record_activity($activity);

                if(!empty($activity_id)){
                    vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_commission'.$appointment['author_id'],'meta_value'=>$commision_value));
                    if(!empty($commision_currency)){
                        vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_currency'.$appointment['author_id'],'meta_value'=>$commision_currency));
                    }
                }

            }  
        }
    }

}

Vibe_Appointments_Actions::init();
