<?php
/**
 * Actions WPLMS Appointments
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	vibe-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



class Vibe_Appointments_Activity{


	public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Activity();
        return self::$instance;
    }


    function __construct(){

        add_action('bp_activity_register_activity_actions',array($this,'register_actions'));
        
        add_action('vibe_appointments_booking_requested',array($this,'appointment_requsted'),10,2);
        add_action('vibe_appointments_booking_confirmed',array($this,'booking_confirmed'),10,2);
        
        add_action('vibe_appointments_booking_updated',array($this,'booking_updated'),10,2);
        
        add_action('vibe_appointments_booking_accepted',array($this,'booking_confirmed'),10,2);
        add_action('vibe_appointments_booking_cancelled',array($this,'booking_cancelled_activity'),10,3);

        //wplms_bbb_record_join_activity args ($meeting_id,$user_id)
        
    }

    function register_actions(){
        global $bp; 
        $bp_course_action_desc=apply_filters('bp_course_register_actions',array(
            'booking_requested' => __( 'Booking request.', 'vibe-appointments' ),
            'appointment_requested' => __( 'Appointment request.', 'vibe-appointments' ),
            'booking_confirmed' => __( 'Booking Confirmed.', 'vibe-appointments' ),
            'appointment_confirmed' => __( 'Appointment Confirmed.', 'vibe-appointments' ),

            'start_appointment' => __( 'Appointment Started', 'vibe-appointments' ),
            'meeting_finished' => __( 'Appointment meeting finished', 'vibe-appointments' ),
            'meeting_ended' => __( 'Appointment Meeting Ended', 'vibe-appointments' ),
            'appointment_attended' => __( 'Appointment is Attended by user', 'vibe-appointments' ),
            'appointment_cancelled' => __( 'Appointment is cancelled', 'vibe-appointments' ),
            'appointment_marked_attended' => __( 'Appointment is marked attended by instructor', 'vibe-appointments' ),
            'appointment_rescheduled' => __( 'Appointment is Rescheduled', 'vibe-appointments' ),
            'schedule_updated' => __( 'The Schedule of Appointment is Updated', 'vibe-appointments' ),
            
            'booking_rejected' => __( 'Booking is Rejected by Instructor', 'vibe-appointments' ),
            'requested_cancellation' => __( 'Cancellation is Requested for a Booking', 'vibe-appointments' ),
            'requested_reschedule' => __( 'Reschedule is Requested for a Booking', 'vibe-appointments' ),
            

            'appointment_meeting_created' => __( 'Meeting is Created for an Appointment', 'vibe-appointments' ),
            'appointment_meeting_create_failed' => __( 'Created Meeting for Appointment is failed', 'vibe-appointments' ),
            
            ));
        foreach($bp_course_action_desc as $key => $value){
            bp_activity_set_action($bp->activity->id,$key,$value);  
        }
    }

    function booking_confirmed($post,$payment=null){
        $aid = bp_activity_add( array( 
            'user_id' => $post['author_id'], 
            'action' => _x('Appointment confirmed.','confirmed appointment','vibe-appointments'), 
            'content' => sprintf(_x('Appointment %s is confirmed for %s.','booking confirmed','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($post['booker_id'])), 
            'component' => 'appointments', 
            'type' => 'appointment_confirmed', 
            'item_id' => $post['appointment_id'], 
        ));

        //echo '<pre>'; print_r($payment);

        if(!empty($payment)){
            $per = apply_filters('vibe_appointment_commision_payment',0.7,$post['author_id']);
            $price = floor($payment['payment']*$per );
           bp_activity_update_meta( $aid, '_commission', $price);
        }
        
        $aid = bp_activity_add( array( 
            'user_id' => $post['booker_id'], 
            'action' => _x('Booking confirmed.','confirmed booking','vibe-appointments'), 
            'content' => sprintf(_x('Booking %s confirmed by %s','booking confirmed','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($post['author_id'])), 
            'component' => 'appointments', 
            'type' => 'booking_confirmed', 
            'item_id' => $post['appointment_id'], 
        ));
        vibebp_fireabase_update_stale_requests($post['author_id'],'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($post['author_id'],'author/getbookings');
        vibebp_fireabase_update_stale_requests($post['booker_id'],'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($post['booker_id'],'booker/getbookings');
       
    }


    function booking_updated($post,$payment){
        $aid = bp_activity_add( array( 
            'user_id' => $post['author_id'], 
            'action' => _x('Appointment updated.','confirmed appointment','vibe-appointments'), 
            'content' => sprintf(_x('Appointment %s is updated for %s.','booking updated','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($post['booker_id'])), 
            'component' => 'appointments', 
            'type' => 'appointment_confirmed', 
            'item_id' => $post['appointment_id'], 
        ));
        
        $per = apply_filters('vibe_appointment_commision_payment',0.7,$post['author_id']);
        
        if(!empty($payment)){
            $price = floor($payment['payment']*$per );
            bp_activity_update_meta( $aid, '_commission', $price);
        }
    
        $aid = bp_activity_add( array( 
            'user_id' => $post['booker_id'], 
            'action' => _x('Booking updated.','confirmed booking','vibe-appointments'), 
            'content' => sprintf(_x('Booking %s updated by %s.','booking updated','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($post['author_id'])), 
            'component' => 'appointments', 
            'type' => 'booking_confirmed', 
            'item_id' => $post['appointment_id'], 
        ));
        vibebp_fireabase_update_stale_requests($post['author_id'],'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($post['author_id'],'author/getbookings');
        vibebp_fireabase_update_stale_requests($post['booker_id'],'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($post['booker_id'],'booker/getbookings');
    }

    function appointment_requsted($user_id,$post){
        $aid = bp_activity_add( array( 
            'user_id' => $post['author_id'], 
            'action' => _x('Appointment requested.','appointment requested','vibe-appointments'), 
            'content' => sprintf(_x('Appointment %s is requested by %s.','appointment ','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($user_id)), 
            'component' => 'appointments', 
            'type' => 'appointment_requested', 
            'item_id' => $post['appointment_id'], 
        ));

        $aid = bp_activity_add( array( 
            'user_id' => $user_id, 
            'action' => _x('Booking request sent.','confirmed booking','vibe-appointments'), 
            'content' => sprintf(_x('Request for booking %s sent to %s.','booking requested','vibe-appointments'),$post['appointment_id'],bp_core_get_user_displayname($post['author_id'])), 
            'component' => 'appointments', 
            'type' => 'booking_requested', 
            'item_id' => $post['appointment_id'], 
        ));
        vibebp_fireabase_update_stale_requests($post['author_id'],'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($post['author_id'],'author/getbookings');
        vibebp_fireabase_update_stale_requests($user_id,'appointmentDetails/'.$post['appointment_id']);
        vibebp_fireabase_update_stale_requests($user_id,'booker/getbookings');
    }

    function booking_cancelled_activity($args,$order_details=null){
        if(empty($order_details) || empty($order_details['booker_id']))
            return;

        $message = sprintf(_x('Appointment %s is cancelled for %s.','appointment ','vibe-appointments'),$args['appointment_id'],bp_core_get_user_displayname($order_details['booker_id']));

        $activity_id = bp_activity_add( array( 
            'user_id' => $args['author_id'], 
            'action' => _x('Appointment cancelled.','appointment cancelled','vibe-appointments'), 
            'content' => $message, 
            'component' => 'appointments', 
            'type' => 'appointment_cancelled', 
        ));

        $aid = bp_activity_add( array( 
            'user_id' => $order_details['booker_id'], 
            'action' => _x('Booking cancelled.','cancelled booking','vibe-appointments'), 
            'content' => sprintf(_x('Booking %s has been cancelled by %s. ','booking requested','vibe-appointments'),$args['appointment_id'],bp_core_get_user_displayname($args['author_id'])), 
            'component' => 'appointments', 
            'type' => 'booking_cancelled'
        ));
        vibebp_fireabase_update_stale_requests($args['author_id'],'appointmentDetails/'.$args['appointment_id']);
        vibebp_fireabase_update_stale_requests($args['author_id'],'author/getbookings');
        vibebp_fireabase_update_stale_requests($args['booker_id'],'appointmentDetails/'.$args['appointment_id']);
        vibebp_fireabase_update_stale_requests($args['booker_id'],'booker/getbookings');
    }


}

Vibe_Appointments_Activity::init();