<?php
/**
 * Register blocks.
 *
 * @package VibeBP
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Load registration for our blocks.
 *
 * @since 1.6.0
 */
class Vibe_Appointments_Register_Guten_Blocks {


	/**
	 * This plugin's instance.
	 *
	 * @var VibeBP_Register_Blocks
	 */
	private static $instance;

	/**
	 * Registers the plugin.
	 */
	public static function register() {
		if ( null === self::$instance ) {
			self::$instance = new Vibe_Appointments_Register_Guten_Blocks();
		}
	}

	/**
	 * The Plugin version.
	 *
	 * @var string $_slug
	 */
	private $_slug;

	/**
	 * The Constructor.
	 */
	public function __construct() {
		$this->counter = 0;
		$this->_slug = 'vibeappointments';

		add_action( 'init', array( $this, 'register_blocks' ), 99 );
		add_action( 'admin_enqueue_scripts', array($this,'vibebp_block_assets'));
		
		add_filter( 'block_categories_all', array($this,'block_category'), 1, 2);


		// Hook: Frontend assets.
		//add_action( 'enqueue_block_assets', array($this,'block_assets'),9 );

		//FOR TESTING

	}

	/**
	 * Add actions to enqueue assets.
	 *
	 * @access public
	 */
	public function register_blocks() {

		// Return early if this function does not exist.
		if ( ! function_exists( 'register_block_type' ) ) {
			return;
		}

		// Shortcut for the slug.
		$slug = $this->_slug;



		register_block_type(
			$slug . '/appointmentsdirectory',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'appointmentsdirectory')
			)
		);
		register_block_type(
			$slug . '/bookingreviews',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'bookingreviews')
			)
		);
		register_block_type(
			$slug . '/bookableslots',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'bookableslots')
			)
		);
		register_block_type(
			$slug . '/bookableslotswidget',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'bookableslotswidget')
			)
		);

		register_block_type(
			$slug . '/coursebookableslotswidget',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'coursebookableslotswidget')
			)
		);

		register_block_type(
			$slug . '/bookingstartrating',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'bookingstartrating')
			)
		);
		register_block_type(
			$slug . '/bookingprice',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'bookingprice')
			)
		);
		
		register_block_type(
			$slug . '/favourite',
			array(
				'editor_script' => $slug . '-editor',
				'editor_style'  => $slug . '-editor',
				'style'         => $slug . '-frontend',
				'render_callback' => array($this,'favourite')
			)
		);

	}

	function bookingprice($settings){
		$settings = wp_parse_args($settings,
			array(
				'font_size'=>array('size'=>1,'unit'=>'rem','color'=>'inherit'),
				'service'=>0,
				'color'=>'inherit'
			)
			
		);
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		global $wpdb;
		$product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=".$user_id);
        
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){
                $product = wc_get_product( $product_id );
                $slot_price = $product->get_price_html(); 
            }
        }else{
        	$slot_price = _x('Request booking','vibe-appointments');
        }
        

        return '<div class="slot_price" style="font-size:'.$settings['font_size']['size'].$settings['font_size']['unit'].';color:'.$settings['color'].'">'.$slot_price.'</div>';
	}


	function favourite($settings){
		$settings = wp_parse_args($settings,
			array(
				'font_size'=>array('size'=>1,'unit'=>'rem','color'=>'inherit'),
				'service'=>0,
				'color'=>'inherit'
			)
			
		);
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		return '<div class="vibe_mark_favourite" data-user="'.$user_id.'" style="font-size:'.$settings['font_size']['size'].$settings['font_size']['unit'].';color:'.$settings['color'].'"></div>';
	}
	function bookingstartrating($settings){
		$settings = wp_parse_args($settings,
			array(
				'font_size'=>array('size'=>1,'unit'=>'rem'),
			)
		);
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
		$average_rating = get_user_meta($user_id,'appointment_average_rating',true);
		if(empty($average_rating)){$average_rating=0;}
        
        $html= '<div class="instructor_star_rating_wrapper" style="font-size:'.$settings['font_size']['size'].$settings['font_size']['unit'].'">
            <strong class="instructor_star_rating">
		    <small class="blank_stars"><small style="width:'.round(100*$average_rating/5,2).'%;" class="filled_stars"></small></small>
	      	</strong> 
      	</div>';

      	return  $html;
	}

	function bookableslotswidget($settings){
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
        return  do_shortcode('[appointments_member_book_widget users="'.$user_id.'"][/appointments_member_book_widget]');
	}

	function coursebookableslotswidget($settings){
		$settings = wp_parse_args($settings,
			array(
				'show_only_to_course_students'=>0,
			)
		);
		

		$id = apply_filters('elementor_course_block_id','');
        if(empty($id))
            return;
		$course_authors=get_post_field('post_author',$id);
		$course_authors = apply_filters('wplms_course_instructors',$course_authors,$id);
		$users= '';
		if(!is_array($course_authors)){
			$users = $course_authors;
		}else{
			$users = implode(',',$course_authors);
		}
        return do_shortcode('[course_appointments_member_book_widget users="'.$users.'" show_only_to_course_students="'.$settings['show_only_to_course_students'].'" service="'.$id.'"][/course_appointments_member_book_widget]');
	}

	function bookableslots($settings){
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
       
		vibe_appointments_bookable_widget_scripts();
		
		 return '<div id="member_bookable_slots"></div>';
	}

	function bookingreviews($settings){
		$html = '';
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}

		$defaults = array(
			'title'=>'',
			'show_breakup'=>true,
			'rating_count'=>true,
			'hide_if_none'=>false,
			'number'=>5,
			'orderby'=>'',
		);
		$settings = wp_parse_args($settings,$defaults);
		ob_start();
		?>
        <div class="instructor_reviews_wrapper">
	        <?php 
	        if($settings['title']){
	        ?>
	        <h3><span><?php echo do_shortcode($settings['title']); ?></span></h3>
	        <?php
	        }
	        ?>
	        <div class="instructor_reviews">
	        <?php
	            if($settings['show_breakup']){ 
	        ?>
	            <div class="review_breakup">
	              <?php
	              	

	              	global $wpdb;
	              	$ratings_breakup = $wpdb->get_results($wpdb->prepare("
	              		SELECT count(m.meta_value) as count,m.meta_value as rating
		              	FROM {$wpdb->comments} as c
		              	INNER JOIN {$wpdb->commentmeta} as m 
		              	ON c.comment_ID = m.comment_id
		              	WHERE c.comment_agent = 'appointments' 
	                    AND c.comment_type = 'instructor_review' 
	                    AND c.comment_approved = 1
	              		AND c.comment_author = %d
	              		AND m.meta_key = 'appointment_review_rating'
	              		GROUP BY m.meta_value ",$user_id),ARRAY_A);

	              
	              	
	              	$breakup=[];$rating_count = $rating_total =0;
	              	if(!empty($ratings_breakup)){
	              		foreach($ratings_breakup as $rb){
	              			$breakup[$rb['rating']]=$rb['count'];
	              			$rating_total+=$rb['rating']*$rb['count'];
	              			$rating_count+=$rb['count'];
	              		}
	              	}
	              	
	              ?>
	             
	                <div class="rating_snapshot">
	                  <h2><?php echo (!empty($breakup)?round($rating_total/$rating_count,2):__('N.A','vibe-appointments')); ?></h2>
	                  <?php
	                  	if($rating_total){
	                  		$width = round($rating_total/$rating_count,2)*100/5;
		                  echo '<div class="instructor_star_rating_wrapper">
		                        <strong class="instructor_star_rating">
							    <small class="blank_stars"><small style="width:'.$width.'%;" class="filled_stars"></small></small>
						      	</strong>';    
		                      echo '</div>';
		                      echo '<span>'.sprintf(__('%d ratings','rating count','vibe-appointments'),$rating_count).'</span>';
                      	}
	                  ?>
	                </div>
	                <ul class="rating_breakup">
	                <?php	                  
	                  for($i=5;$i>=1;$i--){
	                    echo '<li><span>'.$i.'</span><strong>
	                    	'.(empty($breakup[$i])?'':'<span style="width:'.round(100*($i/5),2).'%"><span>'.sprintf(__('%s ratings','vibe-appointments'),$breakup[$i]).'</span></span>').'</strong></li>';
	                  }
	                ?>
	                </ul>
	              </div>
	        <?php
	        }
	        ?>    
	        </div>
	        <div class="show_instructor_reviews">
	        <?php

	        $paged = 1;
            if(!empty($_GET['paged']) && is_numeric($_GET['paged']) && $_GET_['paged'] <= ceil(count($comments)/$settings['number'])){
            	$paged = $_GET['paged'];
            }else{
            	$paged = get_query_var('paged');
            }
            if(empty($paged)){
            	$paged = 1;
            }

            $comment_ids = $wpdb->get_results($wpdb->prepare("
          		SELECT comment_ID
              	FROM {$wpdb->comments} 
              	WHERE comment_agent = 'appointments' 
                AND comment_type = 'instructor_review' 
                AND comment_approved = 1
          		AND comment_author = %d
          		LIMIT 0,999",$user_id),ARRAY_A);

            if(!empty($comment_ids)){

		         $comments = get_comments( array(
		         	'comment__in' =>wp_list_pluck($comment_ids,'comment_ID'),
		         	'comment_agent'=>'appointments',
		         	'number'=>$settings['number'],
		         	'paged'=>$paged,
	                'type' => 'instructor_review'
	            ) );
		     }
	        
	        if (empty($comments)) {
	            echo '<div id="message" class="message notice"><p>';_e('No Reviews found for instructor.','vibe-appointments');echo '</p></div>';
	        }else{
	            
	            
	        ?>

	            <ol class="reviewlist commentlist"> 
	            <?php 
	                  wp_list_comments(array(
	                     'type'        =>'instructor_review',
	                     'avatar_size' =>120,
	                     'per_page'=>$settings['number'],
	                     'page'=>$paged,
	                     'callback'    => 'vibe_appointments_instructor_reviews'
	                     ),$comments
	                   ); 
	                
	                echo '<div id="instructor_appointment_reviews" class="pagination">';
                  	if(count($comments) > $settings['number']){
                  		if($paged >1){
                  			if($_GET['paged'] == ceil(count($comments)/$settings['number']) ){
                  				echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                  				echo '<span>'.$paged.'</span>';	
                  			}else{
                  				echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                  				echo '<span>'.$paged.'</span>';	
                  				echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>';	
                  			}
                  			
                  		}else{
                  			echo '<span>1</span>';
                  			echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>';	
                  		}
                  		
                  	}
                  	if(empty($settings['number'])){$settings['number']=5;}
                  	if(empty($paged)){$paged=1;}
                  	if($settings['number'] >= count($comments)){
	                  	echo '<i>'.sprintf(__('Showing %s out of %s reviews','vibe-appointments'),(($settings['number']*($paged-1))+1).'-'.(
	                  		(count($comments)<$settings['number']*$paged)?
	                  			count($comments)
	              			:$settings['number']*$paged),count($comments)).'</i>';
                  	}
                  	echo '</div>';
	              ?>  
	            </ol> 
	        <?php
	          }
	        ?>
	        </div>
	    </div>
        <?php
        $html .=ob_get_clean();
        return $html;
	}

	function appointmentsdirectory($settings){

		//print_r('appointments_directory settings=\''.serialize($settings).'\'');
		return do_shortcode('[appointments_directory settings=\''.serialize($settings).'\']');
	}

	function block_category( $categories, $post ) {
		return array_merge(
			$categories,
			array(
				array(
					'slug' => $this->_slug,
					'title' => __( 'Vibe Appointments', 'vibe-appointments' ),
				),
			)
		);
	}

	function get_services(){
		$argss = array('post_type' => VIBE_APPOINTMENTS_SERVICE_SLUG,'posts_per_page'=>-1);
		$posts = [];
	     $postss = get_posts($argss);
	     if(!empty($postss)){
	     	foreach($postss as $k => $post){
	         	$posts[$post->ID] = $post->post_title;
	         }
	     }
         return $posts;
    }

	public function vibebp_block_assets(){
	
		// Shortcut for the slug.
		$slug = $this->_slug;
		$color_options = apply_filters('vibe_bp_gutenberg_text_color_options',array(

			array(
				'name'=>_x('Black','color description','vibe-appointments'),
				'color'=>'#000000'
			),
			array(
				'name'=>_x('White','color description','vibe-appointments'),
				'color'=>'#ffffff'
			),

		));

		
		$fontsizeunit_options = apply_filters('vibe_bp_gutenberg_text_size_unit_options',array(
			'px','em','rem','pt','vh','vw','%'
		));
		$groups = array();
		$fields = array();
		if(function_exists('bp_xprofile_get_groups')){
			$groups = bp_xprofile_get_groups( array(
				'fetch_fields' => true
			) );
		}
		

		if(!empty($groups)){
			foreach($groups as $group){
				if(!empty($group->fields)){
					foreach ( $group->fields as $field ) {
						//$field = xprofile_get_field( $field->id );
						$fields[$field->id]=$field->name;
					}
				}
			}
		}


		$profile_field_styles = apply_filters('wplms_course_field_styles',array(
					'' =>__('Default','vibe-appointments'),
					'stacked' =>__('Stacked','vibe-appointments'),
					'spaced'=>__('Spaced','vibe-appointments'),
					'nolabel'=>__('No Label','vibe-appointments'),
					'icon'=>__('Icons','vibe-appointments'),
				));

		$fontwieght_options = apply_filters('vibe_bp_gutenberg_text_color_options',array(
			'100','200','300','400','500','600','700','800','900'
		));
		$member_types = array();
		if(function_exists('bp_get_member_types')){
			$member_type_objects = bp_get_member_types(array(),'objects');
			if(!empty($member_type_objects) && count($member_type_objects)){
				$member_types=array();
				foreach($member_type_objects as $member_type=>$mt){
					$member_types[$member_type]=$member_type_objects[ $member_type ]->labels['singular_name'];
				}
				$member_types = array_merge(array('all'=>__('All','vibe-appointments' )),$member_types);
				
			}
		}
		

		
		$blog_id = '';
        if(function_exists('get_current_blog_id')){
            $blog_id = get_current_blog_id();
        }
        global $wpdb,$bp;
		$results = $wpdb->get_results("SELECT field.id as id, field.name as name FROM {$bp->profile->table_name_fields} as field INNER JOIN {$bp->profile->table_name_meta} as meta ON field.id = meta.object_id
			WHERE meta.object_type = 'field' AND meta.meta_key = 'do_autolink' AND meta.meta_value = 'on'");
		
		$member_directory_filters = array(
			'availability'=>_x('Slot availability','vibe-appointments'),
			'price'=>_x('Slot Price','vibe-appointments')
		);
		if(!empty($results)){
			foreach($results as $result){
				$member_directory_filters[$result->id] = $result->name;
			}
		}
		$service_types = [];
		if(empty($this->app_settings)){
        	$this->app_settings = vibe_appointments_get_settings();
        }
		if(!empty($this->app_settings['appointments_services'])){

			$terms = get_terms(VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG);
			$service_types = array('all'=>_x('All','','vibe-appointments'));
			$services = array();
			if(!empty($terms)){
				foreach($terms as $term) {
				    
				    $service_types[$term->term_id] = $term->name;
				    
				}
			}
		}
		$settings = apply_filters('vibe_appointments_data',array(
			'default_avatar'=>plugins_url( '../../assets/images/avatar.jpg',  __FILE__ ),
			'default_profile_value'=>_x('default value','','vibe-appointments'),
			'default_name'=>_x('default name','','vibe-appointments'),
			'current_user'=>wp_get_current_user(),
			'services_enabled'=>(!empty($this->app_settings['appointments_services'])?true:false),
			'url'=>get_rest_url($blog_id,Vibe_BP_API_NAMESPACE),
			'appointments_api'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),

			'appointnents_dir_order_options'=>	array(
				'active' =>__('Active','vibe-appointments' ),
				'newest' =>__('Recently Added','vibe-appointments' ),
				'alphabetical' =>__('Alphabetical','vibe-appointments' ),
				'random'=>__('Random','vibe-appointments' ),
				'popular'=>__('Popular','vibe-appointments' ),
			),
			'profile_fields' => $fields,
			'font_size_units'=>$fontsizeunit_options,
			'member_types'=>$member_types,
			'member_directory_filters_options' => $member_directory_filters,
			'app_card_styles'=> array(
				'' =>__('Default','vibe-appointments' ),
				'names' =>__('Name','vibe-appointments' ),
				'pop_names' =>__('Pop Names','vibe-appointments' ),
				'card' =>__('Card','vibe-appointments' ),
			),
			'service_types_options'=>$service_types,
			'review_order_by'=>array('' => __('Recent rating first','vibe-appointments'),
					'highest_rated' => __('Highest rating first','vibe-appointments')),
			'services'=>$this->get_services()
		));

		

		// Register block editor script for backend.
		wp_enqueue_script(
			'vibe-appointments-blocks-block-js', // Handle.
			plugins_url( '../assets/js/vibe_appointments_blocks.js', dirname( __FILE__ ) ),
			array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ),
			VIBE_APPOINTMENTS_VERSION, 
			true 
		);

		// Register block editor styles for backend.
		wp_enqueue_style(
			'vibe-appointments-blocks-block-editor-css',
			plugins_url( '../assets/css/vibe_appointments_blocks.css', dirname( __FILE__ ) ),
			array( 'wp-edit-blocks' ), 
			VIBE_APPOINTMENTS_VERSION 
		);
		wp_localize_script( 'vibe-appointments-blocks-block-js', 'vibe_appointments_data', $settings );
	}


	
	
}

Vibe_Appointments_Register_Guten_Blocks::register();


