<?php
/**
 *  WPLMS appointments Admin
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



class Vibe_Appointments_Admin{


	public static $instance;
    public $appointment_settings;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Admin();
        return self::$instance;
    }


    function __construct(){

    	add_action('admin_notices',array($this,'table_exists'));
    	add_action( 'current_screen', array($this,'install_tables'));

        add_filter('manage_users_columns', array($this,'column'));
        add_filter('manage_users_custom_column', [$this,'custom_column_content'], 10, 3);
        add_action('wp_ajax_apply_uid_label',array($this,'apply_uid_label'));
    }

    function column($columns){
        if(empty($this->appointment_settings)){
            $this->appointment_settings = get_option(VIBE_APPOINTMENTS_OPTION);
        }

        if(!empty($this->appointment_settings['instructor_labels'])){
            $columns['labels'] = 'Instructor Label';
        }

        ?>
        <script>
            jQuery(document).ready(function($){
                $('.add_change_labels').on('click',function(){
                    $(this).next().toggleClass('hide');
                });
                $('.apply_label').on('click',function(){
                    var $this = $(this);
                    
                    if($this.hasClass('loading'))
                        return;

                    $this.addClass('loading')
                    $this.text('...');

                    $.ajax({
                      type: "POST",
                      url: ajaxurl,
                      data: { action: 'apply_uid_label', 
                              security: $this.parent().find('.security').val(),
                              user_id: $this.parent().find('.uid').val(),
                              labels: $this.parent().find('.selected_labels').val(),
                            },
                      cache: false,
                      success: function (html) {
                        if(html){
                            $this.parent().parent().find('.saved_labels').html(html);  
                            $this.html('<span class="dashicons dashicons-yes"></span>');  
                            setTimeout(function(){$this.parent().addClass('hide');},2000);
                        }else{
                            $this.html('<span class="dashicons dashicons-yes"></span>');
                        }
                      }
                    });    
                });

            });
        </script><style>.hide{display:none;}.saved_labels img { width: 48px; }</style>
        <?php

        return $columns;
    }

    function custom_column_content($value, $column_name, $user_id) {
        
        if ( 'labels' == $column_name ){
            $select = '';
            if(!empty($this->appointment_settings['instructor_labels'])){
                $select.='<div class="saved_labels">';
                $saved_labels = get_user_meta( $user_id ,'appointment_label',false);
                if(!empty($saved_labels)){
                    
                    $labels = $this->appointment_settings['instructor_labels'];
                  
                   forEach($saved_labels as $label){
                        $k = array_search($label, $labels['label']);
                        $select.='<img src="'.wp_get_attachment_url($labels['image'][$k]).'" />';
                   }
                   
                }
                $select .='</div>';
                $select .= '<a class="add_change_labels button"><span class=" dashicons dashicons-edit"></span></a>';
                $select .= '<div class="hide change_labels"><select class="selected_labels" multiple>';
                if(!empty($this->appointment_settings['instructor_labels']['label'])){
                    foreach($this->appointment_settings['instructor_labels']['label'] as $label){
                        $select .= '<option value="'.$label.'" '.(in_array($label,$saved_labels)?'selected':'').'>'.$label.'</option>';
                    }    
                }
                
                $select .='</select><input type="hidden" value="'.$user_id.'" class="uid" /><input type="hidden" value="'.wp_create_nonce('security').'" class="security" /><a class="apply_label button-primary"><span class="dashicons dashicons-yes"></span></a></div>';
                return $select;
            }
            
        }
        return $value;
    }

    function apply_uid_label(){


        if ( !isset($_POST['security']) || !wp_verify_nonce($_POST['security'],'security') || !current_user_can('manage_options')){
             _e('Security check Failed. Contact Administrator.','vibe-appointments');
            die();
        }


        if(empty($this->appointment_settings)){
            $this->appointment_settings = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        if(!empty($this->appointment_settings['instructor_labels'])){
            $labels = $this->appointment_settings['instructor_labels'];
            delete_user_meta($_POST['user_id'],'appointment_label');
            foreach($_POST['labels'] as $label){
                add_user_meta($_POST['user_id'],'appointment_label',$label);
             
                $k = array_search($label, $labels['label']);
                echo '<img src="'.wp_get_attachment_url($labels['image'][$k]).'" />';
               
            } 
        }   

        
        
        do_action('vibe_appointments_instructor_update_label');
        die();
    }


    function table_exists(){
    	$appointment = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
    	if(!$appointment->table_exists($appointment->table_name) || !$meta->table_exists($meta->table_name)){
    		echo '<div class="message error"><p>'.sprintf(__('Install Vibe Appointments tables. %s Click to install %s','vibe-appointments'),'<a href="admin.php?page=vibebp_settings&tab=appointments&install_tables" class="button-primary">','</a>').'</p></div>';
    	}
    }

    function install_tables(){

    	$current_screen = get_current_screen();
    	if($current_screen->id == 'vibe-bp_page_vibebp_settings' && !empty($_GET['tab']) && $_GET['tab'] == 'appointments' && isset($_GET['install_tables'])){
           
    		$appointment = new VIBE_APPOINTMENTS_DB;
            $meta = new VIBE_APPOINTMENTS_META_DB;
    		if(!$appointment->table_exists($appointment->table_name) || !$meta->table_exists($meta->table_name)){
    			
                if(!$appointment->table_exists($appointment->table_name)){
                    $appointment->create_table();    
                }
    			if(!$meta->table_exists($meta->table_name)){
                    $meta->create_table();
                }

    			add_action('admin_notices',function(){echo '<div class="message updated"><p>'.__('Vibe Appointments tables added.','wplms-appointments').'</p></div>';});
    			
    		}
    	}
    	
    }
}


Vibe_Appointments_Admin::init();