<?php
/**
 * Settings in Admin
 *
 * @author 		VibeThemes
 * @category 	Admin
 * @package 	wplms_appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if( !defined('VIBE_APPOINTMENTS_OPTION')){
    define('VIBE_APPOINTMENTS_OPTION','vibe_appointments');
}

class Vibe_Appointments_Settings{

	public static $instance;
    
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Settings();
        return self::$instance;
    }

	private function __construct(){
		add_filter('vibebp_settings_tabs',array($this,'setting_tab'));
		add_filter('vibebp_settings_tab',array($this,'tab'));
		add_filter('vibe_appointments_settings',array($this,'add_settings'));
	}

	function setting_tab($tabs){

		$tabs['appointments'] = __('Appointments','vibe-appointments');
		return $tabs;
	}

	function tab($name){
		if($name == 'appointments')
			return 'Vibe_Appointments_Settings';
		
		return $name;
	}

	function get_settings(){
 			
		$locale = get_locale();
        $locale=str_replace('_','-',$locale);
        if(empty($this->pages)){
			$query = new WP_Query(array(
				'post_type'=>'page',
				'posts_per_page'=>-1
			));
			$this->pages[]=__('Select page','vibe-appointments');
			while($query->have_posts()){
				$query->the_post();
				$this->pages[get_the_ID()]=get_the_title();
			}
		}
		if(empty($this->video_fields)){
			$this->video_fields = [];
			$this->otherfields = [];
			$groups = bp_xprofile_get_groups( array(
	            'fetch_fields' => true
	        ) );
	        $options_array = $otherfields = array(''=>_x('Select field','','vibe-appointments'));
	        if(!empty($groups)){
	            foreach($groups as $group){
	            
	                if ( !empty( $group->fields ) ) {
	                    //CHECK IF FIELDS ENABLED

	                    foreach ( $group->fields as $field ) {
	                        $field = xprofile_get_field( $field->id );
	                        if($field->type=='video'){
	                        	$options_array[$field->id] = $field->name.' ( '.$field->type.''.(empty($field->can_delete)?', '._x('Necessary','necessary fields for buddypress registration','vibe-appointments'):'').
	                        	')';
	                        }else{
	                        	$otherfields[$field->id] = $field->name;
	                        }
	                    } // end for
	                    
	                }
	                
	            }
	            $this->video_fields = $options_array;
	            $this->otherfields = $otherfields;
	        }
		}

		if(empty($this->cards)){
			$query = new WP_Query(array(
				'post_type'=>'member-card',
				'posts_per_page'=>-1
			));
			$this->cards[]=__('Select card','vibe-appointments');
			while($query->have_posts()){
				$query->the_post();
				$this->cards[get_the_ID()]=get_the_title();
			}
		}
		$member_types=bp_get_member_types();
		$member_types['']='Instructors [Edit posts capability]';

		$gfields = vibebp_get_setting('group_custom_fields','bp','groups');
		$group_fields = $price_fields = [''=>__('Select Group field','vibe-appointments')];
		if(!empty($gfields)){
			
			foreach($gfields['type'] as $k=>$v){
				$group_fields[$gfields['key'][$k]]=$gfields['label'][$k];
				if($v == 'product'){
					$price_fields[$gfields['key'][$k]]=$gfields['label'][$k];
				}
		 	}
		}


		return apply_filters('vibe_appointments_settings',array(
			array(
				'label' => __('Who can offer appointments','vibe-appointments'),
				'name' => 'appointments_provider',
				'type' => 'multiselect',
				'options' => $member_types,
				'default'=>'',
				'desc' => __('By default all Instructors [edit_posts capability] can manage appointments','vibe-appointments').' <a href="'.admin_url('edit-tags.php?taxonomy=bp_member_type').'" class="button">'._x('Create member type','settings admin','vibe-appointments').'</a>',
			),
			array(
				'label' => __('Appointments Minimum Slot Time','vibe-appointments'),
				'name' => 'appointments_slot_time',
				'type' => 'select',
				'options' => array(
					'15'=>__('15 Minutes','vibe-appointments'),
					'30'=>__('30 Minutes','vibe-appointments'),
					'60'=>__('1 Hour','vibe-appointments'),
					'120'=>__('2 Hour','vibe-appointments'),
					'180'=>__('3 Hour','vibe-appointments')
				),
				'default'=>'30',
				'desc' => __('Set minimum appoint slot time in minutes','vibe-appointments'),
			),
			array(
				'label' => __('Redirect to cart upon clicking on slot','vibe-appointments'),
				'name' => 'redirect_cart_click_slot',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Check this if you want user to be redirected to cart page as soon as they click on a user slot. WooCommerce required.','vibe-appointments'),
			),
			array(
				'label' => __('Buffer time for Appointments','vibe-appointments'),
				'name' => 'appointments_buffer_time',
				'type' => 'number',
				'default'=>30,
				'desc' => __('Set time (in minutes) before appointment start the booker can request cancellation ( 0 to disable ).','vibe-appointments'),
			),
			array(
				'label' => __('Show only Instructor controls to Instructors','vibe-appointments'),
				'name' => 'instructor_controls',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Remove My Bookings from Instructor panel','vibe-appointments'),
			),
			array(
				'label' => __('Enable Credits as Hours for Appointments','vibe-appointments'),
				'name' => 'credit_hours',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Run a Membership site where users can buy hours and use it to book instructors. Vibe Credits accumulate as hours.','vibe-appointments'),
			),
			array(
				'label' => __('Translate based on Location [coming up]','vibe-appointments'),
				'name' => 'locale_detection',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Detects timezone to translate calendar','vibe-appointments'),
			),
			array(
				'label' => __('Clear expired slots','vibe-appointments'),
				'name' => 'expired_slots_clear',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Sets a cron job to clear all expired and empty slots which have not been booked.','vibe-appointments'),
			),
			array(
				'label' => __('Set minutes for reminder email.','vibe-appointments'),
				'name' => 'reminder_minutes',
				'type' => 'number',
				'default'=>1,
				'desc' => __('Set minutes before reminder email should go.','vibe-appointments'),
			),
			
			array(
				'label' => __('Enable Services','vibe-appointments'),
				'name' => 'appointments_services',
				'type' => 'checkbox',
				'desc' => __('Enable this to show services offered by a member. ','vibe-appointments'),
			),
			array(
				'label' => __('Select appointments directory page','vibe-appointments'),
				'name' => 'appointments_directory_page',
				'type' => 'select',
				'options'=>$this->pages,
				'desc' => __('Select appointments directory page. Necessary to load directory on service and service type pages.','vibe-appointments'),
				'default'=>''
			),
			array(
				'label' => __('Set Instructor Labels','vibe-appointments'),
				'name' => 'instructor_labels',
				'type' => 'repeatable',
				'placeholder'=>__('Set label for instructor','vibe-appointments'),
				'desc' => __('Set labels for instructors which you can set in WP admin - users.','vibe-appointments'),
				'default'=>''
			),
			array(
				'label' => __('Select service colors','vibe-appointments'),
				'name' => 'service_colors',
				'type' => 'service_colors',
				'desc' => __('Service colors make it easy to distinguish between different services when displayed in a calendar.','vibe-appointments'),
				'default'=>''
			),
			array(
				'label' => __('Select Service commissions','vibe-appointments'),
				'name' => 'service_commissions',
				'type' => 'service_commissions',
				'desc' => __('Commission % earned by an Instructor when selling service booking.','vibe-appointments'),
				'default'=>''
			),
			array(
				'label' => __('Instructor video field','vibebp'),
				'name' => 'instructor_video_field',
				'type' => 'select',
				'options'=>$this->video_fields,
				'desc' => __('Select instructor video field here to show intro video in schedule in directory.','vibebp'),
				'default'=>''
			),
			array(
				'label' => __('Instructor sub field','vibebp'),
				'name' => 'instructor_sub_field',
				'type' => 'select',
				'options'=>$this->otherfields,
				'desc' => __('Select instructor sub field here to show below instructors name.','vibebp'),
				'default'=>''
			),
			array(
				'label' => __('Global commission percentage','vibe-appointments'),
				'name' => 'global_commission_percentage',
				'type' => 'text',
				'desc' => __('This will be global commission percentage!.','vibe-appointments'),
				'default'=>''
			),
			array(

				'label' => __('Directory member card','vibebp'),
				'name' => 'directory_member_card',
				'type' => 'select',
				'options'=>$this->cards,
				'desc' => __('Select instructor video field here to show intro video in schedule in directory.','vibebp'),
				'default'=>''
			),
			array(
				'label' => __('Enable Multiple Seats per Booking','vibe-appointments'),
				'name' => 'booking_seats',
				'type' => 'checkbox',
				'default'=>'',
				'desc' => __('Enable multiple seats per booking.','vibe-appointments'),
			),
			array(
				'label' => __('Enable Class Price ','vibe-appointments'),
				'name' => 'class_price',
				'type' => 'select',
				'options'=>$price_fields,
				'default'=>'',
				'desc' => __('Enable Class price for selling Classes. Purchasing WooCommerce product.','vibe-appointments'),
			),
			array(
				'label' => __('Enable Google Calendar sync','vibe-appointments'),
				'name' => 'enable_gcal_sync',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Enable google calendar sync option!','vibe-appointments'),
			),
			array(

				'label' => __('Google calendar client id','vibebp'),
				'name' => 'google_calendar_client_id',
				'type' => 'text',
				'desc' => __('Add google calendar client id.','vibebp'),
				'default'=>''
			),
			array(

				'label' => __('Google calendar api key','vibebp'),
				'name' => 'google_calendar_api_key',
				'type' => 'text',
				'desc' => __('Add google calendar api key.','vibebp'),
				'default'=>''
			),
			array(
				'label' => __('Who can take action on Disputes','vibe-appointments'),
				'name' => 'dispute_action',
				'type' => 'select',
				'options'=>['manage_options'=>__('Administrators only','vibe-appointments'),'edit_posts'=>__('Instructors & Administrators','vibe-appointments')],
				'desc' => __('Dispute : Post Booking. This will enable instructors to approve or reject disputes arising after bookings.','vibe-appointments'),
				'default'=>''
			),
			array(
				'label' => __('Who can Approve refunds','vibe-appointments'),
				'name' => 'refud_approval',
				'type' => 'select',
				'options'=>['manage_options'=>__('Administrators only','vibe-appointments'),'edit_posts'=>__('Instructors & Administrators','vibe-appointments')],
				'desc' => __('This will enable Instructors to approve refunds on disputed bookings.Else the Order is marked as Admin Approval.','vibe-appointments'),
				'default'=>''
			),
			
		));	
	}

	function add_settings($settings){
		if(function_exists('vibe-appointments_bbb_plugin_update')){
			$settings[]=array(
				'label' => __('Auto Create bigbluebutton meeting on appointment allocation','vibe-appointments'),
				'name' => 'vibe_bbb',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Creates bbb meetings automatically on order confirm','vibe-appointments'),
			);
		}
		if(function_exists('vibe-appointments_zoom_plugin_update')){
			$settings[]=array(
				'label' => __('Auto Create Zoom meeting on appointment allocation','vibe-appointments'),
				'name' => 'vibe_zoom',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Creates Zoom meetings automatically on order confirm','vibe-appointments'),
			);
		}

		if(function_exists('wplms_plugin_update')){
			$settings[]=array(
				'label' => __('Enable course slots','vibe-appointments'),
				'name' => 'course_slots',
				'type' => 'checkbox',
				'default'=>0,
				'desc' => __('Enable this will allow instructor to assign course to a course.','vibe-appointments'),
			);
		}
		return $settings;
	}

	function settings(){
		
		$settings = $this->get_settings();
		
		if(!isset($_GET['sub'])){$_GET['sub']='';}

		switch($_GET['sub']){
			default:

				echo '<form method="post">';
				wp_nonce_field('wplms_appointments_Settings');   
				echo '<table class="form-table">
						<tbody>';

						 $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
				

				$this->generate_form($settings);

				
				echo '<tr valign="top"><th colspan="2"><input type="submit" name="save_vibe_appointments_settings" class="button button-primary" value="'.__('Save Settings','video-vibe').'" /> </th>';
				echo '</tbody></table></form>';			
			break;
		}	
	}

	


	function generate_form($settings){
		
		$query = new WP_Query(array(
			'post_type'=>VIBE_APPOINTMENTS_SERVICE_SLUG,
			'posts_per_page'=>-1
		));
		$services = [];		
		while($query->have_posts()){
			$query->the_post();
			$services[get_the_ID()]=get_the_title();
		}

		foreach($settings as $setting ){

			if(!isset($this->settings[$setting['name']]) && !empty($setting['default']) ){
				if(is_array($setting['default'])){$setting['default']=json_encode($setting['default'],true);}
				$this->settings[$setting['name']]=$setting['default'];
			}
			
			echo '<tr valign="top">';
			$setting['std']= '';
			switch($setting['type']){
				case 'textarea':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><textarea name="'.$setting['name'].'" style="width: 50%; height: 240px;border:1px solid #DDD;">'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:'').'</textarea>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'select':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><select name="'.$setting['name'].'">';
					foreach($setting['options'] as $key=>$option){
						echo '<option value="'.$key.'" '.(isset($this->settings[$setting['name']])?selected($key,$this->settings[$setting['name']]):'').'>'.$option.'</option>';
					}
					echo '</select>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'multiselect':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><select name="'.$setting['name'].'[]" multiple>';
					foreach($setting['options'] as $key=>$option){
						echo '<option value="'.$key.'" '.((is_array($this->settings[$setting['name']]) && in_Array($key,$this->settings[$setting['name']]))?'selected':'').'>'.$option.'</option>';
					}
					echo '</select>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'checkbox':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="checkbox" name="'.$setting['name'].'" '.(isset($this->settings[$setting['name']])?'CHECKED':'').' />';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'number':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="number" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" />';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'text':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="text" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" />';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'color':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><input type="text" class="colorpicker" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" style="background:'.$this->settings[$setting['name']].'"/>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
				case 'repeatable':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp"><a class="add_new_repeatable button-primary" data-name="'.$setting['name'].'" data-placeholder="'.$setting['placeholder'].'">'.__('Add New','vibebp').'</a><ul>';

					$value = [];
					if(!empty($this->settings[$setting['name']])){
						$value = $this->settings[$setting['name']];	
					}
					
					if(!empty($value)){

						foreach($value['image'] as $k=>$item){
							echo '<li class="repeat_li"><img src="'.wp_get_attachment_url($item).'" /><input type="hidden" name="'.$setting['name'].'[image][]" value="'.$item.'"/><input type="text" name="'.$setting['name'].'[label][]" value="'.$value['label'][$k].'"/><span class="dashicons dashicons-no-alt remove_item"></span></li>';
						}
						
					}
					echo '</ul><span>'.$setting['desc'].'</span></td>';
					add_action('admin_footer',array($this,'repeatable_script'));
				break;
				
				case 'service_commissions':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp">';
					
					echo '<ul class="service_colors">';
					
						
						if(!empty($services)){
							forEach($services as $id=>$service){
								echo '<li><label>'.$service.'</label><span>
								<input type="text"  name="'.$setting['name'].'['.$id.']" value="'.(!empty($this->settings[$setting['name']]) && !empty($this->settings[$setting['name']][$id])?$this->settings[$setting['name']][$id]:'').'" placeholder="'._x('Commission percentage','','vibe-appointments').'"/>

								</span></li>';
							}
						}
						
					
					echo '</ul>';
					echo '<span>'.$setting['desc'].'</span></td>';
					
					?>
					<style>
						ul.service_colors { display:flex; flex-direction:column; justify-content:space-between; width:100%; } ul.service_colors li{ max-width:50%; display:flex; justify-content:space-between; margin:0.5rem; border-bottom:1px solid rgba(0,0,0,0.1); flex-wrap:wrap; } @media(max-width:700px){ ul.service_colors li{ max-width:100%; } }
					</style>
					<?php
				break;
				case 'service_colors':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>';
					echo '<td class="forminp">';
					
					echo '<ul class="service_colors">';
						if(!empty($services)){
							forEach($services as $id=>$service){
								echo '<li><label>'.$service.'</label><span>
								<input type="text" class="colorpicker" name="'.$setting['name'].'['.$id.']" value="'.(!empty($this->settings[$setting['name']]) && !empty($this->settings[$setting['name']][$id])?$this->settings[$setting['name']][$id]:'').'" />

							</span></li>';
							}
						}
					
					echo '</ul>';
					echo '<span>'.$setting['desc'].'</span></td>';
					wp_enqueue_style( 'wp-color-picker' );
					wp_enqueue_script( 'wp-color-picker' );
					wp_enqueue_media();
					?>
					<style>
						ul.service_colors { display:flex; flex-direction:column; justify-content:space-between; width:100%; } ul.service_colors li{ max-width:50%; display:flex; justify-content:space-between; margin:0.5rem; border-bottom:1px solid rgba(0,0,0,0.1); flex-wrap:wrap; } @media(max-width:700px){ ul.service_colors li{ max-width:100%; } }
					</style>
					<script>
						jQuery(document).ready(function($){

							$( '.colorpicker' ).wpColorPicker();
							
							$('.remove_uploaded').on('click',function(){
								$(this).parent().find('img').remove();
								$(this).parent().find('input').remove();
								$(this).parent().find('.upload_image_button').show();
								$(this).remove();
							});
							
							var media_uploader=[];
							jQuery('.upload_image_button').on('click', function( event ){
							  
							    var button = jQuery( this );
							    var input_name = button.attr( 'input-name' );

							    if ( media_uploader[input_name]) {
							      media_uploader[input_name].open();
							      return;
							    }
							    // Create the media uploader.
							    media_uploader[input_name] = wp.media.frames.media_uploader = wp.media({
							        title: button.attr( 'uploader-title' ),
							        // Tell the modal to show only images.
							        library: {
							            type: 'image',
							            query: false
							        },
							        button: {
							            text: button.attr( 'button_label' ),
							        },
							        multiple: false
							    });

							    // Create a callback when the uploader is called
							    media_uploader[input_name].on( 'select', function() {
						        	var selection = media_uploader[input_name].state().get('selection');
						            
						            selection.map( function( attachment ) {
							            attachment = attachment.toJSON();

							            var url_image='';
							            if( attachment.sizes){
							                if(   attachment.sizes.thumbnail !== undefined  ) url_image=attachment.sizes.thumbnail.url; 
							                else if( attachment.sizes.medium !== undefined ) url_image=attachment.sizes.medium.url;
							                else url_image=attachment.sizes.full.url;
							            }
							            
								        if(button.prop('tagName') == 'IMG'){
								        	button.attr('src',url_image);
								        	button.parent().find('input[name="'+input_name+'"]').val(attachment.id);
								        }else{
								        	button.html('<img src="'+url_image+'" class="submission_thumb thumbnail" /><input id="'+input_name+'" class="post_field" data-type="featured_image" data-id="'+input_name+'" name="'+input_name+'" type="hidden" value="'+attachment.id+'" />');	
								        }
							            
						         	});

							    });
							    // Open the uploader
							    media_uploader[input_name].open();
							  });
						});
						</script>
					<?php
				break;
				case 'file':
					echo '<th scope="row" class="titledesc"><label>'.$setting['label'].'</label></th>
					';
					?>
					<script>
						var $ = jQuery;
	                	var media_uploader2;
	                	jQuery(document).ready(function(){
						jQuery('.upload_pdf_button').on('click', function( event ){
						    var button = jQuery( this );
						    if ( media_uploader2 ) {
						      media_uploader2.open();
						      return;
						    }
						    // Create the media uploader.
						    media_uploader2 = wp.media.frames.media_uploader = wp.media({
						        title: button.data( 'uploader-title' ),
						        // Tell the modal to show only images.
						        library: {
						            type: 'application',
						            query: false
						        },
						        button: {
						            text: button.data( 'uploader-button-text' ),
						        },
						        multiple: false
						    });

						    // Create a callback when the uploader is called
						    media_uploader2.on( 'select', function() {
						        var selection = media_uploader2.state().get('selection');
						            
						            selection.map( function( attachment ) {
						            attachment = attachment.toJSON();
						            var pdf_url='';
						            if(attachment &&  attachment.url !== undefined ){
						               pdf_url=attachment.url;
						            }else{
						            	alert('<?php echo _x("Unable to find url of selected PDF","","vibe-appointments");?>');
						            }
						            button.parent().find('.presentation_url').val(pdf_url);
						            button.parent().find('.presentation_name').html('<a href="'+pdf_url+'" class="dashicons dashicons-visibility" target="_blank"></a>');
						         });

						    });
						    // Open the uploader
						    media_uploader2.open();
						  });
					});
	                </script>
					<?php
					echo '<td class="forminp">
							<a class="upload_pdf_button button" data-uploader-button-text="'.__('Upload PDF','vibe-appointments').'" data-input-name="'.$setting['name'].'" >'.__('Upload Default Presentation','vibe-appointments').'</a>
							<input type="hidden" class="presentation_url" name="'.$setting['name'].'" value="'.(isset($this->settings[$setting['name']])?$this->settings[$setting['name']]:$setting['std']).'" /><span class="presentation_name">'.(isset($this->settings[$setting['name']])?'<a href="'.$this->settings[$setting['name']].'" class="dashicons dashicons-visibility" target="_blank"></a>':'').'</span>';
					echo '<span>'.$setting['desc'].'</span></td>';
				break;
			}
		}
	}

	function save(){
		
		if(!isset($_POST['save_vibe_appointments_settings']))
			return;
		
		if ( !isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'],'wplms_appointments_Settings') ){
		     echo '<div class="error notice is-dismissible"><p>'.__('Security check Failed. Contact Administrator !','video-vibe').'</p></div>';
		}

		$settings = $this->get_settings();
		//print_r($settings);
		foreach($settings as $setting){
			if(isset($_POST[$setting['name']])){
				$this->settings[$setting['name']] = $_POST[$setting['name']];
			}else if($setting['type'] == 'checkbox' && isset($this->settings[$setting['name']])){
				unset($this->settings[$setting['name']]);
			}
		}
		
		update_option(VIBE_APPOINTMENTS_OPTION,$this->settings);
		echo '<div class="updated notice is-dismissible"><p>'.__('Settings Saved.','video-vibe').'</p></div>';
	}

	function repeatable_script(){
		?>
		<script>

			jQuery(document).ready(function($){
				

				const media_pop = (e) => {

					var file_frame;
	                // Create the media frame.
	                file_frame = wp.media.frames.downloadable_file = wp.media({
	                    title: "Choose an image",
	                    button: {
	                        text: "Use image"
	                    },
	                    multiple: false
	                });
	                file_frame.on( 'select', function() {
	                    var attachment = file_frame.state().get( 'selection' ).first().toJSON();

	                    jQuery(e.target).next('input[type="hidden"]').val( attachment.id );
	                    jQuery(e.target).attr('src',attachment.sizes.full.url);
	                });
	                file_frame.open();
				}

				$('.add_new_repeatable').on('click',function(){
					$(this).parent().find('ul').append('<li class="repeat_li"><img class="open_pop" src="data:," alt="Set image" /><input type="hidden" name="'+$(this).attr('data-name')+'[image][]" /><input type="text" name="'+$(this).attr('data-name')+'[labels][]" placeholder="'+$(this).attr('data-placeholder')+'" /><span class="dashicons dashicons-no-alt remove_item"></span></li>');
					
					jQuery('.open_pop').on('click',media_pop)

					$('.remove_item').on('click',function(){
						$(this).parent().remove();
					});
				});

				
			});
		</script><style>.repeat_li{display: flex;align-items: center;gap: 1rem;}.repeat_li img{width:48px;}</style>
		<?php
	}
	
}

Vibe_Appointments_Settings::init();

function Vibe_Appointments_Settings(){
	$settings = Vibe_Appointments_Settings::init();
	$settings->save(); 
	$settings->settings();	
}
