<?php
/**
 *  Vibe appointments Widgets
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


require_once(dirname(__FILE__).'/widgets/upcoming_appointments.php');

class Vibe_Appointments_Widgets{


	public static $instance;
    public $appointment_settings;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Widgets();
        return self::$instance;
    }


    function __construct(){
        add_action( 'widgets_init', array($this,'register_widgets' ));
    }

    
    function register_widgets() {
        register_widget('Upcoming_Appointments');
        
    }



}

Vibe_Appointments_Widgets::init();
          

/*======= Vibe Member Types ======== */  

class Member_Types extends WP_Widget {
 
 
    /** constructor -- name this the same as the class above */
    function __construct() {
    $widget_ops = array( 'classname' => 'Member Types Navigation', 'description' => __('Member Types Navigation', 'wplms') );
    $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'member_types' );
    parent::__construct( 'member_types', __('Member Types Navigation', 'wplms'), $widget_ops, $control_ops );
  }
        
 
    /** @see WP_Widget::widget -- do not rename this */
    function widget( $args, $instance ) {
        global $bp;
        if($bp->current_component != 'members' || empty($bp->members)){
            return;
        }
        if(!function_exists('bp_get_member_type_object') || !function_exists('bp_get_members_member_type_base') || !function_exists('bp_get_member_types'))
            return;
        extract( $args );
    
        $title = (isset($instance['title'])?apply_filters('widget_title', $instance['title'] ):'');
        $exclude_member_types = (isset($instance['exclude_member_types'])?esc_attr($instance['exclude_member_types']):'');
        
        
        echo $before_widget;
       
        $type_object = bp_get_member_type_object( bp_get_current_member_type() );
        if(!empty($type_object->directory_slug)){
            $current_type = $type_object->directory_slug;
        }
        
        $mt_base_slug = bp_get_members_member_type_base();
        if(function_exists('bp_get_member_types')){
            $all_member_types = bp_get_member_types( array(), 'objects' );
        }
        $args['exclude'] = $exclude_member_types;
        $pages = get_option('bp-pages');
        $members_dir = isset($pages['members'])?$pages['members']:0;
        echo '<div class="course_cat_nav"><ul class=" '.$order.'">';

        echo '<li class="'.((bp_current_component() == 'members' && is_page() && empty($current_type ))?'current-cat':'').'"><a href="'.get_permalink($members_dir).'">'.get_the_title($members_dir).'</a></li>';
        global $wpdb;
        $orderArray = array();
        $saved_member_types = get_option('wplms_member_types');
        foreach($saved_member_types as $key => $saved_member_type){
            $orderArray[] = $saved_member_type['id'];
        }
        
        $ordered = array();
        foreach ($orderArray as $key) {
            if (array_key_exists($key, $all_member_types)) {
                $ordered[$key] = $all_member_types[$key];
                unset($all_member_types[$key]);
            }
        }
        $all_member_types =  $ordered + $all_member_types;
        if(!empty($exclude_member_types)){
            $exclude_member_types_array = explode(',',$exclude_member_types); 
        }
        if(!empty($exclude_member_types_array)){
            foreach ($exclude_member_types_array as  $exclude) {
                unset($all_member_types[$exclude]);
            }
        }
        if(!empty($all_member_types)){
            foreach($all_member_types as $key => $member_type){

                if ( ! bp_is_root_blog() ) {
                    switch_to_blog( bp_get_root_blog_id() );
                }
                $sql = array(
                    'select' => "SELECT tt.count FROM {$wpdb->term_taxonomy} tt LEFT JOIN {$wpdb->terms} t",
                    'on'     => 'ON tt.term_id = t.term_id',
                    'where'  => $wpdb->prepare( "WHERE tt.taxonomy = '%s' AND t.slug = '%s'", 'bp_member_type',$key),
                );
                $member_type_count = $wpdb->get_var( join( ' ', $sql ) );
                restore_current_blog();

                if(empty($member_type_count))
                    $member_type_count=0;
                echo '<li class="'.$key.' '.((!empty($current_type ) && $current_type  == $key)?'current-cat':'').'">
                        <a href="'.get_permalink($members_dir).(!empty($mt_base_slug)?$mt_base_slug:'type').'/'.$key.'">'.$member_type->labels['name'].'
                            <span>'.$member_type_count .'</span>
                        </a> 
                    </li>';
            }
        }
        
        echo '</ul></div>';
        echo $after_widget;
                
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
    $instance = $old_instance;
    $instance['title'] = strip_tags($new_instance['title']);
    $instance['exclude_member_types'] = $new_instance['exclude_member_types'];
  
    
    return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                    'title'  => __('Member Types','wplms'),
                    'exclude_ids'  => '',
                    'hierarchial'=>0,
                    'sort'  => 'DESC',
                    'order' => ''
                    );
      
      $instance = wp_parse_args( (array) $instance, $defaults );
      $title  = esc_attr($instance['title']);
      $exclude_member_types = esc_attr($instance['exclude_member_types']);
                                 
        ?>
         
         <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
     
        <p>
          <label for="<?php echo $this->get_field_id('exclude_member_types'); ?>"><?php _e('Exclude member types slugs (comma saperated):','wplms'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('exclude_member_types'); ?>" name="<?php echo $this->get_field_name('exclude_member_types'); ?>" type="text" value="<?php echo $exclude_member_types; ?>" />
        </p>
        
        <?php 
        wp_reset_query();
        wp_reset_postdata();
    }
}