<?php 

class Upcoming_Appointments extends WP_Widget {
 
 
    /** constructor -- name this the same as the class above */
    function __construct() {
    $widget_ops = array( 'classname' => 'upcoming_appointments_widget', 'description' => __('UpComing Appointments', 'vibe-appointments') );
    $control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'member_types' );
    parent::__construct( 'upcoming_appointments_widget', __('UpComing Appointments', 'vibe-appointments'), $widget_ops, $control_ops );
  }
        
 
    /** @see WP_Widget::widget -- do not rename this */
    function widget( $args, $instance ) {
        
        extract( $args );
        

        $title = (isset($instance['title'])?apply_filters('widget_title', $instance['title'] ):'');
        $number = (isset($instance['number'])?esc_attr($instance['number']):5);
        
        
        echo $before_widget;
       

        $init = VibeBP_Init::init();
        if(!empty($init->user_id)){
            $user_id = $init->user_id;
        }
        if(Empty($user_id) && is_user_logged_in()){
            $user_id = get_current_user_id();    
        }

        if(!empty($user_id)){

            $args = array(
                'number'=>$number,
                'start_date'=>time()*1000,
                'booker_id'=>$user_id,
                'orderby'           => 'start_date',
                'order'             => 'ASC',
                'status'=> 'upcoming',
                'offset' => 0
            );
            
            $slots = $db->get_appointments($args);
            if(!empty($slots)){
                foreach($slots as $i=>$slot){

                    $slots[$i] =  vibe_appointments_get_next_scheduled_slot($slot);
                   
                    if(!empty($slots[$i]['item_id'])){
                        $slots[$i]['additional']= apply_filters('addition_slot_data','',$slot);
                    }
                    $values = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'google_calendar_users'));
                    if(!empty($values)){
                        $slots[$i]['google_calendar_users'] = maybe_unserialize($values[0]['meta_value']);
                    }
                }
            }

            if(!empty($slots)){
                echo '
                    <div className="appointment_items_wrapper">';
                foreach($slots as $i=>$slot){
                echo '
                    <div className="appointment_item_wrapper">';
                    
                    if(!empty($slot['additional'])){

                        echo '<div className="appointment_item_header" style="border-top:3px solid '.$slot['additional']['color'].'">
                                <div className="post_details">
                                    <img src="'.$slot['additional']['image'].'" />
                                    <strong>'.$slot['additional']['title'].'</strong>
                                </div>
                            </div>';
                    }
               
                    echo '<div className="appointment_item">

                            <div className="appointment_details">
                                <div className="slot_id">
                                    <span>'.esc_html__('Appointment ID ','vibe-appointments').'['.$slot['appointment_id'].'</span>
                                </div>
                                <div className="appointment_date wrapped">
                                    <span>
                                        <span className="vicon vicon-calendar"></span>
                                        {DTE}
                                    </span>
                                    <span className="enlarged"> 
                                        <span className="vicon vicon-time"></span>
                                        <span>{moment(parseInt(slot.start_date)).format(window.vibeappointments.settings.time_format)}</span>
                                        <span>-</span>
                                        <span>{moment(parseInt(slot.end_date)).format(window.vibeappointments.settings.time_format)}</span>
                                    </span>
                                </div>
                            </div>
                        </div>';
                    echo '<div className="appointment_details_footer">
                   
                            <div className="appointment_author_avatar">
                                <img src={avatar.avatar} className="vibebp_avatar" onClick={props.click} alt={avatar.name} title={avatar.name} />
                                <strong>
                                    {avatar.name}
                                </strong>
                            </div>
                        </div>
                    </div>';
                }
                echo '</div>';
            }else{
               echo '<div class="vbp_message">'.esc_html__('No upcoming appointments','vibe-appointments').'</div>'; 
            }
        }else{
            echo '<div class="vbp_message">'.esc_html__('Unidentified user','vibe-appointments').'</div>';
        }
        
        echo $after_widget;
                
    }
 
    /** @see WP_Widget::update -- do not rename this */
    function update($new_instance, $old_instance) {   
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['number'] = $new_instance['number'];
      
        
        return $instance;
    }
 
    /** @see WP_Widget::form -- do not rename this */
    function form($instance) {  
        $defaults = array( 
                    'title'  => __('Upcoming Appointments','vibe-appointments'),
                    'number'  => '',
                );
      
      $instance = wp_parse_args( (array) $instance, $defaults );
      $title  = esc_attr($instance['title']);
      $number = esc_attr($instance['number']);
                                 
        ?>
         
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:','vibe-appointments'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" />
        </p>
     
        <p>
          <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Number of Appointments to show:','vibe-appointments'); ?></label> 
          <input class="regular_text" id="<?php echo $this->get_field_id('number'); ?>" name="<?php echo $this->get_field_name('number'); ?>" type="text" value="<?php echo $number; ?>" />
        </p>
        
        <?php 
        wp_reset_query();
        wp_reset_postdata();
    }
}