<?php
/**
 * API WPLMS appointments
 *
 * @author      VibeThemes
 * @category    Init
 * @package     wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


class Vibe_Appointments_New_Api{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_New_Api();
        return self::$instance;
    }


    function __construct(){

        add_action('rest_api_init',array($this,'register_routes'));
    }
 

    function register_routes(){
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/booker/getbookings', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_user_bookings' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/author/getbookings', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_author_bookings' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getReview', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_event_review' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );


        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/booker/getreviews', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_booker_reviews' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/author/getreviews', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_author_reviews' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/booker/getitembookings', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getitembookings' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        
        
         
    }

    function get_user_permissions_check($request){
        
        $body = json_decode($request->get_body(),true);
        

        if(!empty($body['token'])){
            
            $this->user = apply_filters('vibebp_api_get_user_from_token','',$body['token']);
            if(!empty($this->user)){
                return true;
            }
        }

        return false;
    }

    function get_booker_reviews($request){
        $body = json_decode($request->get_body(),true);
        $return = array('status'=>false);
        $per_page = apply_filters('vibe_appointments_comments_per_page',10);
        $offset = ($body['filter']['page']-1)*$per_page;

        global $wpdb;
        $total = $wpdb->get_var($wpdb->prepare("
            SELECT count(*) 
            FROM {$wpdb->comments}
            WHERE comment_agent = 'appointments' 
            AND comment_type = 'instructor_review' 
            AND comment_approved = 1
            AND user_id = %d",$this->user->id));
        $results = $wpdb->get_results($wpdb->prepare("
            SELECT * 
            FROM {$wpdb->comments}
            WHERE comment_agent = 'appointments' 
            AND comment_type = 'instructor_review' 
            AND comment_approved = 1
            AND user_id = %d
            LIMIT %d,%d",$this->user->id,$offset,$per_page),ARRAY_A);
        $reviews=[];
        if(!empty($results)){
            foreach($results as $k=>$result){
                $appointment =$this->get_appointment($result['comment_post_ID']);
                if(!empty($appointment)){
                    $reviews[]=array(
                        'appointment_id'=>$result['comment_post_ID'],
                        'review_comment_id'=>$result['comment_ID'],
                        'review_title'=>get_comment_meta($result['comment_ID'],'appointment_review_title',true),
                        'review_rating'=>get_comment_meta($result['comment_ID'],'appointment_review_rating',true),
                        'review_content'=>$result['comment_content'],
                        'appointment'=> $appointment
                    );
                }
                
            }
            $return = array('status'=>true,'reviews'=>$reviews,'total'=>$total);
        }
        
        return new WP_REST_Response( $return, 200 );
    }

    function get_appointment($id){
        $db = new VIBE_APPOINTMENTS_DB;
        $args = array(
            'appointment_id'=>$id
        );

        $slots = $db->get_appointments($args);
        if(!empty($slots) && $slots[0]['booker_id'] ){
            return $slots[0];
        }
    }

    function get_event_review($request){
        $body = json_decode($request->get_body(),true);
        $slot = [];
        $return = array('status'=>false);
        if(!empty($body) && !empty($body['event'])){
            $slot =  $body['event'];

            global $wpdb;
            $results = $wpdb->get_results($wpdb->prepare("
                SELECT * 
                FROM {$wpdb->comments}
                WHERE comment_post_ID = %d 
                AND comment_agent = 'appointments' 
                AND comment_type = 'instructor_review' 
                AND comment_approved = 1
                AND user_id = %d
                LIMIT 0,1",$slot['appointment_id'],$this->user->id),ARRAY_A);
            if(!empty($results)){
                $comment_id =$results[0]['comment_ID'];
                $review=array(
                    'appointment_id'=>$slot['appointment_id'],
                    'review_comment_id'=>$results[0]['comment_ID'],
                    'review_title'=>get_comment_meta($results[0]['comment_ID'],'appointment_review_title',true),
                    'review_rating'=>get_comment_meta($results[0]['comment_ID'],'appointment_review_rating',true),
                    'review_content'=>$results[0]['comment_content'],
                );
                $return = array('status'=>true,'review'=>$review);
            }
        }
        return new WP_REST_Response( $return, 200 );
    }

    function get_user_bookings($request){
        $return = array('status'=>false);

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $post = apply_filters('vibe_appointments_get_user_bookings',json_decode($request->get_body(),true));
        $slots = [];
        $total =0;
        if(!empty($post)){
            $number = apply_filters('vibe_appointments_get_bookings_number',20);
            $args = $defaults = [];
            if(empty($post['filter']['status'])){$post['filter']['status']='booked';}
            switch($post['filter']['status']){
                case 'booked':
                    $defaults = array(
                        'number'=>$number,
                        'start_date'=>(time()*1000),
                        'booker_id'=>$this->user->id,
                        'orderby'=> 'start_date',
                        'order' => 'ASC',
                        'sort'  => 'upcoming',
                        //'status'=>'booked',
                    );
                    
                    $args = apply_filters('vibe_appointments_get_bookings',array(
                        'number'=>$number,
                        'start_date'=>empty($post['filter']['start'])?'':$post['filter']['start'],
                        'booker_id'=>$this->user->id,
                        'orderby'           => 'start_date',
                        'order'             => 'ASC',
                        //'status'=>$post['filter']['status'],
                        'offset' => (($post['filter']['page']-1)*$number),
                        'metas'=>(empty($post['filter']['metas'])?'':$post['filter']['metas'])
                    ),$request);
                    $args = wp_parse_args($args,$defaults);

                break;
                case 'previous':
                    $defaults = array(
                        'number'=>$number,
                        'end_date'=>(time()*1000),
                        'booker_id'=>$this->user->id,
                        'orderby'=> 'end_date',
                        'order' => 'DESC',
                    );
                    $args = apply_filters('vibe_appointments_get_bookings',array(
                        'number'=>$number,
                        'end_date'=>$post['filter']['end'],
                        'booker_id'=>$this->user->id,
                        'orderby'           => 'end_date',
                        'order'             => 'DESC',
                        'offset' => (($post['filter']['page']-1)*$number)
                    ),$request);
                    
                break;
                case 'pending':
                    $p_slots = vibe_appointments_get_pending_slots(array('booker_id'=>$this->user->id));
                    $pending_slot_ids= [];
                    if(!empty($p_slots)){
                        foreach($p_slots as $slot_id => $value){
                            $pending_slot_ids[]=$slot_id; 
                        }
                    }
                    $pending_slots=[];
                    if(!empty($pending_slot_ids)){
                        //Small request Pending slots only exist for 30 minutes
                        $args = apply_filters('vibe_appointments_get_pending_slots',array(
                            'number'=>$number,
                            'offset' => (($post['filter']['page']-1)*$number),
                            'appointment_id'=>array_values($pending_slot_ids),
                            'status'=>'open'
                        ),$request);
                        $slots = $db->get_appointments($args);
                        $total = $db->get_appointments($args,true,true);
                        $buffer_time = apply_filters('vibe_appointments_pending_slots_buffer_time',1800);
                        foreach($slots as $i=>$s){
                            if(!empty($p_slots[$s['appointment_id']])){
                                $slots[$i]['timer']=(intval($p_slots[$s['appointment_id']])+$buffer_time)*1000;    
                            }else{
                                $slots[$i]['timer']=(time()+$buffer_time)*1000;
                            }
                        }

                    }
                break;
            }

            if(empty($post['filter']['status']) || $post['filter']['status']!=='pending'){
                $args = wp_parse_args($args,$defaults);

                $slots = $db->get_appointments($args);
                $total =$db->get_appointments($args,true,true);
                
            }
            
            if(!empty($slots)){
                foreach($slots as $i=>$slot){

                    $slots[$i] =  vibe_appointments_get_next_scheduled_slot($slot);
                   
                    if(!empty($slots[$i]['item_id'])){
                        $slots[$i]['additional']= apply_filters('addition_slot_data','',$slot);
                    }
                    $values = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'google_calendar_users'));

                    $cancel_requesters = $meta->get_appointments_meta(array(
                        'appointment_id'=>$slot['appointment_id'],
                        'meta_key'=>'cancellation_request',
                        'meta_value'=> $this->user->id,
                    ));
                    if(!empty($cancel_requesters) && !empty($cancel_requesters[0])){
                        $slots[$i]['cancellation_requested'] = true;
                    }

                    $disputes = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'dispute'));
                    if(!empty($disputes)){
                         if(empty($slots[$i]['meta'])){
                            $slots[$i]['meta']=[];
                         }
                         foreach($disputes as $dispute){
                            $slots[$i]['meta'][]=['meta_key'=>'dispute','meta_value'=>$dispute['meta_value']]  ;
                         }
                         
                    }

                    if(!empty($values)){
                        $slots[$i]['google_calendar_users'] = maybe_unserialize($values[0]['meta_value']);
                    }
                }
            }
            
            $return = array('status'=>true,'bookings'=>$slots,'total'=>$total);
        }

        return new WP_REST_Response( $return, 200 );
    }


    function get_author_bookings($request){
        $return = array('status'=>false);

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $slots = [];
        $total =0;
        $post = json_decode($request->get_body(),true);
        $post = apply_filters('vibe_appointments_get_author_bookings',json_decode($request->get_body(),true));
        if(!empty($post)){
            $number = apply_filters('vibe_appointments_get_bookings_number',150);
            $args = $defaults = [];
            switch($post['filter']['status']){
                case 'booked':
                    $defaults = array(
                        'number'=>$number,
                        'start_date'=>(time()*1000),
                        'author_id'=>$this->user->id,
                        'booker_id'=>'EXISTS',
                        'orderby'=> 'start_date',
                        'order' => 'ASC'
                    );
                    
                    $args = apply_filters('vibe_appointments_get_bookings',array(
                        'number'=>$number,
                        'start_date'=>$post['filter']['start'],
                        'author_id'=>$this->user->id,
                        'orderby'           => 'start_date',
                        'order'             => 'ASC',
                        'sort'              => 'upcoming',
                        'offset' => (($post['filter']['page']-1)*$number)
                    ),$request);
                    
                break;
                case 'previous':
                    $defaults = array(
                        'number'=>$number,
                        'end_date'=>(time()*1000),
                        'author_id'=>$this->user->id,
                        'booker_id'=>'EXISTS',
                        'orderby'=> 'end_date',
                        'order' => 'DESC',
                    );
                    
                    $args = apply_filters('vibe_appointments_get_bookings',array(
                        'number'=>$number,
                        'end_date'=>$post['filter']['end'],
                        'author_id'=>$this->user->id,
                        'orderby'           => 'end_date',
                        'order'             => 'DESC',
                        'offset' => (($post['filter']['page']-1)*$number)
                    ),$request);
                    
                break;
                case 'pending':
                    $p_slots = vibe_appointments_get_pending_slots(array('instructor_id'=>$this->user->id));
                    $pending_slot_ids= [];
                    if(!empty($p_slots)){
                        foreach($p_slots as $slot_id => $value){
                            $pending_slot_ids[]=$slot_id; 
                        }
                    }
                    $pending_slots=[];
                    if(!empty($pending_slot_ids)){
                        //Small request Pending slots only exist for 30 minutes
                        $args = apply_filters('vibe_appointments_get_pending_slots',array(
                            'number'=>$number,
                            'offset' => (($post['filter']['page']-1)*$number),
                            'appointment_id'=>array_values($pending_slot_ids),
                            'status'=>'open'
                        ),$request);
                        $slots = $db->get_appointments($args);
                        $total = $db->num_rows($args);
                        $buffer_time = apply_filters('vibe_appointments_pending_slots_buffer_time',1800);

                        foreach($slots as $i=>$s){
                            $booker_id =0;
                            if(empty($s['booker_id'])){
                                $metas = $meta->get_appointments_meta(array('appointment_id'=>$s['appointment_id'],'meta_key'=>'request_booker_id','single'=>true));
                                if(!empty($metas)){
                                    $slots[$i]['booker_id'] =  $metas[0]['meta_value'];
                                }
                            }
                            if(!empty($p_slots[$s['appointment_id']])){
                                $slots[$i]['timer']=(intval($p_slots[$s['appointment_id']])+$buffer_time)*1000;    
                            }else{
                                $slots[$i]['timer']=(time()+$buffer_time)*1000;
                            }
                            
                        }
                    }
                break;
                case 'cancel_requests':
                    global $wpdb;
                    $table_name_meta = $wpdb->prefix . 'wplms_appointments_meta';
                    $table_name =$wpdb->prefix . 'wplms_appointments';
                    $user_id = $this->user->id;
                    $offset = (($post['filter']['page']-1)*$number);

                    if(in_array('manage_options',(Array)$this->user->caps)){
                        $slots = $wpdb->get_results("SELECT *  FROM {$table_name} as a LEFT JOIN {$table_name_meta} as am ON a.appointment_id=am.appointment_id WHERE am.meta_key IN ('cancellation_request','dispute') LIMIT {$offset},{$number}",ARRAY_A);
                    }else{
                        $slots = $wpdb->get_results("SELECT *  FROM {$table_name} as a LEFT JOIN {$table_name_meta} as am ON a.appointment_id=am.appointment_id WHERE am.meta_key IN ('cancellation_request','dispute') AND a.author_id = {$user_id} LIMIT {$offset},{$number}",ARRAY_A);
                    }

                    if(!empty($slots)){
                        $newslots=[];
                        
                        foreach($slots as $k=>$slot){

                            if(!in_array($slot['appointment_id'],$newslots)){
                                $newslots[]=$slot['appointment_id'];
                            }else{
                                unset($slots[$k]);
                            }
                        }
                    }
                    
                break;
            }

            if($post['filter']['status']!=='pending' && $post['filter']['status']!=='cancel_requests'){
                $args = wp_parse_args($args,$defaults);
                $slots = $db->get_appointments($args);
                $total = $db->num_rows($args);
            }

            if(!empty($slots)){
                foreach($slots as $i=>$slot){

                    $slots[$i] =  vibe_appointments_get_next_scheduled_slot($slot);

                    if(!empty($slots[$i]['item_id'])){
                        $slots[$i]['additional']= apply_filters('addition_slot_data','',$slot);
                    }
                    $values = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'google_calendar_users'));
                    if(!empty($values)){
                        $slots[$i]['google_calendar_users'] = maybe_unserialize($values[0]['meta_value']);
                    }


                    $disputes = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'dispute'));
                    if(!empty($disputes)){
                         if(empty($slots[$i]['meta'])){
                            $slots[$i]['meta']=[];
                         }
                         foreach($disputes as $dispute){

                            $slots[$i]['meta'][]=['meta_key'=>'dispute','meta_value'=>$dispute['meta_value']]  ;
                         }
                         
                    }

                    $booker_ids = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'booker_id'));
                    if(!empty($booker_ids)){
                         if(empty($slots[$i]['users'])){
                            $slots[$i]['users']=[];
                         }
                         if(!empty($slots[$i]['booker_id'])){
                            $booker_ids[]=['meta_value'=>$slots[$i]['booker_id']];
                         }
                         foreach($booker_ids as $booker_id){
                            $slots[$i]['users'][]=[
                                'avatar'=> (function_exists('bp_core_fetch_avatar')?bp_core_fetch_avatar(array(
                                    'item_id' => $booker_id['meta_value'],
                                    'object'  => 'user',
                                    'type'=>'full',
                                    'html'    => false
                                )):plugins_url( '../../assets/images/avatar.jpg',  __FILE__ )),
                                'name'=>bp_core_get_user_displayname($booker_id['meta_value'])]  ;
                         }
                         
                    }
                }
            }

            $return = array('status'=>true,'bookings'=>$slots,'total'=>$total,'$args'=>$args);
        }

        return new WP_REST_Response( $return, 200 );
    }

    function getitembookings($request){
        $return = array('status'=>false);
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $post = json_decode($request->get_body(),true);
        $slots = [];
        $total =0;
        if(!empty($post)){
            $args = $defaults = [];
            $defaults = array(
                'start_date'=>(time()*1000),
                'end_date'=>((time()+(7*86400))*1000),
                'booker_id'=>$this->user->id,
            );
            
            $args = apply_filters('vibe_appointments_get_bookings',array(
                'number'=>99999,
                'start_date'=>$post['filter']['start'],
                'end_date'=>$post['filter']['end'],
                'booker_id'=>$this->user->id,
            ),$request);

            if(!empty($post['filter']['type'])){
                $args['type'] = $post['filter']['type'];
            }
            if(!empty($post['filter']['item_id'])){
                $args['item_id'] = $post['filter']['item_id'];
            }
            $args = wp_parse_args($args,$defaults);

            if(!empty($post['filter']['metas'])){
                $args['metas']= $post['filter']['metas'];    
            }
            $slots = $db->get_appointments($args);
            $authors= [];
            if(!empty($slots)){
                foreach($slots as $k=>$s){
                    if(!empty($s['author_id']) && !in_array($s['author_id'], $authors)){
                        $authors[] = $s['author_id'];
                        $slots = $this->filter_active_slots($authors,$this->user->id,$slots);
                    }
                }
            }
            $return = array('status'=>true,'bookings'=>$slots,'$args'=>$args);
        }
        return new WP_REST_Response( $return, 200 );
    }

    function filter_active_slots($authors,$booker_id,$slots){
        if(!empty($authors)){
            foreach ($authors as $key => $author_id) {
                if(!empty($booker_id)){
                    $active_slots = vibe_appointments_get_active_slots();
                    if(empty($active_slots)){
                        $active_slots = array();
                    }
                    $pslot_ids = vibe_appointments_get_pending_slots(array('booker_id'=>$booker_id));
                    $nslots = [];
                    foreach($slots as $index=>$slot){
                        $aindex = $this->check_active_appointment($slot,$active_slots);
                        if($aindex>-1 && $active_slots[$aindex]['booker_id']==$booker_id){
                            //means slot is active
                        }else{
                            if(!empty($pslot_ids) && in_array($slot['appointment_id'],array_keys($pslot_ids))){
                                $slots[$index]['title']=_x('Booking Requested','calendar slot note','vibe-appointments');
                            }
                            $nslots[] = $slots[$index];
                        }
                    }
                    $slots = $nslots;
                }
                $slot_ids = vibe_appointments_get_pending_slots(array('instructor_id'=>$author_id));
                if(!empty($slot_ids)){
                    $nslots = [];
                    foreach($slots as $index=>$slot){
                        if(in_array($slot['appointment_id'],array_keys($slot_ids)) && empty($slot['title'])){
                            //unset($slots[$index]);
                        }else{
                            $nslots[] = $slots[$index];
                        }
                    }
                    $slots = $nslots;
                }
            }
        }
        return $slots;
    }


    function check_active_appointment($slot,$activeslots){
        if(!empty($activeslots)){
            foreach($activeslots as $k=>$aslot){
                if((!empty($aslot['id']) && $aslot['id']==$slot['appointment_id']) || (!empty($aslot['appointment_id']) && $aslot['appointment_id']==$slot['appointment_id'])){
                    return $k;
                }
            }
        }   
        return -1;
    }

}

Vibe_Appointments_New_Api::init();