<?php
/**
 * API WPLMS appointments
 *
 * @author      VibeThemes
 * @category    Init
 * @package     wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


class Vibe_Appointments_User_Api{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_User_Api();
        return self::$instance;
    }


    function __construct(){

        add_action('rest_api_init',array($this,'register_routes'));
    }
 

    function register_routes(){
        //VIBE_APPOINTMENTS_API_NAMESPACE
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getAppointments', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_appointment_appointments' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getSlots', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_appointment_slots' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );


        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/saveSlots', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'save_appointment_slots' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getBookings', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_appointment_bookings' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getCompletedBookings', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_completed_bookings' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/postReview', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'post_booking_review' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/requestcancellation', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'requestcancellation' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/cancelrequestcancellation', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'cancelrequestcancellation' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/addBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'add_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/removeBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'remove_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/addParentAppointment', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'addParentAppointment' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/rescheduleAppointment', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'rescheduleAppointment' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );



        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/appointmentDetails/googlesync', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'appointment_google_sync' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/appointmentDetails/(?P<id>\d+)?', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'appointment_details' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/acceptBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'accept_appointment_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/rejectBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'reject_appointment_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getAppointmentPrice', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getAppointmentPrice' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );


        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/completeBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'completeBooking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/setAppointmentPrice', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'setAppointmentPrice' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );


        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getEnrolledServices', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getEnrolledServices' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getUserEnrolledServices', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getUserEnrolledServices' ),
            'permission_callback' => array( $this, 'get_public_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getAllServices', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getAllServices' ),
            'permission_callback' => array( $this, 'get_public_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/saveEnrolledServices', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'saveEnrolledServices' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getservicespricing', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getservicespricing' ),
            'permission_callback' => array( $this, 'get_public_permissions_check' ),
        ) );


        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/postActivity', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'postActivity' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        //Directories
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/members', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'get_members' ),
                'permission_callback' => '__return_true'
            ),
        ));

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/search', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'search_sharing_values' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) ); 

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/book-appointment', array( //course
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'book_appointment' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getServices', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'getServices' ),
                'permission_callback'       => array( $this, 'get_user_permissions_check' ),
               
            ),
        ));
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/taxonomy', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'get_taxonomy' ),
                'permission_callback'       => array( $this, 'get_public_permissions_check' ),
            ),
        ));
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/servicedata', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'servicedata' ),
                'permission_callback'       => array( $this, 'get_public_permissions_check' ),
            ),
        ));

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getPriceRange', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'getPriceRange' ),
                'permission_callback'       => array( $this, 'get_public_permissions_check' ),
            ),
        ));

        

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/findService', array(
            array(
                'methods'             =>  'POST',
                'callback'            =>  array( $this, 'findService' ),
                'permission_callback'       => array( $this, 'get_public_permissions_check' ),
            ),
        ));
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/checkBookingCredits', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'checkBookingCredits' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/updateBookingItemID', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'updateBookingItemID' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );


        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/favourites', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'favourites' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/favourite', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'favourite' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getEventMessageThread', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getEventMessageThread' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/submitDispute', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'submitDispute' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/disputeAction', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'disputeAction' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getEventDisputeThreads', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getEventDisputeThreads' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/cancellationRequestAction', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'cancellationRequestAction' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        
        
    }
    

    function get_public_permissions_check($request){
        $client_id = $request->get_param('client_id');
        if($client_id == vibebp_get_setting('client_id')){
            return true;
        }
        return $this->get_user_permissions_check($request);
    }

    function get_user_permissions_check($request){
        
        $body = json_decode($request->get_body(),true);
        
        
        if(!empty($body['token'])){
            
            $this->user = apply_filters('vibebp_api_get_user_from_token','',$body['token']);
            if(!empty($this->user)){
                return true;
            }
        }

        return false;
    }

    function findService($request){
        $body = json_decode($request->get_body(),true);
        $posts_not_in = [];
        if(!empty($body['preloaded'])){
            
            foreach($body['preloaded'] as $s){
                $posts_not_in[]=$s['id'];
            }
        }

        $query = new WP_Query([
            'post_type'=>'service',
            's'=>sanitize_title($body['searchText']),
            'posts_not_in'=>$posts_not_in
        ]);

        if($query->have_posts()){
            $services = [];
            while($query->have_posts()){
                $query->the_post();
                $services[]=[
                    'id'=>get_the_ID(),
                    'text'=>get_the_title()
                ];
            }
            if(count($services)){
                $return=[
                    'status'=>1,
                    'services'=>$services,
                    'message'=>sprintf(__('%s services found','vibe-appointments'),count($services))
                ];    
            }
            
        }else{
            $return=['status'=>1,'services'=>[],'message'=>__('No service found','vibe-appointments')];
        }

        return new WP_REST_Response( $return, 200 );
    }

    function get_manage_appointment_slots($request){

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $args = json_decode($request->get_param('args'));
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($args)){
            $body = json_decode($request->get_body(),true);
            $_args = $args = (object)$body['filter'];
            $args = array(
                'number'=>999,
                'appointment_id'=>!empty($args->appointment_id)?$args->appointment_id:0,
                'start_date'=>$args->start,
                'end_date'=>$args->end,
                'item_id'=>(!empty($args->item_id)?$args->item_id:'any'),
                'author_id'=>!empty($args->user_id)?$args->user_id:(!empty($args->admin)?null:$this->user->id),
                'status'=>'open'
            );
        }else{
            $args =array(
                'number'=>999,
                'appointment_id'=>$args->appointment_id?$args->appointment_id:0,
                'start_date'=>$args->start_date,
                'end_date'=>$args->end_date,
                'start_time'=>$args->start_time,
                'end_time'=>$args->end_time,
                'item_id'=>(!empty($args->item_id)?$args->item_id:'any'),
                'author_id'=>$args->user_id?$args->user_id:(!empty($args->admin)?null:$this->user->id),
                'status'=>'open',
            );
        }
        if(!empty($_args->status)){
            $args['status']=$_args->status;
        }


        $args =  apply_filters('vibe_appointments_get_slots',$args,$request);
        $slots = $db->get_appointments($args); 
        if(!empty($slots)){
            foreach($slots as $key => $slot){
                if(!empty($slot['item_id']) && get_post_status($slot['item_id'])=='publish'){
                    $color = null;
                    if(!empty($this->settings['service_colors']) && !empty($this->settings['service_colors'][$slot['item_id']])){
                        $color=$this->settings['service_colors'][$slot['item_id']];
                    }
                    $slots[$key]['meta'] = array(
                        'type'=>$this->get_appointment_name_from_type($slot['type']),
                        'label'=>get_the_title($slot['item_id']),
                        'color'=>$color,
                    );
                }
                $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
                
                if(!empty($slot['type']) && strpos($slot['type'], 'recurring_')!==false){
                    //recurring appointment
                    $slots[$key]['days_of_week'] = explode('_',str_replace('recurring_', '', $slot['type'])); 
                }

            }
        }

        return new WP_REST_Response( array('status'=>1,'slots'=>$slots,'args'=>$args), 200 );
    }

    function get_appointment_slots($request){

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $args = json_decode($request->get_param('args'));
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($args)){
            $body = json_decode($request->get_body(),true);
            $_args = $args = (object)$body['filter'];
            $args = array(
                'number'=>999,
                'appointment_id'=>!empty($args->appointment_id)?$args->appointment_id:0,
                'start_date'=>$args->start,
                'end_date'=>$args->end,
                'item_id'=>(!empty($args->item_id)?$args->item_id:'any'),
                'author_id'=>!empty($args->user_id)?$args->user_id:(!empty($args->admin)?null:$this->user->id),
                'status'=>'open'
            );
        }else{
            $args =array(
                'number'=>999,
                'appointment_id'=>$args->appointment_id?$args->appointment_id:0,
                'start_date'=>$args->start_date,
                'end_date'=>$args->end_date,
                'start_time'=>$args->start_time,
                'end_time'=>$args->end_time,
                'item_id'=>(!empty($args->item_id)?$args->item_id:'any'),
                'author_id'=>$args->user_id?$args->user_id:(!empty($args->admin)?null:$this->user->id),
                'status'=>'open'
            );
        }

        if(!empty($_args->status)){
            $args['status']=$_args->status;
        }


        $args =  apply_filters('vibe_appointments_get_slots',$args,$request);
        
        
        $slots = $db->get_appointments($args); 
        if(!empty($slots)){
            foreach($slots as $key => $slot){
                $meta= [];

                if(!empty($slot['item_id']) && get_post_status($slot['item_id'])=='publish'){
                    $color = null;
                    if(!empty($this->settings['service_colors']) && !empty($this->settings['service_colors'][$slot['item_id']])){
                        $color=$this->settings['service_colors'][$slot['item_id']];
                    }

                    $meta = array(
                        'type'=>$this->get_appointment_name_from_type($slot['type']),
                        'label'=>get_the_title($slot['item_id']),
                        'color'=>$color,
                    );

                    $slots[$key]['meta'] = $meta;
                }else{
                    $slot['item_id'] = null;
                }

                
                

                $meta = apply_filters('vibe_appointments_slot_meta',$meta,$slot);
                if(!empty($meta)){
                    $slots[$key]['meta'] = $meta;
                }

                $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
                
                if(!empty($slot['type']) && strpos($slot['type'], 'recurring_')!==false){
                    //recurring appointment
                    $slots[$key]['days_of_week'] = explode('_',str_replace('recurring_', '', $slot['type'])); 
                }
            }


        }

        return new WP_REST_Response( apply_filters('vibe_appointments_get_slots',array('status'=>1,'slots'=>$slots,'args'=>$args)), 200 );
    }

    function updateBookingItemID($request){
        $post = json_decode($request->get_body(),true);
        $appointments_db = new VIBE_APPOINTMENTS_DB;

        $args = $post['slot'];

        $appointment_id = $appointments_db->update_appointment($args);
        if(empty($appointment_id)){
            return new WP_REST_Response( array('status'=>0,'message'=>__('Unable to update slot','vibe-appointments')), 200 );
        }
        do_action('vibe_appointments_updated',$appointment_id);
        return new WP_REST_Response( array('status'=>1,'message'=>__('Slot updated','vibe-appointments')), 200 );
    }

    function favourites($request){
        $favs = get_user_meta($this->user->id,'vibe_appointments_favourite',false);
        if(empty($favs)){
            $favs = [];
        }
        return new WP_REST_Response( array('status'=>1,'favourites'=>array_map('intval',$favs)), 200 );
    }
    function favourite($request){

        $post = json_decode($request->get_body(),true);
        $favs = get_user_meta($this->user->id,'vibe_appointments_favourite',false);
        if(empty($favs)){
            $favs = [];
        }
        $message = _x('Something went wrong','api message','vibe-appointments');

        if(!empty($post['user'])){
            $user = intval($post['user']);

            if(!empty($post['favourite'])){

                if(!in_array($user,$favs)){
                    //$favs[]=intval($user);
                    add_user_meta($this->user->id,'vibe_appointments_favourite',$user);
                }
                $message = _x('Added to favourites','','vibe-appointments');
            }else{
                delete_user_meta($this->user->id,'vibe_appointments_favourite',$user);
                $message = _x('Removed from favourites','','vibe-appointments');
            }
        }
        return new WP_REST_Response( array('status'=>1,'message'=>$message), 200 );
    }
    
    function save_appointment_slots($request){

        $post = json_decode($request->get_body(),true);
        $appointments_db = new VIBE_APPOINTMENTS_DB;
        $meta_db = new VIBE_APPOINTMENTS_META_DB;
        if(!empty($post['remove'])){
            foreach($post['remove'] as $a){
                if(!empty($a['appointment_id']) && empty($a['booker_id'])){
                    $appointments_db->delete_appointment($a['appointment_id']);
                }
            }
        }

        $check_can_insert = apply_filters('vibe_appointments_can_user_insert_slots',true,$post,$this->user);
        if($check_can_insert!==true){
            $return=array('status'=>0,'message'=>$check_can_insert);
            return new WP_REST_Response( $return, 200 );
        }
        if(!empty($post['events'])){
            foreach($post['events'] as $a){
                if(empty($a['appointment_id'])){
                    $start_timestamp = $a['date_start'];
                    $end_timestamp =$a['date_end'];
                    $args = array(
                        'start_date'        => $start_timestamp,
                        'end_date'          => $end_timestamp,
                        'start_time'        => (date('H',round($start_timestamp/1000))*60)+date('i',round($start_timestamp/1000)),
                        'end_time'          => (date('H',round($end_timestamp/1000))*60)+date('i',round($end_timestamp/1000)),

                        'author_id'         => $this->user->id,
                        'type'              => ((!empty($a['type']))?$a['type']:'available'),
                        'item_id'           => (!empty($a['item_id'])?$a['item_id']:0),
                        'status'            => 'open',
                    );
                    
                    if(!empty($a['author_id']) && apply_filters('vibe_appointments_calendar_admin_allow',user_can($this->user->id,'manage_options'),$this->user->id,$args,$post)){
                        $args['author_id'] = $a['author_id'];
                    }
                    if(!empty($a['rrule'])){
                       if(!empty($a['rrule']['byweekday'])){
                            $args['type'] = 'recurring_'.implode('_', $a['rrule']['byweekday']);
                        }else{
                             return new WP_REST_Response( array('status'=>0,'message'=>_x('Weekdays not selected for recurring event.','message','vibe-appointments')), 200 );
                        } 
                    }
                    
                    
                    $appointment_id = $appointments_db->insert_appointment($args);

                    if(!empty($a['seats']) && !empty($appointment_id)){
                        $meta_db->add_appointment_meta([
                            'appointment_id'=>$appointment_id,
                            'meta_key'=>'seats',
                            'meta_value'=>$a['seats']
                        ]);
                    }
                    do_action('vibe_appointments_insert_appointment', $appointment_id,$a);
                }
            }
        }

        
       
        $return=array('status'=>1,'message'=>_x('Slots saved.','message','vibe-appointments'),'events'=>$post['events']);
        return new WP_REST_Response( $return, 200 );
    }

    //for type and item id handle
    function merge_args($args,$post){
        if(!empty($post['filter']['type']) && !empty($post['filter']['item_id']) ){
            $args = array_merge($args,array(
                    'type'=>$post['filter']['type'],
                    'item_id'=>$post['filter']['item_id']
                )
            );
        }
        return $args;
    }

    function get_appointment_bookings($request){

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $post = json_decode($request->get_body(),true);

        
        $args = apply_filters('vibe_appointments_get_bookings',array(
            'number'=>999,
            'start_date'=>$post['filter']['start'],
            'end_date'=>$post['filter']['end'],
            'start_time'=>0,
            'end_time'=>1440,
        ),$request);

        if(!empty($post['filter']['type'])){ //if within course tab
            if(!empty($post['filter']['status']) && $post['filter']['status'] == 'booked' ){
                $args['booker_id'] = $this->user->id;
            }else {
                $args['booker_id'] = null;
            }
        }else{
            $args['booker_id'] = $this->user->id;
        }
        

        $args = $this->merge_args($args,$post);
    
        if(!empty($post['filter']['status']) && $post['filter']['status'] == 'dispute'){
            global $wpdb;
            
            $disputed_ids = $wpdb->get_results($wpdb->prepare("SELECT appointment_id FROM {$meta->table_name} WHERE meta_key='dispute' AND meta_value=%d",$this->user->id),ARRAY_A);
            
            if(!empty($disputed_ids)){
                $args['status']='';

                $args['appointment_id']=wp_list_pluck($disputed_ids,'appointment_id'); 
            }else{
                $args['appointment_id']=[99999999];
            }
        }

        $slots = $db->get_appointments($args);
        foreach ($slots as $key => $slot) {
            $slots[$key]['is_booked'] = !empty($this->is_booked($slot['appointment_id']))?true:false;
            $values = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'google_calendar_users'));
            if(!empty($values)){
                $slots[$key]['google_calendar_users'] = maybe_unserialize($values[0]['meta_value']);
            }
            
        }

        //open show only
        if(!empty($post['filter']['status']) && $post['filter']['status'] == 'open'){
            $nslots = [];
            foreach ($slots as $key => $slot) {
                if(!$slot['is_booked']){
                    $nslots[] = $slot;
                }
            }
            $slots = $nslots;
        }
       

        $p_slots = vibe_appointments_get_pending_slots(array('booker_id'=>$this->user->id));
        if(!empty($p_slots)){
            foreach($p_slots as $slot_id => $value){
                $pending_slot_ids[]=$slot_id; 
            }
        }
        $pending_slots=[];
        if(!empty($pending_slot_ids)){
            //Small request Pending slots only exist for 30 minutes
            $args = apply_filters('vibe_appointments_get_pending_slots',array(
                'number'=>999,
                'appointment_id'=>array_values($pending_slot_ids),
                'status'=>'open'
            ),$request);
            $pending_slots = $db->get_appointments($args);
           // $buffer_time =apply_filters('vibe_appointments_pending_slots_buffer_time',1800);
            foreach($pending_slots as $i=>$s){
                if(!empty($p_slots[$s['appointment_id']])){
                    $pending_slots[$i]['timer']=$p_slots[$s['appointment_id']];    
                }else{
                    $pending_slots[$i]['timer']=time();
                }
                
            }
        }

        return new WP_REST_Response( array('status'=>1,'bookings'=>$slots,'active_bookings'=>vibe_appointments_get_active_slots(),'pending_bookings'=>$pending_slots ), 200 );
    }

  

    function get_completed_bookings($request){

        

        $post = json_decode($request->get_body(),true);

        $args = apply_filters('vibe_appointments_get_bookings',array(
            'number'=>999,
            'start_date'=>$post['filter']['start'],
            'end_date'=>$post['filter']['end'],
            'start_time'=>0,
            'end_time'=>1440,
        ),$request);

        $args = $this->merge_args($args,$post);

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $slots = $db->get_appointments($args);

        if(!empty($slots)){
            global $wpdb;
            foreach($slots as $i=>$slot){
                $results = $wpdb->get_results($wpdb->prepare("
                    SELECT * 
                    FROM {$wpdb->comments}
                    WHERE comment_post_ID = %d 
                    AND comment_agent = 'appointments' 
                    AND comment_type = 'instructor_review' 
                    AND comment_approved = 1
                    AND user_id = %d
                    LIMIT 0,1",$slot['appointment_id'],$this->user->id),ARRAY_A);
                if(!empty($results)){
                    $comment_id =$results[0]['comment_ID'];
                    $slots[$i]['review']=array(
                        'review_comment_id'=>$results[0]['comment_ID'],
                        'review_title'=>get_comment_meta($results[0]['comment_ID'],'appointment_review_title',true),
                        'review_rating'=>get_comment_meta($results[0]['comment_ID'],'appointment_review_rating',true),
                        'review_content'=>$results[0]['comment_content']
                    );
                }
            }
        }
        return new WP_REST_Response( array('status'=>1,'bookings'=>$slots), 200 );
    }

    function post_booking_review($request){

        
        $post = json_decode($request->get_body(),true);

        $db = new VIBE_APPOINTMENTS_DB;
        $meta_db = new VIBE_APPOINTMENTS_META_DB;
        global $wpdb;

        $args = apply_filters('vibe_appointments_get_bookings',array(
            'appointment_id'=>$post['appointment_id']
        ),$request);

        $slots = $db->get_appointments($args);
        $flag = 0;
        if(in_array('manage_options',array_keys((Array)$this->user->caps))){
            $flag= 1;
        }
        
        $check = $meta_db->get_appointments_meta(['appointment_id'=>$post['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$this->user->id]);

        if(!empty($slots) && ($slots[0]['booker_id'] == $this->user->id || !empty($check)) || $flag){

            if(!empty($post['review_comment_id'])){

                wp_update_comment(apply_filters('vibe_appointments_post_review',
                    array(
                    'comment_ID'=>$post['review_comment_id'],
                    'comment_content'=>$post['review_content'],
                    'comment_post_ID'=>$post['appointment_id'],
                    'comment_author'=>$slots[0]['author_id'],
                    'user_id'=>$this->user->id,
                ),$request,$this->user));

                $cid = $post['review_comment_id'];
            
            }else{
                $c_arr = array('comment_agent'=>'appointments',
                    'comment_approved' => 1,
                    'comment_author'=>$slots[0]['author_id'],
                    'comment_content'=>$post['review_content'],
                    'comment_post_ID'=>$post['appointment_id'],
                    'comment_type'=>'instructor_review',
                    'user_id'=>$this->user->id,
                );
                

                if(!empty($slots[0]['item_id'])){
                    $c_arr['comment_karma'] = $slots[0]['item_id'];
                }

                $cid = wp_insert_comment(apply_filters('vibe_appointments_post_review',
                    $c_arr,$request,$this->user));

                
            }
            if(is_numeric($cid)){

                vibebp_fireabase_update_stale_requests($this->user->id,'getReview');

                update_comment_meta($cid,'appointment_review_title',(!empty($post['review_title'])?$post['review_title']:''));
                update_comment_meta($cid,'appointment_review_rating',$post['review_rating']);


                $group_ids= $meta_db->get_appointments_meta(['appointment_id'=>$post['appointment_id'],'meta_key'=>'group_id']);

                

                if(!empty($group_ids)){
                    if(!empty($group_ids[0]['meta_value'])){
                        update_comment_meta($cid,'group_id',$group_ids[0]['meta_value']);
                        $average_rating = $wpdb->get_var($wpdb->prepare("
                            SELECT AVG(cm1.meta_value) 
                            FROM {$wpdb->commentmeta} as cm
                            INNER JOIN {$wpdb->commentmeta} as cm1
                            ON cm.comment_id = cm1.comment_id
                            WHERE cm.meta_key = 'group_id' 
                            AND cm.meta_value = %d
                            AND cm1.meta_key = 'appointment_review_rating'",$group_ids[0]['meta_value']));

                        groups_update_groupmeta($group_ids[0]['meta_value'],'rating',$average_rating);
                    }
                }

                if(!empty($slots[0]['item_id'])){

                    $type = apply_filters('vibebp_appointments_slot_id',get_post_type($slots[0]['item_id']));
                    update_comment_meta($cid,'booking_'.$type.'_id',$slots[0]['item_id']);
                    $avarage_rating = $wpdb->get_var($wpdb->prepare("
                    SELECT AVG(cm.meta_value)
                    FROM {$wpdb->comments} as c LEFT JOIN {$wpdb->commentmeta} as cm 
                    ON c.comment_ID = cm.comment_id
                    WHERE c.comment_agent = 'appointments' 
                    AND c.comment_type = 'instructor_review' 
                    AND c.comment_approved = 1
                    AND c.comment_post_ID = %d
                    AND cm.meta_key = 'appointment_review_rating'
                    ",$slots[0]['item_id']));

                    update_post_meta($slots[0]['author_id'],'appointment_service_average_rating'.$slots[0]['item_id'],round($avarage_rating));
                }

                
                
                $avarage_rating = $wpdb->get_var($wpdb->prepare("
                SELECT AVG(cm.meta_value)
                FROM {$wpdb->comments} as c LEFT JOIN {$wpdb->commentmeta} as cm 
                ON c.comment_ID = cm.comment_id
                WHERE c.comment_agent = 'appointments' 
                AND c.comment_type = 'instructor_review' 
                AND c.comment_approved = 1
                AND c.comment_author = %d
                AND cm.meta_key = 'appointment_review_rating'
                ",$slots[0]['author_id']));
                update_user_meta($slots[0]['author_id'],'appointment_average_rating',round($avarage_rating));
                

            }else{
                return new WP_REST_Response( array('status'=>0,'message'=>__('Unable to post review.','vibe-appointments')), 200 );
            }
        }else{
            return new WP_REST_Response( array('status'=>0,'message'=>__('Review can not be posted','vibe-appointments')), 200 );
        }

        return new WP_REST_Response( array('status'=>1,'message'=>__('Review posted','vibe-appointments'),'id'=>$cid), 200 );
    }

    function requestcancellation($request){
        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        global $wpdb;
        if(empty($post['event'])){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Something went wrong!','vibe-appointments') ) , 200 );
        }
        $args = apply_filters('vibe_appointments_get_bookings',array(
            'appointment_id'=>$post['event']['appointment_id']
        ),$request);

        $options = vibe_appointments_get_settings();
        $buffer_time = intval($options['appointments_buffer_time']);
        if(empty($buffer_time)){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Cancellation not allowed','vibe-appointments'))  , 200 );
        }

        $slots = $db->get_appointments($args);
        $appointment = [];
        if(!empty($slots) && $slots[0]){
            $appointment = $slots[0];
        }
        if(empty($appointment) || empty($appointment['booker_id'])){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Something went wrong!','vibe-appointments') ) , 200 );
        }
        $start_timestamp = (intval($appointment['start_date'])/1000);
        if($start_timestamp - ($buffer_time*60) < time()){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Sorry booking cannot be cancelled now!','vibe-appointments') ) , 200 );
        }
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $meta->update_appointment_meta(array(
            'appointment_id'=>$appointment['appointment_id'],
            'meta_key'=>'cancellation_request',
            'meta_value'=> $this->user->id,
        ));
        do_action('vibe_appointments_booking_request_cancellation',$appointment);
        return new WP_REST_Response(array('status'=>1,'message'=>__('Cancel request sent to Instructor','vibe-appointments')  ), 200 );
    }

    function cancelrequestcancellation($request){
        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        global $wpdb;
        if(empty($post['event'])){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Something went wrong!','vibe-appointments') ) , 200 );
        }
        $args = apply_filters('vibe_appointments_get_bookings',array(
            'appointment_id'=>$post['event']['appointment_id']
        ),$request);


        $options = vibe_appointments_get_settings();
        $buffer_time = intval($options['appointments_buffer_time']);
        if(empty($buffer_time)){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Cancellation not allowed','vibe-appointments'))  , 200 );
        }

        $slots = $db->get_appointments($args);
        $appointment = [];
        if(!empty($slots) && $slots[0]){
            $appointment = $slots[0];
        }
        
        $start_timestamp = (intval($appointment['start_date'])/1000);
        if($start_timestamp - ($buffer_time*60) < time()){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Sorry booking cannot be cancelled now!','vibe-appointments') ) , 200 );
        }
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $metas = $meta->get_appointments_meta(array(
            'appointment_id'=>$appointment['appointment_id'],
            'meta_key'=>'cancellation_request',
            'meta_value'=> $this->user->id,
        ));

        if(!empty($metas)){
            $meta->delete_appointment_meta($metas[0]['meta_id']);
        }
        return new WP_REST_Response(array('status'=>1,'message'=>__('Cancel request cancelled','vibe-appointments')  ), 200 );
    }

    function get_appointment_appointments($request){
        
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $post = json_decode($request->get_body(),true);
        $filter = $post['filter'];
        

        if(!empty($filter)){
            $args = apply_filters('vibe_appointments_get_slots',array(
                'number'=>999,
                'start_date'=>$filter['start'],
                'end_date'=>$filter['end'],
                'author_id'=>$this->user->id,
                'status'=>'booked'
            ),$request);
        }else{
            $args = apply_filters('vibe_appointments_get_slots',array(
                'number'=>999,
                'start_date'=>$post->start_date,
                'end_date'=>$post->end_date,
                'start_time'=>$post->start_time,
                'end_time'=>$post->end_time,
                'author_id'=>$this->user->id,
                'status'=>'booked'
            ),$request);
        }
        $slots = $db->get_appointments($args);


        if(!empty($slots)){
            foreach($slots as $key => $slot){
                if(!empty($slot['item_id']) && get_post_status($slot['item_id'])=='publish'){
                    $slots[$key]['meta'] = array(
                        'type'=>$this->get_appointment_name_from_type($slot['type']),
                        'label'=>get_the_title($slot['item_id']),
                    );
                }
            }
        }

        $pending_slot_ids=$pending_slots=$active_slot_ids=$active_slots=[];
        $p_slots = vibe_appointments_get_pending_slots(array('instructor_id'=>$this->user->id));
        if(!empty($p_slots)){
            foreach($p_slots as $slot_id => $value){
                $pending_slot_ids[]=$slot_id;
            }
        }

        if(!empty($pending_slot_ids)){
            
            $args = apply_filters('vibe_appointments_get_pending_slots',array(
                'number'=>999,
                'appointment_id'=>array_values($pending_slot_ids),
                'status'=>'open'
            ),$request);
            $pending_slots = $db->get_appointments($args);
            foreach($pending_slots as $i=>$slot){
                $values = $meta->get_appointments_meta(array('appointment_id'=>$slot['appointment_id'],'meta_key'=>'request_booker_id'));
                if(!empty($values)){
                    $pending_slots[$i]['booker_id']=$values[0]['meta_value'];
                }
                if(!empty($p_slots[$slot['appointment_id']])){
                    $pending_slots[$i]['timer']=$p_slots[$slot['appointment_id']];    
                }else{
                    $pending_slots[$i]['timer']=time();
                }
                
            }
            
        }

        if(!empty($active_slot_ids)){
            $args = apply_filters('vibe_appointments_get_active_slots',array(
                'number'=>999,
                'appointment_id'=>$active_slot_ids,
                'status'=>'open'
            ),$request);
            $active_slots = $db->get_appointments($args);    
        }
        

        $active_slots = vibe_appointments_get_active_slots();


        return new WP_REST_Response( 
            array('status'=>1,
                'appointments'=>$slots,
                'active_appointments'=>$active_slots,
                'pending_appointments'=>$pending_slots 
            ), 200 );        
    }

    function add_booking($request){ 

        $post = json_decode($request->get_body(),true);
        if(empty($post['appointment_id']) ){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','booking cancelled','vibe-appointments')),200);
        }
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $old_booker_id = 0;
        
        $slots = $db->get_appointments(array('appointment_id'=>$post['appointment_id']));

        if(!empty($slots) && !empty($slots[0]['booker_id']) && !empty($post['user_id'])){

            $old_booker_id=$slots[0]['booker_id'];
            if( $old_booker_id!==$post['user_id']){
                $slot = $slots[0];

                if(!empty($slot['author_id'])){
                    $slot['author_id'] = intval($slot['author_id']);
                   
                    $hours = intval(get_user_meta($slot['author_id'],'vibe_appointments_instructor_hours_booked',true));
                    $hours = $hours - (($slot['end_date']-$slot['start_date'])/(1000*60*60));
                    if($hours<0){
                        $hours=0;
                    }
                    if(is_array($post['user_id'])){
                        $hours = count($post['user_id'])*$hours;
                    }
                    update_user_meta($slot['author_id'],'vibe_appointments_instructor_hours_booked',$hours);
                }
                
                if(!empty($slot['booker_id'])){

                    $slot['booker_id'] = intval($slot['booker_id']);

                    if($post['type'] == 'member'){
                        $hours = intval(get_user_meta($slot['booker_id'],'vibe_appointments_user_hours_booked',true));
                        $hours = $hours - (($slot['end_date']-$slot['start_date'])/(1000*60*60));
                        if($hours<0){
                            $hours=0;
                        }
                        update_user_meta($slot['booker_id'],'vibe_appointments_user_hours_booked',$hours);  
                    }
                }
            }

        }
        $args = array(
            'appointment_id'=>$post['appointment_id'],
            'booker_id'=> $post['user_id'],
            'status'    => (!empty($post['status'])?$post['status']:'booked'),
        );
        if(strpos($slots[0]['type'], 'recurring_')===false){
            if($post['type'] != 'group'){
                $args['type'] = $post['type'];    
            }
        }

        if(!empty($post['author_id']) && apply_filters('vibe_appointments_calendar_admin_allow',user_can($this->user->id,'manage_options'),$this->user->id,$args,$post)){
            $args['author_id'] = $post['author_id'];
        }
        if(!empty($post['item_id']) && apply_filters('vibe_appointments_calendar_admin_allow',user_can($this->user->id,'manage_options'),$this->user->id,$args,$post)){
            $args['item_id'] = $post['item_id'];
        }
        $db->update_appointment($args);

        if(!empty($post['seats']) && $post['seats'] > 1){
            $meta->update_appointment_meta(array(
                    'appointment_id'=>$post['appointment_id'],
                    'meta_key'=>'seats',
                    'meta_value'=> $post['seats'],
                ));
        }

        if(!empty($post['additionalBookers'])){
            $existing_booker_ids = $meta->get_appointments_meta(['appointment_id'=>$post['appointment_id'],'meta_key'=>'booker_id']);
            foreach($existing_booker_ids as $booker){
                if(!in_array($booker['meta_value'],$post['additionalBookers'])){
                    $meta->delete_appointment_meta(['meta_id'=>$booker['meta_id']]);
                }else{
                    unset($post['additionalBookers'][array_search($booker['meta_value'],$post['additionalBookers'])]);
                }
            }

            
            if(!empty($post['additionalBookers'])){
                forEach($post['additionalBookers'] as $booker_id){
                    $meta->add_appointment_meta([
                        'appointment_id'=>$post['appointment_id'],
                        'meta_key'=>'booker_id',
                        'meta_value'=>$booker_id
                    ]);
                }    
            }
            
        }

        if(!empty($post['metas'])){
            foreach($post['metas'] as $field){
                if(empty($field['value_type']) || $field['value_type'] == 'single'){
                     $meta->update_appointment_meta(array(
                        'appointment_id'=>$post['appointment_id'],
                        'meta_key'=>$field['meta_key'],
                        'meta_value'=> $field['value'],
                    ));
                }
            }
        }

        if(!empty($post['parent_appointment_id'])){
            $additional_slots = $meta->get_appointments_meta(array('appointment_id'=>$post['parent_appointment_id'],'meta_key'=>'additional_slots')); 
            if(!empty($additional_slots)){
                $data = maybe_unserialize($additional_slots[0]['meta_value']);
                $data['assigned']=(int)$data['assigned']+1;
                $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$post['parent_appointment_id'],'meta_key'=>'additional_slots','meta_value'=>$data));
            }
        }
        $_post = $post;
        $_post['booker_id'] = $post['user_id'];
        
        if(!empty($_post['booker_id']) && $old_booker_id!==$_post['booker_id']){
            do_action('vibe_appointments_booking_confirmed',$_post);
        }
        
        do_action('vibe_appointments_booking_updated',$post,null);

        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking updated.','booking updated','vibe-appointments'),'rtm'=>array(array('user_id'=>$post['user_id'],'message'=>sprintf(_x('Your booking for Appointment id %d is updated.','booking confirmed','vibe-appointments'),$post['appointment_id']))))
            , 200 );     
        

    }

    function addParentAppointment($request){

        $post = json_decode($request->get_body(),true);
        if(empty($post['appointment_id']) || empty($post['parent_appointment_id'])){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','parent booking ','vibe-appointments')),200);
        }
        $db = new VIBE_APPOINTMENTS_DB;
        
        $args = array(
            'appointment_id'=>$post['appointment_id'],
            'booker_id'=> $post['booker_id'],
            'status'    => 'booked',
            'type'      => $post['type'], //group or member
            'parent_appointment_id'      => $post['parent_appointment_id'],
        );
        $db->update_appointment($args);

        do_action('vibe_appointments_booking_updated',$post,null);

        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking updated.','booking updated','vibe-appointments'),'rtm'=>array(array('user_id'=>$post['booker_id'],'message'=>sprintf(_x('Your booking for Appointment id %d is updated.','booking confirmed','vibe-appointments'),$post['appointment_id']))))
            , 200 ); 
    }

    function rescheduleAppointment($request){
        $post = json_decode($request->get_body(),true);
        //old : $post['appointment']
        //new : $post['slot']
        if(empty($post['appointment']['appointment_id']) || empty($post['slot']['appointment_id'])){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','reschdule  ','vibe-appointments')),200);
        }
        $db = new VIBE_APPOINTMENTS_DB;
       
        $args = array(
            'appointment_id'=>$post['appointment']['appointment_id'],
            'booker_id'=> '',
            'status'    => 'open'
        );
        $db->update_appointment($args);

        $args = array(
            'appointment_id'=>$post['slot']['appointment_id'],
            'booker_id'=> $post['appointment']['booker_id'],
            'status'    => 'booked'
        );
        $db->update_appointment($args);

        $metadb = new VIBE_APPOINTMENTS_META_DB;
        $metas = $metadb->get_appointments_meta(
            array('appointment_id'=>$post['appointment']['appointment_id']));
        if(!empty($metas)){
            foreach($metas as $meta){
                global $wpdb;
                $table_name = $metadb->get_table_name();
                if(!empty($meta['meta_id'])){
                    $wpdb->query("UPDATE {$table_name} SET appointment_id = ".$post['slot']['appointment_id']." WHERE meta_id = ".$meta['meta_id']);
                }
            }
        }

        if(!empty($post['child_appointments'])){
            foreach($post['child_appointments'] as $appointment_id){
                $args = array(
                    'appointment_id'=>$appointment_id,
                    'parent_appointment_id' => $post['slot']['appointment_id'],
                );
                $db->update_appointment($args);
            }
        }else{
            $nargs = array('parent_appointment_id'=>$post['slot']['appointment_id']);
            $childs  = $db->get_appointments($nargs);
            if(!empty($childs)){
                foreach($childs as $child){
                    $args = array(
                        'appointment_id'=>$child['appointment_id'],
                        'parent_appointment_id' => $post['appointment']['appointment_id'],
                    );
                    $db->update_appointment($args);
                }
            }
        }

        do_action('vibe_appointments_booking_rescheduled',$post);

        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking updated.','booking updated','vibe-appointments'),'rtm'=>array(array('user_id'=>$post['appointment']['booker_id'],'message'=>sprintf(_x('Your booking for Appointment id %d is updated.','booking confirmed','vibe-appointments'),$post['appointment']['appointment_id']))))
            , 200 );

    }


    function remove_booking($request){

        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        
        
        $slots = $db->get_appointments(array('appointment_id'=>intval($post['appointment_id'])));
        if(!empty($slots) && !empty($slots[0])){
            $appointment = $slots[0];
        }
        if(empty($appointment)){
            return new WP_REST_Response(array('status'=>0,'message'=>__('Appointment does not exist!','vibe-appointments') ) , 200 );
        }

        $metadb = new VIBE_APPOINTMENTS_META_DB;

        $metas = $metadb->get_appointments_meta(
            array('appointment_id'=>$post['appointment_id']) );
        $order_details = [];
        if(!empty($metas)){

            foreach ($metas as $key => $m) {

                if(!empty($m['meta_key']) && strpos($m['meta_key'], 'order_details') !== false){

                    $order_details = maybe_unserialize($m['meta_value']);

                    if(!empty($order_details) && $order_details['order_id'] && $order_details['item_id']){

                        $order = wc_get_order($order_details['order_id']);

                        foreach ($order->get_items() as $key => $item) {

                            if($item->get_id()==$order_details['item_id']){
                                //
                                
                                $total     = $item->get_total(); // Total without tax (discounted)
                                $total_tax = $item->get_total_tax(); // Total tax (discounted)
                                $refund_amount = $total+$total_tax;
                                $refund = wc_create_refund( array(
                                    'amount'         => $refund_amount,
                                    'reason'         => _x('Cancelled by instructor!','','vibe-appointments'),
                                    'order_id'       => $order_details['order_id'],
                                    'line_items'     =>  array($item),
                                    'refund_payment' => true
                                ));

                                

                                if(!empty($refund) && is_wp_error($refund)){
                                    //addd in order comments 
                                    $product_name =  get_the_title($item->get_product_id()).' - '._x('Appointment ID ','','vibe-appointments').' ['.$post['appointment_id'].']';
                                    $order->add_order_note( sprintf(_x('Instructor attempted refund for the item %s','','vibe-appointments'),$product_name) );
                                }

                            }

                            
                        }

                    }                    
                }

                if(!empty($m['meta_key']) && $m['meta_key'] == 'booker_id'){
                    $metadb->delete_appointment_meta(['meta_id'=>$m['meta_id']]);
                }
            }
        }
        $db->update_appointment(['appointment_id'=>$post['appointment_id'],'booker_id'=>null]);
        bp_activity_add( array( 
            'user_id' => $appointment['appointment_id'], 
            'action' => _x('All bookings cancelled.','cancelled booking','vibe-appointments'), 
            'content' => sprintf(_x('Booking %s has been cancelled by %s. ','booking requested','vibe-appointments'),$appointment['appointment_id'],bp_core_get_user_displayname($appointment['author_id'])), 
            'component' => 'appointments', 
            'item_id'=>$appointment['appointment_id'],
            'type' => 'booking_cancelled'
        ));
        do_action('vibe_appointments_booking_cancelled',$appointment,['booker_id'=>$appointment['booker_id'],'order_details'=>$order_details]);
        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking cancelled.','booking cancelled','vibe-appointments'),'rtm'=>array(array('user_id'=>$post['booker_id'],'message'=>sprintf(_x('Your booking for Appointment id %d is cancelled.','booking cancel message','vibe-appointments'),$post['appointment_id']))))
            , 200 ); 
    }

    function appointment_google_sync($request){
        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        if(!empty($post['bookings']) && is_array($post['bookings'])){
            foreach ($post['bookings'] as $key => $booking) {
                if(!empty($booking['is_google_calendar_users_changed']) && !empty($booking['google_calendar_users'])){
                    $meta->update_appointment_meta(array(
                        'appointment_id'=>$booking['appointment_id'],
                        'meta_key'=>'google_calendar_users',
                        'meta_value'=>array_map('intval',$booking['google_calendar_users']),
                    ));
                    vibebp_fireabase_update_stale_requests($this->user->id,'author/getbookings');
                    vibebp_fireabase_update_stale_requests($this->user->id,'booker/getbookings');
                }
            }
        }

        return new WP_REST_Response( array('status'=>1,'message'=>esc_html_x('Bookings synced!','','vibe-appointments')),200);
    }

    function appointment_details($request){

        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $details = array(
            'meta'=>array(),
            'activity'=>array()
        );

        $additionalBookers=[];
        $seats = 1;
        $metas = $meta->get_appointments_meta(array('appointment_id'=>$post['appointment_id']));
        if(!empty($metas)){
            foreach($metas as $info){

                if($info['meta_key'] != 'booker_id' && $info['meta_key']!=='request_booker_id' && strpos($info['meta_key'],'_') > 0 ){

                    $info['meta_value'] = maybe_unserialize($info['meta_value']);
                    $m = apply_filters('vibe_appointments_appointment_meta',array(
                        'meta_key'=>$info['meta_key'],
                        'meta_value'=>$info['meta_value'],
                        'label'=>$info['meta_key'],
                        'value'=>$info['meta_value']
                    ),$post,$this->user->id);
                    if(!empty($m)){
                        $details['meta'][] = $m;    
                    }
                    

                    if($info['meta_key'] == 'additional_slots'){
                        $child_appointments = $db->get_appointments(array('parent_appointment_id'=>$post['appointment_id']));
                        if(!empty($child_appointments)){
                            $details['additional_slots']=$child_appointments;
                        }
                    }
                }

                if($info['meta_key'] == 'booker_id'){
                    $additionalBookers[]=$info['meta_value'];
                }

                if($info['meta_key'] == 'seats'){
                    $seats = $info['meta_value'];
                }

            }
        }

        

        if(!empty($post['parent_appointment_id'])){
            $parent_appointment = $db->get_appointments(array('appointment_id'=>$post['parent_appointment_id']));
            $details['parent_appointment']=$parent_appointment[0];
        }
        $activity_args = array('per_page'=>20,'filter'=>array(
            'primary_id' => $post['appointment_id'],
            'object'=>'appointments',
            'user_id'=>array($this->user->id,$post['author_id'])
        ));      
        
        $run = bp_activity_get($activity_args);
        if(!empty($run['activities'])){
            foreach($run['activities'] as $activity){
                $activity->date_recorded=strtotime($activity->date_recorded);
            }
        }
        $details['activity']=$run;
        $details['seats']=$seats;
        $details['additionalBookers'] = $additionalBookers;

         return new WP_REST_Response( array('status'=>1,'details'=>$details),200);
    }

    function checkBookingCredits($request){
        $post = json_decode($request->get_body(),true);
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $db = new VIBE_APPOINTMENTS_DB;
        $return  =[];

        if(empty($post['event']['appointment_id'])){
            $return  =array('status'=>false,'message'=>_x('Appointment not found!','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }
        $balance = intval(get_user_meta($this->user->id,'wallet',true));
        if(empty($balance) || $balance < 0){
            $return  =array('status'=>false,'message'=>_x('Not enough credits! 0 balance','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }
        $slots = $db->get_appointments(array('appointment_id'=>intval($post['event']['appointment_id'])));

        if(empty($slots )){
            $return  = array('status'=>false,'message'=>_x('Appointment not found!','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }
        $slot = $slots[0];
        if(empty($slot['author_id'])){
            $return  = array('status'=>false,'message'=>_x('Appointment author not found!','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }
        
        $pricing = get_vibe_appointments_pricing_array($slot['author_id']);
        if(empty($slot['item_id'])){
            $slot['item_id']='';
        }
        if(empty($pricing[$slot['item_id']]) || empty($pricing[$slot['item_id']]['credits'])){
            $return  =array('status'=>false,'message'=>_x('Credit purchase not set for this appointment','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }
        if(!empty($slot['booker_id'])){
            $return  =array('status'=>false,'message'=>_x('Appointment already booked!','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }

        $credits=intval($pricing[$slot['item_id']]['credits']);

        if(strpos($slot['type'], 'recurring_')!==false){
            $dow = explode('_',str_replace('recurring_', '', $slot['type']));
            function check_nod($day){
                $dow = array(
                    'MO'=>1,
                    'TU'=>2,
                    'WE'=>3,
                    'TH'=>4,
                    'FR'=>5,
                    'SA'=>6,
                    'SU'=>0,
                );
                return $dow[$day];
            }
            $dow = array_map('check_nod',$dow);
            
            $sdate = intval($slot['start_date'])/1000;
            $slotsnumber = 0;
            while($sdate < (intval($slot['end_date'])/1000)){
                if(in_array((date('w',$sdate)),$dow)){
                    $slotsnumber++;
                }
                $sdate+=86400;
            }
            if(empty($slotsnumber)){
                $slotsnumber= 1;
            }
            $credits = $credits*$slotsnumber;
        }

        if($balance < $credits ){
            $return  =array('status'=>false,'message'=>_x('Not enough credits!','','vibe-appointments'));
            return new WP_REST_Response($return ,200);
        }

        $activity_id = bp_activity_add( array( 
            'user_id' => $this->user->id, 
            'action' => 'debit', 
            'content' => sprintf(_x('%s credits debited for purchase of appointment id %s','wallet','vibe-appointments'),$credits,$slot['appointment_id'].'('.get_the_title($slot['item_id']).')'), 
            'component' => 'wallet', 
            'type' => 'debit', 
        ));
        bp_activity_update_meta($activity_id,'transaction',array(
            'status'=>'debit',
            'amount'=>$credits,
        ));
        
        $wallet = $balance - ($credits);
        update_user_meta($this->user->id,'wallet',$wallet); //Amount
        $slot['booker_id'] = $this->user->id;
        $slot['status']='booked';
        $db->update_appointment(array(
            'appointment_id'=>$slot['appointment_id'],
            'status'=>'booked',
            'booker_id'=>$this->user->id
        ));
        do_action('wplms_wallet_transaction',array('user_id' => $this->user->id,'post'=>(Array)$post));

        do_action('vibe_appointments_booking_confirmed',$slot);
        $return = array('status'=>1,'message'=>_x('Booking done successfully!.','booking request done','vibe-appointments'));
        
        return new WP_REST_Response($return ,200);

    }

    function accept_appointment_booking($request){
        
        $post = json_decode($request->get_body(),true);
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $db = new VIBE_APPOINTMENTS_DB;

        $booker_id= 0;


        if(!empty($post['booker_id'])){
            $booker_id= $post['booker_id'];
        }
        if(!empty($post['user_id'])){
            $booker_id= $post['user_id'];
        }
        $appointment = [];
        $status='open';
        $settings = vibe_appointments_get_settings();
        
        if(!empty($settings['booking_seats'])){

            $appointment = $db->get_appointments(['appointment_id'=>$post['appointment_id']]);
            $seats = $meta->get_appointments_meta(['appointment_id'=>$post['appointment_id'],'meta_key'=>'seats']);

            if(!empty($seats) && $seats[0]['meta_value'] > 1){
                if(!empty($appointment[0]['booker_id'])){
                    $booker_ids = $meta->get_appointments_meta(['appointment_id'=>$post['appointment_id'],'meta_key'=>'booker_id']);

                    if($seats[0]['meta_value'] > count($booker_ids)+1){
                        $status = 'open';
                    }else{
                        $status = 'booked';
                    }
                }
            }else{
                $status = 'booked';
            }
            

        }else{
            $status = 'booked';
        }
            

        $db->update_appointment(array(
            'appointment_id'=>$post['appointment_id'],
            'status'=>$status,
            'booker_id'=>$booker_id
        ));
        $metas = $meta->get_appointments_meta(array('appointment_id'=>$post['appointment_id'],'meta_key'=>'request_booker_id','meta_value'=>$booker_id,'single'=>false));
        if(!empty($metas)){
            $meta->delete_appointment_meta($metas[0]['meta_id']);
        }

        $slots = $db->get_appointments(array('appointment_id'=>$post['appointment_id']));
        if(!empty($slots) && !empty($slots[0]['booker_id'])){
            do_action('vibe_appointments_booking_confirmed',$slots[0]);
        }

        $pending_bookings = get_user_meta($booker_id,'pending_bookings',true);  
        if(!empty($pending_bookings) && !empty($pending_bookings[$post['appointment_id']])){
            unset($pending_bookings[$post['appointment_id']]);
        }


        $pending_appointments = get_user_meta($slots[0]['author_id'],'pending_appointments',true);  
        if(!empty($pending_appointments) && !empty($pending_appointments[$post['appointment_id']])){
            unset($pending_appointments[$post['appointment_id']]);
        }

        
        
        do_action('vibe_appointments_booking_accepted',array('appointment_id'=>$post['appointment_id'],'booker_id'=>$booker_id,'author_id'=>$this->user->id));
        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking request accepted.','booking request rejected','vibe-appointments')),200);   
    }

    function reject_appointment_booking($request){
        $post = json_decode($request->get_body(),true);
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $metas = $meta->get_appointments_meta(array('appointment_id'=>$post['appointment_id'],'meta_key'=>'request_booker_id','single'=>true));
        $instructor_id = $this->user->id;
        if(!empty($metas)){
            $meta->delete_appointment_meta($metas[0]['meta_id']);
        }

        $app = get_user_meta($instructor_id,'pending_appointments',true);  
        if(is_array($app) && count($app) && in_array($post['appointment_id'],array_keys($app))){
            unset($app[$post['appointment_id']]);
            update_user_meta($instructor_id,'pending_appointments',$app);
        }
        if($post['booker_id']){
            $book=get_user_meta($post['booker_id'],'pending_bookings',true);  
            if(is_array($book) && count($book) && in_array($post['appointment_id'],array_keys($book))){
                unset($book[$post['appointment_id']]);
                update_user_meta($post['booker_id'],'pending_bookings',$book);
            }
        }
        

        do_action('vibe_appointments_booking_rejected',array('appointment_id'=>$post['appointment_id'],'booker_id'=>$post['booker_id'],'author_id'=>$this->user->id));
        return new WP_REST_Response( array('status'=>1,'message'=>_x('Booking request rejected.','booking request rejected','vibe-appointments')),200);     
    }



    function getAppointmentPrice($request){
        $post = json_decode($request->get_body(),true);
        global $wpdb;
        $return = array('status'=>0);

        if(user_can($this->user->id,'manage_options') && !empty($post['user_id'])){
            $user_id = $post['user_id'];
        }else{
            $user_id = $this->user->id;    
        }
    

        $product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value={$user_id}");


        
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){

                $saved_service_prices = get_vibe_appointments_pricing_array($this->user->id);

                $product = wc_get_product( $product_id );
                $slot_price = $product->get_price_html();   
                $return = array(
                    'id'=>$product_id,
                    'priceHTML'=>$slot_price,
                    'value'=>$product->get_price(),
                    'credits'=>((!empty($saved_service_prices['']) && !empty(!empty($saved_service_prices['']['credits'])))?$saved_service_prices['']['credits']:false),
                );

                $return = array('status'=>1,'price'=>$return);
            }
        }

        return new WP_REST_Response( $return,200);     
    }

    function setAppointmentPrice($request){

        $post = json_decode($request->get_body(),true);

        if(user_can($this->user->id,'manage_options') && !empty($post['user_id'])){
            $user_id = $post['user_id'];
        }else{
            $user_id = $this->user->id;    
        }

        global $wpdb;
        $product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=".$user_id);
        
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){
                if(empty($post['slotPrice'])){
                    wp_delete_post($product_id);
                    delete_user_meta($user_id,'_appointment_price');
                    $return = 0;
                    remove_vibe_appointments_pricing_array($user_id,'');
                }else{
                    // update_post_meta($product_id,'_price',$post['slotPrice']);
                    // update_post_meta($product_id,'_regular_price',$post['slotPrice']);
                    $product = wc_get_product( $product_id );
                    $product->set_price($post['slotPrice']);
                    $product->set_regular_price($post['slotPrice']);

                    $slot_price = $product->get_price_html();   
                    $return = array(
                        'type'=>'wc',
                        'id'=>$product_id,
                        'priceHTML'=>$slot_price,
                        'html'=>$slot_price,
                        'value'=>$post['slotPrice'],
                        'type'=>'wc',
                    );
                    if(!empty($post['credits'])){
                        $return['credits'] = $post['credits'];
                    }
                    update_vibe_appointments_pricing_array($user_id,'',$return);
                    
                }
            }
        }else{
            if(function_exists('wc')){
                if(empty($post['slotPrice'])){
                    wp_delete_post($product_id);
                    delete_user_meta($user_id,'_appointment_price');
                    $return = 0;
                    remove_vibe_appointments_pricing_array($user_id,'');
                }else{
                    $product_id = wp_insert_post(apply_filters('vibe_appointments_create_product',array(
                        'post_title'=>sprintf(_x('Appointment Booking product for %s','product title','vibe-appointments'),bp_core_get_user_displayname($user_id)),
                        'post_content'=>sprintf(_x('Appointment Booking product for %s','product title','vibe-appointments'),bp_core_get_user_displayname($user_id)),
                        'post_author'=>$user_id,
                        'post_type'=>'product',
                        'post_status'=>'publish',
                        'meta_input'=>array(
                            '_price'=>$post['slotPrice'],
                            '__regular_price'=>$post['slotPrice'],
                            '_appointment_price'=>$user_id,
                            '_hidden'=>1
                        )
                    ),$post,$this->user));
                    if(is_numeric($product_id)){
                        $product = wc_get_product( $product_id );
                        $product->set_price($post['slotPrice']);
                        $product->set_regular_price($post['slotPrice']);
                        $slot_price = $product->get_price_html();   
                        $return = array(
                            'type'=>'wc',
                            'id'=>$product_id,
                            'priceHTML'=>$slot_price,
                            'html'=>$slot_price,
                            'value'=>$post['slotPrice'],
                            'type'=>'wc',
                        );
                        update_user_meta($user_id,'_appointment_price',$post['slotPrice']);
                        if(!empty($post['credits'])){
                            $return['credits'] = $post['credits'];
                        }
                        update_vibe_appointments_pricing_array($user_id,'',$return);
                    }else{
                       return new WP_REST_Response( array('status'=>1,'message'=>__('Failed to set price.','vibe-appointments')),200); 
                    }
                }
            }
        }

        return new WP_REST_Response( array('status'=>1,'price'=>$return,'message'=>__('Price per slot booking set for instructor','vibe-appointments')),200);     
    }

    function getservicespricing($request){
        $post = json_decode($request->get_body(),true);
        global $wpdb;
        if(empty($post['user'])){
            $user_id  = $this->user->id;
        }else{
            $user_id  = intval($post['user']);
        }

        if(user_can($this->user->id,'manage_options') && !empty($post['user_id'])){
            $user_id = $post['user_id'];
        }else{
            $user_id = $this->user->id;    
        }
        
        $saved_service_prices = get_user_meta($user_id,'saved_services_prices',true);

        if(!empty($saved_service_prices)){
            if(empty($this->settings)){
                $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
            }
            foreach($saved_service_prices as $k=>$saved_service_price){
                if(!empty($this->settings['service_colors']) && !empty($this->settings['service_colors'][$saved_service_price['id']])){
                    $saved_service_prices[$k]['color'] = $this->settings['service_colors'][$saved_service_price['id']];
                    if(!empty($post['type']) && $post['type']=='card'){
                        $saved_service_prices[$k]['avatar'] = get_the_post_thumbnail_url($saved_service_price['id']);
                        if(empty($saved_service_prices[$k]['avatar'] )){
                            $saved_service_prices[$k]['avatar']  = plugins_url( '../../assets/images/avatar.jpg',  __FILE__ );
                        }
                        $saved_service_prices[$k]['types'] = get_the_terms($saved_service_price['id'],VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG);
                    }
                    
                }
            }
        }
        $data = array('status'=>false,'message'=>__('No saved services price found','vibe-appointments'));
        if(!empty($saved_service_prices)){
            $data = array('status'=>true,'prices'=>$saved_service_prices,'message'=>__('No saved services price found','vibe-appointments'));
        }
        return new WP_REST_Response( $data,200);
    }

    function array_find($xs, $f) {
      foreach ($xs as $i=>$x) {
        if (call_user_func($f, $x) === true)
          return $i;
      }
      return -1;
    }

    function getAllServices($request){
        $post = json_decode($request->get_body(),true);
        
        $saved_services = [];
        global $wpdb;
        if(!empty($post['user_id'])){
            $uid =intval($post['user_id']);
            
            $results = $wpdb->get_results("
                SELECT u.user_id,u.meta_value 
                FROM {$wpdb->usermeta} as u
                LEFT JOIN {$wpdb->posts} as p
                ON p.ID=u.meta_value 
                WHERE u.meta_key='service' 
                AND u.user_id={$uid} AND p.post_status='publish'
            ");
        }else{
            $results = $wpdb->get_results("
                SELECT u.user_id,u.meta_value 
                FROM {$wpdb->usermeta} as u
                LEFT JOIN {$wpdb->posts} as p
                ON p.ID=u.meta_value 
                WHERE u.meta_key='service' AND p.post_status='publish'
            ");
        }
        
        if(!empty($results)){
            foreach ($results as $key => $val) {
                if(!in_array($val->meta_value, $saved_services))
                    $saved_services[] = $val->meta_value;
            }
        }
        $enrolled_services=[];
        if(!empty($saved_services)){
            foreach($saved_services as $user_id=>$service){
                
                $this->service = $service;
               $sar =[
                    'id'=>$service,
                    'title'=>get_the_title($service),
                    'image'=>get_the_post_thumbnail_url($service),
                    'price'=>[],
                ];
                if(empty($this->settings)){
                    $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
                }
                if(!empty($this->settings['service_colors'][$service])){
                    $sar['color']=$this->settings['service_colors'][$service];
                }   
                $enrolled_services[] = apply_filters('vibe_appointments_fetch_service',$sar);
            }

        }

        return new WP_REST_Response(['services'=>$enrolled_services,'status'=>1],200);
        
        
    }

    function getUserEnrolledServices($request){
        $post = json_decode($request->get_body(),true);
        if(!empty($post['user'])){
            $user_id  = $post['user'];
            $saved_services = get_user_meta($user_id,'service',false);
            $enrolled_services=[];

            
            if(!empty($saved_services)){

                foreach($saved_services as $service){
                    $saved_service_price = get_vibe_appointments_pricing_array($user_id,$service);
                    $this->service = $service;
                   $sar =[
                        'id'=>$service,
                        'title'=>get_the_title($service),
                        'image'=>get_the_post_thumbnail_url($service),
                        'price'=>[],
                    ];

                    
                    if(!empty($saved_service_price)){
                        $sar['price']=$saved_service_price;
                        if(!empty($saved_service_price['credits'])){
                            $sar['credits']=$saved_service_price['credits'];
                        }
                    }
                    if(empty($this->settings)){
                        $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
                    }
                    if(!empty($this->settings['service_colors'][$service])){
                        $sar['color']=$this->settings['service_colors'][$service];
                    }   
                    $enrolled_services[] = apply_filters('vibe_appointments_fetch_service',$sar);
                }

            }

            return new WP_REST_Response(['services'=>$enrolled_services,'status'=>1],200);
        }
        return new WP_REST_Response(['services'=>[],'status'=>0],200);
        
    }

    function getEnrolledServices($request){
        $post = json_decode($request->get_body(),true);
        $user_id  = $this->user->id;

        if(user_can($this->user->id,'manage_options') && !empty($post['user_id'])){
            $user_id = $post['user_id'];
        }else{
            $user_id = $this->user->id;    
        }

        $saved_services = get_user_meta($user_id,'service',false);
        $enrolled_services=[];

        
        if(!empty($saved_services)){
            foreach($saved_services as $service){
                if(get_post_status($service)=='publish'){
                    $saved_service_price = get_vibe_appointments_pricing_array($user_id,$service);
                    $this->service = $service;
                    $sar =[
                        'id'=>$service,
                        'title'=>get_the_title($service),
                        'image'=>get_the_post_thumbnail_url($service),
                        'price'=>[],
                    ];

                    
                    if(!empty($saved_service_price)){
                        $sar['price']=$saved_service_price;
                        if(!empty($saved_service_price['credits'])){
                            $sar['credits']=$saved_service_price['credits'];
                        }
                    }
                    if(empty($this->settings)){
                        $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
                    }
                    if(!empty($this->settings['service_colors'][$service])){
                        $sar['color']=$this->settings['service_colors'][$service];
                    }   
                    $enrolled_services[] = apply_filters('vibe_appointments_fetch_service',$sar);
                }
            }
        }

        return new WP_REST_Response(['services'=>$enrolled_services,'status'=>1],200);
    }

    
    function saveEnrolledServices($request){

        $post = json_decode($request->get_body(),true);
        global $wpdb;
        $user_id  = $this->user->id;

        if(user_can($this->user->id,'manage_options') && !empty($post['user_id'])){
            $user_id = $post['user_id'];
        }else{
            $user_id = $this->user->id;    
        }


        $enrolled_services = get_user_meta($user_id,'service',false);

        $services = wp_list_pluck($post['enrolledServices'],'id');

        

        $add_services = array_diff($services,$enrolled_services);
        $remove_services = array_diff($enrolled_services,$services);

        if(!empty($add_services)){
            foreach($add_services as $service_id){
                add_user_meta($user_id,'service',$service_id);
            }
        }
        if(!empty($remove_services)){
            foreach($remove_services as $service_id){
                delete_user_meta($user_id,'service',$service_id);
            }
        }
        

        //$posted_service_prices = wp_list_pluck($post['enrolledServices'],'price');

        $posted_service_prices = $post['enrolledServices'];
        $saved_service_prices = get_vibe_appointments_pricing_array($user_id);


        if(empty($posted_service_prices)){$posted_service_prices = array();}

        $existing_products = $new_products = $to_be_deleted = [];

        if(empty($saved_service_prices)){
            $saved_service_prices = array();
        }else{
            //DELETE REMOVED SERVICES
            foreach($saved_service_prices as $key=>$saved_service_price){
                $this->saved_service_price = $saved_service_price;
                $index= $this->array_find($posted_service_prices,function($item){return (!empty($this->saved_service_price['service_id']) && $this->saved_service_price['service_id'] == $item['id']);});
                //check if Product to be deleted

                if($index==-1){ 
                    if(!empty($saved_service_price['product_id'])){
                        $to_be_deleted[]=['product_id'=>$saved_service_price['product_id'],'service_id'=>$saved_service_price['service_id']];    
                    }
                    unset($saved_service_prices[$key]);
                }
            }
        }

        //UPDATE OR ADD
        foreach($posted_service_prices as $key=>$posted_service_price){
            $this->posted_service_price = $posted_service_price;
            $index= $this->array_find($saved_service_prices,function($item){return $this->posted_service_price['id'] == $item['service_id'];});

            //UPDATE SERVICE PRICE
            if($index >-1 && !empty($posted_service_prices[$key]['price']) && $saved_service_prices[$index]['value'] !=  $posted_service_price['price']['value']){
                $saved_service_prices[$index]['value'] = $posted_service_price['price']['value'];
                
                $posted_service_price['price']['index']=$key;

                $existing_products[] = $posted_service_price['price'];        

                //set lowest service price
                $lowest_service_price = get_post_meta($this->posted_service_price['id'],'lowest_price',true);
                if(empty($lowest_service_price) || $lowest_service_price['value'] > $posted_service_price['price']['value']){
                    update_post_meta($this->posted_service_price['id'],'lowest_price',['value'=>$posted_service_price['price']['value'],'html'=>$posted_service_price['price']['html']]);
                }

            }else if($index == -1){

                //ADD New SERVICE
                $posted_service_price['index']=$key;
                if(empty($posted_service_price['price']['product_id'])){
                    $new_products[] = $posted_service_price;    
                }
                
            }
        }

        if(!empty($existing_products)){
            foreach($existing_products as $key=> $existing_product){

                $product = wc_get_product($existing_product['product_id']);
                $product->set_price($existing_product['value']);
                $product->set_regular_price($existing_product['value']);

                // update_post_meta($existing_product['product_id'],'_price',$existing_product['value']);
                // update_post_meta($existing_product['product_id'],'_regular_price',$existing_product['value']);
                
                
                if(isset($existing_product['index']) && $existing_product['index'] > -1){
                    
                    $posted_service_prices[$existing_product['index']]['price']['html'] = $product->get_price_html();    
                }
                
            }
        }

        if(!empty($new_products)){
            foreach($new_products as $key=> $new_product){
                if(function_exists('wc')){
                    $product_id = wp_insert_post(apply_filters('vibe_appointments_create_product',array(
                        'post_title'=>sprintf(_x('Appointment Booking product for %s for service %s','product title','vibe-appointments'),bp_core_get_user_displayname($this->user->id),$new_product['id']),
                        'post_content'=>sprintf(_x('Appointment Booking product for %s for service %s','product title','vibe-appointments'),bp_core_get_user_displayname($this->user->id),get_the_title($new_product['id'])),
                        'post_author'=>$user_id,
                        'post_type'=>'product',
                        'post_status'=>'publish',
                        'meta_input'=>array(
                            '_hidden'=>true,
                            '_price'=>$new_product['price']['value'],
                            '__regular_price'=>$new_product['price']['value'],
                            '_appointments_service_price'=>$this->user->id,
                            '_appointments_service_id'=>$new_product['id'],
                        )
                    ),$post,$this->user));
                    if(is_numeric($product_id)){
                        
                        $product = wc_get_product($product_id);
                        $product->set_price($new_product['price']['value']);
                        $product->set_regular_price($new_product['price']['value']);
                

                        $posted_service_prices[$new_product['index']]['price']['product_id'] = $product_id;
                        $posted_service_prices[$new_product['index']]['price']['value']=$new_product['price']['value'];
                        $posted_service_prices[$new_product['index']]['price']['html']= $product->get_price_html();



                    }else{
                       return new WP_REST_Response( array('status'=>1,'message'=>__('Failed to set price.','vibe-appointments')),200); 
                    }
                }
            }
        }

        if(!empty($to_be_deleted)){
            foreach($to_be_deleted as $key=> $to_be_delete){
                wp_delete_post($to_be_delete['product_id']);
                remove_vibe_appointments_pricing_array($user_id,$to_be_delete['service_id']);
            }    
        }
        
       
        
        if(!empty($posted_service_prices)){
            foreach($posted_service_prices as $kk => $posted_service_price){

                if(!empty($posted_service_price['price']) && !empty($posted_service_price['price']['product_id'])){
                    $p_details = array(
                        'type'=>'wc',
                        'product_id'=>$posted_service_price['price']['product_id'],
                        'service_id'=>$posted_service_price['id'],
                        'value'=>$posted_service_price['price']['value'],
                        'html'=>$posted_service_price['price']['html'],
                    );
                    if(!empty($posted_service_price['credits'])){
                        $p_details['credits'] = $posted_service_price['credits'];
                     
                    }
                    update_vibe_appointments_pricing_array($user_id,$posted_service_price['id'],$p_details); 
                }
                
            }
        }
        //
        return new WP_REST_Response( array('status'=>1,'enrolledServices'=>$posted_service_prices,'message'=>__('Price per slot booking set for instructor','vibe-appointments'),'deleted'=>$to_be_deleted,'new_product'=>$new_products,'existing_product'=>$existing_products),200);
    }

    function check_service_inarray($service,$services){
        if(!empty($services)){
            foreach($services as $key=>$s){
                if($s['id']===$service['id']){
                    return $key;
                }
            }
        }   
        return -1;
    }

    function postActivity($request){
        $post = json_decode($request->get_body(),true);
        

        $aid = bp_activity_add( array( 
            'user_id' => $post['appointment']['booker_id'], 
            'action' => _x('Update from Instructor.','appointment','vibe-appointments'), 
            'content' => $post['postMessage'],
            'component' => 'appointments', 
            'type' => 'appointment_update', 
            'item_id' => $post['appointment']['appointment_id'], 
        ));
        return new WP_REST_Response( array('status'=>1,'message'=>__('Activity posted on user wall.','vibe-appointments')),200);
    }


    function get_members($request){
        $args = json_decode($request->get_body(),true); 
        $args=apply_filters( 'vibe_bp_api_members_get_members_args', $args, $request);

        $include = array();

        if(!empty($args['serviceypes'])){

        }
        
        if(!empty($args['dateRanges']) || !empty($args['timeRanges'])){
            global $wpdb;

            $db = new VIBE_APPOINTMENTS_DB;
            $query = "
                SELECT * 
                FROM {$db->table_name} 
                WHERE status='open'";

            if(!empty($args['item_id'])){
                if(is_array($args['item_id'])){
                    $query .=' AND item_id IN ('.implode(',',$args['item_id']).') ' ;
                }else if(is_numeric($args['item_id'])){
                    $query .=' AND item_id='.$args['item_id'].' ' ;
                }
               
            }
            if(!empty($args['dateRanges'])){
                $query .=' AND (';
                foreach($args['dateRanges'] as $i=>$dateRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .='( start_date >= '.$dateRange['start_date'].' AND start_date <= '.$dateRange['end_date'].' OR end_date >= '.$dateRange['start_date'].' AND end_date <= '.$dateRange['end_date'].' OR '.$dateRange['start_date'].' >= start_date AND '.$dateRange['start_date'].' <= end_date OR '.$dateRange['end_date'].' >= start_date AND '.$dateRange['end_date'].' <= end_date) ';
                }
                $query .=' ) ';
            }

            if(!empty($args['weekRanges'])){
                $query .=' AND (';
                foreach($args['weekRanges'] as $i=>$dateRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .=' start_date >= '.$dateRange['start_date'].' AND end_date <= '.$dateRange['end_date'];
                }
                $query .=' ) ';
            }


            if(!empty($args['timeRanges'])){
                $query .=' AND (';
                foreach($args['timeRanges'] as $i=>$timeRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .=' start_time >= '.$timeRange['start_time'].' AND start_time <= '.$timeRange['end_time'];
                }
                $query .=' ) ';
            }

            $query .=' LIMIT 0,999';

           //print_R($query);
            $member_slots = array();
            $results = $wpdb->get_results($query);
            if(!empty($results)){
                foreach($results as $result){
                    if(!in_array($result->author_id, $include)){
                        $include[]=$result->author_id;
                    }
                    if(empty($member_slots[$result->author_id])){
                        $member_slots[$result->author_id] =[];
                    }

                    if(!empty($result->start_date)){
                        $result->debug_date = date('Y-m-d H:i:s',($result->start_date/1000));
                    }
                    if(!empty($result->type) && strpos($result->type, 'recurring_')!==false) {
                            //recurring appointment
                        $result->days_of_week = explode('_',str_replace('recurring_', '', $result->type)); 
                    }

                    if(empty($result->item_id)){
                        $result->item_id = '';
                    }
                    $member_slots[$result->author_id][] = $result;
                }
            }else{
                return new WP_REST_Response( array('status'=>1,'data'=>array('users'=>[],'total'=>0),'message'=>_x('No members in given timeslot','api','vibe-appointments'),'$query'=>$query), 200 ); 
            }
        }


        //Pass those users with remaining filters

        if(!empty($args['filters'])){
            $xprofile_query = array(
                'relation'=>'AND'
            );
            foreach($args['filters'] as $filter){
                if(!empty($filter['type'])){
                    switch($filter['type']){
                        case 'checkbox':
                      
                            global $wpdb,$bp;
                            $us = implode(',', $include);
                            $results = $wpdb->get_results("SELECT value,user_id FROM 
                                {$bp->profile->table_name_data} 
                                WHERE field_id='{$filter['field_id']}' AND 
                                user_id IN ({$us})");
                            if(!empty($results)){
                                foreach ($results as $key => $user_data) {
                                    if(!empty($user_data->value)){
                                        $user_data->value = maybe_unserialize($user_data->value);
                                        if(!$this->has_checkbox_field_value($user_data->value ,$filter['values'])){
                                            $k = $this->get_user_key($user_data->user_id,$include);
                                            unset($include[$k]);
                                        }
                                    }
                                }
                            }
                        break;
                        default:
                            $xprofile_query[] = array(
                                'field'   => $filter['field_id'],
                                'value'   => $filter['values'],
                                'compare' => 'IN',
                            );
                        break;
                    }
                }else{
                    $xprofile_query[] = array(
                        'field'   => $filter['field_id'],
                        'value'   => $filter['values'],
                        'compare' => 'IN',
                    );
                }
                
            }
            
            $args['xprofile_query'] = $xprofile_query;
            unset($args['filters']);
        }
         
        
        if(empty($include)){
            return new WP_REST_Response( array('status'=>1,'data'=>array('users'=>[],'total'=>0),'message'=>_x('No members in given timeslot','api','vibe-appointments'),'$query'=>$query), 200 ); 
        }

        if(isset($args['users_in'])){

            if(!empty($args['users_in'])){
                $include = $args['users_in'];
            }else{
                $include = array(9999999999999999);
            }
            
            /*if(!empty($args['no_filters'])){
                //to fetch only favourites
                if(!empty($args['users_in'])){
                    $include = $args['users_in'];
                }else{
                    $include = array(9999999999999999);
                }
                
            }else{
                //to fetch only favourites along with daterange context
                foreach ($args['users_in'] as $k=> $u) {
                    if(!in_array($u,$include)){
                        unset($include[$k]);
                    }
                }
            }*/
            
            unset($args['users_in']);
        }
        unset($args['timeRanges']);
        unset($args['dateRanges']);


        $args['include']=implode(',',$include);


        if(!empty($args['priceRange']) && !empty($include)){
            $this->price_range = $args['priceRange'];  
            if($this->price_range['min']!=0){
                add_filter('bp_user_query_uid_clauses',array($this,'set_price'),10,2);
                unset($args['price_range']); 
            }
        }
        if(!empty($args['orderby'])){
           $args['type']= $args['orderby'];
        }
        $args['populate_extras']=false;

        $run =  bp_core_get_users($args);   

        if( count($run['users']) ){
            foreach($run['users'] as $key => $user){
                
                unset($run['users'][$key]->user_email);
                unset($run['users'][$key]->user_login);
                unset($run['users'][$key]->user_nicename);
                unset($run['users'][$key]->user_pass);
                
                $run['users'][$key]->avatar = bp_core_fetch_avatar(array(
                    'item_id'   => $user->ID,
                    'object'    => 'user',
                    'type'      =>'thumb',
                    'html'      => false
                ));
                $run['users'][$key]->id=$user->ID;
                $run['users'][$key]->url = bp_core_get_user_domain($run['users'][$key]->id);
                if(isset($user->last_update)){
                    $run['users'][$key]->last_update = maybe_unserialize($user->last_update);   
                }
                if(!empty($member_slots[$user->ID])){
                    $run['users'][$key]->slots = $member_slots[$user->ID];
                }
                
                
                if(!empty($args['show_map'])){
                    $run['users'][$key]->location = array('lat'=>get_user_meta($user->ID,'lat',true),'lng'=>get_user_meta($user->ID,'lng',true));
                }
                $run['users'][$key]->price = $this->get_user_pricing_array($user->ID);
                if(!empty($args['firstLoad']) && $args['firstLoad'] == 'card'){

                    $layouts = new WP_Query(apply_filters('vibe_member_card',array(
                        'post_type'=>'member-card',
                        'posts_per_page'=>1,
                        'meta_query'=>array(
                            'relation'=>'AND',
                            array(
                                'key'=>'member_type',
                                'compare'=>'NOT EXISTS'
                            )
                        )
                    ),$user->ID));
                    $init = VibeBP_Init::init();
                    $init->user_id = $user->ID;
                    ob_start();
                    if($layouts->have_posts()){
                        while($layouts->have_posts()){
                            $layouts->the_post();
                            the_content();
                        }
                    }                    
                    $run['users'][$key]->memberCard= ob_get_clean();
                }
                if(!empty($args['videofield']) && is_numeric($args['videofield'])){
                    $val =BP_XProfile_ProfileData::get_value_byid($args['videofield'], $run['users'][$key]->id);
                    if(is_serialized($val)){
                        $val = unserialize(stripcslashes($val));
                    }
                    $run['users'][$key]->videodata= $val;
                }
            }
            $data=array(
                'status' => 1,
                'data' => $run,
                'message' => _x('Members Exist','Members Exist','vibebp'),
                '$query'=>$query,
                
            );
        }else{
            $data=array(
                'status' => 1,
                'data' => $run,
                'message' => _x('No members found !','Members Not Exist','vibebp'),
                '$query'=>$query,

            );
        }
        $data=apply_filters( 'vibe_bp_api_members_get_members', $data, $request ,$args );
        return new WP_REST_Response( $data, 200 ); 
    }

    function has_checkbox_field_value($user_values,$filter_values){
        if(!empty($filter_values) && !empty($user_values)){
            foreach ($filter_values as $key => $value) {
                if(in_array($value, $user_values))
                    return true;
            }
        }

        return false;
    }

    function get_user_key($user_id,$users){
        if(!empty($users)){
            foreach ($users as $key => $u) {
                if($u==$user_id)
                    return $key;
            }
        }   
        return -1;
    }

    function get_user_pricing_array($user_id,$service_id=null){
        if(empty($this->pricing_array)){
            $this->pricing_array = [];
        }
        if(!empty($this->pricing_array[$user_id])){
            return apply_filters('vibeappointments_get_user_pricing_array',$this->pricing_array[$user_id],$user_id,$service_id);
        }
        $pricing_array = [];
        $data = get_user_meta($user_id,'vibe_appointments_pricing_array',true);
        if(!empty($data)){
            
            foreach($data as $k => $price){
                if(empty($price['service_id'])){
                    $pricing_array[''] = $price;
                }else{
                    if(!empty($price['service_id']) && get_post_status($price['service_id'])=='publish'){
                        $pricing_array[$price['service_id']] = $price;
                    }
                }
                
            }
            $this->pricing_array[$user_id] = $pricing_array;
        }
        return apply_filters('vibeappointments_get_user_pricing_array',(!empty($this->pricing_array[$user_id])?$this->pricing_array[$user_id]:[]),$user_id,$service_id);
    }

    function set_price($sql,$qthis){
        
        if(!empty($this->price_range)){
            if(empty($sql['where'])){
                $sql['where']=array();
            }
            global $wpdb;
            $meta_sql = $wpdb->prepare( "SELECT user_id FROM {$wpdb->usermeta} WHERE meta_key = %s AND cast(meta_value as unsigned) >= %d AND cast(meta_value as unsigned) <= %d", '_appointment_price',$this->price_range['min'],$this->price_range['max'] );

            $found_user_ids = $wpdb->get_col( $meta_sql );

            if ( ! empty( $found_user_ids ) ) {
                $sql['where'][] = "u.{$qthis->uid_name} IN (" . implode( ',', wp_parse_id_list( $found_user_ids ) ) . ")";
            }else{
                 $sql['where'][] = "u.{$qthis->uid_name} IN (-1)";
            }
        }
        return $sql;
    }


    function completeBooking($request){

        $post = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $args = apply_filters('vibe_appointments_get_slots',array(
            'appointment_id'=>array($post['appointment']['appointment_id']),
        ),$request);
   
        $slots = $db->get_appointments($args);

        if($slots[0]['author_id'] !== $post['appointment']['author_id'] || $post['appointment']['author_id'] !== $this->user->id && !in_array('manage_options',array_keys((Array)$this->user->caps))){
            return new WP_REST_Response( array('status'=>0,'message'=>__('Only Appointment author can mark appointment as complete.','vibe-appointments')), 200 ); 
        }

        $args = array(
            'appointment_id'=>$post['appointment']['appointment_id'],
            'status'    => 'complete',
        );
        $db->update_appointment($args);
        
        return new WP_REST_Response( array('status'=>1,'message'=>__('Appointment marked complete.','vibe-appointments')), 200 ); 
    }

    function search_sharing_values($request){
        $args = json_decode($request->get_body(),true);
        $return = array( 'status' => 0 );
        if(!empty($args['s']) && !empty($args['shared_type'])){
            $scope = $args['shared_type'];
            $search = $args['s'];
            switch($scope){
                case 'course':
                    global $wpdb, $bp;
                    $results = $wpdb->get_results( "SELECT ID,post_title FROM {$wpdb->posts} WHERE `post_type` = 'course' AND (`post_title` LIKE '%{$search}%' OR 
                        `post_name` LIKE '%{$search}%')", ARRAY_A );
                    if(!empty($results)){
                        $return['status']=1;
                        foreach($results as $result){
                            $return['values'][]=array('id'=>$result['ID'],'label'=>$result['post_title']);
                        }
                    }
               break;
            }
        }
        return new WP_REST_Response(apply_filters('vibe_appointments_search_sharing_values',$return,$request,$this->user), 200);
    }

    function is_booked($id){
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $db = new VIBE_APPOINTMENTS_DB;
        $slots = $db->get_appointments(array('appointment_id'=>$id));
        if(!empty($slots)){
            if(empty($slots[0]['booker_id'])){
                $val = $meta->get_appointments_meta(array('appointment_id'=>$id,'meta_key'=>'booker_id'));
            }else{
                return $slots[0]['booker_id'];
            }
        }
        return $val;
    }

    function book_appointment($request){
        $post = json_decode($request->get_body(),true);
        $event = $post['event'];
        $return = array( 'status' => 0 ,'message'=>__('Booking Not Done!','vibe-appointments'));
        if($event['appointment_id']){

            $is_booked = !empty($this->is_booked($event['appointment_id']))?true:false;
            if(!$is_booked){
                $meta = new VIBE_APPOINTMENTS_META_DB;
                $db = new VIBE_APPOINTMENTS_DB;
                if($post['unit_id']){
                    $meta->update_appointment_meta(array(
                        'appointment_id'=>$event['appointment_id'],
                        'meta_key'=>'unit',
                        'meta_value'=> (int)$post['unit_id'],
                    ));
                }
        
                $slots = $db->get_appointments(array('appointment_id'=>$event['appointment_id']));
                if(!empty($slots)){
                    if(empty($slots[0]['booker_id'])){
                        $db->update_appointment(array(
                            'appointment_id'=>$event['appointment_id'],
                            'booker_id'=>$booker_id
                        ));
                    }else{
                        $meta->add_appointment_meta(array(
                            'appointment_id'=>$event['appointment_id'],
                            'meta_key'=>'booker_id',
                            'meta_value'=> (int)$this->user->id,
                        ));
                    }
                }
                
                $return = array( 'status' => 1 ,'message'=>__('Booked','vibe-appointments'));
            }
        }
        return new WP_REST_Response($return, 200);
    }
    function getServices($request){
        
        $post = json_decode($request->get_body(),true);
        $return = array();
        $data = array('status'=>1,'services'=>[],'message'=>_x('No services found!','','vibe-appointments'));

        
            $args = array(
                'post_type' => 'service',
                'per_page'=>-1,
            );
            if(!empty($post['term']) && $post['term'] != -1){
                $args['tax_query'] = array(
                    array(
                    'taxonomy' => 'service-type',
                    'field' => 'term_id',
                    'terms' => [$post['term']]
                     ),
                );
            }
            $args = apply_filters('vibe_appointments_get_services',$args,$post);

            $the_query = new WP_Query($args);
            $posts = array();
            if($the_query->have_posts()){
                if(empty($this->settings)){
                    $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
                }
                while($the_query->have_posts()){
                    $the_query->the_post();
                    global $post;
                    $data = array('id'=>$post->ID,'title'=>$post->post_title,'image'=>get_the_post_thumbnail_url($post->ID,'medium'));
                    if(!empty($this->settings['service_colors']) && !empty($this->settings['service_colors'][$post->ID])){
                        $data['color'] = $this->settings['service_colors'][$post->ID];
                    }
                    $posts[] = $data;
                }
                wp_reset_postdata();
                $data = array('status'=>true,'services'=>$posts);
            }
            
        $data['args']=$args;
        return new WP_REST_Response( $data, 200 );
    }
    function get_taxonomy($request){
        
        $body = $request->get_body();
        $body = json_decode($body);
        $return = array();
        $taxonomy=$body->taxonomy;
        $posts = array();

        if(!empty($body ) && !empty($taxonomy) ){
            $terms = get_terms( $taxonomy, array('hide_empty' => false,'orderby'=>'name','order'=>'ASC') );
            if(!empty($terms) && is_array($terms)){
                foreach ($terms as $key=>$term ){
                    
                    $posts[] = array('id'=>$term->term_id,'text'=>$this->get_taxonomy_name('',$term,$terms));
                      
                    
                }
            }
            wp_reset_postdata();
        }else{
            $return = array('status'=>false,'message'=>_x('Sorry Something went wrong or invalid post type','','vibe-appointments'));
        }

        if(empty($posts)){
            return new WP_REST_Response( array('status'=>false,'message'=>_x('Sorry no results found!Try another search keyword!','API request','vibe-appointments')), 200 );
        }
        return new WP_REST_Response( array('status'=>true,'posts'=>$posts), 200 );
    }

    function servicedata($request){
        $body = $request->get_body();
        $body = json_decode($body,true);
        $showServices = false;
        if(!empty($body['taxonomy'])){
            $showServices = true;
            $args = array(
                'taxonomy' => VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
                'orderby' => 'meta_value_num',
                'order' => 'DESC',
                'hide_empty' => false,
                'parent'   => intval($body['taxonomy']),
                'meta_query' => [
                    'relation'=>'OR',
                    [
                        'key' => 'service_type_order',
                        'type' => 'NUMERIC',

                    ],
                    [
                        'key' => 'service_type_order',
                        'type' => 'NUMERIC',
                        'compare'=>"NOT EXISTS"
                    ]
                ],
            );
        }else{
           $args = array(
                'taxonomy' => VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
                'orderby' => 'meta_value_num',
                'order' => 'DESC',
                'hide_empty' => false,
                'parent'   => 0,
                'meta_query' => [
                    'relation'=>'OR',
                    [
                        'key' => 'service_type_order',
                        'type' => 'NUMERIC',

                    ],
                    [
                        'key' => 'service_type_order',
                        'type' => 'NUMERIC',
                        'compare'=>"NOT EXISTS"
                    ]
                ],
            ); 
        }
        
        $terms = get_terms($args);
        $term_ids = [];
        $service_types = [];
        $services =[];
        if(!empty($terms)){
            foreach($terms as $key => $term){
                $image = get_term_meta($term->term_id,'service_type_thumbnail_id',true);
                $image = wp_get_attachment_url($image);  
                $terms[$key]->id=$term->term_id;
                $terms[$key]->text=$term->name;
                if(empty($image)){
                    $terms[$key]->image=  apply_filters('vibe_appointments_service_type_default_bg','background:radial-gradient(27.19% 67.83% at 101.83% 2.63%, #abb3ff 0%, rgba(171,179,255,0) 100%),linear-gradient(134.39deg, #ea4c89 -6.16%, #4d44c6 85.98%)');
                }else{
                    $terms[$key]->image=$image;
                }
                

                $terms[$key]->url=get_term_link($term);

                     

                $term_ids[]= $term->term_id;
                $service_types[]=$term;
            }

        }
        if($showServices){
            $term_ids[]=$body['taxonomy'];
            $services = $this->get_term_posts($term_ids);
        }
        return new WP_REST_Response( array('status'=>true,'services'=>$services,'service_types'=>$service_types), 200 );
    }

    function getPriceRange($request){
        $body = $request->get_body();
        $body = json_decode($body,true);
        $data = array('status'=>false,'message'=>'');
        global $wpdb;
        $results =[];
        if(!empty($body['service'])){
            if(is_array($body['service'])){
                $services_String = '(';
                foreach($body['service'] as $i=>$service_id){
                    if($i){$services_String .= ',';}
                    $services_String .= '"_appointment_price'.$service_id.'"';
                }
                $services_String .= ')';
                
                $results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$wpdb->usermeta} WHERE meta_key IN $services_String");
            }else{
                $results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$wpdb->usermeta} WHERE meta_key='_appointment_price{$body['service']}'");    
            }
            
        }else{
            $results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$wpdb->usermeta} WHERE meta_key='_appointment_price'");
            
        }
        if(!empty($results)){
            $data['status'] = true;
            foreach($results as $result){
                if(empty($result->min)){$result->min =0;}
                if(empty($result->max)){$result->max =100;}
                if($result->min == $result->max){$result->min=0;}
                $data['ranges'] =  array('min'=>$result->min,'max'=>$result->max);
            }
        }else{
            $data['ranges'] =  array('min'=>0,'max'=>apply_filters('vibebpappointments_get_price_range',1000));
        }

        return new WP_REST_Response( $data, 200 );
    }

    function check_term_posts($term){
        if(!empty($term->children)){
            unset($term->posts);
            foreach($term->children as $key=>$child_term){
                $term->children[$key]= $this->check_term_posts($child_term);
            }
        }
        return $term;
    }

    function get_term_posts($terms){
        $args = array('post_type' => VIBE_APPOINTMENTS_SERVICE_SLUG,
            'posts_per_page'=>-1,
            'tax_query' => array(
                array(
                    'taxonomy' => VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
                    'field' => 'term_id',
                    'terms' => $terms,
                ),
            ),
         );

         $loop = new WP_Query($args);
         $posts= [];
         if($loop->have_posts()) {
            while($loop->have_posts()) : $loop->the_post();
                $image = get_the_post_thumbnail_url(get_the_ID());
                $posts[] = array('id'=>get_the_ID(),'text'=>get_the_title(),'image'=>$image,'url'=>get_permalink());
            endwhile;

         }
         wp_reset_postdata();

         return $posts;
    }

    function get_taxonomy_name($name,$term,$terms){
        if(!empty($term->parent)){
            
            $name .= $this->get_term_name_from_taxonomies($term->parent,$terms).' > '.$term->name;
        }else{
            $name .= $term->name;
        }
        return $name;
    }

    function  get_term_name_from_taxonomies($term_id,$terms){
        if(!empty($terms)){
            foreach ($terms as $key => $tt) {
                if($tt->term_id==$term_id){
                    return $this->get_taxonomy_name('',$tt,$terms);
                }
            }
        }
    }

    function all_types_names(){
        return apply_filters('vibe_appointments_type_names',array(
            'service'=>_x('Service','vibe_appointments_type_names','vibe-appointments'),
            'course'=>_x('Course','vibe_appointments_type_names','vibe-appointments'),
        ));
    }

    function get_appointment_name_from_type($type){
        if(!empty($this->all_types_names()[$type])){
            return $this->all_types_names()[$type];
        }else{
            return array();
        }
        
    }

    function getEventMessageThread($request){
        $body = json_decode($request->get_body(),true);
        $data = array('status'=>false,'message'=>'');
        global $wpdb,$bp;

        $message_id = $wpdb->get_var($wpdb->prepare("SELECT message_id FROM {$bp->messages->table_name_meta} WHERE meta_key = 'appointment_id' AND meta_value = %d",$body['appointment']['appointment_id']));

        
        $run = new BP_Messages_Thread( $message_id );
        
        if( empty($run->thread_id)){
           
            $subject = sprintf(_x('Message Thread for Appointment [ %d ]','','vibe-appointments'),$body['appointment']['appointment_id']);
            if(!empty($body['appointment']['additional']) && $body['appointment']['additional']){
                $subject .= sprintf(__(' for %s','vibe-appointments'),$body['appointment']['additional']['title']);
            }
            $message_args = array(
                'sender_id'  => $body['appointment']['author_id'],
                'recipients' => [$body['appointment']['booker_id']], // Can be an array of usernames, user_ids or mixed.
                'subject'    => $subject,
                'content'    => __('Start of conversation','vibe-appointments'),
            );
            $thread_id = messages_new_message($message_args);
            bp_messages_update_meta( $thread_id, 'appointment_id', $body['appointment']['appointment_id']);
            $run = $thread = new BP_Messages_Thread( $thread_id );

        }

        if( $run){
            $data=array(
                'status' => 1,
                'data' => $run,
                'message' => _x('Messages Found','Messages Found','vibebp')
            );
        }
        return array('status'=>1,'message'=>$run);
    }



    function submitDispute($request){
        $body = json_decode($request->get_body(),true);
       

        if(function_exists('messages_new_message')){
            global $wpdb,$bp;

            $thread_id = $wpdb->get_var($wpdb->prepare("
                    SELECT m.message_id as message_id 
                    FROM {$bp->messages->table_name_meta} as m
                    LEFT JOIN {$bp->messages->table_name_meta} as m1 
                    ON m.message_id = m1.message_id
                    WHERE m.meta_key = 'disputed_appointment_id' 
                    AND m1.meta_key = 'disputed_appointment_member_id'
                    AND m1.meta_value = %d
                    AND m.meta_value = %d",
            $this->user->id,$body['appointment']['appointment_id']
        ));

            if( empty($thread_id)){
               
                $subject = sprintf(_x('Message Thread for Appointment [ %d ] Dispute','','vibe-appointments'),$body['appointment']['appointment_id']);
                if(!empty($body['appointment']['additional']) && $body['appointment']['additional']){
                    $subject .= sprintf(__(' for %s','vibe-appointments'),$body['appointment']['additional']['title']);
                }
                $message_args = array(
                    'sender_id'  => $this->user->id,
                    'recipients' => [$body['appointment']['author_id']], // Can be an array of usernames, user_ids or mixed.
                    'subject'    => $subject,
                    'content'    => __('Start of conversation','vibe-appointments'),
                );
                $thread_id = messages_new_message($message_args);
                bp_messages_update_meta( $thread_id, 'disputed_appointment_id', $body['appointment']['appointment_id']);
                bp_messages_update_meta( $thread_id, 'disputed_appointment_member_id', $this->user->id);
            }

            $recipients=[$body['appointment']['author_id']];
            $user_query = new WP_User_Query( array( 'role' => 'Administrator' ,'fields' => array('ID','user_email')) );
            foreach( $user_query->results as $user){
                $recipients[] = $user->ID;
            }

            $message_args = array(
                'thread_id' => $thread_id,
                'sender_id'  => $this->user->id,
                'recipients' => $recipients,
                'content'    => $body['message'],
            );
            $message_id = messages_new_message($message_args);

        }
        
        $meta = new VIBE_APPOINTMENTS_META_DB;
        $fx = $meta->update_appointment_meta(['appointment_id'=>$body['appointment']['appointment_id'],'meta_key'=>'dispute','meta_value'=>$this->user->id]);


        return new WP_REST_Response(['status'=>1,'message'=>__('Booking marked as Disputed.')]);

    }


    function disputeAction($request){

        $body = json_decode($request->get_body(),true);
       
       
        $flag = apply_filters('vibe_appointments_who_can_clear_dispute',true);

        if($flag){


        
            $meta = new VIBE_APPOINTMENTS_META_DB;
            $fx = $meta->delete_appointment_meta(['appointment_id'=>$body['appointment']['appointment_id'],'meta_key'=>'dispute','meta_value'=>$body['appointment']['booker_id']]);    

            if($body['action'] == 'approve'){
                $action = _x('Approved','dispution action','vibe-appointments');

            }
            if($body['action'] == 'reject'){
                $action = _x('Rejected','dispution action','vibe-appointments');
            }

            $flag = apply_filters('vibe_appointments_dispute_action',false,$body);

            if(empty($flag)){
                if($body['action'] == 'approve'){
                    $db = new VIBE_APPOINTMENTS_DB;
                    $appointment = $db->get_appointments(['appointment_id'=>$body['appointment']['appointment_id']]);
                    if(!empty($appointment) && $appointment[0]['booker_id'] == $body['appointment']['booker_id']){
                        $db->update_appointment(['appointment_id'=>$body['appointment']['appointment_id'],'booker_id'=>'','status'=>'open']);
                    }else{
                        $meta->delete_appointment_meta(['appointment_id'=>$body['appointment']['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$body['appointment']['booker_id']]);
                    }

                    $metas = $appointments_meta_db->get_appointments_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'order_details_'.$user_id));
                    $order_details = [];
                    if(!empty($metas) && !empty($metas[0]['meta_id'])){
                        $appointments_meta_db->delete_appointment_meta($metas[0]['meta_id']);
                        $order_details=$metas[0]['meta_value'];
                    }
                    do_action('vibe_appointments_booking_cancelled',$appointments[0],['booker_id'=>$appointment[0]['booker_id'],'order_details'=>$order_details]);
                }
                $activity_id = bp_activity_add( array( 
                    'user_id' => $body['appointment']['booker_id'], 
                    'action' => __('Appointment dispute action','vibe-appointments'), 
                    'content' => sprintf(_x('Dispute for Appointment [%d]  %s','wallet','vibe-appointments'),$body['appointment']['appointment_id'],$action), 
                    'item_id'=>$body['appointment']['appointment_id'],
                    'component' => 'appointment', 
                    'type' => 'appointment_dispute', 
                ));    
                $return = ['status'=>1,'message'=>__('Dispute Action Performed.')];
            }else{
                $return = ['status'=>1,'message'=>$flag];
            }
            

            return new WP_REST_Response($return);

        }
        

        if($fx){
            $return = ['status'=>1,'message'=>__('Dispute was cleared.')];
        }else{
            $return = ['status'=>0,'message'=>__('Unable to clear dispute.')];
        }

        return new WP_REST_Response($return);
    }

    function getEventDisputeThreads($request){
        $body = json_decode($request->get_body(),true);
       
        if(empty($body['args'])){$args=['page'=>1,'search'=>''];}else{$args=$body['args'];}

        $run = false;
        if(function_exists('messages_new_message') && !empty($body['appointment']['meta'])){
            global $wpdb,$bp;
            $thread_ids=[];

            $disputed_user_metas = array_filter($body['appointment']['meta'],function($item){return $item['meta_key'] == 'dispute';});;

            if(!empty($disputed_user_metas)){


                $dispute_user_ids = wp_list_pluck($disputed_user_metas,'meta_value');
                
                if(!empty($body['type']) && $body['type'] == 'author'){
                    

                    if(!empty($disputed_user_metas)){
                        $thread_ids = $wpdb->get_results($wpdb->prepare("
                                    SELECT m.message_id as message_id 
                                    FROM {$bp->messages->table_name_meta} as m
                                    LEFT JOIN {$bp->messages->table_name_meta} as m1 
                                    ON m.message_id = m1.message_id
                                    WHERE m.meta_key = 'disputed_appointment_id' 
                                    AND m1.meta_key = 'disputed_appointment_member_id'
                                    AND m1.meta_value IN (".implode(',',$dispute_user_ids).")
                                    AND m.meta_value = %d",
                            $body['appointment']['appointment_id']
                        ),ARRAY_A);
                        
                        
                    }

                }else if(!empty($body['type']) && $body['type'] == 'booker' && in_Array($this->user->id,$dispute_user_ids)){

                    $thread_ids = $wpdb->get_results($wpdb->prepare("
                                SELECT m.message_id as message_id 
                                FROM {$bp->messages->table_name_meta} as m
                                LEFT JOIN {$bp->messages->table_name_meta} as m1 
                                ON m.message_id = m1.message_id
                                WHERE m.meta_key = 'disputed_appointment_id' 
                                AND m1.meta_key = 'disputed_appointment_member_id'
                                AND m1.meta_value = %d
                                AND m.meta_value = %d",
                        $this->user->id,$body['appointment']['appointment_id']
                    ),ARRAY_A);
                } 
            }
            

            
            
            
            if(!empty($thread_ids)){
                foreach($thread_ids as $thread_id){
                    ;
                    $threads[] = new BP_Messages_Thread(
                        $thread_id['message_id'],
                        'ASC',
                        array(
                            'user_id'             => $this->user->id,
                        )
                    );
                }
                ;
                
                $run = ['threads'=>$threads,'total'=>count($thread_ids)];
            }
            
        }
        if($run){
            $return = ['status'=>1,'data'=>$run];
        }else{
            $return = ['status'=>0,'message'=>__('Unable to find any dispute messages.')];
        }

        return new WP_REST_Response($return);

    }

    function cancellationRequestAction($request){
        $body = json_decode($request->get_body(),true);
       
        $return = ['status'=>0,'message'=>__('Unable to process','vibe-appointments')];

        $meta = new VIBE_APPOINTMENTS_META_DB;

        if(!empty($body['appointment'])){
            if(!empty($body['meta'])){
                foreach($body['meta'] as $m){
                    if($m['meta_key']== 'cancellation_request'){
                        $meta->delete_appointment_meta($m['meta_id']);
                    }
                }
            }

            if(!empty($body['appointment']['meta_key']) && $body['appointment']['meta_key'] == 'cancellation_request'){
                $meta->delete_appointment_meta($body['appointment']['meta_id']);
            }

            if($body['action'] == 'approve'){

                $action = __('Accepted','vibe-appointments');
                $activity_id = bp_activity_add( array( 
                    'user_id' => $body['booker_id'], 
                    'action' => __('Cancellation request approved','vibe-appointments'), 
                    'content' => sprintf(_x('Cancellation request for Appointment [%d]  %s','wallet','vibe-appointments'),$body['appointment']['appointment_id'],$action), 
                    'item_id'=>$body['appointment']['appointment_id'],
                    'component' => 'appointment', 
                    'type' => 'appointment_cancel', 
                )); 
                if($body['booker_id'] == $body['appointment']['booker_id']){
                    $db = new VIBE_APPOINTMENTS_DB;
                    $db->update_appointment(['appointment_id'=>$body['appointment']['appointment_id'],'booker_id'=>null]);
                }else{
                    $meta->delete_appointment_meta(['appointment_id'=>$body['appointment']['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$body['booker_id']])   ;    
                }

               $return = ['status'=>1,'message'=>__('Cancellation request removed','vibe-appointments')];
                
            }else{
                $return = ['status'=>1,'message'=>__('Cancellation request removed','vibe-appointments')];
            }
        }
        return $return;
    }
}


Vibe_Appointments_User_Api::init();
