<?php
/**
 * API WPLMS appointments
 *
 * @author      VibeThemes
 * @category    Init
 * @package     wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}


class Vibe_Appointments_Booking_Api{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Booking_Api();
        return self::$instance;
    }


    function __construct(){

        add_action('rest_api_init',array($this,'register_routes'));
    }
 

    function register_routes(){
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getOpenSlots', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'get_appointment_slots' ),
            'permission_callback'       => '__return_true'

        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/requestSlotBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'request_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/getOpenAppointmentPrice', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'getOpenAppointmentPrice' ),
            'permission_callback'       => '__return_true'
        ) );
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/addActiveSlot', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'addActiveSlot' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/courseSlotBooking', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'request_course_slot_booking' ),
            'permission_callback' => array( $this, 'get_user_permissions_check' ),
        ) );

         register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/member_details', array(
            'methods'                   =>   'POST',
            'callback'                  =>  array( $this, 'member_details' ),
            'permission_callback' => array( $this, 'get_appointment_permissions' ),
        ) );
    }


    function get_appointment_permissions($request){
        $client_id = $request->get_param('client_id');
        if($client_id == vibebp_get_setting('client_id')){
            return true;
        }
        return false;
    }

    function get_user_permissions_check($request){
        
        $body = json_decode($request->get_body(),true);
        
        if (empty($body['token'])){
            $client_id = $request->get_param('client_id');
            if($client_id == vibebp_get_setting('client_id')){
                return true;
            }
        }else{
            $token = $body['token'];
        }

        if(!empty($body['token'])){
            
            $this->user = apply_filters('vibebp_api_get_user_from_token','',$body['token']);
            if(!empty($this->user)){
                return true;
            }
        }

        return false;
    }

    function check_active_appointment($slot,$activeslots){
        if(!empty($activeslots)){
            foreach($activeslots as $k=>$aslot){
                if((!empty($aslot['id']) && $aslot['id']==$slot['appointment_id']) || (!empty($aslot['appointment_id']) && $aslot['appointment_id']==$slot['appointment_id'])){
                    return $k;
                }
            }
        }   
        return -1;
    }

    function get_pending_booking($request){
        $post = json_decode($request->get_body(),true);
        if(empty($post['filter'])){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','missing data','vibe-appointments')),200);
        }


    }

    function request_booking($request){

        $post = json_decode($request->get_body(),true);

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;
        
        if(empty($post['event'])){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','booking cancelled','vibe-appointments')),200);
        }
        $approve_all = false;
        if(!empty($post['event']['extendedProps'])){
            $approve_all = apply_filters('vibe_appointments_approve_all_booking_requests',false,$post['event']['extendedProps']);
        }
        
        if($approve_all){
            
            $args = array(
                'appointment_id'=>$post['event']['appointment_id'],
                'booker_id'=> $this->user->id,
                'status'    => 'booked',
                'type'      => 'member'
            );
            $db->update_appointment($args);


            do_action('vibe_appointments_booking_confirmed',$post['event']);
            return new WP_REST_Response( array(
                'status'=>1,
                'message'=>_x('Booking confirmed.','booking confirmed','vibe-appointments'),
                'rtm'=>array(
                    array('user_id'=>$post['event']['author_id'],'message'=>sprintf(_x('Booking confirmed for Appointment id %d by %s.','booking confirmed','vibe-appointments'),$post['event']['extendedProps']['appointment_id'],$this->user->displayname))
                    )
            ), 200 );     
        }else{
            


            $settings = vibe_appointments_get_settings();
            if(!empty($settings['booking_seats'])){

                $appointment = $db->get_appointments(['appointment_id'=>$post['event']['appointment_id']]);

                if(!empty($appointment[0]['booker_id'])){
                    $seats = $meta->get_appointments_meta(['appointment_id'=>$result['appointment_id'],'meta_key'=>'seats']);
                    if(!empty($seats) && $seats[0]['meta_value'] > 1){
                        vibe_appointments_update_pending_slots(
                            array(
                            'instructor_id'=>$post['event']['author_id'],
                            'booker_id'=>$this->user->id,
                            'slot_id'=>$post['event']['appointment_id'])
                        );
                        $meta->add_appointment_meta(array('appointment_id'=>$post['event']['appointment_id'],'meta_key'=>'request_booker_id','meta_value'=>$this->user->id));
                    }else{

                    }
                }else{
                    vibe_appointments_update_pending_slots(
                        array(
                        'instructor_id'=>$post['event']['author_id'],
                        'booker_id'=>$this->user->id,
                        'slot_id'=>$post['event']['appointment_id'])
                    );
                    $meta->add_appointment_meta(array('appointment_id'=>$post['event']['appointment_id'],'meta_key'=>'request_booker_id','meta_value'=>$this->user->id));
                }

            }else{

                vibe_appointments_update_pending_slots(
                    array(
                    'instructor_id'=>$post['event']['author_id'],
                    'booker_id'=>$this->user->id,
                    'slot_id'=>$post['event']['appointment_id'])
                );

                $meta->update_appointment_meta(array('appointment_id'=>$post['event']['appointment_id'],'meta_key'=>'request_booker_id','meta_value'=>$this->user->id));
            }

            do_action('vibe_appointments_booking_requested',$this->user->id,$post['event']);
            
        }
        

        
        return new WP_REST_Response( array(
                'status'=>1, 
                'message'=>_x('Booking request sent to Instructor.','booking requested','vibe-appointments')),200);
    }


    function getOpenAppointmentPrice($request){
        $post = json_decode($request->get_body(),true);
        global $wpdb;
        $return =array('status'=>0);
        $product_id =0;
        if(!empty($post['author_id'])){
            $product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=".$post['author_id']);
        }
        $return =array();
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){
                $product = wc_get_product( $product_id );
                $slot_price = $product->get_price_html();   
                $data = array(
                    'id'=>$product_id,
                    'priceHTML'=>$slot_price
                );
                $return =array('status'=>1,'price'=>$data);
            }
        }

        return new WP_REST_Response( $return,200);     
    }

    function addActiveSlot($request){
        $post = json_decode($request->get_body(),true);
        $buffer_time =apply_filters('vibe_appointments_pending_slots_buffer_time',1800);
        vibe_appointments_record_active_slot(array('appointment_id'=>$post['event']['appointment_id'],'expiry'=>time()+$buffer_time,'author_id'=>$post['event']['author_id'],'booker_id'=>$this->user->id));
         return new WP_REST_Response( array('status'=>1,'message'=>__('Active slot','vibe-appointments')),200);     
    }

    function request_course_slot_booking($request){

        $post = json_decode($request->get_body(),true);
        if(empty($post['event'])){
             return new WP_REST_Response( array('status'=>1,'message'=>_x('Data missing.','booking cancelled','vibe-appointments')),200);
        }

        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        $status='open';
        $settings = vibe_appointments_get_settings();
        if(!empty($settings['booking_seats'])){

            $appointment = $db->get_appointments(['appointment_id'=>$post['event']['appointment_id']]);

            $seats = $meta->get_appointments_meta(['appointment_id'=>$post['event']['appointment_id'],'meta_key'=>'seats']);

            if(!empty($seats) && $seats[0]['meta_value'] > 1){
                if(!empty($appointment[0]['booker_id'])){
                    $booker_ids = $meta->get_appointments_meta(['appointment_id'=>$post['event']['appointment_id'],'meta_key'=>'booker_id']);
                    if($seats[0]['meta_value'] > count($booker_ids)+1){
                        $status = 'open';
                    }else{
                        $status = 'booked';
                    }
                }
            }else{
                $status = 'booked';
            }

        }else{
            $status = 'booked';
        }
        $args = array(
            'appointment_id'=>$post['event']['appointment_id'],
            'booker_id'=> $this->user->id,
            'status'    => $status,
            'type'      => 'member'
        );

        //print_R($args);
        $db->update_appointment($args);
        $post['event']['booker_id'] = $this->user->id;
        $post['event']['status'] = 'booked';
        do_action('vibe_appointments_booking_confirmed',$post['event']);
        return new WP_REST_Response( array(
            'status'=>1, 
            'message'=>_x('Booking done for Instructor.','booking requested','vibe-appointments')
        ),200);
    }

    function member_details($request){

        $post = json_decode($request->get_body(),true);

        $user_data = [];
        if(!empty($post['members'])){
            foreach ($post['members'] as $key => $user_id) {
                $types = [];
            
                $mtypes = bp_get_member_type( $user_id, false );
                if(!empty($mtypes)){
                    foreach ($mtypes as $key => $mtype) {
                        $tt = bp_get_member_type_object($mtype);
                        $types[] = $tt->labels['name'] ;
                    }
                }
                $details = array(
                    'avatar'=> (function_exists('bp_core_fetch_avatar')?bp_core_fetch_avatar(array(
                                    'item_id' => $user_id,
                                    'object'  => 'user',
                                    'type'=>'full',
                                    'html'    => false
                                )):plugins_url( '../../assets/images/avatar.jpg',  __FILE__ )),
                    'display_name'=>bp_core_get_user_displayname($user_id),
                    'member_types'=> $types,
                    'id'=>$user_id,
                );
                $user_data[] = $details;
            }
            return new WP_REST_Response( array(
                'status'=>1, 
                'data'=>$user_data
            ),200);
        }


        return new WP_REST_Response( array(
            'status'=>0, 
            'message'=>_x('Unable to fetch details','booking requested','vibe-appointments')
        ),200);
    }

    function get_appointment_slots($request){
        $body = json_decode($request->get_body(),true);
        $db = new VIBE_APPOINTMENTS_DB;
        $meta = new VIBE_APPOINTMENTS_META_DB;

        if(empty($body['author_id'])){
            return new WP_REST_Response( array('status'=>1,'slots'=>[]), 200 );
        }
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        $args = array(
            'number'=>999,
            'start_date'=>$body['filter']['start'],
            'end_date'=>$body['filter']['end'],
            'author_id'=>$body['author_id'],
            'status'=>'open',
        );
        if(isset($body['filter']['item_id'])){
            $args['item_id'] = $body['filter']['item_id'];
        }
        $args = apply_filters('vibe_appointments_get_slots',$args,$request);
        
        if(!empty($body['filter']['start_time'])){
            $args['start_time']=$body['filter']['start_time'];
        }
        if(!empty($body['filter']['end_time'])){
            $args['end_time']=$body['filter']['end_time'];
        }
        $slots = $db->get_appointments($args);
        if(!empty($body['token'])){
            $user = apply_filters('vibebp_api_get_user_from_token','',$body['token']);
        }
        if(!empty($body['author_id'])){
            

            if(!empty($user)){
                $active_slots = vibe_appointments_get_active_slots();
                if(empty($active_slots)){
                    $active_slots = array();
                }
                $args['booker_id']=$user->id;
                $pslot_ids = vibe_appointments_get_pending_slots($args);

                $nslots = [];
                foreach($slots as $index=>$slot){
                    $aindex = $this->check_active_appointment($slot,$active_slots);
                    if($aindex>-1 && $active_slots[$aindex]['booker_id']==$user->id){
                        //means slot is active
                    }else{
                        if(!empty($pslot_ids) && in_array($slot['appointment_id'],array_keys($pslot_ids))){
                            $slots[$index]['title']=_x('Booking Requested','calendar slot note','vibe-appointments');
                        }
                        $nslots[] = $slots[$index];
                    }
                }
                $slots = $nslots;
            }else{

                $args['instructor_id']=$body['author_id'];
                $slot_ids = vibe_appointments_get_pending_slots($args);

                if(!empty($slot_ids)){
                    $nslots = [];
                    foreach($slots as $index=>$slot){
                        if(in_array($slot['appointment_id'],array_keys($slot_ids)) && empty($slot['title'])){
                            //unset($slots[$index]);
                        }else{
                            $nslots[] = $slots[$index];
                        }
                    }
                    $slots = $nslots;
                }
            }
            //
        }
        if(!empty($slots)){
            foreach ($slots as $key => $slot) {
                if(!empty($slot['item_id']) && get_post_status($slot['item_id'])=='publish'){
                    $color = null;
                    if(!empty($this->settings['service_colors']) && !empty($this->settings['service_colors'][$slot['item_id']])){
                        $color=$this->settings['service_colors'][$slot['item_id']];
                    }
                    if(empty($slots[$key]['meta'])){
                        $slots[$key]['meta']= [];
                    }
                    $slots[$key]['meta'] = array(
                        'type'=>$this->get_appointment_name_from_type($slot['type']),
                        'label'=>get_the_title($slot['item_id']),
                        'color'=>$color,
                    );

                }
                if(!empty($slot['type']) && strpos($slot['type'], 'recurring_')!==false){
                        //recurring appointment
                    $slots[$key]['days_of_week'] = explode('_',str_replace('recurring_', '', $slot['type'])); 
                }
                if(!empty($slot['author_id'])){
                    $slots[$key]['price'] = $this->get_user_pricing_array($slot['author_id']);
                }
            }
        }
        
        return new WP_REST_Response( array('status'=>1,'slots'=>$slots), 200 );
    }

    function get_user_pricing_array($user_id,$service_id=null){
        if(empty($this->pricing_array)){
            $this->pricing_array = [];
        }
        if(!empty($this->pricing_array[$user_id])){
            return apply_filters('vibeappointments_get_user_pricing_array',$this->pricing_array[$user_id],$user_id,$service_id);
        }
        $pricing_array = [];
        $data = get_user_meta($user_id,'vibe_appointments_pricing_array',true);
        if(!empty($data)){
            foreach($data as $k => $price){
                if(empty($price['service_id'])){
                    $pricing_array[''] = $price;
                }else{
                    if(!empty($price['service_id']) && get_post_status($price['service_id'])=='publish'){
                        $pricing_array[$price['service_id']] = $price;
                    }
                }
            }
        }
        
        $this->pricing_array[$user_id] = $pricing_array;


        return apply_filters('vibeappointments_get_user_pricing_array',$this->pricing_array[$user_id],$user_id,$service_id);
    }

    function all_types_names(){
        return apply_filters('vibe_appointments_type_names',array(
            'service'=>_x('Service','vibe_appointments_type_names','vibe-appointments'),
            'course'=>_x('Course','vibe_appointments_type_names','vibe-appointments'),
        ));
    }

    function get_appointment_name_from_type($type){
        if(!empty($this->all_types_names()[$type])){
            return $this->all_types_names()[$type];
        }else{
            return array();
        }
        
    }
}

Vibe_Appointments_Booking_Api::init();
