<?php
/**
 * API Classes appointments
 *
 * @author      VibeThemes
 * @category    Init
 * @package     wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}



class Vibe_Appointments_Classes_Api{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Classes_Api();
        return self::$instance;
    }


    function __construct(){

        add_action('rest_api_init',array($this,'register_routes'));
    }
 

    function register_routes(){
        
        register_rest_route( VIBE_APPOINTMENTS_API_NAMESPACE, '/classes', array(
            'methods'                   =>   'post',
            'callback'                  =>  array( $this, 'classes' ),
            'permission_callback'       => [$this,'check_permissions']

        ) );
    }

    function check_permissions($request){
        $client_id = sanitize_text_field($request->get_param('client_id'));
        if(function_exists('vibebp_get_setting') && $client_id == vibebp_get_setting('client_id')){
            return true;
        }
        return false;
    }

    function classes($request){

        $args = json_decode($request->get_body(),true);
        if(is_user_logged_in() && current_user_can('manage_options')){
            $args['show_hidden'] = true;
        }
        
        $args = apply_filters( 'vibe_bp_api_get_groups_args', $args, $request);
            
        $group_ids = [];
        if(!empty($args['dateRanges']) && !empty($args['dateRanges'][0])){

            global $wpdb;
            $db = new VIBE_APPOINTMENTS_DB;
            $meta_db = new VIBE_APPOINTMENTS_META_DB;

            $query = "
                SELECT M.meta_value 
                FROM {$db->table_name} as A INNER JOIN {$meta_db->table_name} as M ON A.appointment_id = M.appointment_id 
                WHERE A.status = 'open'";

            if(!empty($args['item_id'])){
               $query .=' AND m.meta_key = "group_id" AND m.meta_value ='.$args['item_id'].' ' ;
            }
            if(!empty($args['dateRanges']) && !empty($args['dateRanges'][0])){
                $query .=' AND (';
                foreach($args['dateRanges'] as $i=>$dateRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .='( start_date >= '.$dateRange['start_date'].' AND start_date <= '.$dateRange['end_date'].' OR end_date >= '.$dateRange['start_date'].' AND end_date <= '.$dateRange['end_date'].' OR '.$dateRange['start_date'].' >= start_date AND '.$dateRange['start_date'].' <= end_date OR '.$dateRange['end_date'].' >= start_date AND '.$dateRange['end_date'].' <= end_date) ';
                }
                $query .=' ) ';
            }

            if(!empty($args['weekRanges'])){
                $query .=' AND (';
                foreach($args['weekRanges'] as $i=>$dateRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .=' start_date >= '.$dateRange['start_date'].' AND end_date <= '.$dateRange['end_date'];
                }
                $query .=' ) ';
            }


            if(!empty($args['timeRanges'])){
                $query .=' AND (';
                foreach($args['timeRanges'] as $i=>$timeRange){
                    if($i){
                        $query .=' OR';
                    }
                    $query .=' start_time >= '.$timeRange['start_time'].' AND start_time <= '.$timeRange['end_time'];
                }
                $query .=' ) ';
            }

            $query .=' LIMIT 0,999';


            $results = $wpdb->get_results($query);

             if(!empty($results)){
                foreach($results as $result){
                    if(!in_array($result->meta_value, $group_ids)){
                        $group_ids[]=$result->meta_value;
                    }
                }   
            }else{
                 $data=array(
                    'status' => 1,
                    'total'=>0,
                    'message' => _x('No Classes found .','Classes Exist','vibe-appointments')
                );
                return new WP_REST_Response( $data, 200 );  
            }   
        }

        if(!empty($args['meta'])){
            $args['meta_query']=array(
                'relation'=>'AND'
            );
            foreach($args['meta'] as $meta){
                if(!empty($meta['values']) && is_Array($meta['values'])){

                    if($meta['type'] == 'number'){
                        if(is_array($meta['values'])){
                            if($meta['values'][1] > 0){
                                $args['meta_query'][]=array(
                                    'key'=>$meta['id'],
                                    'compare'=>'BETWEEN',
                                    'value'=>$meta['values'],
                                );  
                            }
                        }
                        
                    }else if($meta['type'] == 'date'){
                        
                        $meta['values'][0]=date('Y-m-d', $meta['values'][0]);
                        $meta['values'][1]=date('Y-m-d', $meta['values'][1]);

                        $args['meta_query'][]=array(
                            'key'=>$meta['id'],
                            'compare'=>'BETWEEN',
                            'value'=>$meta['values'],
                            'type' => 'DATE',
                        );
                    }else{
                        $args['meta_query'][]=array(
                            'key'=>$meta['id'],
                            'compare'=>'IN',
                            'value'=>$meta['values'],
                        );
                    }
                    
                }else{
                    $args['meta_query'][]=array(
                        'key'=>$meta['id'],
                        'compare'=>'=',
                        'value'=>$meta['value'],
                    );  
                }
                
            }
        }

        if(!empty($group_ids)){
            $args['include']=$group_ids;
        }

        $run = groups_get_groups($args); 
            
        if( count($run['groups']) ) {

            foreach($run['groups'] as $k=>$group){

                $init = VibeBP_Init::init();
                $init->group = $group;
                $init->group_id = $group->id;
                
                $run['groups'][$k]->avatar = esc_url(bp_core_fetch_avatar(array(
                        'item_id' => $run['groups'][$k]->id,
                        'object'  => 'group',
                        'type'=> 'full',
                        'html'    => false
                    )));
                
                
                if(!empty($args['class_card'])){
                    $card_query = new WP_Query(['post_type'=>'group-card','p'=>$args['class_card']]);    
                    ob_start();
                    if($card_query->have_posts()){
                        while($card_query->have_posts()){
                            $card_query->the_post();
                            global $post;
                           
                            the_content();
                        }
                        wp_reset_postdata();
                    }
                    $run['groups'][$k]->html = ob_get_clean();
                }
                

                $run['groups'][$k]->url = bp_get_group_permalink($group);
            }

                $data=array(
                    'status' => 1,
                    'data' => $run,
                    'message' => _x('Classes Exist','Classes Exist','vibe-appointments')
                );
        }else{
            $data=array(
                'status' => 1,
                'data' => $run,
                'message' => _x('Classes Not Exist','Classes Not Exist','vibe-appointments')
            );
        }


        $data = apply_filters( 'vibe_bp_api_get_groups', $data, $args, $request);
        return new WP_REST_Response( $data, 200 );  
    }
}

Vibe_Appointments_Classes_Api::init();
