<?php 
add_action( 'bp_loaded', 'bp_appointments_load_core_component' );
function bp_appointments_load_core_component() {
	class BP_Appointments_Component extends BP_Component {
		function __construct() {
			global $bp;
			parent::start(
				VIBE_APPOINTMENTS_SLUG,
				__( 'Appointments', 'vibe-appointments' ),
				VIBE_APPOINTMENTS_PLUGIN_DIR
			);
			$this->includes();

			
			$bp->active_components[$this->id] = '1';

			
			add_action( 'init', array( &$this, 'register_post_types' ) );
			
		}
		
		public function setup_globals($args=array()) {
			global $bp;

			// Defining the slug in this way makes it possible for site admins to override it
			if ( !defined( 'VIBE_APPOINTMENTS_SLUG' ) )
				define( 'VIBE_APPOINTMENTS_SLUG', $this->id );

			
			
			
			$globals = array(
				'slug'                  => VIBE_APPOINTMENTS_SLUG,
				'root_slug'             => isset( $bp->pages->{$this->id}->slug ) ? $bp->pages->{$this->id}->slug : VIBE_APPOINTMENTS_SLUG,
				'has_directory'         => false, // Set to false if not required
				'directory_title'       => _x( 'Appointments Directory', 'Course directory title', 'vibe-appointments' ),
				'notification_callback' => 'bp_appointments_format_notifications',
				'search_string'         => __( 'Search Appointments ...', 'vibe-appointments' ),
				//'global_tables'         => $global_tables
			);
			parent::setup_globals( $globals );

		}

		function includes($includes=[]) {
			$includes = array(
			);
			parent::includes( $includes );
		 }
	}
	global $bp;

	$bp->appointments = new BP_Appointments_Component;
	//print_r($bp);die();
}
