<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

 class Vibe_Appointments_Directory extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{

	public function __construct($data = [], $args = null) {
	    parent::__construct($data, $args);
	    foreach(get_vibe_appointments_directory_scripts() as $k => $script){
	    	$deps = array_merge($script['deps'],array('elementor-frontend'));
	    	
	    	wp_register_script($script['id'],$script['src'],$deps , VIBE_APPOINTMENTS_VERSION, true );
	    	
	    	
		}
		foreach(get_vibe_appointments_directory_styles() as $k => $style){
			 wp_register_style($style['id'],$style['src'],$style['deps'] , VIBE_APPOINTMENTS_VERSION );
		}
	    
	}

	public function get_script_depends() {
		$ss = [];
		foreach(get_vibe_appointments_directory_scripts() as $k => $script){
	    	$ss[] = $script['id'];
		}
	    return $ss;
	}

	public function get_style_depends() {
       $ss = [];
		foreach(get_vibe_appointments_directory_styles() as $k => $style){
	    	$ss[] = $style['id'];
		}
	    return $ss;
   }

    public function get_name() {
		return 'appointments_directory';
	}

	public function get_title() {
		return __( 'Appointments Directory', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-layout-tab-v';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'members_per_page',
			[
				'label' =>__('Total Number of Members in view', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range'=>[
					'min' => 1,
					'max' => 20,
					'step' => 1,
				],
				'default' => [
					'size'=>1,
				]
			]
		);

		$this->add_control(
			'per_row',
			[
				'label' =>__('Min-width of Member', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'=>[
					'px' => [
						'min' => 200,
						'max' => 760,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'size'=>240,
					'unit' => 'px',
				],
			]
		);
		$this->add_control(
			'order',
			[
				'label' => __( 'Default Sort by', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'active',
				'options' => array(
					'active' =>__('Active','vibe-appointments' ),
					'newest' =>__('Recently Added','vibe-appointments' ),
					'alphabetical' =>__('Alphabetical','vibe-appointments' ),
					'random'=>__('Random','vibe-appointments' ),
					'popular'=>__('Popular','vibe-appointments' ),
				)
			]
		);
		$member_type_objects = bp_get_member_types(array(),'objects');
		if(!empty($member_type_objects) && count($member_type_objects)){
			$member_types=array();
			foreach($member_type_objects as $member_type=>$mt){
				$member_types[$member_type]=$member_type_objects[ $member_type ]->labels['singular_name'];
			}
			$member_types = array_merge(array('all'=>__('All','vibe-appointments' )),$member_types);
			$this->add_control(
				'member_type',
				[
					'label' => __( 'Member Type', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $member_types
				]
			);
		}
		$this->add_control(
			'member_pagination',
			[
				'label' => __( 'Show Pagination', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'fa fa-x',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);

		$this->add_control(
				'show_member_popup',
				[
					'label' => __( 'Show Member in Popup', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'0' => [
							'title' => __( 'No', 'vibe-appointments' ),
							'icon' => 'fa fa-x',
						],
						'1' => [
							'title' => __( 'Yes', 'vibe-appointments' ),
							'icon' => 'fa fa-check',
						],
					],
				]
			);

		if(function_exists('vibebp_get_setting') && vibebp_get_setting('google_maps_api_key','general','misc')){

			$groups = array();
			$fields = array(''=>__('Select Field','vibebp'));
			$field_names = [''=>__('Select Field','vibebp')];

			if(function_exists('bp_xprofile_get_groups')){
				$groups = bp_xprofile_get_groups( array(
					'fetch_fields' => true
				) );
			}
			
			if(!empty($groups)){
				foreach($groups as $group){
					if(!empty($group->fields)){
						foreach ( $group->fields as $field ) {
							if($field->type == 'location'){
								$fields[$field->id]=$field->name;
								$field_names[$field->name]=$field->name;	
							}
						}
					}
				}
			}

			$this->add_control(
				'show_map',
				[
					'label' => __( 'Show Map & Filters', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::CHOOSE,
					'options' => [
						'0' => [
							'title' => __( 'No', 'vibe-appointments' ),
							'icon' => 'fa fa-x',
						],
						'1' => [
							'title' => __( 'Yes', 'vibe-appointments' ),
							'icon' => 'fa fa-check',
						],
					],
				]
			);	

			$this->add_control(
				'map_field',
				[
					'label' => __('Map Field', 'vibebp'),
					'type' => \Elementor\Controls_Manager::SELECT,
					'condition' => [
	            		'show_map' => '1',
	        		],
					'default' => '',
					'options' => $fields
				]
			);
		}
		

		global $wpdb,$bp;
		$results = $wpdb->get_results("SELECT field.id as id, field.name as name FROM {$bp->profile->table_name_fields} as field INNER JOIN {$bp->profile->table_name_meta} as meta ON field.id = meta.object_id
			WHERE meta.object_type = 'field' AND meta.meta_key = 'do_autolink' AND meta.meta_value = 'on'");
		
			$options = array(
				'availability'=>_x('Slot availability','vibe-appointments'),
				'price'=>_x('Slot Price','vibe-appointments')
			);
		if(!empty($results)){
			foreach($results as $result){
				$options[$result->id] = $result->name;
			}
		}
		$this->add_control(
			'member_directory_filters',
			[
				'label' => __( 'Select Filters', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'multiple'=>true,
				'options' => $options,
				'default'=>'availability'
			]
		);
		
		$this->add_control(
			'card_style',
			[
				'label' => __( 'Card Style', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'card',
				'options' => array(
					'' =>__('Default','vibe-appointments' ),
					'names' =>__('Name','vibe-appointments' ),
					'pop_names' =>__('Pop Names','vibe-appointments' ),
					'card' =>__('Card','vibe-appointments' ),
				)
			]
		);

		$this->add_control(
			'show_slot_calendar', [
				'label' => __( 'Show Slot Calendar', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'fa fa-x',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);

		$this->add_control(
			'search_appointments', [
				'label' => __( 'Show Search', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'fa fa-x',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);
		$this->add_control(
			'sort_appointments', [
				'label' => __( 'Show Sort options', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'fa fa-x',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);


		if(!empty($member_types) && count($member_types)){

			$this->add_control(
				'member_type_filter', [
					'label' => __( 'Show Member type Filter', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'multiple'=>true,
					'options' => $member_types,
					'default' => ''
				]
			);
		}
		if(empty($this->app_settings)){
        	$this->app_settings = vibe_appointments_get_settings();
        }
		if(!empty($this->app_settings['appointments_services'])){

			$terms = get_terms(VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG);
			$service_types = array();
			$services = array();
			if(!empty($terms)){
				foreach($terms as $term) {
				    wp_reset_query();
				    $service_types[$term->term_id] = $term->name;
				    $args = array('post_type' => VIBE_APPOINTMENTS_SERVICE_SLUG,
				        'tax_query' => array(
				            array(
				                'taxonomy' => VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
				                'field' => 'slug',
				                'terms' => $term->slug,
				            ),
				        ),
				     );

				     $loop = new WP_Query($args);
				     if($loop->have_posts()) {
				        while($loop->have_posts()) : $loop->the_post();
				        	$services[get_the_ID()] = $term->name.' > '.get_the_title();
				        endwhile;
				     }
				}
			}
			$services['all'] = _x('All','','vibe-appointments');
			$service_types['all'] = _x('All','','vibe-appointments');
			$this->add_control(
				'service_types',
				[
					'label' => __( 'Select Service types', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'multiple'=>true,
					'options' => $service_types,
					'default'=>array('all')
				]
			);
			$this->add_control(
				'services',
				[
					'label' => __( 'Select Service', 'vibe-appointments' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'multiple'=>true,
					'options' => $services,
					'default'=>array('all')
				]
			);
		}
		

	}



	protected function render() {

		$settings = $this->get_settings_for_display();
 		
 		foreach($settings as $key=>$val){
 			if(strpos($key,'_') === 0){
 				unset($settings[$key]);
 			}
 		}
 		$this->settings = $settings;



		$defaults = array(
            'members_per_page'=>5,
            'card_style'=>'card',
            'order'=>'newest',
            'show_map'=>false,
            'member_pagination'=>true,
            'search_appointments'=>true,
            'sort_appointments'=>true,
            'show_slot_calendar'=>true,
            'member_type_filter'=>['all'],
            'service_types'=>['all'],
            'member_directory_filters'=>['availability','price']
        );

		

        $settings = wp_parse_args($settings,$defaults);


        if(!empty($settings['member_directory_filters'])){
            global $wpdb,$bp;

            $member_directory_filters = array();
            if(!empty($settings['member_directory_filters']) && !is_array($settings['member_directory_filters'])){
                $settings['member_directory_filters'] = [$settings['member_directory_filters']];
            }

            $check=-1;
            if(!empty($settings['member_directory_filters']) && is_array($settings['member_directory_filters'])){
            	$check = array_search('availability', $settings['member_directory_filters']);
            }
            
            if($check > -1){
                $member_directory_filters[]='availability';
                unset($settings['member_directory_filters'][$check]);
            }
            $check=-1;
            if(!empty($settings['member_directory_filters']) && is_array($settings['member_directory_filters'])){
            	$check = array_search('price', $settings['member_directory_filters']);
        	}
            if($check > -1){
                $member_directory_filters[]='price';
                unset($settings['member_directory_filters'][$check]);
            }
            if(!empty($settings['member_directory_filters'])){
                $results = $wpdb->get_results("SELECT id,name,type FROM {$bp->profile->table_name_fields} WHERE id IN (".implode(',',$settings['member_directory_filters']).")");
                if(!empty($results)){
                    foreach($results as $field){
                        $member_directory_filters[]=array('field_id'=>$field->id,'name'=>$field->name,'type'=>$field->type);

                        if($field->type == 'datebox'){
                            wp_enqueue_script('flatpickr');
                        }
                    }
                }
                
            }
            $member_directory_filters[] = apply_filters('vibe_appointments_member_directory_filters_show_dateranges','dateranges',$settings);
            $settings['member_directory_filters']=$member_directory_filters;
        }

        $this->args = get_vibeappointments_directory_data($settings);
        
        $upload_dir   = wp_upload_dir();
        if($settings['card_style'] == 'card'){
        	if(!empty($this->args['card_id'])){
        		if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$this->args['card_id'].'.css')){
                    wp_enqueue_style('vibebp-member-card-'.$this->args['card_id'],$upload_dir['baseurl'].'/elementor/css/post-'.$this->args['card_id'].'.css',array());   
                }
        	}else{


	            global $wpdb;
	            $ids = $wpdb->get_results("SELECT ID FROM {$wpdb->posts} WHERE post_type='member-card' AND post_status='publish'");
	            if(!empty($ids)){
	                $upload_dir   = wp_upload_dir();
	                foreach($ids as $id){
	                    if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$id->ID.'.css')){
	                        wp_enqueue_style('vibebp-member-card-'.$id->ID,$upload_dir['baseurl'].'/elementor/css/post-'.$id->ID.'.css',array());   
	                    }
	                }
	            }
            }
        }
        
        
        
        
        //enqueue_vibe_appointments_directory_assets();
        
        if(in_array('price',$settings['member_directory_filters'])){
            $this->args['priceRange'] = $this->get_price_range();
        }
        //wp_localize_script('vibebp-appointments-directory-js','vibeappointments',$this->args);
        if(is_tax('service-type')){
        	$term = get_queried_object();
        	$this->args['settings']['service_types'] = [$term->term_id];
        }


        ?>
        <script>
        	var vibeappointmentsdirectory= <?php echo json_encode($this->args);?>;
        	setTimeout(()=>{document.dispatchEvent(new Event('vibeappointments_loaded'))
			},300);
        </script>
        <?php
        if(empty($settings['appointments_per_page'])){
            $settings['appointments_per_page'] = array();
            $settings['appointments_per_page']['size'] = 15;
        }
        if(empty($settings['horizontal_filters'])){
            $settings['horizontal_filters'] = '';
        }
        $args = array(
            'type'      =>$settings['order'],
            'per_page'  =>$settings['appointments_per_page']['size']
        );
        if(!empty($settings['member_type']) && $settings['member_type'] != 'all'){
            $args['member_type'] = $settings['member_type'];
        }

        $run = bp_core_get_users($args);
            
        if( count($run['users']) ) {

            foreach($run['users'] as $k=>$user){
                
                $run['users'][$k]->avatar = bp_core_fetch_avatar(array(
                        'item_id' => $run['users'][$k]->id,
                        'object'  => 'user',
                        'type'=> 'full',
                        'html'    => false
                    ));
                $run['users'][$k]->url = bp_core_get_user_domain($run['users'][$k]->id);
            }
        }
        ob_start();
        $html = '';
        ?>
        <div id="vibe_appointments_directory" <?php  echo $settings['show_map']?'class="with_map"':''?>>
            <div class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
            <div class="vibebp_appointments_directory_wrapper opacity_0 <?php  echo $settings['horizontal_filters']?'horizontal_filters':''?>">
            <?php
                if(!empty($settings['member_directory_filters'])){
                    
                    ?>
                    <div class="vibebp_member_directory_filters">
                        <?php
                            if($settings['search_appointments'] && empty($settings['member_directory_filters'])){
                            ?>
                            <div class="vibebp_appointments_search">
                                <input type="text" placeholder="<?php _e('Type to search','vibe-appointments' ); ?>" />
                            </div>
                            <?php
                        }
                        
                        foreach($settings['member_directory_filters'] as $field){
                            if(!empty($field['name'])){
                                echo '<div class="vibebp_member_directory_filter">
                                <span>'.$field['name'].'</span></div>';
                            }
                            
                        }
                        ?>
                    </div>
                    <?php
                }
            ?>
            <div class="vibebp_appointments_directory_main">
                <div class="vibebp_appointments_directory_header">
                <?php
                    if($settings['search_appointments'] && empty($settings['member_directory_filters'])){
                        ?>
                        <div class="vibebp_appointments_search">
                            <input type="text" placeholder="<?php _e('Type to search','vibe-appointments' ); ?>" />
                        </div>
                        <?php
                    }

                    if(!empty($settings['member_type_filter'])){
                        ?>
                        <div class="vibebp_appointments_filter">
                            <ul>
                            <?php
                    
                            $member_types = bp_get_member_types();
                            
                            if(empty($settings['member_type_filter']) || (is_array($settings['member_type_filter']) && in_array('all',$settings['member_type_filter'])) || $settings['member_type_filter'] === 'all'){
                                echo '<li><a class="member_type all">'.__('All','vibe-appointments' ).'</a></li>';
                                foreach($member_types as $type=>$label){
                                        echo '<li><a class="member_type '.$type.'">'.$label.'</a></li>';
                                    }
                            }else{ 

                                if(!empty($settings['member_type_filter']) && is_array($settings['member_type_filter'])){

                                    foreach($settings['member_type_filter'] as $type){
                                        echo '<li><a class="member_type '.$type.'">'.$member_types[$type].'</a></li>';
                                    }
                                }
                            }
                            ?>
                            </ul>
                        </div>
                        <?php
                    }

                    if($settings['sort_appointments']){

                        $default_sorters = array(
                            'active' =>__('Active','vibe-appointments' ),
                            'newest' =>__('Recently Added','vibe-appointments' ),
                            'alphabetical' =>__('Alphabetical','vibe-appointments' ),
                            'random'=>__('Random','vibe-appointments' ),
                            'popular'=>__('Popular','vibe-appointments' )
                        );
                        ?>
                        <div class="vibebp_appointments_sort">
                            <select>
                                <?php
                                foreach($default_sorters as $key => $val){
                                    echo '<option value="'.$key.'">'.$val.'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <?php
                    
                    }
                    if(empty($settings['style'])){
                        $settings['style'] = '';
                    }
                ?>
                </div>
                <div class="vibebp_appointments_directory <?php echo $settings['style'];?>" style="display:grid;grid-template-columns:repeat(auto-fit,minmax(<?php echo $settings['per_row']['size']; ?>px,1fr))">
                    <?php 
                    if( $run['total'] ){
                        foreach($run['users'] as $key=>$member){
                            if(!empty($member)){
                                echo '<div class="vibebp_member">';
                                echo '<a href="'.bp_core_get_user_domain($member->id).'"><img src="'.$member->avatar.'" /></a>';
                                if($settings['card_style'] == 'names' || $settings['card_style'] == 'pop_names'){
                                    echo '<span>'.$member->name.'</span>';
                                }
                                echo '</div>';
                            }
                            
                        }
                    }
                    ?>
                </div>
                <?php
                if( $run['total'] > count($run['users'])){
                    if($settings['member_pagination']){
                        ?>
                        <div class="vibebp_appointments_directory_pagination">
                            <span>1</span>
                            <a class="page_name">2</a>
                            <?php
                                $end = ceil($run['total']/count($run['users']));
                                if($end === 3){
                                    echo '<a class="page_name">'.$end.'</a>';
                                }else if($end > 3){
                                    echo '<span>...</span><a class="page_name">'.$end.'</a>';
                                }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
        </div>
        <?php
        $html .= ob_get_clean();
        add_filter('vibebp_inside_pwa_scripts',function($scripts){
            $scripts['vibebpappointments']= plugins_url('../../../assets/js/directory.js',__FILE__); 
        	$scripts['vibebpappointmentsfav']= plugins_url('../../../assets/js/favourite.js',__FILE__); 
        	return $scripts;
        });

        add_filter('vibebp_inside_pwa_styles',array($this,'pwa_styles'),10,2);
        add_filter('vibebp_inside_pwa_objects',array($this,'pwa_object'));
        foreach(get_vibe_appointments_directory_styles() as $k => $style){
			 wp_enqueue_style($style['id'],$style['src'],$style['deps'] , VIBE_APPOINTMENTS_VERSION );
		}
        wp_enqueue_style('iziToast');
		wp_enqueue_script('iziToast');
        echo $html;
		/*add_action('elementor/frontend/after_enqueue_scripts',function(){
 			enqueue_vibe_appointments_directory_assets();
	        $this->args = get_vibeappointments_directory_data($settings);
	        wp_localize_script('vibebp-appointments-directory-js','vibeappointments',$this->args);
 		});*/
	}

	function pwa_styles($styles,$post_id){
		$upload_dir   = wp_upload_dir();
		if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$post_id.'.css')){
			$styles['elementor_specific_css']=$upload_dir['baseurl'].'/elementor/css/post-'.$post_id.'.css?v='.WPLMS_PLUGIN_VERSION;	
		}
		if($this->settings['card_style'] == 'card'){
			global $wpdb;
			$ids = $wpdb->get_results("SELECT ID FROM {$wpdb->posts} WHERE post_type='member-card' AND post_status='publish'");
			
			if(!empty($ids)){
				$upload_dir   = wp_upload_dir();
				foreach($ids as $id){
					if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$id->ID.'.css')){
						$styles['vibebp-member-card-'.$id->ID]=$upload_dir['baseurl'].'/elementor/css/post-'.$id->ID.'.css?v='.WPLMS_PLUGIN_VERSION;	
					}
				}
			}
		}

		return $styles;
	}

	function pwa_object($objects){
		$objects['vibebpappointments']= $this->args; 
		return $objects;
	}


	function get_price_range(){
		global $wpdb;
		$results =[];
		$results = apply_filters('vibebpappointments_get_price_range',$results);
		if(empty($results)){
			$results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$wpdb->usermeta} WHERE meta_key='_appointment_price'");
		}
		
		if(!empty($results)){
			foreach($results as $result){
				if(empty($result->min)){$result->min =0;}
				if(empty($result->max)){$result->max =100;}
				if($result->min == $result->max){$result->min=0;}
				return array('min'=>$result->min,'max'=>$result->max);
			}
		}
	}

}