<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

 class Vibe_Appoinment_Slots extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_slots';
	}

	public function get_title() {
		return __( 'Bookable Slots', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-calendar';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'' =>__('Default','vibe-appointments'),
				)
			]
		);
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
        echo '<div id="member_bookable_slots"></div>';
   
        vibe_appointments_bookable_widget_scripts($user_id,'booking');
        

	}
}

class Vibe_Appoinment_Slots_Widget extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_slots_widget';
	}

	public function get_title() {
		return __( 'Bookable Slots Widget Style', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-calendar';
	}

	public function get_categories() {
		return [ 'vibe-appointments' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => '',
				'options' => array(
					'' =>__('Default','vibe-appointments'),
				)
			]
		);
	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
        echo do_shortcode('[appointments_member_book_widget users="'.$user_id.'"][/appointments_member_book_widget]');

	}
}

class Vibe_Appoinment_Slots_Course_Widget extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_slots_course_widget';
	}

	public function get_title() {
		return __( 'Course Bookable Slots Widget Style', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-calendar';
	}

	public function get_categories() {
		return [ 'vibe-appointments','vibe-appointments' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'show_only_to_course_students',
			[
				'label' => __( 'Show only to course students', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'vicon vicon-close',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);
	}

	protected function render() {

		$settings = $this->get_settings_for_display();
		

		$id = apply_filters('elementor_course_block_id','');
        if(empty($id))
            return;
		$course_authors=get_post_field('post_author',$id);
		$course_authors = apply_filters('vibe-appointments_course_instructors',$course_authors,$id);
		$users= '';
		if(!is_array($course_authors)){
			$users = $course_authors;
		}else{
			$users = implode(',',$course_authors);
		}
        echo do_shortcode('[course_appointments_member_book_widget users="'.$users.'" show_only_to_course_students="'.$settings['show_only_to_course_students'].'" service="'.$id.'"][/course_appointments_member_book_widget]');

	}
}

 class Vibe_Appoinment_Price extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_price';
	}

	public function get_title() {
		return __( 'Booking Price', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-money';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'font_size',
			[
				'label' => __( 'Font Size', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .slot_price' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Text Color', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .slot_price,{{WRAPPER}} .slot_price del,{{WRAPPER}} .slot_price span' => 'color: {{VALUE}}',
				],
			]
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		global $wpdb;
		$product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=".$user_id);
        
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){
                $product = wc_get_product( $product_id );
                $slot_price = $product->get_price_html(); 
            }
        }else{
        	$slot_price = _x('Request booking','vibe-appointments');
        }


        echo '<div class="slot_price">'.$slot_price.'</div>';


	}
}


 class Vibe_Appoinment_Rating_Count extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_rating_count';
	}

	public function get_title() {
		return __( 'Booking Rating Count', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-star';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'font_size',
			[
				'label' => __( 'Font Size', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .text' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Text Color', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .text' => 'color: {{VALUE}}',
				],
			]
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
		global $wpdb;
		$rating_count = 0;
		
		$rating_count = $wpdb->get_var($wpdb->prepare("
                        SELECT count(m.meta_value)
                        FROM {$wpdb->comments} as c
                        INNER JOIN {$wpdb->commentmeta} as m 
                        ON c.comment_ID = m.comment_id
                        WHERE c.comment_agent = 'appointments' 
                        AND c.comment_type = 'instructor_review' 
                        AND c.comment_approved = 1
                        AND c.comment_author = %d
                        AND m.meta_key = 'appointment_review_rating'
                        GROUP BY m.meta_value ",$user_id));
		
        echo '<div class="rating_count text">( '.(empty($rating_count)?__('N.A','vibe-appointments'):$rating_count).' )</div>';
	}
}


 class Vibe_Appoinment_Star_Rating extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_star_rating';
	}

	public function get_title() {
		return __( 'Booking Star Rating', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-star';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'font_size',
			[
				'label' => __( 'Font Size', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .instructor_star_rating_wrapper' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'show_count',
			[
				'label' => __( 'Show only count', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'vicon vicon-close',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);


	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
		
		
		global $wpdb;
		$average_rating = $wpdb->get_var($wpdb->prepare("
                        SELECT AVG(m.meta_value)
                        FROM {$wpdb->comments} as c
                        INNER JOIN {$wpdb->commentmeta} as m 
                        ON c.comment_ID = m.comment_id
                        WHERE c.comment_agent = 'appointments' 
                        AND c.comment_type = 'instructor_review' 
                        AND c.comment_approved = 1
                        AND c.comment_author = %d
                        AND m.meta_key = 'appointment_review_rating'
                        GROUP BY m.meta_value ",$user_id));

		if(empty($average_rating)){$average_rating=0;}
        
        if(empty($settings['show_count'])){
        	echo '<div class="instructor_star_rating_wrapper">
            <strong class="instructor_star_rating">
		    <small class="blank_stars"><small style="width:'.round(100*$average_rating/5,2).'%;" class="filled_stars"></small></small>
	      	</strong>';    
      	echo '</div>';
        }else{
        	echo '<div class="instructor_star_rating_wrapper">'.round($average_rating,2).'</div>';
        }
        
		                      

	}
}

class Vibe_Appoinment_Favourite extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_favourite';
	}

	public function get_title() {
		return __( 'Booking favourite', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-heart';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'font_size',
			[
				'label' => __( 'Font Size', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .vicon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __( 'Text Color', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .vicon' => 'color: {{VALUE}}',
				],
			]
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}
        echo '<span class="vibe_mark_favourite" data-user="'.$user_id.'"></span>';
        
	}

	
}


 class Vibe_Appoinment_Reviews extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'appointment_reviews';
	}

	public function get_title() {
		return __( 'Booking Reviews', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-comments';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label' => __( 'Review Heading', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::TEXT,
			]
		);

		$this->add_control(
			'font_size',
			[
				'label' => __( 'Heading Font Size', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				'selectors' => [
					'{{WRAPPER}} .instructor_reviews h3' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'show_breakup',
			[
				'label' => __( 'Show Rating Breakup', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'vicon vicon-close',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);

		$this->add_control(
			'rating_count',
			[
				'label' => __( 'Show Rating count', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'vicon vicon-close',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);

		$this->add_control(
			'number',
			[
				'label' => __( 'Number of reviews', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '5',
			]
		);

		$this->add_control(
			'hide_if_none',
			[
				'label' => __( 'Hide if no reviews', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-appointments' ),
						'icon' => 'vicon vicon-close',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-appointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);

		$this->add_control(
			'orderby',
			[
				'label' => __( 'Orderby', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'' => __('Recent rating first','vibe-appointments'),
					'highest_rated' => __('Highest rating first','vibe-appointments'),
				],
			]
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			global $members_template;
			if(!empty($members_template->member)){
				$user_id = $members_template->member->id;
			}
		}
		if(empty($user_id)){
			$init = VibeBP_Init::init();
			if(!empty($init->user_id)){
				$user_id = $init->user_id;
			}else{
				$user_id = get_current_user_id();
			}
		}

		?>
        <div class="instructor_reviews_wrapper">
	        <?php 
	        if($settings['title']){
	        ?>
	        <h3><span><?php echo do_shortcode($settings['title']); ?></span></h3>
	        <?php
	        }
	        ?>
	        <div class="instructor_reviews">
	        <?php
	            if($settings['show_breakup']){ 
	        ?>
	            <div class="review_breakup">
	              <?php
	              	

	              	global $wpdb;
	              	$ratings_breakup = $wpdb->get_results($wpdb->prepare("
	              		SELECT count(m.meta_value) as count,m.meta_value as rating
		              	FROM {$wpdb->comments} as c
		              	INNER JOIN {$wpdb->commentmeta} as m 
		              	ON c.comment_ID = m.comment_id
		              	WHERE c.comment_agent = 'appointments' 
	                    AND c.comment_type = 'instructor_review' 
	                    AND c.comment_approved = 1
	              		AND c.comment_author = %d
	              		AND m.meta_key = 'appointment_review_rating'
	              		GROUP BY m.meta_value ",$user_id),ARRAY_A);

	              
	              	
	              	$breakup=[];$rating_count = $rating_total =0;
	              	if(!empty($ratings_breakup)){
	              		foreach($ratings_breakup as $rb){
	              			$breakup[$rb['rating']]=$rb['count'];
	              			$rating_total+=$rb['rating']*$rb['count'];
	              			$rating_count+=$rb['count'];
	              		}
	              	}
	              	
	              ?>
	             
	                <div class="rating_snapshot">
	                  <h2><?php echo (!empty($breakup)?round($rating_total/$rating_count,2):__('N.A','vibe-appointments')); ?></h2>
	                  <?php
	                  	if($rating_total){
	                  		$width = round($rating_total/$rating_count,2)*100/5;
		                  echo '<div class="instructor_star_rating_wrapper">
		                        <strong class="instructor_star_rating">
							    <small class="blank_stars"><small style="width:'.$width.'%;" class="filled_stars"></small></small>
						      	</strong>';    
		                      echo '</div>';
		                      echo '<span>'.sprintf(__('%d ratings','rating count','vibe-appointments'),$rating_count).'</span>';
                      	}
	                  ?>
	                </div>
	                <ul class="rating_breakup">
	                <?php	                  
	                  for($i=5;$i>=1;$i--){
	                    echo '<li class="'.(empty($breakup[$i])?'':'active').'"><span>'.sprintf(_x('%d stars','star rating','vibe-appointments'),$i).'</span><strong>
	                    	'.(empty($breakup[$i])?'':'<span style="width:'.round(100*($i/5),2).'%"></span>').'</strong><span>( '.(empty($breakup[$i])?0:$breakup[$i]).' )</span></li>';
	                  }
	                ?>
	                </ul>
	              </div>
	        <?php
	        }
	        ?>    
	        </div>
	        <div class="show_instructor_reviews">
	        <?php

	        $paged = 1;
            if(!empty($_GET['paged']) && is_numeric($_GET['paged']) && $_GET_['paged'] <= ceil(count($comments)/$settings['number'])){
            	$paged = $_GET['paged'];
            }else{
            	$paged = get_query_var('paged');
            }
            if(empty($paged)){
            	$paged = 1;
            }
            global $wpdb;
            $comment_ids = $wpdb->get_results($wpdb->prepare("
          		SELECT comment_ID
              	FROM {$wpdb->comments} 
              	WHERE comment_agent = 'appointments' 
                AND comment_type = 'instructor_review' 
                AND comment_approved = 1
          		AND comment_author = %d
          		LIMIT 0,999",$user_id),ARRAY_A);

            if(!empty($comment_ids)){
		         $comments = get_comments( array(
		         	'comment__in' =>wp_list_pluck($comment_ids,'comment_ID'),
		         	'comment_agent'=>'appointments',
		         	'number'=>$settings['number'],
		         	'paged'=>$paged,
	                'type' => 'instructor_review'
	            ) );
	        }
	        if (empty($comments)) {
	            echo '<div id="message" class="message notice"><p>';_e('No Reviews found for instructor.','vibe-appointments');echo '</p></div>';
	        }else{
	            
	            
	        ?>

	            <ol class="reviewlist commentlist"> 
	            <?php 
	                  wp_list_comments(array(
	                     'type'        =>'instructor_review',
	                     'avatar_size' =>120,
	                     'per_page'=>$settings['number'],
	                     'page'=>$paged,
	                     'callback'    => 'vibe_appointments_instructor_reviews'
	                     ),$comments
	                   ); 
	                
	                echo '<div id="instructor_appointment_reviews" class="pagination">';
                  	if(count($comments) > $settings['number']){
                  		if($paged >1){
                  			if($_GET['paged'] == ceil(count($comments)/$settings['number']) ){
                  				echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                  				echo '<span>'.$paged.'</span>';	
                  			}else{
                  				echo '<a href="?paged='.($paged-1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-left"></i></a>';
                  				echo '<span>'.$paged.'</span>';	
                  				echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>';	
                  			}
                  			
                  		}else{
                  			echo '<span>1</span>';
                  			echo '<a href="?paged='.($paged+1).'#instructor_appointment_reviews" class="page"><i class="vicon vicon-angle-right"></i></a>';	
                  		}
                  		
                  	}
                  	if(empty($settings['number'])){$settings['number']=5;}
                  	if(empty($paged)){$paged=1;}
                  	if($settings['number'] >= count($comments)){
	                  	echo '<i>'.sprintf(__('Showing %s out of %s reviews','vibe-appointments'),(($settings['number']*($paged-1))+1).'-'.(
	                  		(count($comments)<$settings['number']*$paged)?
	                  			count($comments)
	              			:$settings['number']*$paged),count($comments)).'</i>';
                  	}
                  	echo '</div>';
	              ?>  
	            </ol> 
	        <?php
	          }
	        ?>
	        </div>
	    </div>
        <?php

	}
}


class Vibe_Appoinment_Group_slots extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{


    public function get_name() {
		return 'group_appointments';
	}

	public function get_title() {
		return __( 'Group Slots', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'vicon vicon-money';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'number',
			[
				'label' => __( 'Number of Slots to Display', 'vibe-appointments' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'placeholder' => '5',
			]
		);

	}

	protected function render() {

		$settings = $this->get_settings_for_display();

		

		
		global $wpdb;
		$product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=".$user_id);
        
        if(!empty($product_id)){
            $type = get_post_type($product_id);
            if($type == 'product'){
                $product = wc_get_product( $product_id );
                $slot_price = $product->get_price_html(); 
            }
        }else{
        	$slot_price = _x('Request booking','vibe-appointments');
        }


        echo '<div class="slot_price">'.$slot_price.'</div>';


	}
}
