<?php
/**
 * Initialise WPLMS appointments
 * 
 * @author 		VibeThemes
 * @category 	Init
 * @package 	wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class Vibe_Appointments_Init{

    public $user_id;
	public static $instance;
    public $settings;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Init();
        return self::$instance;
    }


    function __construct(){

        add_action( 'elementor/widgets/widgets_registered', [ $this, 'init_widgets' ] );

        add_action('template_redirect',array($this,'add_products_to_cart'),1);



        add_action('woocommerce_remove_cart_item',array($this,'remove_active_slot'),10,2);
        add_action('woocommerce_check_cart_items',array($this,'timer_expired'));
        
        add_action('woocommerce_add_order_item_meta',array($this,'add_appointment_meta_to_order_item_meta'),1,2);
        /* WooCommerce Order STatus */
        
        add_action('woocommerce_order_status_completed',array($this,'appointment_enable_access'),10,1);
        add_action('woocommerce_order_status_cancelled',array($this,'appointment_disable_access'),10,1);
        add_action('woocommerce_order_status_refunded',array($this,'appointment_disable_access'),10,1);

        
        add_action('template_redirect',array($this,'set_gmt_offset'),1);

        //fetch the custom meta values

        add_filter('vibebp_user_caps',array($this,'add_appointment_provider_caps'),999,2);
        add_filter( 'woocommerce_cart_item_quantity',array($this, 'change_quantity_input'), 10, 3);

        add_action( 'init', [$this,'register_admin_approval_order_status']);
        add_filter( 'wc_order_statuses', [$this,'add_admin_approval_to_order_statuses']);
        add_filter( 'bulk_actions-edit-shop_order', [$this,'custom_dropdown_bulk_actions_shop_order'], 50, 1 );


        add_action('wp_footer',[$this,'first_active'],99);
        

    }

    function first_active(){

        if(function_exists('wc_get_cart_url')){
           
            echo '<script>
                document.addEventListener("userLoaded",function(e){
                    let user = e.detail.userLoaded;
                    if(user){
                        let item = localStorage.getItem("bookSlot");
                        if(item){
                            item = JSON.parse(item);
                            if(location.href != item.member.url){
                                location.href = item.member.url;
                            }else{
                                if(item.expire > new Date().getTime()){
                                    setTimeout(()=>{
                                        document.dispatchEvent(new CustomEvent("bookSlotEvent",{detail:{...item,user}}));    
                                    },3000);
                                }
                                localStorage.removeItem("bookSlot");
                            }
                        }
                    }
                }, { once: true });
            </script>';
        }

    }

    function register_admin_approval_order_status() {
        register_post_status( 'wc-admin-approve', array(
        'label'                     => _x('Approve Refund','WC order status','vibe-appointments'),
        'public'                    => true,
        'show_in_admin_status_list' => true,
        'show_in_admin_all_list'    => true,
        'exclude_from_search'       => false,
        'label_count'               => _n_noop( __('Approve Refund (%s)','vibe-appointments'), __('Approve Refunds (%s)','vibe-appointments') )
        ) );
    }
    
    function add_admin_approval_to_order_statuses( $order_statuses ) {
        $new_order_statuses = array();
        foreach ( $order_statuses as $key => $status ) {
            $new_order_statuses[ $key ] = $status;
            if ( 'wc-on-hold' === $key ) {
                $new_order_statuses['wc-admin-approve'] = _x('Approve Refund','WC order status','vibe-appointments');
            }
        }
        return $new_order_statuses;
    }


    function custom_dropdown_bulk_actions_shop_order( $actions ) {
        $new_actions = array();

        // add new order status before processing
        foreach ($actions as $key => $action) {
            if ('mark_processing' === $key)
                $new_actions['wc-admin-approve'] = __( 'Change status to Approve Refund', 'vibe-appointments');

            $new_actions[$key] = $action;
        }
        return $new_actions;
    }

    function get_settings(){

        if(empty($this->settings)){
            $this->settings = get_option(VIBE_APPOINTMENTS_OPTION);
        }

        return $this->settings;
    }

    

    function add_appointment_provider_caps($allcaps,$user=null){
        $this->get_settings();
        if(!empty($this->settings) && !empty($this->settings['appointments_provider'])){
            $type = bp_get_member_type($user->data->ID);
            $type = bp_get_member_type($user->data->ID);
            if(empty($type)){
                $type='no_type_exists';
            }
            if((is_array($this->settings['appointments_provider']) && in_array($type,$this->settings['appointments_provider']) ) 
                || 
                (!is_Array($this->settings['appointments_provider']) && $type == $this->settings['appointments_provider'] ) && !in_array('edit_appointments',array_keys($allcaps))){                
                $allcaps['edit_appointments'] = 1;
            }
        }
        if(!in_array('edit_appointments',$allcaps) && user_can($user->data->ID,'edit_posts')){
            $allcaps['edit_appointments'] = 1;
        }
        return $allcaps;
    }

    function init_widgets() {

        global $post;

        if(!is_admin() || ($post && ($post->post_type == 'member-profile' || $post->post_type == 'member-card'))){
            require_once( __DIR__ . '/class.elementor.php' );
            
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Slots());
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Favourite());
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Slots_Widget());

            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Price());
            
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Reviews());

            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Star_Rating());

            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Rating_Count());
               
        }
        if(!is_admin() || ($post && $post->post_type == 'page')){
            require_once( __DIR__ . '/class_directory.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Apppointments_Class_Directory());
        }

        if(!is_admin() || ($post && $post->post_type == 'page')){
            require_once( __DIR__ . '/class.appointmentsDirectory.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appointments_Directory());
        }
        if(!is_admin() || ($post && ($post->post_type == 'course' || $post->post_type == 'course-layout'))){
  
            require_once( __DIR__ . '/class.elementor.php' );
            \Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Vibe_Appoinment_Slots_Course_Widget());
            
        }

    }

    function change_quantity_input( $product_quantity, $cart_item_key, $cart_item ) {
        
        // whatever logic you want to determine whether or not to alter the input
        if ( !empty($cart_item['appointment_id']) ) {
            return '<span>' . $cart_item['quantity'] .' '._x('Slots','','vibe-appointments'). '</span>';
        }

        return $product_quantity;
    }

    function add_products_to_cart(){
        if(function_exists('wc_get_cart_url')){
            if(is_page(wc_get_page_id('cart'))){
                if(!empty($_COOKIE['appointment_products'])){
                    $str = stripslashes(urldecode($_COOKIE['appointment_products']));
                    
                    $str = utf8_encode($str);
                    $products = json_decode($str,true);

                    if(!empty($products)){

                        $cart_items = WC()->cart->get_cart();
                        $cart_pids=[];
                        if(!empty($cart_items)){
                            forEach($cart_items as $item){
                                if(!empty($item['product_id'])){
                                    $cart_pids[]=$item['product_id'];
                                }
                            }    
                        }
                    
                        foreach($products as $product){                            
                            if(!empty($product['appointment_id']) && !empty($product['booker_id']) && !in_array($product['id'],$cart_pids)){

                                if(!empty($product['quantity'])){
                                    WC()->cart->add_to_cart($product['id'],intval($product['quantity']),'','',array(
                                        'appointment_id'=>$product['appointment_id'],
                                        'booker_id'=>$product['booker_id'],
                                        'author_id'=>$product['author_id'],
                                        'expiry'=>strtotime($product['expiry'])
                                    ));
                                }else{
                                    WC()->cart->add_to_cart($product['id'],1,'','',array(
                                        'appointment_id'=>$product['appointment_id'],
                                        'booker_id'=>$product['booker_id'],
                                        'author_id'=>$product['author_id'],
                                        'expiry'=>strtotime($product['expiry'])
                                    ));
                                }
                                
                                vibe_appointments_record_active_slot(array(
                                    'booker_id'=>$product['booker_id'],
                                    'author_id'=>$product['author_id'],
                                    'expiry'=>strtotime($product['expiry']),
                                    'appointment_id'=>$product['appointment_id']
                                ));
                            }  
                        }
                        //expire the cookie
                        setcookie("appointment_products", "", time()-3600,COOKIEPATH,$_SERVER['SERVER_NAME']);
                    }
                }
                
            }
        }
    }
    
    function add_appointment_meta_to_order_item_meta($item_id, $values){
        //Return if email is empty
        if(empty($values) || empty($values['appointment_id'])){
            return;
        }

        if(empty($values['booker_id'])){
            $values['booker_id']=get_current_user_id();
        }

        wc_add_order_item_meta($item_id,'_appointment_id',$values);
    }

    function remove_active_slot( $cart_item_key, $cart ) {
        if(!empty($cart->cart_contents[ $cart_item_key ])){
            if(!empty($cart->cart_contents[ $cart_item_key ]['appointment_id'])){
                vibe_appointments_remove_active_slot($cart->cart_contents[ $cart_item_key ]['appointment_id'],$cart->cart_contents[ $cart_item_key ]['booker_id']);
            }
            if(!empty($cart->cart_contents[ $cart_item_key ]['appointment_ids'])){
                $appointment_ids = $cart->cart_contents[ $cart_item_key ]['appointment_ids']; 
                if(!is_Array($appointment_ids)){
                    $appointment_ids=array($appointment_ids);
                }
                foreach($appointment_ids as $appointment_id){
                    vibe_appointments_remove_active_slot($appointment_id);
                }
            }
        }
        
    }

    function timer_expired(){
        
        if(!WC()->cart->is_empty()){
            $cartitems = WC()->cart->get_cart();
            foreach($cartitems as $cartItemKey=>$item){
                if(!empty($item['appointment_id'])){
                    if($item['expiry']+1800 < time()){
                        WC()->cart->remove_cart_item( $cartItemKey );   
                    }
                }
            }
            //remove from record
            vibe_appointments_get_active_slots();
        }
    }

    function appointment_enable_access($order_id){
        $order = new WC_Order( $order_id );
        $items = $order->get_items();        
        $user_id=$order->get_user_id();

       

        foreach($items as $item_id=>$item){
           
            $appointment_id = 0;
            $appointment =wc_get_order_item_meta($item_id,'_appointment_id',true);
            if(!empty($appointment['appointment_id'])){
                $appointment_id = $appointment;
            }
           
            if(!empty($appointment_id)){
                //update appointment set booker ID
                $appointments_db = new VIBE_APPOINTMENTS_DB;
                $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
                $appointments = $appointments_db->get_appointments(array('appointment_id'=>$appointment_id['appointment_id']));
                
               
                if(!empty($appointments)){
             
                    if($appointments[0]['status'] == 'open'){
                        

                        $payment = wc_get_order_item_meta($item_id,'_line_total',true);

                        if(method_exists($order,'get_currency')){
                            $currency = $order->get_currency();
                        }else{
                            $currency = get_woocommerce_currency();
                        }

                        $order_details=array(
                            'type'=>'woocommerce',
                            'order_id'=>$order_id,
                            'item_id'=>$item_id,
                            'payment'=>$payment,
                            'author_id'=>$appointment_id['author_id'],
                            'booker_id'=>$user_id,
                            'currency'=>$currency,
                        );

                        if(empty($appointments[0]['booker_id'])){

                            $status = 'booked';

                            $seats = $appointments_meta_db->get_appointments_meta(['appointment_id'=>$appointment_id['appointment_id'],'meta_key'=>'seats']);
                            
                            
                            if(!empty($seats) && $seats[0]['meta_value'] > 1){
                                
                                $booker_ids = $appointments_meta_db->get_appointments_meta(['appointment_id'=>$appointment_id['appointment_id'],'meta_key'=>'seats']);

                                if(empty($booker_ids) || (count($booker_ids) <= ($seats[0]['meta_value']-1) )){
                                    $status = 'open';
                                }
                            }

                            $appointments_db->update_appointment(array(
                                'appointment_id'=>$appointment_id['appointment_id'],
                                'booker_id'=>$appointment_id['booker_id'],
                                'status'=>apply_filters('vibe_appointments_woocommerce_order_status',$status,$appointment_id),
                            ));

                            $appointments[0]['booker_id']=$appointment_id['booker_id'];

                            $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'order_details','meta_value'=>$order_details));

                            $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'_wc_order_id_'.$user_id,'meta_value'=>$order_id));
                            
                            $quantity = wc_get_order_item_meta($item_id,'_qty',true);
                            if($quantity > 1 && strpos($appointments[0]['type'], 'recurring') === false){
                                $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'additional_slots','meta_value'=>array(
                                    'assigned'=>1,
                                    'total'=>($quantity-1)
                                )));
                            }
                        }else{

                            $appointments_meta_db->add_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$appointment_id['booker_id']));

                            $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'order_details_'.$appointment_id['booker_id'],'meta_value'=>$order_details));
                            
                            $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'_wc_order_id_'.$user_id,'meta_value'=>$order_id));
                            
                            $quantity = wc_get_order_item_meta($item_id,'_qty',true);
                            if($quantity > 1 && strpos($appointments[0]['type'], 'recurring') === false){
                                $appointments_meta_db->update_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'additional_slots_'.$appointment_id['booker_id'],'meta_value'=>array(
                                    'assigned'=>1,
                                    'total'=>($quantity-1)
                                )));
                            }
                        }
                        
                        vibe_appointments_remove_active_slot($appointments[0]['appointment_id']);
                        
                        
                  
                        do_action('vibe_appointments_booking_confirmed',$appointments[0],$order_details);
                    }

                    if($appointments[0]['status'] == 'group_booked'){
                       
                        if(apply_filters('vibe_appointments_group_booking_user_can_join',true,$appointments[0]['booker_id'],$appointment_id['booker_id'])){

                            $appointments_meta_db->add_appointment_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$appointment_id['booker_id']));

                            groups_join_group($appointments[0]['booker_id'], $appointment_id['booker_id']);
    
                        }
                        
                        vibe_appointments_remove_active_slot($appointments[0]['appointment_id']);
                    }

                }
            }
        }
        
    }

/*
    add_action('vibe_appointments_booking_confirmed',function($appointment,$order_details){

        $instructor_id = $appointment['author_id'];

        $commission_html = $order_details['payment'].woocommerce_get_order_currency();
        $commission = $order_details['payment'];
        $course_id = 0;

        $meta_db = new VIBE_APPOINTMENTS_META_DB();
        $metas = $meta_db->get_appointments_meta(array('appointment_id'=>$appointment['appointment_id'],'meta_key'=>'appointment_course'));
        if(!empty($metas)){
            $course_id = $metas[0]['meta_value'];
        }

        $activity_id = vibe_appointments_record_activity(apply_filters('bp_course_record_instructor_commission_activity',array(
                'user_id' => $instructor_id,
                'action' => _x('You earned commission','Instructor earned commission activity','wplms'),
                'content' => sprintf(_x('%s commission earned for booking ID %s','Instructor earned commission activity','wplms'),$commission_html,$appointment['appointment_id']),
                'component' => 'course',
                'type' => 'appointment_commission',
                'item_id' => empty($course_id)?$appointment['appointment_id']:$course_id,
                'secondary_item_id' => $appointment['appointment_id'],
                'hide_sitewide' => true,
            )));
            if(!empty($activity_id)){
              vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_commission'.$instructor_id,'meta_value'=>$commission));
              vibe_appointments_record_activity_meta(array('id'=>$activity_id,'meta_key'=>'_currency'.$instructor_id,'meta_value'=>$meta['currency']));
            }
    },10,2);

*/
    function appointment_disable_access($order_id){

        $order = new WC_Order( $order_id );
        $items = $order->get_items();
        $user_id=$order->get_user_id();

        foreach($items as $item_id=>$item){
            
            $appointment_id = wc_get_order_item_meta($item_id,'_appointment_id',true);
            
            if(!empty($appointment_id)){
                
                
                //update appointment set booker ID
                $appointments_db = new VIBE_APPOINTMENTS_DB;
                $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
                $appointments = $appointments_db->get_appointments(array('appointment_id'=>$appointment_id['appointment_id']));

                if(!empty($appointments)){


                    if($appointments[0]['booker_id'] == $user_id){

                        if($appointments[0]['status'] == 'booked'){
                            $appointments_db->update_appointment(array(
                                'appointment_id'=>$appointment_id['appointment_id'],
                                'booker_id'=>null,
                                'status'=>'open'
                            ));    
                        }
                    }else{
                        $appointments_meta_db->delete_appointment_meta(['appointment_id'=>$appointment_id['appointment_id'],'meta_key'=>'booker_id','meta_value'=>$user_id]);
                    }
                        

                    $appointments[0]['booker_id']=$appointment_id['booker_id'];

                    vibe_appointments_remove_active_slot($appointments[0]['appointment_id']);
                        
                    $payment = wc_get_order_item_meta($item_id,'_line_total',true);


                    $order_details = [];
                    $metas = $appointments_meta_db->get_appointments_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'order_details_'.$user_id));


                    if(!empty($metas) && !empty($metas[0]['meta_id'])){
                        $appointments_meta_db->delete_appointment_meta($metas[0]['meta_id']);
                        $order_details[$metas[0]['meta_key']]=$metas[0]['meta_value'];
                    }

                    
                    $quantity = wc_get_order_item_meta($item_id,'_qty',true);
                    

                    if($quantity > 1){
                        $metas = $appointments_meta_db->get_appointments_meta(array('appointment_id'=>$appointments[0]['appointment_id'],'meta_key'=>'additional_slots'));
                        if(!empty($metas)){
                            foreach ($metas as $key => $m) {
                                $appointments_meta_db->delete_appointment_meta($m['meta_id']);
                            }
                        }
                    }
                    //$order_details['order']= $order;
                    $order_details['item_id'] = $item_id;
                    do_action('vibe_appointments_booking_cancelled',$appointments[0],['booker_id'=>$user_id,'order_details'=>$order_details]);

                }
            }
        }
    }

    function set_gmt_offset(){
        add_action('wp_head',function(){
            if(!empty($_GET['gmt_offset']) && is_numeric($_GET['gmt_offset'])){
            echo '<script>window.gmt_offset='.$_GET['gmt_offset'].';</script>';
            }
        },1);
    }


    
}

Vibe_Appointments_Init::init();