<?php
/**
 * Scheduler WPLMS appointments
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	vibe-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*

NOTES

* WP Cron event nomenclature :

wplms_meeting_SCHEDULE_ID 

*/


class Vibe_Appointments_Scheduler{


	public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Scheduler();
        return self::$instance;
    }


    function __construct(){
        add_action('vibe_appointments_booking_confirmed',array($this,'set_reminders'));
        add_action('vibe_appointments_booking_rescheduled',array($this,'check_rescheduled_reminders'));
        add_action('vibe_appointments_booking_cancelled',array($this,'remove_reminders'));
        

        add_action('vibe_send_appointment_reminder',array($this,'vibe_send_appointment_reminder'),10,3);
        add_action('vibe_appointment_end_reminder',array($this,'vibe_appointment_end_reminder'),10,3);
        
    }

    function end_reminder($args){
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;
        
        $new_args = array(
            'appointment_id'=>$args['appointment_id'],
            'booker_id'=>$args['booker_id'],
            'author_id'=>$args['author_id'],
        );

    }

    function set_reminders($args){
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;
        
        $new_args = array(
            'appointment_id'=>$args['appointment_id'],
            'booker_id'=>$args['booker_id'],
            'author_id'=>$args['author_id'],
        );

        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments[0])){
            $appointment = $appointments[0];
        }
         
        if(!empty($appointment)){
            if(strpos($appointment['type'],'recurring_')!==false){
                $start_day = $appointment['start_date'];
                $end_time = $appointment['end_date'];
                $appointment = vibe_appointments_get_next_scheduled_slot($appointment['appointment_id']);

                $new_args = array(
                    'appointment_id'=>$args['appointment_id'],
                    'booker_id'=>$args['booker_id'],
                    'author_id'=>$args['author_id'],
                    'start_date'=>$appointment['start_date']
                );

                wp_clear_scheduled_hook('vibe_send_appointment_reminder',$new_args);
                wp_clear_scheduled_hook('vibe_appointment_end_reminder',$new_args);

                if(!wp_next_scheduled('vibe_send_appointment_reminder',$new_args))
                    wp_schedule_single_event(((intval($appointment['start_date'])/1000)-($this->options['reminder_minutes']*60)),'vibe_send_appointment_reminder',$new_args);

                    wp_schedule_single_event(((intval($appointment['end_date'])/1000)),'vibe_appointment_end_reminder',$new_args);

				while($start_day < $end_time){
                    //print_r($appointment['start_date'].' =---'.$start_day .'*****');
                    $appointment = vibe_appointments_get_next_scheduled_slot($appointment['appointment_id'],($appointment['start_date']/1000));
                    $new_args = array(
                        'appointment_id'=>$args['appointment_id'],
                        'booker_id'=>$args['booker_id'],
                        'author_id'=>$args['author_id'],
                        'start_date'=>$appointment['start_date']
                    );
                    wp_clear_scheduled_hook('vibe_send_appointment_reminder',$new_args);
                    if(!wp_next_scheduled('vibe_send_appointment_reminder',$new_args))
                        wp_schedule_single_event(((intval($appointment['start_date'])/1000)-($this->options['reminder_minutes']*60)),'vibe_send_appointment_reminder',$new_args);
                    $start_day += 86400000;


                        wp_schedule_single_event(((intval($appointment['end_date'])/1000)),'vibe_appointment_end_reminder',$new_args);
                }
                
            }else{
                if(empty($args['start_date']) && !empty($appointment) && !empty($appointment['start_date'])){
                    $args['start_date'] = $appointment['start_date'];
                }
    
                wp_clear_scheduled_hook('vibe_send_appointment_reminder',$new_args);
                if(!wp_next_scheduled('vibe_send_appointment_reminder',$new_args))
                    wp_schedule_single_event(((intval($args['start_date'])/1000)-($this->options['reminder_minutes']*60)),'vibe_send_appointment_reminder',$new_args);
            }
        
            

        }
    
        
    }

    function check_rescheduled_reminders($args){
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;
        //old : $post['appointment']
        //new : $post['slot']

        $old_args = array(
            'appointment_id'=>$args['appointment']['appointment_id'],
            'booker_id'=>$args['appointment']['booker_id'],
            'author_id'=>$args['appointment']['author_id'],
        );
        $this->remove_reminders($old_args);


        $new_args = array(
            'appointment_id'=>$args['slot']['appointment_id'],
            'booker_id'=>$args['appointment']['booker_id'],
            'author_id'=>$args['slot']['author_id'],
        );

        $this->set_reminders($new_args);

    }

    function remove_reminders($args){
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;
        $new_args = array(
            'appointment_id'=>$args['appointment_id'],
            'booker_id'=>$args['booker_id'],
            'author_id'=>$args['author_id'],
        );
        wp_clear_scheduled_hook('vibe_send_appointment_reminder',$new_args);
    }

    function vibe_send_appointment_reminder($appointment_id,$booker_id,$author_id){

        $_args = $args = array(
            'appointment_id'=>$appointment_id,'booker_id'=>$booker_id,'author_id'=>$author_id
        );
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(empty($appointments)){
            return;
        }
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;

        
        if(empty($this->time_format)){
            $this->time_format = get_option('date_format').' '.get_option('time_format');
        }
        $user = get_user_by( 'id', $args['author_id']);
        $to = $user->user_email;
        vibebp_wp_mail($to,'','',array('action'=>'instructor_appointment_start',
            'item_id'=>$args['appointment_id'],
        'tokens'=>array(
            'appointment.id'=>$args['appointment_id'],
            'appointment.time'=>date($this->time_format,(intval($appointments[0]['start_date'])/1000)).'['.wp_timezone_string().'] '.human_readable_duration(gmdate( 'H:i:s',intval($appointments[0]['start_date']/1000) - time())),
            'student.name'=>bp_core_get_userlink($args['booker_id']),
            'student.userlink'=>bp_core_get_userlink($args['booker_id']),
        )));
        if(empty($args['item_id']) || empty($args['start_date'])){
            

            if(empty($args['item_id']) && !empty($appointments) && !empty($appointments[0]['item_id'])){
                $args['item_id'] = $appointments[0]['item_id'];
            }else{
                $args['item_id'] = 0;
            }
        }

        $user = get_user_by( 'id', $args['booker_id']);
        $to = $user->user_email;
        vibebp_wp_mail($to,'','',array('action'=>'student_appointment_start','item_id'=>$args['appointment_id'],
        'tokens'=>array(
             'appointment.id'=>$args['appointment_id'],
            'appointment.time'=>date($this->time_format,(intval($appointments[0]['start_date'])/1000)).'['.wp_timezone_string().'] '.human_readable_duration(gmdate( 'H:i:s',intval($appointments[0]['start_date']/1000) - time())) ,
            'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
            'appointment.instructor_link'=>bp_core_get_userlink($args['author_id']),
            'appointment.item_link'=>(!empty($args['item_id'])?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':''),
        )));
        wp_clear_scheduled_hook('vibe_send_appointment_reminder',array_values($_args));
        wp_clear_scheduled_hook('vibe_send_appointment_reminder',$_args);
    }

    function vibe_appointment_end_reminder($appointment_id,$booker_id,$author_id){

        $_args = $args = array(
            'appointment_id'=>$appointment_id,'booker_id'=>$booker_id,'author_id'=>$author_id
        );
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(empty($appointments)){
            return;
        }
        if(empty($this->options)){
            $this->options = get_option(VIBE_APPOINTMENTS_OPTION);
        }
        
        if(empty($this->options['reminder_minutes']))
            return;

        
        if(empty($this->time_format)){
            $this->time_format = get_option('date_format').' '.get_option('time_format');
        }
        $user = get_user_by( 'id', $args['author_id']);
        $to = $user->user_email;
        vibebp_wp_mail($to,'','',array('action'=>'instructor_appointment_end',
            'item_id'=>$args['appointment_id'],
        'tokens'=>array(
            'appointment.id'=>$args['appointment_id'],
            'appointment.time'=>date($this->time_format,(intval($appointments[0]['start_date'])/1000)).'['.wp_timezone_string().'] '.human_readable_duration(gmdate( 'H:i:s',intval($appointments[0]['start_date']/1000) - time())),
            'instructor.name'=>bp_core_get_userlink($args['author_id']),
            'student.name'=>bp_core_get_userlink($args['booker_id']),
            'student.userlink'=>bp_core_get_userlink($args['booker_id']),
        )));
        if(empty($args['item_id']) || empty($args['start_date'])){
            

            if(empty($args['item_id']) && !empty($appointments) && !empty($appointments[0]['item_id'])){
                $args['item_id'] = $appointments[0]['item_id'];
            }else{
                $args['item_id'] = 0;
            }
        }

        $user = get_user_by( 'id', $args['booker_id']);
        $to = $user->user_email;
        vibebp_wp_mail($to,'','',array('action'=>'student_appointment_start','item_id'=>$args['appointment_id'],
        'tokens'=>array(
             'appointment.id'=>$args['appointment_id'],
            'appointment.time'=>date($this->time_format,(intval($appointments[0]['start_date'])/1000)).'['.wp_timezone_string().'] '.human_readable_duration(gmdate( 'H:i:s',intval($appointments[0]['start_date']/1000) - time())) ,
            'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
            'appointment.instructor_link'=>bp_core_get_userlink($args['author_id']),
            'appointment.item_link'=>(!empty($args['item_id'])?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':''),
        )));
        wp_clear_scheduled_hook('vibe_send_appointment_reminder',array_values($_args));
        wp_clear_scheduled_hook('vibe_send_appointment_reminder',$_args);
    }
    
}

Vibe_Appointments_Scheduler::init();
