<?php
/**
 * Shortcodes WPLMS appointments
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPLMS_Appointments_Shortcodes{


	public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new WPLMS_Appointments_Shortcodes();
        return self::$instance;
    }


    function __construct(){

        
       add_shortcode('appointments_directory',array($this,'appointments_directory'));
       add_shortcode('appointments_member_book_widget',array($this,'appointments_member_book_widget'));
       add_shortcode('course_appointments_member_book_widget',array($this,'course_appointments_member_book_widget'));

       add_shortcode('service_rating',array($this,'service_rating'));
       add_shortcode('service_instructor_count',array($this,'service_instructor_count'));
       add_shortcode('service_booking_count',array($this,'service_booking_count'));
       add_shortcode('vibe_appointments_hours_booked',array($this,'vibe_appointments_hours_booked'));

       add_shortcode('vibe_appointments_students_booked',array($this,'vibe_appointments_students_booked'));
       add_shortcode('instructor_student_count',array($this,'instructor_student_count'));
       add_shortcode('instructor_booking_count',array($this,'instructor_booking_count'));
       add_shortcode('instructor_services',array($this,'instructor_services'));

       add_shortcode('instructor_labels',array($this,'instructor_labels'));
       add_shortcode('instructor_price',array($this,'instructor_price'));

       add_shortcode('instructor_appointment_stats',array($this,'instructor_appointment_stats'));
       add_shortcode('group_slots',array($this,'group_slots'));
       add_shortcode('my_classes',array($this,'my_classes'));
       add_shortcode('instructor_classes',array($this,'instructor_classes'));
    }

    function group_slots($atts,$content=null){

        $group_id=0;
        if(!empty($atts['group_id'])){
            $group_id = intval($atts['group_id']);
        }

        
        if(class_exists('VibeBP_Init') && empty($group_id)){
            $init = VibeBP_Init::init();
            if(!empty($init->group)){
                $group_id = $init->group->id;
            }
        }

        $return = '';

        if(!empty($group_id)){
            global $wpdb;
            $db = new VIBE_APPOINTMENTS_DB;
            $meta_db = new VIBE_APPOINTMENTS_META_DB;
            $results = $wpdb->get_results($wpdb->prepare("
                    SELECT a.* 
                    FROM {$db->table_name} as a 
                    INNER JOIN {$meta_db->table_name} as m 
                    ON a.appointment_id = m.appointment_id 
                    WHERE m.meta_key = %s 
                    AND m.meta_value = %d 
                    AND a.end_date > %d 
                    AND a.status = 'open' 
                    LIMIT 0,9",'group_id',$group_id,time()*1000
                ),ARRAY_A);
            
            if(!empty($results)){

                foreach($results as $k=>$result){

                    $n_result = vibe_appointments_get_next_scheduled_slot($result);

                    $result['start_date']=$n_result['start_date'];
                    
                    
                    $results[$k]['start_date'] = $result['start_date'];
                    $avatar = bp_core_fetch_avatar(array(
                        'item_id'   =>  $result['author_id'],
                        'object'    => 'user',
                        'type'      =>'thumb',
                        'html'      => false
                    ));
                    $link = bp_core_get_user_domain( $result['author_id']);
                    $name = bp_core_get_user_displayname( $result['author_id']);
                    if(empty($avatar)){
                        $avatar = plugins_url('../assets/images/avatar.jpg',__FILE__);
                    }
                    $results[$k]['author']=[
                        'avatar'=>$avatar,
                        'url'=>$link,
                        'name'=>$name
                    ];

                    $settings = vibe_appointments_get_settings();

                    if(!empty($settings['class_price']) && function_Exists('groups_get_groupmeta')){
                        $product_id = groups_get_groupmeta($group_id,$settings['class_price'],true);
                        
                    }else{
                        $product_id = $wpdb->get_var($wpdb->prepare("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=%d",$result['author_id']));
                    }

                    if(!empty($settings['booking_seats'])){
                        $seats = $meta_db->get_appointments_meta(['appointment_id'=>$result['appointment_id'],'meta_key'=>'seats']);
                        
                        if(!empty($seats)){
                            $booked_count = 0;
                            if(!empty($result['booker_id'])){
                                $bookers = $meta_db->get_appointments_meta(['appointment_id'=>$result['appointment_id'],'meta_key'=>'booker_id']);
                                
                                $booked_count = 1+count($bookers);
                            }
                            $results[$k]['seats']= [ 'total'=>$seats[0]['meta_value'],'filled'=>$booked_count];
                            

                        }
                        
                    }

                    if(!empty($product_id)){
                        $product = wc_get_product( $product_id );
                        $results[$k]['bookingPrice'] = [
                            'productId'=>$product_id,
                            'html'=>$product->get_price_html(),
                            'value'=>$product->get_price()
                        ];
                    }
                }
                    
                
                wp_enqueue_script('moment');
                wp_enqueue_style('vibebp-swiper');
                wp_enqueue_script('vibebp-swiper');
        ob_start();
        ?>

        <div class="vibe_appointments_group_slots_wrapper">

            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
        </div>
        <script>
            var cart_url = '<?php echo wc_get_cart_url().'?'.rand(0,999999999); ?>';
            var slides = <?php echo json_encode($results); ?>;
            var slot_translations = <?php echo json_encode([
                'meet_once'=>__('Meets Once','vibe-appointments'),
                'book_now'=>esc_html__('Book Now','vibe-appointments'),
                'show_more'=> __('Show more slots','vibe-appointments'),
                'slots_remaining'=> __('Seats Remaining','vibe-appointments'),
                'seats_full'=> __('Seats Full','vibe-appointments')
                ])?>;
            var setCookie = function(name, value, expires, path, domain, secure){

                document.cookie = name + "=" + escape(value) +
                    ((expires) ? "; expires=" + expires : "") +
                    ((path) ? "; path=" + path : "") +
                    ((domain) ? "; domain=" + domain : window.location.hostname) +
                    ((secure) ? "; secure" : "");
            }

            var getCookie = function(name){
                var cookie = " " + document.cookie;
                var search = " " + name + "=";
                var setStr = null;
                var offset = 0;
                var end = 0;
                if (cookie.length > 0) {
                    offset = cookie.indexOf(search);
                    if (offset != -1) {
                        offset += search.length;
                        end = cookie.indexOf(";", offset)
                        if (end == -1) {
                            end = cookie.length;
                        }
                        setStr = unescape(cookie.substring(offset, end));
                    }
                }
                return (setStr);
            }

            var cartBook = function(index){
                
                localforage.getItem('bp_user').then(function(user){
                    if(!user){
                        document.dispatchEvent(new Event('vibebp_show_login_popup'));
                    }else{
                        let event = slides[index];
                        if(typeof event ==='undefined'){
                            return false;
                        }
                        let cartItems = 0;
                        

                        let appointment_products = getCookie('appointment_products');
                        if(appointment_products){
                            appointment_products=JSON.parse(appointment_products);
                        }else{
                            appointment_products=[];
                        }
                        
                        if(!appointment_products.length || appointment_products.findIndex(e=>e.appointment_id == event.appointment_id) ==-1){
                            
                            user= JSON.parse(user);

                            appointment_products.push({
                                id:event.bookingPrice.productId,
                                product_id:event.bookingPrice.productId,
                                appointment_id:event.appointment_id,
                                booker_id:user.id,
                                author_id:event.author_id,
                                title:event.author.display_name,
                                image:event.author.avatar,
                                quantity:event.quantity,
                                expiry:new Date(new Date().setMinutes(new Date().getMinutes() + 15)).toUTCString()
                            });

                            setCookie('appointment_products', 
                            JSON.stringify(appointment_products), 
                            new Date(new Date().setMinutes(new Date().getMinutes() + 15)).toUTCString(),
                            '<?php echo COOKIEPATH; ?>',window.location.hostname);

                            window.location.href= window.cart_url;
                            
                        }
                    }
                });
            }

            document.addEventListener('DOMContentLoaded',function(){
                

                let date_format='<?php echo convertPhpToJsMomentFormat(get_option('date_format')); ?>';
                let time_format='<?php echo convertPhpToJsMomentFormat(get_option('time_format')); ?>';
                let wrapper = document.createElement('div');
                wrapper.classList.add('swiper-wrapper');
                var domString = '';
                let dow = ['SU','MO','TU','WE','TH','FR','SA'];
                let sub_slots = [];

                slides.map(function(slot,index){
                    sub_slots = [];
                    if(slot['type'].match('recurring')){
                        
                        let wds = slot['type'].split('_');
                        let sd = moment(parseInt(slot.start_date));
                        let ed = moment(parseInt(slot.end_date));
                        let current = sd.clone();

                        wds.map((d,i)=>{
                            if(i > 0){
                               
                                let day = dow.indexOf(d);

                                while (current.clone().day(day).isBefore(ed)) {
                                    
                                    sub_slots.push(current.clone().day(day));
                                    day = day+7;
                                    

                                  //upcoming week slots
                                }
                            }
                        })
                        slides[index]['quantity'] = sub_slots.length;
                        sub_slots.sort((a, b) => a._d.valueOf() - b._d.valueOf());
                    }

                    
                    domString += '<div class="swiper-slide">';
                    
                    domString += '<h3>'+moment(parseInt(slot.start_date)).format('ddd')+' <span>'+moment(parseInt(slot.start_date)).date()+' '+moment(parseInt(slot.start_date)).format('MMM')+'</span>['+slot.appointment_id+']</h3>';

                    if(moment(parseInt(slot.start_date)).dayOfYear  == moment(parseInt(slot.end_date)).dayOfYear){
                       domString +=  '<h3 class="slot_info flex flex-col gap-3">'+moment(parseInt(slot.start_date)).format(date_format)+'\
                       <span class="flex text-2xl gap-4">\
                        <span>'+moment(parseInt(slot.start_date)).format(time_format)+'</span>\
                        <span>'+moment(parseInt(slot.end_date)).format(time_format)+'</span>\
                        </span></h3>';
                    }else{
                        domString +=  '<h3 class="slot_info">\
                        <span class="flex gap-4">\
                            <span class="flex-col flex gap-2">\
                                <span>'+moment(parseInt(slot.start_date)).format(date_format)+'</span>\
                                <span> '+moment(parseInt(slot.start_date)).format(time_format)+'</span>\
                            </span>\
                            <span class="flex-col flex gap-2">\
                                <span>'+moment(parseInt(slot.end_date)).format(date_format)+'</span>\
                                <span> '+moment(parseInt(slot.end_date)).format(time_format)+'</span>\
                            </span>\
                        </span></h3>';
                    }

                    if(slot.hasOwnProperty('seats') ){
                        domString += '<span class="seats"><span>'+(slot.seats.total-slot.seats.filled)+'</span><span>'+slot_translations.slots_remaining+'</span></span>';
                    }


                    if(sub_slots.length){
                        domString += '<div class="additional_slots">\
                                        <label for="slot_show_check_'+index+'">'+slot_translations.show_more+'['+sub_slots.length+']</label><input type="checkbox" id="slot_show_check_'+index+'" />\
                                        <div class="sub_slots">';
                                sub_slots.map(function(sl){
                                    domString +=  '<span class="slot_info">'+sl.format(date_format)+'\
                       <span class="flex gap-4">\
                        <span>'+sl.format(time_format)+'</span>\
                        <span>'+moment(parseInt(slot.end_date)).format(time_format)+'</span>\
                        </span></span>';
                                });
                        domString += '</div>\
                                        </div>';
                    }else{
                         domString += '<div class="additional_slots">'+slot_translations.meet_once+'</div>';
                    }


                    domString +='<a href="'+slot.author.url+'" class="slot_instructor"><img src="'+slot.author.avatar+'" /><span>'+slot.author.name+'</span></a>';

                    if(slot.hasOwnProperty('seats') && !(slot.seats.total-slot.seats.filled)){
                        domString += '<a class="seats_full">'+slot_translations.seats_full+'</a>';
                    }else{
                        domString += '<a onclick="cartBook('+index+')" class="button book_slot ">'+slot_translations.book_now+'</a>';    
                    }
                    
                    domString += '</div>';
                    
                });
                //domString += '</div>';


                wrapper.innerHTML =  domString;
                document.querySelector('.vibe_appointments_group_slots_wrapper').appendChild(wrapper);
                var swiper = new Swiper('.vibe_appointments_group_slots_wrapper', {              
                  nextButton: '.swiper-button-next',
                  prevButton: '.swiper-button-prev',
                  slidesPerView: 3,
                  spaceBetween: 30,
                });

                
                setTimeout(function(){
                    document.querySelectorAll('.book_slot').forEach(function(el){
                        el.addEventListener('click',function(){
                            let slot_id = el.getAttribute('data-id');
                            cartBook(slides[slides.findIndex(function(e){return e.appointment_id == slot_id})]);
                        });
                    });
                },3000);
               

            });
        </script>
        <style>
            .vibe_appointments_group_slots_wrapper .swiper-slide{
                border:  2px solid var(--border);
                border-radius: 0.5rem;max-width: 320px;
                padding: 1rem;display: flex;flex-direction: column;
                justify-content:space-between;
                gap: 1rem;
            }.additional_slots input{display:none;}.vibe_appointments_group_slots_wrapper .swiper-slide:hover{
                border-color: var(--bg-primary);
            }.vibe_appointments_group_slots_wrapper .swiper-slide .slot_instructor{
                display: flex; gap: 1rem;font-size: 1rem; align-items: center;
            }.vibe_appointments_group_slots_wrapper .swiper-slide .slot_instructor img{border-radius: 50%;border: 1px solid var(--border);max-width: 48px;}.additional_slots{padding:0.75rem;border: 1px solid var(--border);border-radius:5px;display: flex;flex-direction: column;gap: 0.5rem;}.additional_slots .sub_slots{display: none;}.vibe_appointments_group_slots_wrapper .additional_slots .sub_slots{flex-direction: column;gap: 0.75rem;}.vibe_appointments_group_slots_wrapper .additional_slots input:checked+.sub_slots{display: flex;}.slot_info {font-size: 0.8rem;background: var(--border);padding: 0.5rem;border-radius: 5px;}.slot_info span.flex.gap-4 {font-weight: 600;}.book_slot{text-align: center}.seats_full{border: 1px solid var(--warning);color: var(--warning);padding: 0.5rem;border-radius: 5px;text-align: center;cursor: not-allowed;}
        </style>
        <?php
        $return = ob_get_clean();


        }}

        return $return;
    }

    function service_rating($atts,$content=null){
        global $wpdb;

        if(empty($atts['service_id']))
            return '';

        $service_id = intval($atts['service_id']);
        $val = $wpdb->get_row($wpdb->prepare("
            SELECT AVG(b.meta_value) as avg, count(b.meta_value) as count
            FROM {$wpdb->commentmeta} as cm
            INNER JOIN {$wpdb->commentmeta} as b ON b.comment_id = cm.comment_id
            WHERE cm.meta_key ='booking_service_id'
            AND cm.meta_value = %d AND b.meta_key = %s
            ",$service_id,'appointment_review_rating'),ARRAY_A);
        if(empty($atts['count'])){
            return $val['avg'];
        }else{
            return $val['count'];
        }

        return '';
    }

    function service_booking_count($atts,$content){
        if(!empty($atts['service'])){
            return intval(get_post_meta(intval($atts['service']),'service_booking_count',true));
        }
    }

    function vibe_appointments_students_booked($atts,$content=null){
        $return = 0;
        
        return $return;
    }
    function instructor_services($atts,$content=null){
        if(!empty($atts['user_id'])){
            $user_id = $atts['user_id'];
        }else{
            if(class_exists('VibeBP_Init')){
                $init = VibeBP_Init::init();
                if(!empty($init->user_id)){
                    $user_id = $init->user_id;
                }
            }
        }

        if(empty($user_id)){
            if(bp_displayed_user_id()){
                $user_id = bp_displayed_user_id();
            }else if(is_user_logged_in()){
                $user_id = get_current_user_id();
            }
        }
        $saved_services = get_user_meta($user_id,'service',false);

        if(!empty($atts['count'])){
            return count($saved_services);
        }

        $enrolled_services=[];

        $html ='';
        
        if(!empty($saved_services)){
            
            if(empty($this->settings)){
                $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
            }
            if(!empty($atts['type']) && $atts['type'] == 'full'){
                foreach($saved_services as $service){
                    $saved_service_price = get_vibe_appointments_pricing_array($user_id,$service);
                    $this->service = $service;
                   $sar =[
                        'id'=>$service,
                        'title'=>get_the_title($service),
                        'image'=>get_the_post_thumbnail_url($service),
                        'price'=>[],
                    ];

                    
                    if(!empty($saved_service_price)){
                        $sar['price']=$saved_service_price;
                        if(!empty($saved_service_price['credits'])){
                            $sar['credits']=$saved_service_price['credits'];
                        }
                    }
                    
                    if(!empty($this->settings['service_colors'][$service])){
                        $sar['color']=$this->settings['service_colors'][$service];
                    }   
                    $enrolled_services[] = apply_filters('vibe_appointments_fetch_service',$sar);
                }

                if(!empty($enrolled_services)){
                    
                    
                    if(!empty($atts['style']) && $atts['style'] == 'carousel'){ 
                        $html .='<div class="service_blocks_swiper">';
                        $html .='<div class="swiper-wrapper">';
                    }else{
                        $html .='<div class="service_blocks">';
                    }
                    
                    foreach($enrolled_services as $service){
                        if(!empty($atts['style']) && $atts['style'] == 'carousel'){ 
                         $html .= '<div class="swiper-slide">';
                        }

                        $block_html = apply_filters('vibe_appointments_profile_service_block_html','',$atts,$service,$user_id,$sar);

                        if(empty($block_html)){
                            $block_html .='<div class="service_block">';
                            $block_html .='<img src="'.$service['image'].'" />';
                            $block_html .='<div class="service_instructor_info"><strong><a href="'.get_permalink($service['id']).'">'.$service['title'].'</a>
                            <span '.(!empty($service['color'])?'style="border-color:'.$service['color'].'"':'').'></span></strong>';

                            $block_html .= vibe_appointments_get_instructor_service_rating($service['id'],$user_id,'html');
                            
                            $block_html .='<div class="service_prices">';    
                            if(!empty($service['credits'])){
                                $block_html .= $sar['credits'].' '.__('Credits','vibe-appointments');
                            }
                            if(!empty($sar['price']) && !empty($sar['price']['priceHTML'])){
                                $block_html .= $sar['price']['priceHTML'];
                            }
                            if(empty($service['credits']) && empty($sar['price'])){
                                $block_html .='<span>'.__('Free Booking','vibe-appointments').'</span>';
                            }
                            $block_html .='</div></div></div>';   
                        }

                         $html .= $block_html;
                        if(!empty($atts['style']) && $atts['style'] == 'carousel'){ 
                            $html .='</div>';
                        } 
                    }
                    
                    if(!empty($atts['style']) && $atts['style'] == 'carousel'){ 
                        $html .='</div>';
                        $html .='<div class="swiper-button-prev"></div><div class="swiper-button-next"></div>';
                        
                        wp_enqueue_script('vibebp-swiper');
                        wp_enqueue_style('vibebp-swiper');
                    }
                    $html .='</div>';    
                    
                }
                ob_start();
                ?>
                <style>.service_blocks {
                    display: flex;
                    gap: 1rem;
                    flex-wrap: wrap;
                }
                .service_blocks > .service_block {
                    flex: 1 0 240px;
                    max-width: 320px;
                    display: flex;
                    flex-direction: column;
                    gap: 0.5rem;
                    border: 1px solid var(--border);
                    position:relative;
                }
                .service_instructor_info{
                    position: absolute;
                    bottom: 1rem;
                    left: 1rem;
                    z-index: 1;
                    padding: 1rem;
                    background:rgba(0,0,0,0.2);
                    color: #fff;
                    width: calc(100% - 2rem);
                    border-radius: 5px;
                }.service_instructor_info a{color: #fff;}
                .service_block img {
                    border-radius: 5px;
                    min-height: 132px;
                }.service_blocks_swiper{overflow: hidden;}</style>
                <?php if(!empty($atts['style']) && $atts['style'] == 'carousel'){ ?><script>
                    const initSwiper = function(){
                        new Swiper('.service_blocks_swiper', {
                          slidesPerView: 3,
                          spaceBetween: 10,
                          navigation: {
                            nextEl: '.swiper-button-next',
                            prevEl: '.swiper-button-prev',
                            disabledClass: 'disabled_swiper_button'
                          },
                          breakpoints: {
                            320: {
                              slidesPerView: 1,
                              spaceBetween: 20
                            },
                            480: {
                              slidesPerView: 2,
                              spaceBetween: 30
                            },
                            640: {
                              slidesPerView: 3,
                              spaceBetween: 30
                            }
                          }
                        })
                    }
                    document.addEventListener('DOMContentLoaded',function(){
                        setTimeout(initSwiper,800);
                    });
                </script>
                <?php
                }
                $html .= ob_get_clean();
            }else{
                $html .='<ul class="service_list">';
                foreach($saved_services as $service){
                    $html .='<li><span '.(!empty($this->settings['service_colors'][$service])?'style="border-color:'.$this->settings['service_colors'][$service].'"':'').'
                        >'.get_the_title($service).'</span></li>';
                }
                $html .='</ul>';
                if(function_exists('is_singular') && is_singular('member-card')){
                    $html.='<style>ul.service_list {display: flex;list-style: none;gap: 0.25rem;flex-wrap: wrap;}
                    ul.service_list li {list-style: none !important;border: 1px solid rgba(0,0,0,0.1);border-radius: 5px;overflow: hidden;}ul.service_list li > span {padding: 5px 8px;border-left: 3px solid;}</style>';
                }
            }
        }
        

        return $html;
    }

    function vibe_appointments_hours_booked($atts,$content=null){
        if(!empty($atts['instructor'])){
            return intval(get_user_meta(intval($atts['instructor']),'vibe_appointments_instructor_hours_booked',true));
        }
        if(!empty($atts['user'])){
            return intval(get_user_meta(intval($atts['user']),'vibe_appointments_user_hours_booked',true));
        }

        if(class_exists('VibeBP_Init')){

            $init = VibeBP_Init::init();
            if(!empty($init->user_id)){

                return intval(get_user_meta($init->user_id,'vibe_appointments_user_hours_booked',true));
            }
        }

        global $wpdb;
        $total = $wpdb->get_var("SELECT sum(meta_value) FROM {$wpdb->usermeta} WHERE meta_key = 'vibe_appointments_instructor_hours_booked'");

        return round($total,0);
    }

    function instructor_student_count($atts,$content=null){
        if(!empty($atts['instructor'])){
            $user_id = $atts['instructor'];
        }
        if(!empty($atts['user'])){
            $user_id = $atts['user'];
        }

        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }
        $total =0;
        if(!empty($user_id)){
            global $wpdb;
            $table = $wpdb->prefix . 'wplms_appointments';
            $total = $wpdb->get_var($wpdb->prepare("
                SELECT count(*) 
                FROM {$table} 
                WHERE status = 'booked' 
                AND author_id= %d 
                GROUP BY booker_id",$user_id
            ));    
        }

        return round($total,0);
    }

    function instructor_booking_count($atts,$content=null){
        if(!empty($atts['instructor'])){
            $user_id = $atts['instructor'];
        }
        if(!empty($atts['user'])){
            $user_id = $atts['user'];
        }

        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }
        $total =0;
        if(!empty($user_id)){
            global $wpdb;
            $table = $wpdb->prefix . 'wplms_appointments';
            $total = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM {$table} WHERE status = 'booked' AND author_id= %d",$user_id));    
        
        }

        return round($total,0);
    }


    function service_instructor_count($atts,$content){
        if(!empty($atts['service'])){
            $sid = intval($atts['service']);

            global $wpdb;
            $count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(meta_value) from {$wpdb->usermeta}  WHERE meta_key = '_appointments_service_id' AND m1.meta_value=%d",$sid));
            if(empty($count)){
                $count = 0;
            }
            return $count;
        }
    }

    function appointments_member_book_widget($atts,$content){
        if(!defined('VIBEBP_PLUGIN_URL'))
            return;
        $users = '';
        if(!empty($atts['users'])){
            $users = $atts['users'];
        }
        $service = '';
        if(!empty($atts['service'])){
            $service = $atts['service'];
        }
        
        $html = '<div id="member_bookable_slots_widget" users="'.$users.'" service="'.$service.'">'.apply_filters('appointments_member_book_widget_content',do_shortcode($content),$atts).'</div>';

       
        vibe_appointments_bookable_widget_scripts($users,'book_widget_shortcode');

        return $html;
    }

    function course_appointments_member_book_widget($atts,$content){
        if(!defined('VIBEBP_PLUGIN_URL'))
            return;
        $users = '';
        if(!empty($atts['users'])){
            $users = $atts['users'];
        }
        $service = '';
        if(!empty($atts['service'])){
            $service = $atts['service'];
        }
        
        $html = '<div id="course_member_bookable_slots_widget" users="'.$users.'" service="'.$service.'" show_only_to_course_students="'.(!empty($atts['show_only_to_course_students'])?1:0).'">'.apply_filters('course_member_bookable_slots_widget_content',do_shortcode($content),$atts).'</div>';

        
        $vibeappointments=get_vibeappointments_script_data();
        wp_enqueue_script('vibebp-flatpickr');
        wp_enqueue_script('moment');
        wp_enqueue_script('vibe-appointments-course-booking-widget',plugins_url('../assets/js/coursebookingwidget.js',__FILE__),array('wp-element','wp-data','vibebplogin','vibebp-flatpickr','moment'),VIBE_APPOINTMENTS_VERSION,true);
        
        vibe_appointments_bookable_widget_scripts($users,'course_book_widget_shortcode');


        return $html;
    }

    

    function appointments_directory($atts,$content){
        
        $settings = maybe_unserialize($atts['settings']);
        
        $defaults = array(
            'members_per_page'=>5,
            'card_style'=>'card',
            'order'=>'newest',
            'show_map'=>false,
            'member_pagination'=>true,
            'search_appointments'=>true,
            'sort_appointments'=>true,
            'show_slot_calendar'=>true,
            'member_type_filter'=>['all'],
            'service_types'=>['all'],
            'member_directory_filters'=>['availability','price']

        );
        $settings = wp_parse_args($settings,$defaults);

        if(!empty($settings['member_directory_filters'])){
            global $wpdb,$bp;

            $member_directory_filters = array();
            $check = array_search('availability', $settings['member_directory_filters']);
            if($check > -1){
                $member_directory_filters[]='availability';
                unset($settings['member_directory_filters'][$check]);
            }

            $check = array_search('price', $settings['member_directory_filters']);
            if($check > -1){
                $member_directory_filters[]='price';
                unset($settings['member_directory_filters'][$check]);
            }
            if(!empty($settings['member_directory_filters'])){
                $results = $wpdb->get_results("SELECT id,name,type FROM {$bp->profile->table_name_fields} WHERE id IN (".implode(',',$settings['member_directory_filters']).")");
                if(!empty($results)){
                    foreach($results as $field){
                        $member_directory_filters[]=array('field_id'=>$field->id,'name'=>$field->name,'type'=>$field->type);

                        if($field->type == 'datebox'){
                            wp_enqueue_script('vibebp-flatpickr');
                        }
                    }
                }
                
            }
            $member_directory_filters[] = apply_filters('vibe_appointments_member_directory_filters_show_dateranges','dateranges',$settings);
            $settings['member_directory_filters']=$member_directory_filters;
        }

        


        if($settings['card_style'] == 'card'){
            global $wpdb;
            $ids = $wpdb->get_results("SELECT ID FROM {$wpdb->posts} WHERE post_type='member-card' AND post_status='publish'");
            
            if(!empty($ids)){
                $upload_dir   = wp_upload_dir();
                foreach($ids as $id){
                    if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$id->ID.'.css')){
                        wp_enqueue_style('vibebp-member-card-'.$id->ID,$upload_dir['baseurl'].'/elementor/css/post-'.$id->ID.'.css',array());   
                    }
                }
            }
        }

        
        
        
        if(in_array('price',$settings['member_directory_filters'])){
            $this->args['priceRange'] = $this->get_price_range();
        }
        enqueue_vibe_appointments_directory_assets();
        $this->args = get_vibeappointments_directory_data($settings);
        wp_localize_script('vibebp-appointments-directory-js','vibeappointmentsdirectory',$this->args);

        if(empty($settings['appointments_per_page'])){
            $settings['appointments_per_page'] = array();
            $settings['appointments_per_page']['size'] = 15;
        }
        if(empty($settings['horizontal_filters'])){
            $settings['horizontal_filters'] = '';
        }
        $args = array(
            'type'      =>$settings['order'],
            'per_page'  =>$settings['appointments_per_page']['size']
        );
        if(!empty($settings['member_type']) && $settings['member_type'] != 'all'){
            $args['member_type'] = $settings['member_type'];
        }

        $run = bp_core_get_users($args);
            
        if( count($run['users']) ) {

            foreach($run['users'] as $k=>$user){
                
                $run['users'][$k]->avatar = bp_core_fetch_avatar(array(
                        'item_id' => $run['users'][$k]->id,
                        'object'  => 'user',
                        'type'=> 'full',
                        'html'    => false
                    ));
                $run['users'][$k]->url = bp_core_get_user_domain($run['users'][$k]->id);
            }
        }
        ob_start();
        $html = '';
        ?>
        <div id="vibe_appointments_directory" <?php  echo $settings['show_map']?'class="with_map"':''?>>
            <div class="lds-ellipsis"><div></div><div></div><div></div><div></div></div>
            <div class="vibebp_appointments_directory_wrapper opacity_0 <?php  echo $settings['horizontal_filters']?'horizontal_filters':''?>">
            <?php
                if(!empty($settings['member_directory_filters'])){
                    
                    ?>
                    <div class="vibebp_member_directory_filters">
                        <?php
                            if($settings['search_appointments'] && empty($settings['member_directory_filters'])){
                            ?>
                            <div class="vibebp_appointments_search">
                                <input type="text" placeholder="<?php _e('Type to search','vibe-appointments' ); ?>" />
                            </div>
                            <?php
                        }
                        
                        foreach($settings['member_directory_filters'] as $field){
                            if(!empty($field['name'])){
                                echo '<div class="vibebp_member_directory_filter">
                                <span>'.$field['name'].'</span></div>';
                            }
                            
                        }
                        ?>
                    </div>
                    <?php
                }
            ?>
            <div class="vibebp_appointments_directory_main">
                <div class="vibebp_appointments_directory_header">
                <?php
                    if($settings['search_appointments'] && empty($settings['member_directory_filters'])){
                        ?>
                        <div class="vibebp_appointments_search">
                            <input type="text" placeholder="<?php _e('Type to search','vibe-appointments' ); ?>" />
                        </div>
                        <?php
                    }

                    if(!empty($settings['member_type_filter'])){
                        ?>
                        <div class="vibebp_appointments_filter">
                            <ul>
                            <?php
                    
                            $member_types = bp_get_member_types();
                            
                            if(empty($settings['member_type_filter']) || (is_array($settings['member_type_filter']) && in_array('all',$settings['member_type_filter'])) || $settings['member_type_filter'] === 'all'){
                                echo '<li><a class="member_type all">'.__('All','vibe-appointments' ).'</a></li>';
                                foreach($member_types as $type=>$label){
                                        echo '<li><a class="member_type '.$type.'">'.$label.'</a></li>';
                                    }
                            }else{ 

                                if(!empty($settings['member_type_filter']) && is_array($settings['member_type_filter'])){

                                    foreach($settings['member_type_filter'] as $type){
                                        echo '<li><a class="member_type '.$type.'">'.$member_types[$type].'</a></li>';
                                    }
                                }
                            }
                            ?>
                            </ul>
                        </div>
                        <?php
                    }

                    if($settings['sort_appointments']){

                        $default_sorters = array(
                            'active' =>__('Active','vibe-appointments' ),
                            'newest' =>__('Recently Added','vibe-appointments' ),
                            'alphabetical' =>__('Alphabetical','vibe-appointments' ),
                            'random'=>__('Random','vibe-appointments' ),
                            'popular'=>__('Popular','vibe-appointments' )
                        );
                        ?>
                        <div class="vibebp_appointments_sort">
                            <select>
                                <?php
                                foreach($default_sorters as $key => $val){
                                    echo '<option value="'.$key.'">'.$val.'</option>';
                                }
                                ?>
                            </select>
                        </div>
                        <?php
                    
                    }
                    if(empty($settings['style'])){
                        $settings['style'] = '';
                    }
                ?>
                </div>
                <div class="vibebp_appointments_directory <?php echo $settings['style'];?>" style="display:grid;grid-template-columns:repeat(auto-fit,minmax(<?php echo $settings['per_row']['size']; ?>px,1fr))">
                    <?php 
                    if( $run['total'] ){
                        foreach($run['users'] as $key=>$member){
                            if(!empty($member)){
                                echo '<div class="vibebp_member">';
                                echo '<a href="'.bp_core_get_user_domain($member->id).'"><img src="'.$member->avatar.'" /></a>';
                                if($settings['card_style'] == 'names' || $settings['card_style'] == 'pop_names'){
                                    echo '<span>'.$member->name.'</span>';
                                }
                                echo '</div>';
                            }
                            
                        }
                    }
                    ?>
                </div>
                <?php
                if( $run['total'] > count($run['users'])){
                    if($settings['member_pagination']){
                        ?>
                        <div class="vibebp_appointments_directory_pagination">
                            <span>1</span>
                            <a class="page_name">2</a>
                            <?php
                                $end = 0;
                                if(!empty(count($run['users']))){
                                    $end = ceil($run['total']/count($run['users']));
                                }
                                
                                if($end === 3){
                                    echo '<a class="page_name">'.$end.'</a>';
                                }else if($end > 3){
                                    echo '<span>...</span><a class="page_name">'.$end.'</a>';
                                }
                            ?>
                        </div>
                        <?php
                    }
                }
                ?>
            </div>
        </div>
        </div>
        <?php
        $html .= ob_get_clean();
        add_filter('vibebp_inside_pwa_scripts',function($scripts){
            $scripts['vibebpappointments']= plugins_url('../../../assets/js/directory.js',__FILE__);
            $scripts['vibebpappointmentsfav']= plugins_url('../../../assets/js/favourite.js',__FILE__); 
            return $scripts;
        });

        add_filter('vibebp_inside_pwa_styles',array($this,'pwa_styles'),10,2);
        add_filter('vibebp_inside_pwa_objects',array($this,'pwa_object'));
        wp_enqueue_style('iziToast');
        wp_enqueue_script('iziToast');
        return $html;

    }

    function pwa_styles($styles,$post_id){
        $upload_dir   = wp_upload_dir();
        if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$post_id.'.css')){
            $styles['elementor_specific_css']=$upload_dir['baseurl'].'/elementor/css/post-'.$post_id.'.css?v='.WPLMS_PLUGIN_VERSION;    
        }
        if($this->settings['card_style'] == 'card'){
            global $wpdb;
            $ids = $wpdb->get_results("SELECT ID FROM {$wpdb->posts} WHERE post_type='member-card' AND post_status='publish'");
            
            if(!empty($ids)){
                $upload_dir   = wp_upload_dir();
                foreach($ids as $id){
                    if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$id->ID.'.css')){
                        $styles['vibebp-member-card-'.$id->ID]=$upload_dir['baseurl'].'/elementor/css/post-'.$id->ID.'.css?v='.WPLMS_PLUGIN_VERSION;    
                    }
                }
            }
        }

        return $styles;
    }

    function pwa_object($objects){
        $objects['vibebpappointments']= $this->args; 
        return $objects;
    }


    function get_price_range(){
        global $wpdb;
    
        $results =[];
        $results = apply_filters('vibebpappointments_get_price_range',$results);
        if(empty($results)){
            $results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$wpdb->usermeta} WHERE meta_key='_appointment_price'");
        }
        if(!empty($results)){
            foreach($results as $result){
                if(empty($result->min)){$result->min =0;}
                if(empty($result->max)){$result->max =100;}
                if($result->min == $result->max){$result->min=0;}
                return array('min'=>$result->min,'max'=>$result->max);
            }
        }
    }

    function instructor_labels($atts,$content = null){

        if(!empty($atts['instructor'])){
            $user_id = $atts['instructor'];
        }
        if(!empty($atts['user'])){
            $user_id = $atts['user'];
        }


        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }
        if(empty($user_id)){
            $user_id = bp_displayed_user_id();
        }
        $return ='';
        
        if(!empty($user_id)){
           
            if(empty($this->appointment_settings)){
                $this->appointment_settings = get_option(VIBE_APPOINTMENTS_OPTION);
            }
            if(!empty($this->appointment_settings['instructor_labels'])){
                $labels = $this->appointment_settings['instructor_labels'];
                $user_labels = get_user_meta($user_id,'appointment_label',false);
                if(!empty($user_labels) && !empty($labels['label'])){
                    $return.='<div class="user_labels">';
                    foreach($user_labels as $label){
                        $k = array_search($label, $labels['label']);
                        $return.= '<img src="'.wp_get_attachment_url($labels['image'][$k]).'" title="'.$label.'" />';
                    }
                    $return.='</div>';
                }
            }

        }

        add_action('wp_footer',array($this,'instructor_styles'));
        return $return;
    }

    function instructor_styles(){
    ?>
    <style>.user_labels{display:flex;gap:0.5rem;flex-wrap:wrap;}.user_labels img{flex:0 0 24px;width: 24px;height: 24px;}</style>
    <?php
    }

    function instructor_price($atts,$content=null){

        if(!empty($atts['instructor'])){
            $user_id = $atts['instructor'];
        }
        if(!empty($atts['user'])){
            $user_id = $atts['user'];
        }


        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }
        global $wpdb;
        $product_id = $wpdb->get_var("SELECT post_id FROM {$wpdb->postmeta} WHERE meta_key = '_appointment_price' AND meta_value=$user_id");

        
        if(!empty($product_id) && function_exists('wc_get_product')){
            $type = get_post_type($product_id);
            if($type == 'product'){
                $product = wc_get_product( $product_id );
                return $product->get_price_html();   
            }
        }
        return '';
    }

    function instructor_appointment_stats($atts,$content=null){

        if(!empty($atts['instructor'])){
            $user_id = $atts['instructor'];
        }
        if(!empty($atts['user'])){
            $user_id = $atts['user'];
        }


        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }

        $return ='<div class="instructor_appointment_stats_wrapper p-8 rounded">
            <div class="instructor_appointment_stats flex flex-wrap">';

        $favorite_count = 0;
        $booking_count = 0;
        $load_factor = 0;

        global $wpdb,$bp;
        $favorite_count = $wpdb->get_var($wpdb->prepare("SELECT COUNT(meta_value) from {$wpdb->usermeta}  WHERE meta_key = 'vibe_appointment_favourite' AND m1.meta_value=%d",$user_id));

        $return .=' <div class="p-4 flex flex-col gap-4">
                    <h2 class="flex flex-col"><span class="text-lg">'.$favorite_count.'</span><span class="text-sm">'.__('Favourited by Users','vibe-appointments').'</span></h2>
                    </div>';

        $table = $wpdb->prefix . 'wplms_appointments';
        $booking_count = $wpdb->get_var($wpdb->prepare("SELECT count(*) FROM {$table} WHERE status = 'booked' AND author_id= %d",$user_id)); 

          $return .=' <div class="p-4 flex flex-col gap-4">
                    <h2 class="flex flex-col"><span class="text-lg">'.$booking_count.'</span><span class="text-sm">'.__('Bookings Made','vibe-appointments').'</span></h2>
                    </div>';

        $beginOfDay = strtotime("today", $timestamp);
        $endOfDay   = strtotime("tomorrow", $beginOfDay) - 1;

        $loadFactor = $wpdb->get_row($wpdb->prepare("SELECT count(*) FROM {$table} WHERE start_date < %d AND end_date > %d AND author_id= %d GROUP BY status",$beginOfDay,$endOfDay, $user_id),ARRAY_A); 

        if(!empty($loadFactor)){
            $den = array_sum(array_values($loadFactor));
            if(empty($den)){$den =1;}
            $load_factor = round($loadFactor['booked']/$den,0);
        }
        if(empty($load_factor)){
            $load_factor = 0;
        }

         $return .=' <div class="p-4 flex flex-col gap-4">
                    <h2 class="flex flex-col"><span class="text-lg">'.$load_factor.'%</span><span class="text-sm">'.__('Load factor','vibe-appointments').'</span></div>';

        $return .='</div></div>';

        return $return;
    }

    function my_classes($atts,$content=null){

        $return = '';
        if(!empty($atts['student']) && is_numeric($atts['student'])){
            $user_id = $atts['student'];
        }
        if(!empty($atts['user']) && is_numeric($atts['user'])){
            $user_id = $atts['user'];
        }
        if(!empty($atts['card_id']))
            $card_id = $atts['card_id'];

        if(!empty($atts['num'])){
            $num = $atts['num'];
        }else{
            $num =10;
        }
        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }

        if(!empty(bp_displayed_user_id())){
            $user_id = bp_displayed_user_id();
        }

        if(!function_exists('groups_get_groups') || empty($user_id))
            return;

        $groups = bp_get_user_groups($user_id,['per_page'=>$num,'is_admin'=>false]);

        
        $args = ['user_id'=>$user_id,'per_page'=>$num];

        if(!empty($groups)){
            $args['exclude'] = wp_list_pluck($groups,'id');    
        }
        $run = groups_get_groups($args);
            
        if( !empty($run) && !empty($run['groups']) && count($run['groups']) ) {

            foreach($run['groups'] as $k=>$group){
                
                $run['groups'][$k]->avatar = bp_core_fetch_avatar(array(
                        'item_id' => $run['groups'][$k]->id,
                        'object'  => 'group',
                        'type'=> 'full',
                        'html'    => false
                    ));
            }
        }
        if( $run['total'] ){

            ob_start();
            echo '<div class="vibe_apppointments_profile_classes">';
            foreach($run['groups'] as $key=>$group){
                echo '<div class="vibe-apppointments_group">';
                vibe_appointments_class_block($group);
                echo '</div>';
            }
            echo '</div>';

            $return = ob_get_Clean();
        }

        $return .=vibe_appointments_class_block_css();
        return $return;

    }

    function instructor_classes($atts,$content=null){
        $return = '';
        if(!empty($atts['student']) && is_numeric($atts['student'])){
            $user_id = $atts['student'];
        }
        if(!empty($atts['user']) && is_numeric($atts['user'])){
            $user_id = $atts['user'];
        }
        if(!empty($atts['card_id']))
            $card_id = $atts['card_id'];

        if(!empty($atts['num'])){
            $num = $atts['num'];
        }else{
            $num =10;
        }
        if(class_exists('VibeBP_Init')){
            $init = VibeBP_Init::init();
            
            if(!empty($init->user_id)){
               $user_id = $init->user_id;
            }
        }

        if(!empty(bp_displayed_user_id())){
            $user_id = bp_displayed_user_id();
        }

        if(!function_exists('groups_get_groups') || empty($user_id))
            return;

        $groups = bp_get_user_groups($user_id,['per_page'=>$num,'is_admin'=>true]);

        if(!empty($groups)){

            $args = ['user_id'=>$user_id,'per_page'=>$num];
            if(!empty($groups)){
                $args['exclude'] = wp_list_pluck($groups,'id');    
            }

            $run = groups_get_groups($args);

            if( count($run['groups']) ) {

                foreach($run['groups'] as $k=>$group){
                    
                    $run['groups'][$k]->avatar = bp_core_fetch_avatar(array(
                            'item_id' => $run['groups'][$k]->id,
                            'object'  => 'group',
                            'type'=> 'full',
                            'html'    => false
                        ));
                }
            }
            if( $run['total'] ){

                ob_start();
                echo '<div class="vibe_apppointments_profile_classes">';
                foreach($run['groups'] as $key=>$group){
                    echo '<div class="vibe-apppointments_group">';
                    vibe_appointments_class_block($group);
                    echo '</div>';
                }
                echo '</div>';
                $return = ob_get_Clean();
            }

            $return .=vibe_appointments_class_block_css();
        }
        return $return;


    }
}

WPLMS_Appointments_Shortcodes::init();
