<?php

class vibe_Appointments_Tc {


	public static $instance;
    
    public static function init(){
        if ( is_null( self::$instance ) )
            self::$instance = new vibe_Appointments_Tc;
        return self::$instance;
    }

	private function __construct(){

		add_filter('vibebp_touch_points',array($this,'touch_points'));
    	add_filter('vibebp_touch_all_mails',array($this,'email_templates'),9999);


    	//add_filter('vibe_appointments_appointment_id_html',array($this,'vibe_appointments_appointment_id_html'),10,3);
		$this->run_touchpoints();

	}

	

	

	function run_touchpoints(){
		if(!defined('VIBE_BP_SETTINGS'))
			return;
		if(empty($this->vibebp_settings))
			$this->vibebp_settings = get_option(VIBE_BP_SETTINGS);
		if(isset($this->vibebp_settings) && !empty($this->vibebp_settings['touch']) && isset($this->vibebp_settings['touch'])  && !empty($this->vibebp_settings['touch']['general']) && is_array($this->vibebp_settings['touch']['general'])){
			$this->vibebp_settings['touch'] = $this->vibebp_settings['touch']['general'];
			foreach($this->vibebp_settings['touch'] as $key => $value){
				if(!empty($this->get_touch_points()[$key])){
					$hook = $this->get_touch_points()[$key]['vibe_appointment_hook'];
					if(!empty($hook)){
						
						if(!empty($value['student']['message'])){
							$student_fx = 'student_message_'.$key;
							//print_r($hook);print_r('----------');print_r($student_fx);print_r('----------');
							if(function_exists($student_fx)){
								add_action($hook,$student_fx,10,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$student_fx),10,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['student']['notification'])){
							$student_fx = 'student_notification_'.$key;
							if(function_exists($student_fx)){
								add_action($hook,$student_fx,9,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$student_fx),9,$this->get_touch_points()[$key]['params']);	
							}	
						}

						if(!empty($value['student']['email'])){
							$student_fx = 'student_email_'.$key;
							if(function_exists($student_fx)){
								add_action($hook,$student_fx,10,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$student_fx),10,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['instructor']['message'])){
							$instructor_fx = 'instructor_message_'.$key;
							if(function_exists($instructor_fx)){
								add_action($hook,$instructor_fx,15,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$instructor_fx),15,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['instructor']['notification'])){
							$instructor_fx = 'instructor_notification_'.$key;
							if(function_exists($instructor_fx)){
								add_action($hook,$instructor_fx,15,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$instructor_fx),15,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['instructor']['email'])){
							$instructor_fx = 'instructor_email_'.$key;
							if(function_exists($instructor_fx)){
								add_action($hook,$instructor_fx,15,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$instructor_fx),15,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['admin']['message'])){
							$admin_fx = 'admin_message_'.$key;

							if(function_exists($admin_fx)){
								add_action($hook,$admin_fx,25,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$admin_fx),25,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['admin']['notification'])){
							$admin_fx = 'admin_notification_'.$key;
							if(function_exists($admin_fx)){

								add_action($hook,$admin_fx,25,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$admin_fx),25,$this->get_touch_points()[$key]['params']);	
							}
						}

						if(!empty($value['admin']['email'])){
							$admin_fx = 'admin_email_'.$key;
							if(function_exists($admin_fx)){
								add_action($hook,$admin_fx,25,$this->get_touch_points()[$key]['params']);
							}else{
								add_action($hook,array($this,$admin_fx),25,$this->get_touch_points()[$key]['params']);	
							}
						}
					}
				}
				
				
			}
		}
	}

	function get_admins(){
		$admin_ids=array();	
		if(empty($this->admin_ids)){
		 	$user_query = new WP_User_Query( array( 'role' => 'Administrator' ,'fields' => array('ID','user_email')) );
			foreach( $user_query->results as $user){
				$admin_ids[] = (object)array('ID' => $user->ID,'email'=> $user->user_email);
			}
			
		}
		$this->admin_ids = $admin_ids;
		return $this->admin_ids;
	}

	function touch_points($args){
		foreach ($this->get_touch_points() as $key => $touchpoint) {
			$args[$key] = $touchpoint;
		}
    	return $args;
    }

    function get_touch_points(){
    	$args['appointments_booking_confirmed'] = array(
			'label' => __('Appointment Booking confirmed','wplms-appointment'),
			'name' =>'appointments_booking_confirmed',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointments_booking_confirmed&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_confirmed&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_confirmed',
			'params'=>1,
		);

    	$args['appointments_booking_rejected'] = array(
			'label' => __('Appointment Booking rejected','wplms-appointment'),
			'name' =>'appointments_booking_rejected',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointments_booking_rejected&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_rejected&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_rejected',
			'params'=>1,
		);

		$args['appointments_booking_updated'] = array(
			'label' => __('Appointment updated','wplms-appointment'),
			'name' =>'appointments_booking_updated',
			'value' => array(
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_updated&post_type=bp-email'),
				'admin' => admin_url('edit.php?taxonomy=bp-email-type&term=admin_appointments_booking_updated&post_type=bp-email'),
			),
			'type' => 'touchpoint_admin',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_updated',
			'params'=>1,
		);

		$args['appointments_booking_requested'] = array(
			'label' => __('Appointment Requested','wplms-appointment'),
			'name' =>'appointments_booking_requested',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointments_booking_requested&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_requested&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_requested',
			'params'=>2,
		);


		$args['appointments_booking_rescheduled'] = array(
			'label' => __('Appointment Booking rescheduled','wplms-appointment'),
			'name' =>'appointments_booking_rescheduled',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointments_booking_rescheduled&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_rescheduled&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_rescheduled',
			'params'=>1,
		);



		$args['appointments_booking_cancelled'] = array(
			'label' => __('Appointment Booking cancelled','wplms-appointment'),
			'name' =>'appointments_booking_cancelled',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointments_booking_cancelled&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointments_booking_cancelled&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_cancelled',
			'params'=>3,
		);


		
		

		$args['appointment_requested_cancellation'] = array(
			'label' => __('Appointment cancellation Requested','wplms-appointment'),
			'name' =>'appointment_requested_cancellation',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointment_requested_cancellation&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointment_requested_cancellation&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_booking_request_cancellation',
			'params'=>1,
		);


		$args['appointment_requested_reschedule'] = array(
			'label' => __('Appointment reschedule Requested','wplms-appointment'),
			'name' =>'appointment_requested_reschedule',
			'value' => array(
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointment_requested_reschedule&post_type=bp-email'),
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointment_requested_reschedule&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointment_requested_reschedule',
			'params'=>1,
		);

		

		/*$args['cancel_schedule_meeting'] = array(
			'label' => __('Cancel Schedule Meeting','wplms-appointment'),
			'name' =>'cancel_schedule_meeting',
			'value' => array(
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_cancel_schedule_meeting&post_type=bp-email'),
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_cancel_schedule_meeting&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'vibe_appointments_cancel_schedule_meeting',
			'params'=>2,
		);


		$args['appointment_start'] = array(
			'label' => __('Appointment Start','wplms-appointment'),
			'name' =>'appointment_start',
			'value' => array(
				'instructor' => admin_url('edit.php?taxonomy=bp-email-type&term=instructor_appointment_start&post_type=bp-email'),
				'student' => admin_url('edit.php?taxonomy=bp-email-type&term=student_appointment_start&post_type=bp-email'),
			),
			'type' => 'touchpoint',
			'hook' => '',
			'vibe_appointment_hook'=>'appointment_start',
			'params'=>2,
		);*/


    	return apply_filters('vibe_appointments_touch_points_array',$args);
    }

    function email_templates($email){

    	

    	$email['student_appointments_booking_confirmed'] = array(
	            'description'=> __('Student : Appointment Booking confirmed ','vibe-appointments'),
	            'subject' =>  sprintf(__('Your booking confirmed by %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('Your booking request for appointment %s %s confirmed by Instructor %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointments_booking_confirmed'] = array(
	            'description'=> __('Instructor : Appointment Booking confirmed','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment confirmed for Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Appointment booking %s %s confirmed for %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{student.userlink}}}')
	        );



    	$email['student_appointments_booking_cancelled'] = array(
	            'description'=> __('Student : Appointment Booking cancelled ','vibe-appointments'),
	            'subject' =>  sprintf(__('Your booking cancelled by %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('Your booking request for appointment %s %s cancelled by Instructor %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointments_booking_cancelled'] = array(
	            'description'=> __('Instructor : Appointment Booking cancelled','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment cancelled for Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Appointment booking %s %s cancelled for %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{student.userlink}}}')
	        );
    	

    	$email['student_appointments_booking_rejected'] = array(
	            'description'=> __('Student : Appointment Booking rejected ','vibe-appointments'),
	            'subject' =>  sprintf(__('Your booking rejected by Instructor %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('Your booking %s %s rejected by Instructor %s ','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointments_booking_rejected'] = array(
	            'description'=> __('Instructor : Appointment Booking rejected','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment rejected for Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Appointment booking %s %s rejected for %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{student.userlink}}}')
	        );


    	$email['instructor_appointments_booking_updated'] = array(
	            'description'=> __('Instructor : Appointment updated','vibe-appointments'),
	            'subject' =>  __('Appointment updated','vibe-appointments'),
	            'message' =>  sprintf(__('Appointment %s updated ','vibe-appointments'),'{{{appointment.id}}}')
	        );

    	$email['admin_appointments_booking_updated'] = array(
	            'description'=> __('Admin : Appointment updated','vibe-appointments'),
	            'subject' =>  __('Appointment updated','vibe-appointments'),
	            'message' =>  sprintf(__('Appointment %s updated by %s','vibe-appointments'),'{{{appointment.id}}}','{{{instructor.userlink}}}')
	        );

    	
    	
    	$email['student_appointments_booking_requested'] = array(
	            'description'=> __('Student : Appointment Booking requested ','vibe-appointments'),
	            'subject' =>  sprintf(__('You requested appointment for instructor %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('You requested appointment %s %s for instructor %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointments_booking_requested'] = array(
	            'description'=> __('Instructor : Appointment Booking requested','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment requested by Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Appointment %s %s requested by Student %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{student.userlink}}}')
	        );

    	

		$email['student_appointments_booking_rescheduled'] = array(
	            'description'=> __('Student : Appointment Booking rescheduled ','vibe-appointments'),
	            'subject' =>  sprintf(__('Your appointment for instructor %s rescheduled','vibe-appointments'),'{{{instructor.name}}}'),
	            'message' =>  sprintf(__('Your appointment with instructor %s rescheduled from %s %s to %s','vibe-appointments'),'{{instructor.userlink}}','{{appointment.id}}','{{{item.link}}}','{{new_appointment.id}}')
	        );

    	$email['instructor_appointments_booking_rescheduled'] = array(
	            'description'=> __('Instructor : Appointment Booking rescheduled','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment rescheduled for Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Appointment %s %s rescheduled for Student %s to %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{student.userlink}}}','{{new_appointment.id}}')
	        );
    	
		
		$email['student_appointment_requested_cancellation'] = array(
	            'description'=> __('Student : Appointment cancellation requested by student','vibe-appointments'),
	            'subject' =>  sprintf(__('You requested cancellation for appointment with instructor %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('You requested cancellation for appointment %s %s with instructor %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointment_requested_cancellation'] = array(
	            'description'=> __('Instructor : Appointment cancellation requested by student','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment cancellation requested by Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Student %s requested cancellation for appointment %s %s','vibe-appointments'),'{{{student.userlink}}}','{{appointment.id}}','{{{item.link}}}')
	        );

    	$email['student_appointment_requested_reschedule'] = array(
	            'description'=> __('Student : Appointment reschedule requested by student','vibe-appointments'),
	            'subject' =>  sprintf(__('You requested reschedule for appointment with instructor %s','vibe-appointments'),'{{instructor.name}}'),
	            'message' =>  sprintf(__('You requested reschedule for appointment %s %s with instructor %s','vibe-appointments'),'{{appointment.id}}','{{{item.link}}}','{{{instructor.userlink}}}')
	        );

    	$email['instructor_appointment_requested_reschedule'] = array(
	            'description'=> __('Instructor : Appointment reschedule requested by student','vibe-appointments'),
	            'subject' =>  sprintf(__('Appointment reschedule requested by Student %s','vibe-appointments'),'{{student.name}}'),
	            'message' =>  sprintf(__('Student %s requested reschedule for appointment %s %s','vibe-appointments'),'{{{student.userlink}}}','{{appointment.id}}','{{{item.link}}}')
	        );

    	$email['student_cancel_schedule_meeting'] = array(
	            'description'=> __('Student : Meeting Cancelled by Instructor','vibe-appointments'),
	            'subject' =>  __('Scheduled Meeting Cancelled','vibe-appointments'),
	            'message' =>  sprintf(__('Meeting %s Cancelled by %s','vibe-appointments'),'{{{appointment.id}}}','{{{instructor.userlink}}}')
	        );


    	$email['instructor_cancel_schedule_meeting'] = array(
	            'description'=> __('Instructor : Meeting Cancelled','vibe-appointments'),
	            'subject' =>  __('Scheduled Meeting Cancelled','vibe-appointments'),
	            'message' =>  sprintf(__('Meeting %s Cancelled ','vibe-appointments'),'{{appointment.id}}')
	        );

    	$email['instructor_appointment_start'] = array(
            'description'=> __('Instructor : Appointment about to Start','vibe-appointments'),
            'subject' =>  __('Appointment is about to start','vibe-appointments'),
            'message' =>  sprintf(__('Your Appointment %s with %s is about to start on %s','vibe-appointments'),'{{appointment.id}}','{{{student.userlink}}}','{{appointment.time}}')
        );


    	$email['student_appointment_start'] = array(
            'description'=> __('Student : Appointment about to start','vibe-appointments'),
            'subject' =>  __('Appointment is about to Start','vibe-appointments'),
            'message' =>  sprintf(__('Your Appointment %s with %s %s is about to start on %s','vibe-appointments'),'{{appointment.id}}','{{{appointment.instructor_link}}}','{{{appointment.item_link}}}','{{appointment.time}}')
        );


    	return $email;
    }

    //booking confirmed
    function student_message_appointments_booking_confirmed($args){
    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}
    	$appointment_id = vibe_appointments_get_touch_appointment($args,$args['booker_id']);
    	$item_html = ((!empty($args['item_id']))?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');
		$message = sprintf(__('Your appointment %s %s is confirmed by instructor %s','vibe-appointments'),$appointment_id,$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Booking confirmed','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );
    }

    function student_notification_appointments_booking_confirmed($args){
    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointments_booking_confirmed'
		));
    }

    function student_email_appointments_booking_confirmed($args){
    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}
    	$enable = get_user_meta($args['booker_id'],'student_appointments_booking_confirmed',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['booker_id']);
			$to = $user->user_email;
			
	        $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	        $appointment_html = vibe_appointments_get_touch_appointment($args,$args['booker_id']);
	        $item_html = ((!empty($args['item_id']))?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');
			vibebp_wp_mail($to,'','',array('action'=>'student_appointments_booking_confirmed','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html,
					'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
					'item.link'=>$item_html
				)));
		}
    }


    function instructor_message_appointments_booking_confirmed($args){
    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}

    	$item_html = ((!empty($args['item_id']))?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');

	    
	    $appointment_id = vibe_appointments_get_touch_appointment($args,$args['booker_id']);
		$message = sprintf(__('Appointment booking %s %s confirmed for %s','vibe-appointments'),$appointment_id,$item_html,bp_core_get_userlink($args['booker_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Instructor : Booking confirmed','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']) );
    }

    function instructor_notification_appointments_booking_confirmed($args){
    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}
	    vibe_appointments_add_notification( array(
			'user_id'          => $args['author_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['booker_id'],
			'component_action' => 'instructor_appointments_booking_confirmed'
		));
    }

    function instructor_email_appointments_booking_confirmed($args){

    	if(empty($args['author_id']) && !empty($args['appointment_id'])){
    		if(!empty($this->appointments) && !empty($this->appointments[$args['appointment_id']])){
    			$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
    		}else{
    			$db = new VIBE_APPOINTMENTS_DB;
	        	$this->appointments[$args['appointment_id']] = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        	if(!empty($appointments)){
	        		$args['author_id'] = $this->appointments[$args['appointment_id']][0]['author_id'];
	        	}
    		}
    		
    	}
    	$enable = get_user_meta($args['author_id'],'instructor_appointments_booking_confirmed',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$args['author_id']);
			$to = $user->user_email;

	        $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	        $appointment_html = vibe_appointments_get_touch_appointment($args,$args['booker_id']);
	        $item_html = ((!empty($args['item_id']))?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');
			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_confirmed','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['booker_id']),
					'item.link'=>$item_html
				)));
		}
    }


    //booking cancelled
    function student_message_appointments_booking_rejected($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Your booking %s %s rejected by Instructor %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Booking cancelled','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );
    }

    function student_notification_appointments_booking_rejected($args){
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointments_booking_rejected'
		));
    }

    function student_email_appointments_booking_rejected($args){
    	
	    $enable = get_user_meta($args['booker_id'],'student_appointments_booking_rejected',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$args['booker_id']);
			$to = $user->user_email;
			
	        $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointments_booking_rejected',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
					'item.link'=>$item_html
			)));
		}
    }


    function instructor_message_appointments_booking_rejected($args){

	    $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }

    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

	    $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
		$message = sprintf(__('Appointment booking %s %s rejected for %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['booker_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Instructor : Booking rejected','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']) );

    }

    function instructor_notification_appointments_booking_rejected($args){
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['author_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['booker_id'],
			'component_action' => 'instructor_appointments_booking_rejected'
		));
    }

    function instructor_email_appointments_booking_rejected($args){

    	$enable = get_user_meta($args['author_id'],'instructor_appointments_booking_rejected',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$args['author_id']);
			$to = $user->user_email;

	        $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');
			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_rejected','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['booker_id']),
					'item.link'=>$item_html
				)));
		}
    }


    //booking updated
    function admin_message_appointments_booking_updated($schedule){
    	$admins = $this->get_admins();
    	
    	$message = sprintf(__('Appointment %s updated by %s','vibe-appointments'),$schedule['appointment_id'],bp_core_get_userlink($schedule['author_id']));

    	if(!empty($admins)){
    		foreach ($admins as $key => $admin) {
    			$appointment_html = vibe_appointments_get_touch_appointment($schedule,$admin->ID);
		    	if(bp_is_active('messages') )
		      		vibe_appointments_messages_new_message( array('sender_id' => $schedule['author_id'], 'subject' => __('Admin : Appointment updated','vibe-appointments'), 'content' => $message,   'recipients' => $admin->ID ) );
	    	}
	    }
    }
    	

    function admin_notification_appointments_booking_updated($schedule){
    	$admins = $this->get_admins();
    	
    	if(!empty($admins)){
    		foreach ($admins as $key => $admin) {
    	
		    	vibe_appointments_add_notification( array(
					'user_id'          => $admin->ID,
					'item_id'          => $schedule['appointment_id'],
					'secondary_item_id' => $schedule['author_id'],
					'component_action' => 'admin_appointments_booking_updated'
				));
	    	}
	    }
    }

    function admin_email_appointments_booking_updated($schedule){
		$admins = $this->get_admins();
		$to = array();
		$appointment_id =  $schedule['appointment_id'];
    	foreach ($admins as $key => $admin) {

    		
    		if(!empty($admin->email)){
		        $appointment_html = vibe_appointments_get_touch_appointment($schedule,$admin->ID);
				vibebp_wp_mail($admin->email,'','',array('action'=>'admin_appointments_booking_updated','item_id'=>$appointment_id ,
					'tokens'=>array(
						'appointment.id'=>$appointment_html,
						'instructor.userlink'=>bp_core_get_userlink($schedule['author_id'])
				)));
		    }
    	}
    	
    }


    function instructor_message_appointments_booking_updated($schedule){
    	$appointment_html = vibe_appointments_get_touch_appointment($schedule,$schedule['author_id']);
    	$message = sprintf(__('Appointment %s updated','vibe-appointments'),$appointment_html);
    	
    	
    	if(bp_is_active('messages') )
      		vibe_appointments_messages_new_message( array('sender_id' => $schedule['author_id'], 'subject' => __('Instructor : Appointment updated','vibe-appointments'), 'content' => $message,   'recipients' => $schedule['author_id'] ) );
	 }  

    function instructor_notification_appointments_booking_updated($schedule){
    	vibe_appointments_add_notification( array(
			'user_id'          => $schedule['author_id'],
			'item_id'          => $schedule['appointment_id'],
			'secondary_item_id' => $schedule['item_id'],
			'component_action' => 'instructor_appointments_booking_updated'
		));
    }

    function instructor_email_appointments_booking_updated($schedule){
    	$appointment_html = vibe_appointments_get_touch_appointment($schedule,$schedule['author_id']);
	    $enable = get_user_meta($schedule['author_id'],'instructor_appointments_booking_updated',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$schedule['author_id']);
			$to = $user->user_email;

	        $appointment_id =  $schedule['appointment_id'];
	       
			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_updated','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					
				)));
		}
    }



    //booking requested
    function student_message_appointments_booking_requested($booker_id,$schedule){
    	
	    if(!empty($schedule['parent_appointment_id'])){
            $appointment_id = $schedule['parent_appointment_id'];
        }else{
            $appointment_id = $schedule['appointment_id'];
        }
	   	   
	    $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('You requested appointment %s %s for instructor %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($schedule['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $schedule['author_id'], 'subject' => __('Student : Booking Requested','vibe-appointments'), 'content' => $message,   'recipients' =>$booker_id) );
    }

    function student_notification_appointments_booking_requested($booker_id,$schedule){
        $appointment_id = $schedule['appointment_id'];
    	vibe_appointments_add_notification( array(
			'user_id'          => $booker_id,
			'item_id'          => $appointment_id,
			'secondary_item_id' => $schedule['author_id'],
			'component_action' => 'student_appointments_booking_requested'
		));
    }

    function student_email_appointments_booking_requested($booker_id,$schedule){
	    $enable = get_user_meta($booker_id,'student_appointments_booking_requested',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $booker_id);
			$to = $user->user_email;
			
	        $appointment_id = (empty($schedule['parent_appointment_id'])?$schedule['appointment_id']:$schedule['parent_appointment_id']);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointments_booking_requested',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html,
					'instructor.name'=>bp_core_get_user_displayname($schedule['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($schedule['author_id']),
					'item.link'=>$item_html
			)));
		}
    	
    }


    function instructor_message_appointments_booking_requested($booker_id,$schedule){
    	
    	if(!empty($schedule['parent_appointment_id'])){
            $appointment_id = $schedule['parent_appointment_id'];
        }else{
            $appointment_id = $schedule['appointment_id'];
        }
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Appointment %s %s requested by Student %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($booker_id));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $booker_id, 'subject' => __('Instructor : Booking requested','vibe-appointments'), 'content' => $message,   'recipients' =>$schedule['author_id']) );
    }

    function instructor_notification_appointments_booking_requested($booker_id,$schedule){
    	
	   
	    vibe_appointments_add_notification( array(
			'user_id'          => $schedule['author_id'],
			'item_id'          => $schedule['appointment_id'],
			'secondary_item_id' => $booker_id,
			'component_action' => 'instructor_appointments_booking_requested'
		));
    }

    function instructor_email_appointments_booking_requested($booker_id,$schedule){
    	
	    $enable = get_user_meta($schedule['author_id'],'instructor_appointments_booking_requested',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$schedule['author_id']);
			$to = $user->user_email;

	        $appointment_id = (empty($schedule['parent_appointment_id'])?$schedule['appointment_id']:$schedule['parent_appointment_id']);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$schedule['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$booker_id);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');
			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_requested','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($booker_id),
					'student.userlink'=>bp_core_get_userlink($booker_id),
					'item.link'=>$item_html
			)));
		}
    }


    //booking appointments_booking_rescheduled
    function student_message_appointments_booking_rescheduled($args){
    	//old : $post['appointment']
        //new : $post['slot']
        $appointment_id = (empty($args['appointment'])?$args['appointment']['appointment_id']:0);
	   	   
	    $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['appointment']['booker_id']);
    	$item_html = ((!empty($appointment['appointment']['item_id']) )?'<a href="'.get_permalink($appointment['appointment']['item_id']).'">'.get_the_title($appointment['appointment']['item_id']).'</a>':'');

		$message = sprintf(__('Your appointment with instructor %s rescheduled from %s %s to %s','vibe-appointments'),bp_core_get_userlink($args['appointment']['author_id']),$appointment_html,$item_html,$args['slot']['appointment_id']);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['appointment']['author_id'], 'subject' => __('Student : Booking Rescheduled','vibe-appointments'), 'content' => $message,   'recipients' =>$args['appointment']['booker_id']) );
    }

    function student_notification_appointments_booking_rescheduled($args){
    	//old : $post['appointment']
        //new : $post['slot']
    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment']['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['appointment']['booker_id'],
			'item_id'          => $appointment['appointment']['appointment_id'],
			'secondary_item_id' => $args['appointment']['author_id'],
			'component_action' => 'student_appointments_booking_rescheduled'
		));
    }

    function student_email_appointments_booking_rescheduled($args){
    	
	    $enable = get_user_meta($args['appointment']['booker_id'],'student_appointments_booking_rescheduled',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['appointment']['booker_id']);
			$to = $user->user_email;
			
	        $appointment_id =(empty($args['appointment'])?$args['appointment']['appointment_id']:0);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['appointment']['booker_id']);

	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['appointment']['item_id']).'">'.get_the_title($appointment['appointment']['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointments_booking_rescheduled',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'instructor.name'=>bp_core_get_user_displayname($args['appointment']['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['appointment']['author_id']),
					'item.link'=>$item_html,
					'new_appointment.id'=>$args['slot']['appointment_id']
			)));
		}
    }


    function instructor_message_appointments_booking_rescheduled($args){
    	
    	$appointment_id = (empty($args['appointment'])?$args['appointment']['appointment_id']:0);
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment']['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['appointment']['author_id']);
    	$item_html = ((!empty($appointment['appointment']['item_id']) )?'<a href="'.get_permalink($appointment['appointment']['item_id']).'">'.get_the_title($appointment['appointment']['item_id']).'</a>':'');

	    
		$message = sprintf(__('Appointment %s %s rescheduled for Student %s to %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['appointment']['booker_id']),$args['slot']['appointment_id']);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['appointment']['booker_id'], 'subject' => __('Instructor : Booking Rescheduled','vibe-appointments'), 'content' => $message,   'recipients' =>$args['appointment']['author_id']) );
    }

    function instructor_notification_appointments_booking_rescheduled($args){
    
	    vibe_appointments_add_notification( array(
			'user_id'          => $args['appointment']['author_id'],
			'item_id'          => $args['appointment']['appointment_id'],
			'secondary_item_id' => $args['appointment']['booker_id'],
			'component_action' => 'instructor_appointments_booking_rescheduled'
		));
    }

    function instructor_email_appointments_booking_rescheduled($args){
    	
	    $enable = get_user_meta($args['appointment']['author_id'],'instructor_appointments_booking_rescheduled',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id',$args['appointment']['author_id']);
			$to = $user->user_email;

	        $appointment_id = (empty($args['appointment'])?$args['appointment']['appointment_id']:0);
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment']['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['appointment']['author_id']);
	    	$item_html = ((!empty($appointment['appointment']['item_id']) )?'<a href="'.get_permalink($appointment['appointment']['item_id']).'">'.get_the_title($appointment['appointment']['item_id']).'</a>':'');
			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_rescheduled','item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['appointment']['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['appointment']['booker_id']),
					'item.link'=>$item_html,
					'new_appointment.id'=>$args['slot']['appointment_id']
			)));
		}
    }

    //booking appointments_booking_cancelled
    function student_message_appointments_booking_cancelled($args){
    	
    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Your booking request for appointment %s %s cancelled by Instructor %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Booking cancelled','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );
    }

    function student_notification_appointments_booking_cancelled($args){
    	
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointments_booking_cancelled'
		));
    }

    function student_email_appointments_booking_cancelled($args){
    	
	    $enable = get_user_meta($args['booker_id'],'student_appointments_booking_cancelled',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['booker_id']);
			$to = $user->user_email;
			
	        
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
	        $appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointments_booking_cancelled',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html,
					'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
					'item.link'=>$item_html
			)));
		}
    }


    function instructor_message_appointments_booking_cancelled($args){
    	
    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Appointment booking %s %s cancelled for %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['booker_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Instructor : Booking Cancelled','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );

    }

    function instructor_notification_appointments_booking_cancelled($args){

        
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['author_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['booker_id'],
			'component_action' => 'instructor_appointments_booking_cancelled'
		));
    }

    function instructor_email_appointments_booking_cancelled($args){
    	
	    $enable = get_user_meta($args['author_id'],'instructor_appointments_booking_cancelled',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['author_id']);
			$to = $user->user_email;
			
	        
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
	        $appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointments_booking_cancelled',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['booker_id']),
					'item.link'=>$item_html
			)));
		}
    	
    }

	//appointment_requested_cancellation
    function student_message_appointment_requested_cancellation($args){
    	

    	$item_html = ((!empty($args['item_id']) )?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');

		$message = sprintf(__('You requested cancellation for appointment %s %s with instructor %s','vibe-appointments'),$args['appointment_id'],$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Booking Cancellation Requested','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );
    }

    function student_notification_appointment_requested_cancellation($args){
    	
	    $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointment_requested_cancellation'
		));
    }

    function student_email_appointment_requested_cancellation($args){
    	
	    $enable = get_user_meta($args['booker_id'],'student_appointment_requested_cancellation',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['booker_id']);
			$to = $user->user_email;
			
	        
	       
	        $appointment_html = vibe_appointments_get_touch_appointment($args,$args['booker_id']);
	        $appointment_id = (empty($appointment['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	    	$item_html = ((!empty($args['item_id']) )?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointment_requested_cancellation',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html,
					'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
					'item.link'=>$item_html
			)));
		}
    }


    function instructor_message_appointment_requested_cancellation($args){
    	
	    
        $appointment_html = vibe_appointments_get_touch_appointment($args,$args['author_id'] );
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');

		$message = sprintf(__('Student %s requested cancellation for appointment %s %s','vibe-appointments'),bp_core_get_userlink($args['booker_id']),$appointment_html,$item_html);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Instructor : Booking Cancellation Requested','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );
    }

    function instructor_notification_appointment_requested_cancellation($args){
    	
	    
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['author_id'],
			'item_id'          => $args['appointment_id'],
			'secondary_item_id' => $args['booker_id'],
			'component_action' => 'instructor_appointment_requested_cancellation'
		));
    }

    function instructor_email_appointment_requested_cancellation($args){
    	
	    $enable = get_user_meta($args['author_id'],'instructor_appointment_requested_cancellation',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['author_id']);
			$to = $user->user_email;
			
	        
	       
	        $appointment_html = vibe_appointments_get_touch_appointment($args,$args['author_id']);
	        $appointment_id = (empty($args['parent_appointment_id'])?$args['appointment_id']:$args['parent_appointment_id']);
	    	$item_html = ((!empty($args['item_id']) )?'<a href="'.get_permalink($args['item_id']).'">'.get_the_title($args['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointment_requested_cancellation',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['booker_id']),
					'item.link'=>$item_html
			)));
		}

    }


    //appointment_requested_reschedule
    function student_message_appointment_requested_reschedule($args){
    	
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('You requested reschedule for appointment %s %s with instructor %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Booking Reschedule Requested','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );

    }

    function student_notification_appointment_requested_reschedule($args){
    	
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointment_requested_reschedule'
		));
    }

    function student_email_appointment_requested_reschedule($args){
    	
        $enable = get_user_meta($args['booker_id'],'student_appointment_requested_reschedule',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['booker_id']);
			$to = $user->user_email;
			
	        
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
	        $appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_appointment_requested_reschedule',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html,
					'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
					'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
					'item.link'=>$item_html
			)));
		}       
    }


    function instructor_message_appointment_requested_reschedule($args){
    	
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Student %s requested reschedule for appointment %s %s','vibe-appointments'),bp_core_get_userlink($args['booker_id']),$appointment_html,$item_html);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Instructor : Booking Reschedule Requested','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );
    }

    function instructor_notification_appointment_requested_reschedule($args){
    	
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['author_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['booker_id'],
			'component_action' => 'instructor_appointment_requested_reschedule'
		));
    }

    function instructor_email_appointment_requested_reschedule($args){
    	
        $enable = get_user_meta($args['author_id'],'instructor_appointment_requested_reschedule',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['author_id']);
			$to = $user->user_email;
			
	        
	        $appointment = array();
	        $db = new VIBE_APPOINTMENTS_DB;
	        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
	        if(!empty($appointments)){
	            $appointment = $appointments[0];
	        }
	        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
	        $appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
	    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'instructor_appointment_requested_reschedule',
				'item_id'=>$appointment_id ,
				'tokens'=>array(
					'appointment.id'=>$appointment_html ,
					'student.name'=>bp_core_get_user_displayname($args['booker_id']),
					'student.userlink'=>bp_core_get_userlink($args['booker_id']),
					'item.link'=>$item_html
			)));
		}
    }


    //Meeting Schedule cancelled

    function student_message_cancel_schedule_meeting($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('This meeting %s %s  is Cancelled by instructor %s','vibe-appointments'),$appointment_html,$item_html,bp_core_get_userlink($args['author_id']));
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' => $args['author_id'], 'subject' => __('Student : Scheduled Meeting Cancellation','vibe-appointments'), 'content' => $message,   'recipients' => $args['booker_id'] ) );
    }


    function student_notification_cancel_schedule_meeting($args){
    	
        $appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_cancel_schedule_meeting'
		));
    }


    function student_email_cancel_schedule_meeting($args){

		$enable = get_user_meta($args['booker_id'],'student_cancel_schedule_meeting',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['booker_id']);
			$to = $user->user_email;

			$appointment = array();
			$db = new VIBE_APPOINTMENTS_DB;
			$appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
			if(!empty($appointments)){
				$appointment = $appointments[0];
			}
			$appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['booker_id']);
			$appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
			$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'student_cancel_schedule_meeting',
			'item_id'=>$appointment_id ,
			'tokens'=>array(
			'appointment.id'=>$appointment_html,
			'instructor.name'=>bp_core_get_user_displayname($args['author_id']),
			'instructor.userlink'=>bp_core_get_userlink($args['author_id']),
			'item.link'=>$item_html
			)));
		}

    }



    function instructor_message_cancel_schedule_meeting($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id'] );
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('Instructor %s cancelled the meeting %s %s','vibe-appointments'),bp_core_get_userlink($args['booker_id']),$appointment_html,$item_html);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Instructor : Scheduled Meeting Cancellation','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );

    }

    function instructor_notification_cancel_schedule_meeting($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'instructor_cancel_schedule_meeting'
		));

    }

    function instructor_email_cancel_schedule_meeting($args){

		$enable = get_user_meta($args['author_id'],'instructor_cancel_schedule_meeting',true);
		if($enable !== 'no'){
			$user = get_user_by( 'id', $args['author_id']);
			$to = $user->user_email;

			$appointment = array();
			$db = new VIBE_APPOINTMENTS_DB;
			$appointments = $db->get_appointments(Array('appointment_id'=>$args['appointment_id']));
			if(!empty($appointments)){
				$appointment = $appointments[0];
			}
			$appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
			$appointment_id = (empty($appointment['parent_appointment_id'])?$appointment['appointment_id']:$appointment['parent_appointment_id']);
			$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

			vibebp_wp_mail($to,'','',array('action'=>'instructor_cancel_schedule_meeting',
			'item_id'=>$appointment_id ,
			'tokens'=>array(
			'appointment.id'=>$appointment_html ,
			'student.name'=>bp_core_get_user_displayname($args['booker_id']),
			'student.userlink'=>bp_core_get_userlink($args['booker_id']),
			'item.link'=>$item_html
			)));
		}


    }

    /* Appointment About to Start */

    function student_message_appointment_start($schedule_id,$appointment_id){

    	$db = new VIBE_APPOINTMENTS_DB;
    	$appointments = $db->get_appointments(array('appointment_id'=>$appointment_id));
    	$appointment = $appointments[0];

    	if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('The Appointment %s is going to start for student %s','vibe-appointments'),bp_core_get_userlink($args['booker_id']),$appointment_html,$item_html);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Student : Appointment is About to start','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );


    }


    function student_notification_appointment_start($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'student_appointment_start'
		));


    }


    function student_email_appointment_start($schedule_id,$appointment_id){

    	$db = new VIBE_APPOINTMENTS_DB;
    	$appointments = $db->get_appointments(array('appointment_id'=>$appointment_id));
    	$appointment = $appointments[0];


    	$bookers = vibe_get_appointment_bookers($appointment_id);
    	if(!empty($bookers)){
    		foreach($bookers as $booker){
    			$user = get_user_by( 'id', $booker);

				$to = $user->user_email;

				$appointment_html = vibe_appointments_get_touch_appointment($appointment,$appointment['author_id']);

				$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

				//$diff = round($appointment['start_date']/1000) + $appointment['start_time']*60 - time();

				vibebp_wp_mail($to,'','',array('action'=>'student_appointment_start',
					'item_id'=>$appointment_id ,
					'tokens'=>array(
						'appointment.id'=>$appointment_html ,
						'appointment.instructor_link'=>bp_core_get_userlink($appointment['author_id']),
						'appointment.item_link'=>$item_html
				)));
    		}
    	}
    }



    function instructor_message_appointment_start($schedule_id,$appointment_id){

    	$db = new VIBE_APPOINTMENTS_DB;
    	$appointments = $db->get_appointments(array('appointment_id'=>$appointment_id));
    	$appointment = $appointments[0];

    	if(!empty($appointments)){
            $appointment = $appointments[0];
        }
        $appointment_html = vibe_appointments_get_touch_appointment($appointment,$args['author_id']);
    	$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

		$message = sprintf(__('The Appointment %s is going to start for student %s','vibe-appointments'),bp_core_get_userlink($args['booker_id']),$appointment_html,$item_html);
	    if(bp_is_active('messages') )
	      vibe_appointments_messages_new_message( array('sender_id' =>$args['booker_id'] , 'subject' => __('Instructor : Appointment is About to start','vibe-appointments'), 'content' => $message,   'recipients' =>$args['author_id']  ) );

    }
    
    function instructor_notification_appointment_start($args){

    	$appointment = array();
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments = $db->get_appointments(Array('appointment_id'=>$appointment_id));
        if(!empty($appointments)){
            $appointment = $appointments[0];
        }
    	vibe_appointments_add_notification( array(
			'user_id'          => $args['booker_id'],
			'item_id'          => $appointment['appointment_id'],
			'secondary_item_id' => $args['author_id'],
			'component_action' => 'instructor_appointment_start'
		));


    }

    
    function instructor_email_appointment_start($schedule_id,$appointment_id){
    	
    	$db = new VIBE_APPOINTMENTS_DB;
    	$appointments = $db->get_appointments(array('appointment_id'=>$appointment_id));
    	$appointment = $appointments[0];


    	$bookers = vibe_get_appointment_bookers($appointment_id);
    	if(!empty($bookers)){
    		foreach($bookers as $booker){
    			$user = get_user_by( 'id', $booker);

				$to = $user->user_email;

				$appointment_html = vibe_appointments_get_touch_appointment($appointment,$appointment['author_id']);

				$item_html = ((!empty($appointment['item_id']) )?'<a href="'.get_permalink($appointment['item_id']).'">'.get_the_title($appointment['item_id']).'</a>':'');

				//$diff = round($appointment['start_date']/1000) + $appointment['start_time']*60 - time();

				vibebp_wp_mail($to,'','',array('action'=>'instructor_appointment_start',
					'item_id'=>$appointment_id ,
					'tokens'=>array(
						'appointment.id'=>$appointment_html ,
						'appointment.instructor_link'=>bp_core_get_userlink($appointment['author_id']),
						'appointment.item_link'=>$item_html
				)));
    		}
    	}
    	
    }



    function vibe_appointments_appointment_id_html($appointment_html,$appointment,$user_id){
		
        if(!empty($appointment)){
            if(is_array($appointment) && isset($appointment['appointment_id'])){
            	if(!empty($appointment['start_date']) && !empty($appointment['end_date'])){
            		$start_time_readable =  vibe_appointments_convert_utc_local($appointment['start_date'],$appointment['start_time'],$user_id);
            		$end_time_readable =  vibe_appointments_convert_utc_local($appointment['end_date'],$appointment['end_time'],$user_id);

            		return '[Id : '.$appointment['appointment_id'].']['.$start_time_readable.' - '.$end_time_readable.']';
            	}else{
            		$dbappointment = array();
			        $db = new VIBE_APPOINTMENTS_DB;
			        $dbappointments = $db->get_appointments(Array('appointment_id'=>$appointment['appointment_id']));
			        if(!empty($dbappointments)){
			            $dbappointment = $dbappointments[0];
			        }
			        if(!empty($dbappointment)){
			        	if(!empty($dbappointment['start_date']) && !empty($dbappointment['end_date'])){
			        		$start_time_readable =  vibe_appointments_convert_utc_local($dbappointment['start_date'],$dbappointment['start_time'],$user_id);
	            			$end_time_readable =  vibe_appointments_convert_utc_local($dbappointment['end_date'],$dbappointment['end_time'],$user_id);
	            			return '[Id : '.$dbappointment['appointment_id'].']['.$start_time_readable.' - '.$end_time_readable.']';
			        	}else{
			        		return $appointment['appointment_id'];
			        	}
			        }else{
			        	return $appointment['appointment_id'];
			        }
            		
            	}
            }else{

            	$dbappointment = array();
		        $db = new VIBE_APPOINTMENTS_DB;
		        $dbappointments = $db->get_appointments(Array('appointment_id'=>$appointment));
		        if(!empty($dbappointments)){
		            $dbappointment = $dbappointments[0];
		        }
		        if(!empty($dbappointment)){
		        	if(!empty($dbappointment['start_date']) && !empty($dbappointment['end_date'])){
		        		$start_time_readable =  vibe_appointments_convert_utc_local($dbappointment['start_date'],$dbappointment['start_time'],$user_id);
            			$end_time_readable =  vibe_appointments_convert_utc_local($dbappointment['end_date'],$dbappointment['end_time'],$user_id);
            			return '[Id : '.$dbappointment['appointment_id'].']['.$start_time_readable.' - '.$end_time_readable.']';
		        	}else{
		        		return $appointment;
		        	}
		        }else{
		        	return $appointment;
		        }
            }
        }
    }
}
function bp_appointments_format_notifications( $action, $item_id, $secondary_item_id, $total_items, $format = 'string' ) {
	$notification ='';	
	switch ($action) {
		case 'student_appointments_booking_confirmed':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Your appointment %s is confirmed by instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;

		case 'instructor_appointments_booking_confirmed':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s confirmed for Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'student_appointments_booking_rejected':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Your booking %s rejected by Instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_rejected':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s rejected for Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_updated':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('You updated appointment %s','vibe-appointments'),$appointment_html);
		break;
		case 'admin_appointments_booking_updated':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s updated by %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'student_appointments_booking_requested':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('You requested appointment %s for instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_requested':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s requested by Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'student_appointments_booking_rescheduled':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Your appointment %s for instructor %s rescheduled','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_rescheduled':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s rescheduled for Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'student_appointments_booking_cancelled':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Your booking %s cancelled by %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_cancelled':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s cancelled for Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'student_appointment_requested_cancellation':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('You requested cancellation for appointment %s with instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointment_requested_cancellation':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s cancellation requested by Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;


		case 'student_appointment_requested_reschedule':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('You requested reschedule for appointment %s with instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointment_requested_reschedule':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Appointment %s reschedule requested by Student %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;

		case 'student_cancel_schedule_meeting':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Meeting %s cancelled by Instructor %s','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_cancel_schedule_meeting':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);
			$notification = sprintf(__('Meeting %s cancelled','vibe-appointments'),$appointment_html,bp_core_get_userlink($secondary_item_id));
		break;

		case 'student_appointment_start':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);

			$db = new VIBE_APPOINTMENTS_DB;
			$appointments = $db->get_appointments(array('appointment_id'=>$item_id));
			
			//$diff = round($appointments[0]['start_date']/1000)+60*$appointments[0]['start_time'] - time();

			$notification = sprintf(__('Appointment %s is about to start','vibe-appointments'),$appointment_html);
		break;
		case 'instructor_appointment_start':
			$appointment_html = vibe_appointments_get_touch_appointment($item_id,$secondary_item_id);

			$db = new VIBE_APPOINTMENTS_DB;
			$appointments = $db->get_appointments(array('appointment_id'=>$item_id));
			
			//$diff = round($appointments[0]['start_date']/1000)+60*$appointments[0]['start_time'] - time();

			$notification = sprintf(__('Appointment %s with %s is about to start ','vibe-appointments'),$appointment_html,bp_core_get_userlink($appointments[0]['author_id']));
		break;
		case 'student_appointments_booking_request_cancellation':
			
			//$diff = round($appointments[0]['start_date']/1000)+60*$appointments[0]['start_time'] - time();

			$notification = sprintf(__('You requested booking %s with Instructor %s for cancellation','vibe-appointments'),$item_id,bp_core_get_userlink($secondary_item_id));
		break;
		case 'instructor_appointments_booking_request_cancellation':
			$notification =  sprintf(__('%s requested Appointment booking %s %s for cancellation','vibe-appointments'),bp_core_get_userlink($secondary_item_id),$item_id);
		break;

		
	}
	return $notification;
}

function vibe_appointments_get_touch_appointment($appointment,$user_id){
		
	if(!empty($appointment)){
        if(is_array($appointment) && isset($appointment['appointment_id'])){

            return apply_filters('vibe_appointments_appointment_id_html','<a class="activity_appointment_id" data-id="'.$appointment['appointment_id'].'">'.$appointment['appointment_id'].'</a>',$appointment,$user_id);
        }else{
            return apply_filters('vibe_appointments_appointment_id_html','<a class="activity_appointment_id" data-id="'.$appointment.'">'.$appointment.'</a>',$appointment,$user_id);
        }
    }
	return $html;
}

add_action('bp_init',function(){

	$vibe_tc = vibe_Appointments_Tc::init();
});