<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

 class Vibe_Apppointments_Class_Directory extends \Elementor\Widget_Base  // We'll use this just to avoid function name conflicts 
{
	public function __construct($data = [], $args = null) {
		$this->settings =array();
		
	    if(!empty($data['settings'])){
	    	$this->settings = $data['settings'];
	    }

	    parent::__construct($data, $args);
		
	    
	}

    public function get_name() {
		return 'class_directory';
	}

	public function get_title() {
		return __( 'Class Directory', 'vibe-appointments' );
	}

	public function get_icon() {
		return 'dashicons dashicons-groups';
	}

	public function get_categories() {
		return [ 'vibebp' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Controls', 'vibe-appointments' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		if(function_exists('bp_groups_get_group_types')){
			$types = bp_groups_get_group_types(array(),'objects');
			if(!empty($types))	{

				$gtypes = array(
					'' =>__('All Groups are Classes','vibe-apppointments')
				);
				foreach($types as $type => $labels){
					$gtypes[$type]=$labels->labels['name'];
				}

				

				$this->add_control(
					'group_type',
					[
						'label' =>__('Select Group type labeled as Class', 'vibe-appointments'),
						'type' => \Elementor\Controls_Manager::SELECT,
						'default' => 'all',
						'options' => $gtypes 
					]
				);
			}
		}

		$this->add_control(
			'availability_filter',
			[
				'label' => __( 'Show Availability filter', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'vibe-apppointments' ),
				'label_off' => __( 'No', 'vibe-apppointments' ),
				'return_value' => '1',
				'default' => '0',
			]
		);
		

		$this->add_control(
			'classes_per_page',
			[
				'label' =>__('Total Number of Classes in view', 'vibe-appointments'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'range'=>[
					'min' => 1,
					'max' => 20,
					'step' => 1,
				],
				'default' => [
					'size'=>1,
				]
			]
		);


		$this->add_control(
			'order',
			[
				'label' => __( 'Default Sort by', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'active',
				'options' => array(
					'active' =>__('Active','vibe-apppointments'),
					'newest' =>__('Recently Added','vibe-apppointments'),
					'alphabetical' =>__('Alphabetical','vibe-apppointments'),
					'random'=>__('Random','vibe-apppointments'),
					'popular'=>__('Popular','vibe-apppointments'),
				)
			]
		);


		$class_types = [];
		if(function_exists('bp_groups_get_class_types')){
			$gt = bp_groups_get_class_types(array(),'objects');
			foreach($gt as $k=>$t){
				$class_types[$k]=$t->labels['name'];
			}
		}
		
		if(!empty($class_types) && count($class_types)){
			$class_types = array_merge(array('all'=>__('All','vibe-apppointments')),$class_types);
			$this->add_control(
				'class_type',
				[
					'label' => __( 'Group Type', 'vibe-apppointments' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => 'all',
					'options' => $class_types
				]
			);
		}

		$this->add_control(
			'class_availability',
			[
				'label' => __( 'Show Availability Filter', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'vibe-apppointments' ),
				'label_off' => __( 'No', 'vibe-apppointments' ),
				'return_value' => '1',
				'default' => '0',
			]
		);

		
		$groups_settings = vibebp_get_groups_meta_fields_array();
		foreach($groups_settings as $metabox){
			if(in_array($metabox['type'],array('showhide','number','date','yesno','switch','select','checkbox','radio'))){
				$this->add_control(
					'meta__'.$metabox['id'],
					[
						'label' => sprintf(esc_html__('Show %s filter','vibe-apppointments'),$metabox['label']),
						'type' => \Elementor\Controls_Manager::CHOOSE,
						'options' => [
							'0' => [
								'title' => __( 'No', 'vibe-apppointments' ),
								'icon' => 'fa fa-x',
							],
							'1' => [
								'title' => __( 'Yes', 'vibe-apppointments' ),
								'icon' => 'fa fa-check',
							],
						],
					]
				);
			}
		}

		$this->add_control(
			'class_pagination',
			[
				'label' => __( 'Show Pagination', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'vibe-apppointments' ),
				'label_off' => __( 'No', 'vibe-apppointments' ),
				'return_value' => '1',
				'default' => '0',
			]
		);

		$group_cards = new WP_Query([
			'post_type'=>'group-card',
			'posts_per_page'=>-1
		]);

		if($group_cards->have_posts()){
			$cards = [];
			while($group_cards->have_posts()){
				$group_cards->the_post();
				$cards[get_The_ID()] = get_the_title();
			}
			wp_reset_postdata();
			$this->add_control(
				'class_card',
				[
					'label' => __( 'Class Card', 'vibe-apppointments' ),
					'type' => \Elementor\Controls_Manager::SELECT,
					'default' => '',
					'options' => $cards
				]
			);	
			
		}
		
		

		
		$this->add_control(
			'search_classes',
			[
				'label' => __( 'Show Search Classes', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'vibe-apppointments' ),
				'label_off' => __( 'No', 'vibe-apppointments' ),
				'return_value' => '1',
				'default' => '0',
			]
		);

		$this->add_control(
			'sort_classes',
			[
				'label' => __( 'Show Sort options', 'vibe-apppointments' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __( 'Yes', 'vibe-apppointments' ),
				'label_off' => __( 'No', 'vibe-apppointments' ),
				'return_value' => '1',
				'default' => '0',
			]
		);


		if(!empty($class_types) && count($class_types)){

			$this->add_control(
				'class_type_filter', [
					'label' => __( 'Show Class type Filter', 'vibe-apppointments' ),
					'type' => \Elementor\Controls_Manager::SELECT2,
					'multiple'=>true,
					'options' => $class_types,
					'default' => 'all'
				]
			);
		}

		$this->add_control(
			'show_class_popup',
			[
				'label' => __( 'Show Class in popups', 'vibep' ),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'0' => [
						'title' => __( 'No', 'vibe-apppointments' ),
						'icon' => 'fa fa-x',
					],
					'1' => [
						'title' => __( 'Yes', 'vibe-apppointments' ),
						'icon' => 'fa fa-check',
					],
				],
			]
		);
		
		$this->end_controls_section();

	}
	//required for select2
	

	protected function render() {

		$settings = $this->get_settings_for_display();
		$defaults = array(
			'style'=>'card'
		);

		$settings = wp_parse_args($settings,$defaults);
		
		
		
		$class_types = [];
		if(function_exists('bp_groups_get_class_types')){
			$gt = bp_groups_get_class_types(array(),'objects');
			foreach($gt as $k=>$t){
				$class_types[$k]=$t->labels['name'];
			}
		}



		$class_fields = [];
		$groups_settings = vibebp_get_groups_meta_fields_array();
		$deps = ['wp-element','wp-data','flatpickr','moment'];

		foreach($groups_settings as $metabox){

			if(in_array($metabox['type'],array('showhide','number','date','yesno','switch','select','checkbox','radio')) && !empty($settings['meta__'.$metabox['id']])){
				$metabox['property'] ='meta';
				$class_fields[] = $metabox;
				if($metabox['type'] == 'number'){
					$deps[]='nouislider';
					$deps[]='wnumb';
				}
			}
		}
		

		wp_enqueue_style('class_directory-css',plugins_url('../assets/css/class_directory.css',__FILE__),['nouislider_css','flatpickr'],VIBE_APPOINTMENTS_VERSION);

		wp_enqueue_script('class_directory',plugins_url('../assets/js/class_directory.js',__FILE__),$deps,VIBE_APPOINTMENTS_VERSION,true);
		
		$upload_dir   = wp_upload_dir();
	        if(!empty($settings['class_card'])){
	        	;
    			if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$settings['class_card'].'.css')){
	                wp_enqueue_style('vibebp-class-card-'.$settings['class_card'],$upload_dir['baseurl'].'/elementor/css/post-'.$settings['class_card'].'.css',array());   
	            }
	        }

	    $settings['date_format'] = apply_filters('vibe_appointments_date_format',convertPhpToJsMomentFormat(get_option('date_format')));
		$blog_id = get_current_blog_id();
		$this->args = array(
			'api'=>array(
				'url'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),
				'client_id'=>vibebp_get_setting('client_id'),
			),
			'settings'=>$settings,
			'class_fields' => $class_fields,
			'class_types'=>$class_types,
			'availability'=>get_vibe_appointments_availability_data(),
			'class_sorters'=>array(
						'active' =>__('Active','vibe-apppointments'),
						'newest' =>__('Recently Added','vibe-apppointments'),
						'alphabetical' =>__('Alphabetical','vibe-apppointments'),
						'random'=>__('Random','vibe-apppointments'),
						'popular'=>__('Popular','vibe-apppointments')
					),
			'translations'=>array(
				'search_text'=>__('Type to search','vibe-apppointments'),
				'search_location'=>__('Search location','vibe-apppointments'),
				'availability'=>__('Availability','vibe-apppointments'),
				'price'=>__('Price','vibe-apppointments'),
				'any'=>__('Any','vibe-apppointments'),
				'all'=>__('All','vibe-apppointments'),
				'no_groups_found'=>__('No Classes found !','vibe-apppointments'),
				'show_filters'=>__('Show Filters','vibe-apppointments'),
				'close_filters'=>__('Close Filters','vibe-apppointments'),
				'clear_all'=>__('Clear All','vibe-apppointments'),
				'select_option'=>__('Select Option','vibe-apppointments'),
			)
		);
		//wp_localize_Script('vibe-apppointments-groups-directory-js','vibe-apppointmentsgroups',$this->args);
		if(bp_displayed_user_id()){
			$user_id = bp_displayed_user_id();
		}else{
			$user_id = get_current_user_id();
		}
		
		$args = array(
			'type'		=>$settings['order'],
			'per_page'	=>$settings['classes_per_page']['size']
		);
		if(!empty($settings['class_type']) && $settings['class_type'] != 'all'){
			$args['class_type'] = $settings['class_type'];
		}
		if(!function_exists('groups_get_groups'))
			return;
		$run = groups_get_groups($args);
    		
		if( count($run['groups']) ) {

			foreach($run['groups'] as $k=>$group){
				
				$run['groups'][$k]->avatar = bp_core_fetch_avatar(array(
                        'item_id' => $run['groups'][$k]->id,
                        'object'  => 'group',
                        'type'=> 'full',
                        'html'    => false
                    ));
			}
		}
		?>
		<div id="vibe_appointments_classes_directory" class="vibe_appointments_classes_directory_wrapper">
			<div class="vibe_apppointments_classes_directory_header">
			<?php
				if($settings['search_classes']){
					?>
					<div class="vibe_apppointments_classes_search">
						<input type="text" placeholder="<?php _e('Type to search','vibe-apppointments'); ?>" />
					</div>
					<?php
				}

				if(!empty($settings['class_type_filter'])){
					?>
					<div class="vibe_apppointments_classes_filter">
						<ul>
						<?php
						$class_types = bp_groups_get_class_types();
						
						if(!is_array($settings['class_type_filter']) || in_array('all',$settings['class_type_filter'])){
							echo '<li><a class="class_type all">'.__('All','vibe-apppointments').'</a></li>';
							foreach($class_types as $type=>$label){
									echo '<li><a class="class_type '.$type.'">'.$label.'</a></li>';
								}
						}else{ 
							foreach($settings['class_type_filter'] as $type){
								echo '<li><a class="class_type '.$type.'">'.$class_types[$type].'</a></li>';
							}
						}
						?>
						</ul>
					</div>
					<?php
				}

				if($settings['sort_classes']){

					$default_sorters = array(
						'active' =>__('Active','vibe-apppointments'),
						'newest' =>__('Recently Added','vibe-apppointments'),
						'alphabetical' =>__('Alphabetical','vibe-apppointments'),
						'random'=>__('Random','vibe-apppointments'),
						'popular'=>__('Popular','vibe-apppointments')
					);
					?>
					<div class="vibe_apppointments_classes_sort">
						<select>
							<?php
							foreach($default_sorters as $key => $val){
								echo '<option value="'.$key.'">'.$val.'</option>';
							}
							?>
						</select>
					</div>
					<?php
				
				}
			?>
			</div>
			<div class="vibe_apppointments_classes_directory <?php echo $settings['style'];?>">
				<?php 
				if( $run['total'] ){
					foreach($run['groups'] as $key=>$group){
						echo '<div class="vibe-apppointments_group">';
						
						if(empty($settings['class_card'])){
							echo '<a href="'.bp_get_group_permalink($group).'"><img src="'.$group->avatar.'" /></a>';
							echo '<span>'.$group->name.'</span>';
						}else{
							$layouts = new WP_Query(array(
								'post_type'=>'group-card',
								'p'=>$settings['class_card']
							));
							while($layouts->have_posts()){
								$layouts->the_post();
								global $post;
								echo '<div class="class_card_'.$post->post_name.'">';
								the_content();
								echo '</div>';
							}
							wp_reset_postdata();
						}
						
						echo '</div>';
					}
				}
				?>
			</div>
			<?php
			if( $run['total'] > count($run['groups'])){
				if($settings['class_pagination']){
					?>
					<div class="vibe_apppointments_class_directory_pagination">
						<span>1</span>
						<a class="page_name">2</a>
						<?php
							$end = ceil($run['total']/count($run['groups']));
							if($end === 3){
								echo '<a class="page_name">'.$end.'</a>';
							}else if($end > 3){
								echo '<span>...</span><a class="page_name">'.$end.'</a>';
							}
						?>
					</div>
					<?php
				}
			}
			?>
		</div>

		<?php

		if(!empty($settings['class_price'])){
	            $this->args['priceRange'] = $this->get_price_range();
	        }
		?>
		<script>
        	
        	var vibe_apppointments_classes= <?php echo json_encode($this->args);?>;
        	document.dispatchEvent(new Event('vibe_apppointments_classes'));
        </script>
		<?php
		
	}

	function pwa_styles($styles,$post_id){
		$upload_dir   = wp_upload_dir();
		if(file_exists($upload_dir['basedir'].'/elementor/css/post-'.$post_id.'.css')){
			$styles['elementor_specific_css']=$upload_dir['baseurl'].'/elementor/css/post-'.$post_id.'.css?v='.VIBE_APPOINTMENTS_PLUGIN_VERSION;	
		}
		return $styles;
	}

	function pwa_object($objects){
		$objects['vibe-apppointmentsgroups']= $this->args; 
		return $objects;
	}

	function get_groups_directory_scripts($settings=null){
		$scripts =  array('nouislider','flatpickr','wnumb','vibe-apppointments-groups-directory-js');
		if(!empty($settings['show_class_popup'])){
			$scripts[] = array('singlegroup');
			
		}

		return apply_filters('vibe-apppointments_members_directory_scripts',$scripts);
	}

		

	function get_groups_directory_styles(){
		$styles =  array('nouislider_css','vicons','vibe-apppointments-front');

		return apply_filters('vibe-apppointments_members_directory_styles',$styles);
	}


	function get_price_range(){
		global $wpdb,$bp;
		$results =[];
		$results = apply_filters('vibebpappointments_get_price_range',$results);
		if(empty($results)){
			$results = $wpdb->get_results("SELECT MIN(cast(meta_value as unsigned)) as min, MAX(cast(meta_value as unsigned)) as max FROM {$bp->groups->table_name_meta} WHERE meta_key='_appointment_price'");
		}
		
		if(!empty($results)){
			foreach($results as $result){
				if(empty($result->min)){$result->min =0;}
				if(empty($result->max)){$result->max =100;}
				if($result->min == $result->max){$result->min=0;}
				return array('min'=>$result->min,'max'=>$result->max);
			}
		}
	}
}