<?php
/**
 * Adds settings to the permalinks admin settings page.
 *
 * @class       Vibe_CustomTypes_Admin_Permalink_Settings
 * @author      VibeThemes
 * @category    Admin
 * @package     Vibe customtypes/Admin
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
 

class VIBE_Appointments_Update{


	public static $instance;
	
	public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new VIBE_Appointments_Update();
        return self::$instance;
    }

	private function __construct(){
		add_filter('vibebp_addon_class',array($this,'check_addon_license_status'),10,2);
		add_filter('vibebp_addons',array($this,'addon'));
		add_filter('admin_init',array($this,'vibebp_appointments_activate_license'));
		add_action('admin_init', array($this,'vibebp_appointments_deactivate_license'));
	}

	function addon($fields){
		$status = get_option('vibe_appointments_license_status');
		switch($status){
			case 'valid':
				$fields['vibe-appointments']['price'] = 'ACTIVE';
			break;
			case 'invalid':
				$fields['vibe-appointments']['price'] = 'INVALID LICENSE KEY';
			break;
			default:
				$fields['vibe-appointments']['price'] = 'IN-ACTIVE';
			break;
		}
		return $fields;
	}
	
	function check_addon_license_status($class,$addon){

		if($addon['license_key'] != 'vibe_appointments_license_key')
			return $class;

		$status = get_option('vibe_appointments_license_status');
		if(empty($status)){
			$class .=' inactive';
		}else{
			$class .=' '.$status;
		}

		return $class;
	}
	

	function sanitize_license( $new ) {
		$old = get_option( 'vibe_appointments_license_key' );
		if( $old && $old != $new ) {
			delete_option( 'vibe_appointments_license_status' ); // new license has been entered, so must reactivate
		}
		return $new;
	}



	/************************************
	* this illustrates how to activate
	* a license key
	*************************************/

	function vibebp_appointments_activate_license($message) {

		// listen for our activate button to be clicked
		if( empty($_POST['license_key']) || empty($_POST['vibe_appointments_license_key']) || $_POST['vibe_appointments_license_key'] != 'Activate') 
			return;

		if( ! check_admin_referer( 'vibe-appointments', 'vibe-appointments' ) )
			return; // get out if we didn't click the Activate button


		$license = trim($_POST['license_key']);
		// retrieve the license from the database
		
		$purchase_code = get_option('item_purchase_code');
		if(!empty($purchase_code)){
			$license_data = json_decode( wp_remote_retrieve_body(wp_remote_get('https://wpappointify.com/verify-purchase/?purchase_code='.$license.'&site='.home_url())),true);
			if(in_array($license_data['verify-purchase']['item_id'],VIBE_APPOINTMENTS_PRE_ACTIVATED_THEMES)){
				update_option( 'vibe_appointments_license_status' ,'valid');
			}
		}else{

			// data to send in our API request
			$api_params = array(
				'edd_action'=> 'activate_license',
				'license' 	=> $license,
				'item_id' => APPOINTMENTS_UPDATE_ITEM_ID, // the name of our product in EDD
				'url'       => home_url()
			);

			// Call the custom API.
			$response = wp_remote_post( APPOINTMENTS_UPDATE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );


			// make sure the response came back okay
			if ( is_wp_error( $response ) ){
				return __('Unable to contact server','vibe-appointments');
			}

			// decode the license data
			$license_data = json_decode( wp_remote_retrieve_body( $response ) );

			// $license_data->license will be either "valid" or "invalid"
			if(!empty($license)){
				update_option( 'vibe_appointments_license_status', $license_data->license );
				update_option('vibe_appointments_license_key',$license);
			}
		}
		
		return $message;
	}
	


	/***********************************************
	* Illustrates how to deactivate a license key.
	* This will descrease the site count
	***********************************************/

	function vibebp_appointments_deactivate_license() {

		if( empty($_POST['license_key']) || empty($_POST['vibe_appointments_license_key']) || $_POST['vibe_appointments_license_key'] != 'Deactivate') 
			return;

		// listen for our activate button to be clicked
		

		// run a quick security check
	 	if( ! check_admin_referer( 'vibe-appointments', 'vibe-appointments' ) )
			return; // get out if we didn't click the Activate button

		// retrieve the license from the database
		$license = trim( get_option( 'vibe_appointments_license_key' ) );


		// data to send in our API request
		$api_params = array(
			'edd_action'=> 'deactivate_license',
			'license' 	=> $license,
			'item_id' => APPOINTMENTS_UPDATE_ITEM_ID, // the name of our product in EDD
			'url'       => home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( APPOINTMENTS_UPDATE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );

		// make sure the response came back okay
		if ( is_wp_error( $response ) )
			return false;

		// decode the license data
		$license_data = json_decode( wp_remote_retrieve_body( $response ) );
		
		// $license_data->license will be either "deactivated" or "failed"
		if( $license_data->license == 'deactivated' ){
			delete_option( 'vibe_appointments_license_status' );
			delete_option( 'vibe_appointments_license_key' );
		}

		if($license_data->license == 'failed')
			delete_option( 'vibe_appointments_license_key' );
	}
	


	/************************************
	* this illustrates how to check if
	* a license key is still valid
	* the updater does this for you,
	* so this is only needed if you
	* want to do something custom
	*************************************/

	function vibe_appointments_check_license() {

		global $wp_version;

		$license = trim( get_option( 'vibe_appointments_license_key' ) );

		$api_params = array(
			'edd_action' => 'check_license',
			'license' => $license,
			'item_id' => APPOINTMENTS_UPDATE_ITEM_ID,
			'url'       => home_url()
		);

		// Call the custom API.
		$response = wp_remote_post( APPOINTMENTS_UPDATE_URL, array( 'timeout' => 15, 'sslverify' => false, 'body' => $api_params ) );


		if ( is_wp_error( $response ) )
			return false;

		$license_data = json_decode( wp_remote_retrieve_body( $response ) );

		if( $license_data->license == 'valid' ) {
			return 'valid';
			// this license is still valid
		} else {
			return 'invalid';
			// this license is no longer valid
		}
		return;
	}
}

VIBE_Appointments_Update::init();