<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class VIBE_APPOINTMENTS_DB extends WPAP_DB {
/**
 * Get things started
 *
 * @access  public
 * @since   1.0
*/
public function __construct() {
	global $wpdb;
	$this->table_name  = $wpdb->prefix . 'wplms_appointments';
	$this->primary_key = 'appointment_id';
	$this->version     = '1.0';
	$this->num_rows = array();
}
	
	/**
	 * Get columns and formats
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function get_columns() {
		return array(
			'appointment_id'    => '%d',
			'author_id' 		=> '%d',
			'booker_id' 		=> '%d',
			'start_date'       	=> '%d',
			'end_date'    		=> '%d',
			'start_time'       	=> '%d',
			'end_time'         	=> '%d',
			'type'     			=> '%s',
			'item_id'          	=> '%d',
			'parent_appointment_id' => '%d',
			'status'      		=> '%s',
			'date'        		=> '%s',
		);
	}
	/**
	 * Get default column values
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function get_column_defaults() {
		return array(
			'author_id' 		=> get_current_user_id(),
			'status'			=> 'open',
			'date'        		=> date( 'Y-m-d H:i:s' ),
		);
	}
	/**
	 * Retrieve orders from the database
	 *
	 * @access  public
	 * @since   1.0
	 * @param   array $args
	 * @param   bool  $count  Return only the total number of results found (optional)
	*/
	public function get_appointments( $args = array(), $count = false, $no_limit = false) {
		global $wpdb;
		$original_args = $args;
		$defaults = array(
			'number'       		=> 20,
			'offset'       		=> 0,
			'appointment_id' 	=> 0,
			'author_id' 		=> 0,
			'booker_id' 		=> 0,
			'start_date'       	=> 0,
			'end_date'    		=> 0,
			'start_time'       	=> 0,
			'end_time'         	=> 0,
			'type'     			=> '',
			'item_id'          	=> NULL,
			'status'       		=> '',
			'sort'				=> '',
			'orderby'      		=> 'appointment_id',
			'order'        		=> 'DESC',
			'join'				=> '',
			'range'				=> array()
		);
		$args  = wp_parse_args( $args, $defaults );

		$meta_db = new VIBE_APPOINTMENTS_META_DB;

		if(!empty($this->cached[$this->multi_implode('-',$args)])){
			return $this->cached[$this->multi_implode('-',$args)];
		}
		

		if( $args['number'] < 1 ) {
			$args['number'] = 999999999999;
		}
		$where = '';
		$join ='';

		// specific referrals
		if( ! empty( $args['appointment_id'] ) ) {
			
			if( is_array( $args['appointment_id'] ) ) {
				$appointment_id = implode( ',', $args['appointment_id'] );
			} else {
				$appointment_id = intval( $args['appointment_id'] );
			}
			$where .= "WHERE `appointment_id` IN( {$appointment_id} ) ";
		}

		// specific referrals
		if( isset( $args['parent_appointment_id'] ) ) {
			if( is_array( $args['parent_appointment_id'] ) ) {
				$parent_appointment_id = implode( ',', $args['parent_appointment_id'] );
			} else if(is_numeric($args['parent_appointment_id'])){
				$parent_appointment_id = intval( $args['parent_appointment_id'] );
			} 
			if(empty($where)){
				$where .=' WHERE ';
			}else{
				$where .=' AND ';
			}

			if($args['parent_appointment_id'] === 'EXISTS'){
				$where .= " `parent_appointment_id` > 0 ";
			}else if ($args['parent_appointment_id'] == 0 ){
				$where .= " ( `parent_appointment_id` IS NULL OR `parent_appointment_id` = 0 )";
			}else{
				$where .= " `parent_appointment_id` IN( {$parent_appointment_id} ) ";
			}
			
		}

		if( ! empty( $args['not_in'] ) ) {

			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			if( is_array( $args['not_in'] ) ) {
				$not_appointment_id = implode( ',', $args['not_in'] );
			} else {
				$not_appointment_id = intval( $args['appointment_id'] );
			}
			$where .= " `appointment_id` NOT IN( {$not_appointment_id} ) ";
		}

		

		if( !empty( $args['author_id'] ) ) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			if( is_array( $args['author_id'] ) ) {
				$where .= " `author_id` IN(" . implode( ",", $args['author_id'] ) . ") ";
			} else {
				$where .= " `author_id` = " . $args['author_id'] . " ";
			}
		}

		if( ! empty( $args['not_author'] ) ) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			
			if( is_array( $args['not_author'] ) ) {
				$where .= " `author_id` NOT IN(" . implode( ",", $args['not_author'] ) . ") ";
			} else {
				$where .= " `author_id` != " . $args['not_author'] . " ";
			}
		}

		if( ! empty( $args['booker_id'] ) ) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			$where .= " ( ";
			if($args['booker_id'] === 'EXISTS'){
				$where .= " `booker_id` > 0 ";
				$join .= " as A LEFT JOIN {$meta_db->table_name} as M ON A.appointment_id = M.appointment_id";
				$where .= " OR ( M.meta_key = 'booker_id' AND M.meta_value > 0  )";

			}else if ($args['booker_id'] === 0 ){
				$where .= " ( `parent_appointment_id` IS NULL OR `parent_appointment_id` = 0 )";
			}else {
				if( is_array( $args['booker_id'] ) ) {
					$where .= " `booker_id` IN( ".implode(',',$args['booker_id'])." ) ";
				}else{
					$where .= " `booker_id` = {$args['booker_id']} ";
					$join .= " as A LEFT JOIN {$meta_db->table_name} as M ON A.appointment_id = M.appointment_id";

					$join = apply_filters('vibe_appointments_booking_core_query_join_booker_id',$join);

					$where .= " OR ( M.meta_key = 'booker_id' AND M.meta_value =  {$args['booker_id']} )";
				}
			}
			$where .= " ) ";
		}

		if(!empty($args['metas'])){
			if(strpos($join, 'as A') === false ){
				$join .= ' as A ';
			}
			foreach($args['metas'] as $i=>$meta){

				$join .= " LEFT JOIN {$meta_db->table_name} as M{$i} ON  A.appointment_id = M{$i}.appointment_id";
				$where .= " AND M.meta_key = '{$meta['meta_key']}' AND M.meta_value =  {$meta['meta_value']} ";
			}
				
		}

		if( ! empty( $args['unit'] ) ) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			$where .= " ( ";
			if($args['unit'] === 'EXISTS'){
				$where .= " `unit` > 0 ";
			}else if ($args['unit'] === 0 ){
				$where .= " ( `parent_appointment_id` IS NULL OR `parent_appointment_id` = 0 )";
			}else {
				if( is_array( $args['unit'] ) ) {
					$where .= " `unit` IN( {$args['unit']} ) ";
				}else{
					$where .= " `unit` = {$args['unit']} ";
				}

				$join .= " as A LEFT JOIN {$wpdb->prefix}wplms_appointments_meta as M ON ( 
				A.appointment_id = M.appointment_id AND M.meta_key='unit' AND M.meta_value ={$args['unit']} ) ";
				$where .= " OR M.meta_value =  {$args['unit']} ";
			}
			$where .= " ) ";
		}

		if( ! empty( $args['start_date'] ) && ! empty( $args['end_date'] ) && empty($args['range'])) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			if($args['sort'] == 'on_and_upcoming' || $args['sort'] == 'upcoming'){
				$where .= " `end_date` >= " . $args['start_date'] . "AND `start_date` < " . $args['end_date'] . " ";
			}else if($args['sort'] == 'past'){
				$where .= " `start_date` < " . $args['start_date'] . "AND `end_date` < " . $args['end_date'] . " ";
			}else{
				$where .= "(( `start_date` >= " . $args['start_date'] . " AND `start_date` <=" . $args['end_date'] . " ) OR (`end_date` >= " . $args['start_date'] . " AND `end_date` <=" . $args['end_date'] . ") OR (".$args['start_date']." >= start_date AND ".$args['start_date']." <= end_date ) OR (".$args['end_date']." >= start_date AND ".$args['end_date']." <= end_date ))";
				
			}
		}else{
			if( ! empty( $args['start_date'] ) && empty($args['range'])) {
				//print_r($args['start_date']);
			
				if( empty( $where ) ) {
					$where .= " WHERE";
				} else {
					$where .= " AND";
				}

				if($args['sort'] == 'on_and_upcoming' || $args['sort'] == 'upcoming'){
					$where .= " `end_date` >= " . $args['start_date'] . " ";
				}else if($args['sort'] == 'past'){
					$where .= " `start_date` < " . $args['start_date'] . " ";
				}else{
					//if(! empty( $args['end_date'] ) ){
						//$where .= " `start_date` >= " . $args['start_date'] . " AND `start_date` <=" . $args['end_date'] . " ";
					//}else{
						$where .= " `start_date` >= " . $args['start_date'] . " ";
					//}
				}
				//print_r($where);
				
			}


			if( ! empty( $args['end_date'] )  && empty($args['range'])) {
				//print_r($args['end_date']);
				
				if( empty( $where ) ) {
					$where .= " WHERE";
				} else {
					$where .= " AND";
				}
				if($args['sort'] == 'past'){
					
					$where .= " `end_date` < " . $args['end_date'] . " ";
				}else if($args['sort'] == 'on_and_upcoming'  || $args['sort'] == 'upcoming'){
					
					$where .= " `start_date` < " . $args['end_date'] . " ";
				}else{

					//if(! empty( $args['start_date'] ) ){
						//$where .= " `end_date` >= " . $args['start_date'] . " AND `end_date` <=" . $args['end_date'] . " ";
					//}else{
						$where .= " `end_date` <= " . $args['end_date'] . " ";
					//}
					
				}
				//print_r($where);
			}
		}

		if( ! empty( $args['start_time'] ) && empty($args['range'])) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}


			if($args['sort'] == 'past'){
				$where .= " `start_time` < " . $args['start_time'] . " ";
			}else{
				$where .= " `start_time` >= " . $args['start_time'] . " ";
			}


			//print_r($where);

			
		}


		if( ! empty( $args['end_time'] ) && empty($args['range'])) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}


			if($args['sort'] == 'past'){
				$where .= " `end_time` < " . $args['end_time'] . " ";
			}else{
				$where .= " `end_time` <= " . $args['end_time'] . " ";
			}
		}


		if( isset( $args['item_id'] ) && $args['item_id']!==null && $args['item_id'] != 'any') {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			if( is_array( $args['item_id'] ) ) {
				$where .= " `item_id` IN(" . implode( ",", $args['item_id'] ) . ") ";
			} else if($args['item_id'] == 'none'){
				$where .= " ( `item_id` =  0 OR `item_id` =  NULL )";
			}else{
				$where .= " `item_id` = " . $args['item_id'] . " ";
			}
		}

		if( ! empty( $args['type'] ) ) {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			if( is_array( $args['type'] ) ) {
				$where .= " `type` IN('" . implode( "','", $args['type'] ) . "') ";
			} else {
				$where .= " `type` = '" . $args['type'] . "' ";
			}
		}

		if( ! empty( $args['status'] )  && $args['status'] != 'any') {
			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}
			if( is_array( $args['status'] ) ) {
				$where .= " `status` IN('" . implode( "','", $args['status'] ) . "') ";
			} else {
				$where .= " `status` = '" . $args['status'] . "' ";
			}
		}
		
		if( ! empty( $args['date'] ) ) {
			if( is_array( $args['date'] ) ) {
				if( ! empty( $args['date']['start'] ) ) {
					if( false !== strpos( $args['date']['start'], ':' ) ) {
						$format = 'Y-m-d H:i:s';
					} else {
						$format = 'Y-m-d 00:00:00';
					}
					$start = date( $format, strtotime( $args['date']['start'] ) );
					if( ! empty( $where ) ) {
						$where .= " AND `date` >= '{$start}'";
					} else {
						$where .= " WHERE `date` >= '{$start}'";
					}
				}
				if( ! empty( $args['date']['end'] ) ) {
					if( false !== strpos( $args['date']['end'], ':' ) ) {
						$format = 'Y-m-d H:i:s';
					} else {
						$format = 'Y-m-d 23:59:59';
					}
					$end = date( $format, strtotime( $args['date']['end'] ) );
					if( ! empty( $where ) ) {
						$where .= " AND `date` <= '{$end}'";
					} else {
						$where .= " WHERE `date` <= '{$end}'";
					}
				}
			} else {
				$year  = date( 'Y', strtotime( $args['date'] ) );
				$month = date( 'm', strtotime( $args['date'] ) );
				$day   = date( 'd', strtotime( $args['date'] ) );
				if( empty( $where ) ) {
					$where .= " WHERE";
				} else {
					$where .= " AND";
				}
				$where .= " $year = YEAR ( date ) AND $month = MONTH ( date ) AND $day = DAY ( date )";
			}
		}
		if(!empty($args['join'])){

			if(!empty($args['join']['from'])){
				$this->table_name .= ' as tn LEFT JOIN '.sprintf($args['join']['from'],' ON tn.'.$args['join']['on_p'].' = '.$args['join']['on_c']);
				
			}

			if(!empty($args['join']['where'])){
				$where .=' AND '.$args['join']['where'];
			}
		}

		if(!empty($args['range'])){
			//Here start_date and end_date of the ranges are correct
			//print_r($args);

			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			//$where .= '  ( (start_date >= '.$args['start_date'].' AND end_date <= '.$args['end_date'].' AND  start_time >= '.$args['start_time'].' AND end_time <= '.$args['end_time'].')'; 
			$time_ranges = array();
			$date_ranges = array();
			foreach($args['range'] as $range){
				if(in_Array('start_time',array_keys($range))){
					$time_ranges[]=$range;
				}else{
					$date_ranges[]=$range;
				}
			}

			$where .=' (';
			$date_range_added_inquery = true;
			foreach($date_ranges as $range){
				$keys = array_keys($range);
				foreach($keys as $key){
					if(strpos($key, 'start') !== false ){
						if($date_range_added_inquery){
							$where .= ' ( '.$key.' >= '.$range[$key];
							$date_range_added_inquery = false;
						}else{
							$where .= ' OR ( '.$key.' >= '.$range[$key];
						}
								
					}else{
						$where .= ' AND '.$key.' <= '.$range[$key].' )';
					}
				}
				
			}

			$time_range_added_inquery = true;
			$where .=') AND (';
			foreach($time_ranges as $range){
				$keys = array_keys($range);
				foreach($keys as $key){
					if(strpos($key, 'start') !== false ){
						if($time_range_added_inquery){
							$where .= ' ( '.$key.' >= '.$range[$key];
							$time_range_added_inquery = false;
						}else{
							$where .= ' OR ( '.$key.' >= '.$range[$key];
						}		
					}else{
						$where .= ' AND '.$key.' <= '.$range[$key].' )';
					}
				}
				
			}

			$where .=') )';
		}
		

		$args['orderby'] = ! array_key_exists( $args['orderby'], $this->get_columns() ) ? $this->primary_key : $args['orderby'];


		if(!empty($join)){
			$args['orderby'] =' A.'.$args['orderby'];
		}

		$args['orderby'] = ' ORDER BY '.$args['orderby'];
		if(empty($args['group_by'])){
			if(empty($join)){
				$args['group_by'] = ' appointment_id';
			}else{
				$args['group_by'] = ' A.appointment_id';	
			}
			
		}
		if(!empty($args['group_by'])){
			$args['orderby'] = 'GROUP BY '.$args['group_by'].$args['orderby'];
		}

			
		if ( true === $count ) {
			//print_R('#');
			if($this->primary_key == 'appointment_id'){
				$this->primary_key = 'A.appointment_id';
			}

			if(empty($join)){
				$join .= " as A ";
			}
			if(true===$no_limit){
				$results = absint( $wpdb->get_var("SELECT COUNT({$this->primary_key}) FROM {$this->table_name} {$join} {$where} {$args['orderby']} {$args['order']} " ) );
			}else{
				$results = absint( 
				$wpdb->get_var(
					$wpdb->prepare("SELECT COUNT({$this->primary_key}) FROM {$this->table_name} {$join} {$where} {$args['orderby']} {$args['order']} LIMIT %d, %d;",absint( $args['offset'] ),absint( $args['number'] ) )));
			}
			
		} else {
			if(empty($join)){
				$select = '*';
			}else{
				$select = 'A.*';
			}
			$query = $wpdb->prepare(
					"SELECT {$select} FROM {$this->table_name} {$join} {$where} {$args['orderby']} {$args['order']} LIMIT %d, %d;",absint( $args['offset'] ),absint( $args['number'] )
				);
			
			//print_R($query);
			$results = $wpdb->get_results(
				$query,ARRAY_A
			);
			$this->num_rows[$this->multi_implode('-',$original_args)] = $wpdb->num_rows;

		}


		$this->cached[$this->multi_implode('-',$args)] = $results;

		return $results;
	}

	/**
	 * Retrieves the number of results found for a given query.
	 *
	 * @access public
	 * @since  1.0
	 *
	 * @param array $args Optional. Any valid get_appointments() arguments. Default empty array.
	 * @return int Number of appointments found for the given arguments.
	 */
	public function count( $args = array() ) {
		return $this->get_appointments( $args, true );
	}

	public function num_rows($args = array()){
		if(!empty($this->num_rows[$this->multi_implode('-',$args)]))
		return $this->num_rows[$this->multi_implode('-',$args)];
	}

	/**
	 * Retrieve orders from the database
	 *
	 * @access  public
	 * @since   1.0
	 * @param   array $args
	 * @param   bool  $count  Return only the total number of results found (optional)
	*/
	public function get_appointment( $args = array()){


	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function book_appointment($data = array()){

		$defaults = array(
			'booker_id' 		=> get_current_user_id(),
			'type'     			=> 'open',
			'status'      		=> 'open',
		);

		$args = wp_parse_args( $data, $defaults );
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function insert_appointment( $data = array()){
		$defaults = array(
			'author_id' 		=> get_current_user_id(),
			'type'     			=> 'open',
			'status'      		=> 'open',

		);
		$args = wp_parse_args( $data, $defaults );
		if ( empty( $args['date'] ) ) {
			unset( $args['date'] );
		} else {
			$time = strtotime( $args['date'] );
			$args['date'] = gmdate( 'Y-m-d H:i:s' );
		}

		$add = $this->insert( $args, 'appointment' );
		if ( $add ) {
			/**
			 * Fires immediately after a appointment has been added to the database.
			 *
			 * @param array $add The appointment data being added.
			 */
			do_action( 'vibe_appointment_insert_appointment', $add );
			return $add;
		}
		return false;
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function update_appointment( $data = array()){
		$defaults = array(
			
		);
		$args = wp_parse_args( $data, $defaults );
		
		$add = $this->update($args['appointment_id'],$args);
		if ( $add ) {
			/**
			 * Fires immediately after a appointment has been added to the database.
			 *
			 * @param array $add The appointment data being added.
			 */
			do_action( 'vibe_appointment_update_appointment', $add );
			return $add;
		}
		return false;
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function delete_appointment( $appointment_id){
		if(empty($appointment_id))
			return false;

		$this->delete($appointment_id);
		$meta_db = new VIBE_APPOINTMENTS_META_DB;
		$metas = $meta_db->get_appointments_meta(['appointment_id'=>$appointment_id]);
		if(!empty($metas)){
			foreach($metas as $meta){
				$meta_db->delete_appointment_meta($meta['meta_id']);
			}
		}
	}

	/**
	 * Checks if an appointment exists.
	 *
	 * @access public
	 * @since  1.0
	 *
	 * @return bool True if the affiliate exists, otherwise false.
	*/
	public function appointment_exists( $args ) {
		global $wpdb;
		
		$exists = $wpdb->query( $wpdb->prepare("SELECT 1 FROM {$this->table_name} WHERE %s", $args));
		return ! empty( $exists );
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function create_table() {
		global $wpdb;
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		$sql = "CREATE TABLE " . $this->table_name . " (
		appointment_id bigint(20) NOT NULL AUTO_INCREMENT,
		author_id bigint(20) NOT NULL,
		booker_id bigint(20) NULL,
		start_date bigint(20) NOT NULL,
		end_date bigint(20) NOT NULL,
		start_time int(20) NOT NULL,
		end_time int(20) NOT NULL,
		type varchar(30) NULL,
		item_id bigint(20) NULL,
		status varchar(30) NOT NULL,
		parent_appointment_id bigint(20) NULL,
		date datetime NOT NULL,
		PRIMARY KEY  (appointment_id)
		) CHARACTER SET utf8 COLLATE utf8_general_ci;";

		dbDelta( $sql );
		update_option( $this->table_name . '_db_version', $this->version );
	}

	function multi_implode($glue,$array ) {
	    $ret = '';
	    if(!empty($array) && is_array($array)){
	    	foreach ($array as $item) {
		        if (is_array($item)) {
		            $ret .= $this->multi_implode($glue,$item) . $glue;
		        } else {
		            $ret .= $item . $glue;
		        }
		    }
	    }
	    

	    $ret = substr($ret, 0, 0-strlen($glue));

	    return $ret;
	}
}