<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class VIBE_APPOINTMENTS_META_DB extends WPAP_DB {
/**
 * Get things started
 *
 * @access  public
 * @since   1.0
*/
public function __construct() {
	global $wpdb;
	$this->table_name  = $wpdb->prefix . 'wplms_appointments_meta';
	$this->primary_key = 'meta_id';
	$this->version     = '1.0';
}
	
	/**
	 * Get columns and formats
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function get_columns() {
		return array(
			'meta_id'			=> '%d',
			'appointment_id'    => '%d',
			'meta_key' 			=> '%s',
			'meta_value' 		=> '%s',
		);
	}

	public function get_table_name(){
		return $this->table_name;
	}
	/**
	 * Get default column values
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function get_column_defaults() {
		return array();
	}
	/**
	 * Retrieve orders from the database
	 *
	 * @access  public
	 * @since   1.0
	 * @param   array $args
	 * @param   bool  $count  Return only the total number of results found (optional)
	*/
	public function get_appointments_by_meta( $args = array(), $count = false ) {
		global $wpdb;
		$defaults = array(
			'number'       		=> 20,
			'offset'       		=> 0,
			'appointment_id' 	=> 0,
			'orderby'      		=> 'meta_id',
			'order'        		=> 'DESC',
		);
		$args  = wp_parse_args( $args, $defaults );
		if( $args['number'] < 1 ) {
			$args['number'] = 999999999999;
		}
		$where = '';
		// specific referrals
		if( ! empty( $args['appointment_id'] ) ) {
			if( is_array( $args['appointment_id'] ) ) {
				$appointment_id = implode( ',', $args['appointment_id'] );
			} else {
				$appointment_id = intval( $args['appointment_id'] );
			}
			$where .= "WHERE `appointment_id` IN( {$appointment_id} ) ";
		}

		// specific referrals
		if( isset( $args['parent_appointment_id'] ) ) {
			if( is_array( $args['parent_appointment_id'] ) ) {
				$parent_appointment_id = implode( ',', $args['parent_appointment_id'] );
			} else if(is_numeric($args['parent_appointment_id'])){
				$parent_appointment_id = intval( $args['parent_appointment_id'] );
			} 

			if($args['parent_appointment_id'] === 'EXISTS'){
				$where .= "WHERE `parent_appointment_id` > 0 ";
			}else if ($args['parent_appointment_id'] === 0 ){
				$where .= "WHERE ( `parent_appointment_id` IS NULL OR `parent_appointment_id` = 0 )";
			}else{
				$where .= "WHERE `parent_appointment_id` IN( {$parent_appointment_id} ) ";
			}
			
		}

		if( ! empty( $args['not_in'] ) ) {
			if( is_array( $args['not_in'] ) ) {
				$not_appointment_id = implode( ',', $args['not_in'] );
			} else {
				$not_appointment_id = intval( $args['appointment_id'] );
			}
			$where .= "WHERE `appointment_id` NOT IN( {$not_appointment_id} ) ";
		}


		$args['orderby'] = ! array_key_exists( $args['orderby'], $this->get_columns() ) ? $this->primary_key : $args['orderby'];
		if ( 'total' === $args['orderby'] ) {
			$args['orderby'] = 'total+0';
		} else if ( 'subtotal' === $args['orderby'] ) {
			$args['orderby'] = 'subtotal+0';
		}


		
		if ( true === $count ) {
			$results = absint( $wpdb->get_var( "SELECT COUNT({$this->primary_key}) FROM {$this->table_name} {$where};" ) );
		} else {

			/*print_r($wpdb->prepare(
					"SELECT * FROM {$this->table_name} {$where} ORDER BY {$args['orderby']} {$args['order']} LIMIT %d, %d;",
					absint( $args['offset'] ),
					absint( $args['number'] )
				));*/
			$results = $wpdb->get_results(
				$wpdb->prepare(
					"SELECT * FROM {$this->table_name} {$where} ORDER BY {$args['orderby']} {$args['order']} LIMIT %d, %d;",
					absint( $args['offset'] ),
					absint( $args['number'] )
				),ARRAY_A
			);
		}
	


		return $results;
	}

	/**
	 * Retrieves the number of results found for a given query.
	 *
	 * @access public
	 * @since  1.0
	 *
	 * @param array $args Optional. Any valid get_appointments() arguments. Default empty array.
	 * @return int Number of appointments found for the given arguments.
	 */
	public function count( $args = array() ) {
		return $this->get_appointments_by_meta( $args, true );
	}
	/**
	 * Retrieve orders from the database
	 *
	 * @access  public
	 * @since   1.0
	 * @param   array $args
	 * @param   bool  $count  Return only the total number of results found (optional)
	*/
	public function get_appointments_meta( $args = array()){

		global $wpdb;
		$defaults = array(
			'appointment_id'    => 0,
			'meta_key' 			=> 0,
			'orderby'      		=> 'meta_id',
			'order'        		=> 'DESC',
			'offset'			=>0,
			'number'			=>999,
		);
		$args  = wp_parse_args( $args, $defaults );

		$where = '';
		// specific referrals
		if( ! empty( $args['appointment_id'] ) ) {
			if( is_array( $args['appointment_id'] ) ) {
				$appointment_id = implode( ',', $args['appointment_id'] );
			} else {
				$appointment_id = intval( $args['appointment_id'] );
			}
			$where .= "WHERE `appointment_id` IN( {$appointment_id} ) ";
		}

		// specific referrals
		if( ! empty( $args['meta_key'] ) ) {

			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			if( is_array( $args['meta_key'] ) ) {
				$meta_key = "'".implode( "','", $args['meta_key'] )."'";
			} else {
				$meta_key = "'".$args['meta_key']."'" ;
			}
			$where .= " `meta_key` IN( {$meta_key} ) ";
		}

		// specific referrals
		if( ! empty( $args['meta_value'] ) ) {

			if( empty( $where ) ) {
				$where .= " WHERE";
			} else {
				$where .= " AND";
			}

			if( is_array( $args['meta_value'] ) ) {
				$meta_value = implode( ',', $args['meta_value'] );
			} else {
				$meta_value =  $args['meta_value'] ;
			}
			$where .= " `meta_value` IN( {$meta_value} ) ";
		}
		
		// print_r($wpdb->prepare(
		// 		"SELECT * FROM {$this->table_name} {$where} ORDER BY {$args['orderby']} {$args['order']} LIMIT %d, %d;",
		// 		absint( $args['offset'] ),
		// 		absint( $args['number'] )
		// 	));
		
		$results = $wpdb->get_results(
			$wpdb->prepare(
				"SELECT * FROM {$this->table_name} {$where} ORDER BY {$args['orderby']} {$args['order']} LIMIT %d, %d;",
				absint( $args['offset'] ),
				absint( $args['number'] )
			),ARRAY_A
		);

		return $results;
	}
	
	/**
	 * insert the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function add_appointment_meta( $data = array()){
		$defaults = array(
			'appointment_id'	=> 0,
			'meta_key'      	=> '',
			'meta_value'		=> ''
		);

		$args = wp_parse_args( $data, $defaults );
		$add = $this->insert( $args, 'appointment_meta' );
		if($add){
			do_action( 'wplms_appointment_update_appointment_meta', $add,$args );
			return $add;
		}
	}

	/**
	 * Update the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function update_appointment_meta( $data = array()){
		$defaults = array(
			'meta_id'			=>0,
			'appointment_id'	=> 0,
			'meta_key'      	=> '',
			'meta_value'		=> '',
			'single'			=> 1,
		);

		$args = wp_parse_args( $data, $defaults );
		if(empty($args['meta_id']) && !empty($args['appointment_id']) && (!empty($args['meta_key']) || !empty($args['meta_value']))) {


			if(is_array($args['meta_value'])){
				unset($args['meta_value']);
			}


			$get_args = $args;

			// if(!empty($get_args['meta_value'])){ <-- commented as to Match meta_value if it has been supplied
			// 	unset($get_args['meta_value']);	
			// }
			
			$metas = $this->get_appointments_meta($get_args);
			
			if(!empty($metas)){
				foreach($metas as $meta){

					unset($args['meta_id']);
					$add = $this->update($meta['meta_id'],$args);
					if($args['single']){
						if($add){
							do_action( 'wplms_appointment_update_appointment_meta', $add,$args );
							return $add;
						}
					}
				}
			}else{
				unset($args['meta_id']);
				unset($args['single']);

				
				$add = $this->insert( $args, 'appointment_meta' );
				if($add){
					do_action( 'wplms_appointment_update_appointment_meta', $add,$args );
					return $add;
				}
			}
		}else if(!empty($args['meta_id'])){
			unset($args['meta_id']);

			if(is_array($args['meta_value'])){
				$args['meta_value']=serialize($args['meta_value']);
			}
			$add = $this->update($meta['meta_id'],$args);
			if($add){
				do_action( 'wplms_appointment_update_appointment_meta', $add,$args );
				return $add;
			}
		}
		
		if ( $add ) {
			/**
			 * Fires immediately after a appointment has been added to the database.
			 *
			 * @param array $add The appointment data being added.
			 */
			do_action( 'wplms_appointment_update_appointment', $add,$args );
			return $add;
		}
		return false;
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function delete_appointment_meta( $meta){
		
		if(is_array($meta)){
			$c = $this->get_appointments_meta(['appointment_id'=>$meta['appointment_id'],'meta_key'=>$meta['meta_key'],'meta_value'=>$meta['meta_value']]); 
			
			if(empty($c))
				return false;

			$meta_id = $c[0]['meta_id'];
		}
		if(is_numeric($meta)){
			$meta_id = $meta;
		}
		if(empty($meta_id)){
			return false;
		}

		$this->delete($meta_id);
	}

	/**
	 * Checks if an appointment exists.
	 *
	 * @access public
	 * @since  1.0
	 *
	 * @return bool True if the affiliate exists, otherwise false.
	*/
	public function appointment_meta_exists( $args ) {
		global $wpdb;
		
		$exists = $wpdb->query( $wpdb->prepare("SELECT 1 FROM {$this->table_name} WHERE %s", $args));
		return ! empty( $exists );
	}
	/**
	 * Create the table
	 *
	 * @access  public
	 * @since   1.0
	*/
	public function create_table() {
		global $wpdb;
		require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
		$sql = "CREATE TABLE " . $this->table_name . " (
		meta_id bigint(20) NOT NULL AUTO_INCREMENT,
		appointment_id bigint(20) NOT NULL,
		meta_key varchar(30) NOT NULL,
		meta_value longtext NOT NULL,
		PRIMARY KEY  (meta_id)
		) CHARACTER SET utf8 COLLATE utf8_general_ci;";

		dbDelta( $sql );
		update_option( $this->table_name . '_db_version', $this->version );
	}
}