<?php
/**
 *  Vibe Appointments Filters
 *
 * @author 		VibeThemes
 * @category 	Init
 * @package 	vibe-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}



class Vibe_Appointments_Filters{


	public static $instance;
    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new Vibe_Appointments_Filters();
        return self::$instance;
    }

    function __construct(){
        add_filter('vibebp_component_icon',array($this,'set_icon'),10,2);
        add_filter('vibe_appointments_appointment_meta',array($this,'filter_meta'),10,3);
        add_filter('vibeappointments_script_args',array($this,'add_meetings'));

        add_filter('wplms_appointments_cart_timer',array($this,'apply_cart_timer'));
        add_filter('woocommerce_cart_item_name',array($this,'add_cart_timer'),10,2);

        add_filter('wplms_course_creation_tabs',array($this,'appointment_unit_type_block'));
        add_filter('wplms_get_course_tabs',array($this,'wplms_get_course_tabs'),10,3);
        add_filter('vibebp_group_tabs',array($this,'add_apt_tab'),10,3);

        add_filter('bp_course_api_get_user_course_status_item_unit_meta',array($this,'update_unit_meta_component'),10,3);

        //commissions filters
        add_filter('vibe_get_instructor_commissions_chart',array($this,'vibe_get_instructor_commissions_chart'),10,2);
        add_filter('vibe_get_instructor_commissions_data',array($this,'vibe_get_instructor_commissions_data'),10,2);
        add_filter('vibe_earnings_generate_commission_data',array($this,'vibe_earnings_generate_commission_data'),10,2);
        add_filter('vibe_eranings_get_instructor_commissions_data_label',array($this,'vibe_eranings_get_instructor_commissions_data_label'),10,4);
        


        add_filter('get_vibebp_instructor_commission',array($this,'get_vibebp_instructor_commission'),10,4);

        add_filter('vibebp_featured_taxonomy_styles_options',array($this,'service_type_block'));
        add_filter('vibebp_featured_post_type_styles_options',array($this,'service_block'));
        add_filter('vibebp_featured_members_styles_options',array($this,'booker_blocks'));
        
        
        add_action('addition_slot_data',array($this,'addition_slot_data'),10,2);

        add_filter('vibe_appointments_commision_value',array($this,'vibe_appointments_commision_value'),10,3);
        add_filter('vibebp_carousel_args',[$this,'no_swipe_class']);
        add_action( 'woocommerce_product_query', [$this,'hidden_products'] );

        add_filter('vibebp_vars',array($this,'hours_purchase'));

        add_filter('vibebp_group_tabs',array($this,'check_bookings'),10,3);

        add_filter('vibebp_group_layout_data_element',array($this,'data_element'));
        add_filter('vibe_appointments_dispute_action',array($this,'dispute_action'),10,2);

    }

    function get_vibebp_instructor_commission($results,$start_date,$end_date){
        $andWhere = '';
        if($start_date && $end_date) {
              // date format in php would be : Y-m-d
            $start_date = date('Y-m-d',strtotime($start_date));
            $end_date = date('Y-m-d',strtotime($end_date));
            $andWhere = "AND activity.date_recorded BETWEEN '$start_date' AND '$end_date'";
        }
        global $wpdb,$bp;
        $commissions = array();
        $a_results = $wpdb->get_results( "
                                    SELECT activity.user_id,activity.item_id as course_id,meta.meta_value as commission,meta2.meta_value as currency
                                    FROM {$bp->activity->table_name} AS activity 
                                    LEFT JOIN {$bp->activity->table_name_meta} as meta ON activity.id = meta.activity_id
                                    LEFT JOIN {$bp->activity->table_name_meta} as meta2 ON activity.id = meta2.activity_id
                                    WHERE     activity.component     = 'appointment'
                                    AND     activity.type     = 'appointment_commission'
                                    AND     meta.meta_key   LIKE '_commission%'
                                    AND     meta2.meta_key   LIKE '_currency%'".$andWhere, 
                                    ARRAY_A);
        if(!empty($a_results)){
           $results =  array_merge($a_results,$results);
        }
        return $results;
    }

    function data_element($args){
        $args['class_rating']=esc_html__('Class Rating','vibe-appointments');
        $args['class_reviews']=esc_html__('Class Reviews','vibe-appointments');
        $args['class_instructor']=esc_html__('Class Instructor','vibe-appointments');
        $settings = vibe_appointments_get_settings();
        if(!empty($settings['class_price'])){
            $args['class_price']=esc_html__('Class Price','vibe-appointments');    
        }
        return $args;
    }

    function check_bookings($tabs,$group_id,$user_id){

        global $wpdb;

        $meta_db = new VIBE_APPOINTMENTS_META_DB;
        $booking_count = $wpdb->get_var($wpdb->prepare("
            SELECT count(*) FROM {$meta_db->table_name} 
            WHERE meta_key = 'group_id' AND meta_value = %d",$group_id));

        if(!empty($booking_count)){
            $tabs['vibe_appointments'] = esc_html__('Booking','vibe-appointments');
        }
        return $tabs;
    }

    function hours_purchase($args){
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        if(!empty($this->settings['credit_hours']) && empty($args['settings']['google_play_products'])){
            $args['settings']['google_play_products']=[1=>1];    
        }
        return $args;
    }


    function hidden_products( $query ){
        
        if( !is_admin()) {
            $current_meta = $query->get('meta_query');
            
            $meta_query= $current_meta;
            $meta_query['relation'] = 'AND';

            $custom_meta = array(
                'key' => '_appointment_price',
                'value'=>'',
                'compare' => 'NOT EXISTS'
            );
            $meta_query[]= $custom_meta;
            $custom_meta = array(
                'key' => '_appointments_service_price',
                'value'=>'',
                'compare' => 'NOT EXISTS'
            );

            $meta_query[]= $custom_meta;

            $custom_meta = array(
                'key' => 'vibe_wplms',
                'value'=>'',
                'compare' => 'NOT EXISTS'
            );
            $meta_query[]= $custom_meta;


            $query->set('meta_query', array($meta_query));
            
            
        }
    }

    function no_swipe_class($args){
        $args['noSwipingClass']='swiper-no-swiping';
        return $args;
    }

    function vibe_appointments_commision_value($commission,$order_details,$appointment){
        
        //50 Array ( [appointment_id] => 95 [author_id] => 1 [booker_id] => 3 [start_date] => 1648654320000 [end_date] => 1648657920000 [start_time] => 932 [end_time] => 992 [type] => service [item_id] => 510 [status] => open [parent_appointment_id] => [date] => 2022-03-28 17:33:16 )
        
        if(empty($this->settings)){
            $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        $percentage = null;
        if(empty($appointment['appointment_id'])){
            return $commission;
        }
        if(empty($appointment['item_id'])){
            $appointments_db = new VIBE_APPOINTMENTS_DB;
            $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
            $appointments = $appointments_db->get_appointments(array('appointment_id'=>$appointment['appointment_id']));
            if(!empty($appointments[0])){
                $appointment['item_id'] = $appointments[0]['item_id'];
            }
        }
        if(!empty($appointment['item_id'])){
            if(!empty($this->settings['service_commissions'][$appointment['item_id']])){
                $percentage=intval($this->settings['service_commissions'][$appointment['item_id']]);
            }
        }

        if($percentage===null && !empty($this->settings['global_commission_percentage'])){
            $percentage = intval($this->settings['global_commission_percentage']);
        }
        $commission = floatval($commission);

       
        if($percentage!==null){
            $commission= round((($commission*$percentage)/100),2);
        }
     
        return $commission;
    }

    function addition_slot_data($sar,$slot){
        if(!empty($slot['item_id'])){
            if(get_post_type($slot['item_id']) == 'service'){
                $sar =[
                    'id'=>$slot['item_id'],
                    'title'=>get_the_title($slot['item_id']),
                    'image'=>get_the_post_thumbnail_url($slot['item_id']),
                ];
                if(empty($this->settings)){
                    $this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
                }
                if(!empty($this->settings['service_colors'][$slot['item_id']])){
                    $sar['color']=$this->settings['service_colors'][$slot['item_id']];
                } 
            }
            $appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
            $disputed = $appointments_meta_db->get_appointments_meta(['appointment_id'=>$slot['appointment_id'],'meta_key'=>'dispute']);

            if(!empty($disputed)){
                $sar['disputed']=1;
            }
        }
        return $sar;
    }

 
    function service_type_block($styles){
        $styles['service_type'] = 'Service Type';
        $styles['service_type_alt'] = 'Service Type Alt';
        return $styles;
    }
    function service_block($styles){
        $styles['service_block'] = 'Service Block';
        $styles['service_adblock'] = 'Service Ad Block';
        return $styles;
    }

    function booker_blocks($styles){
        $styles['booking_tutor'] = 'Booking Tutor';
        $styles['booking_tutor1'] = 'Booking Tutor Alt';
        return $styles;
    }

    function vibe_eranings_get_instructor_commissions_data_label($title,$cid,$source,$sales){
        if($source=='appointment'){
            $db = new VIBE_APPOINTMENTS_DB;
            $slots = $db->get_appointments(array(
                'appointment_id'=>$cid,
            ));
            if(!empty($slots)){
                if(!empty($slots[0]['item_id'])){
                    $title = get_the_title($slots[0]['item_id']);
                }else{
                    $title = _x('General Appointment','','vibe-appointments');
                }
                
            }
        }
        return $title;
    }

    function vibe_earnings_generate_commission_data($results,$user_id){
        $start_date = date("Y")."-01-01";
        //$end_date = date('Y-m-d',strtotime($end_date));
        $end_date = date("Y")."-12-31";
        global $wpdb,$bp;
        $commissions = array();
        $_results = $wpdb->get_results( "
                                      SELECT activity.user_id,activity.item_id as course_id,meta.meta_value as commission,meta2.meta_value as currency,MONTH(activity.date_recorded) as date,
                                      activity.component as source
                                      FROM {$bp->activity->table_name} AS activity 
                                      LEFT JOIN {$bp->activity->table_name_meta} as meta ON activity.id = meta.activity_id
                                      LEFT JOIN {$bp->activity->table_name_meta} as meta2 ON activity.id = meta2.activity_id
                                      WHERE     activity.component     = 'appointment'
                                      AND     activity.type     = 'appointment_commission'
                                      AND     activity.user_id     = {$user_id}
                                      AND     meta.meta_key   LIKE '_commission%'
                                      AND     meta2.meta_key   LIKE '_currency%'
                                      AND activity.date_recorded BETWEEN '$start_date' AND '$end_date' ORDER BY activity.date_recorded ASC
                                      ",ARRAY_A);
        if(!empty($_results)){
            foreach ($_results as $key => $r) {
                
                $results[] = $r;
            }
        }
        return $results;
    }

    function vibe_get_instructor_commissions_data($return, $request){

        $user_id = $request->get_param('id');
        $count = $request->get_param('count');
        $paged = $request->get_param('page');
        $per_page = $request->get_param('per_page');    
        $course_id =$request->get_param('course_id');   
        $date_start = $request->get_param('date_start');    
        $date_end = $request->get_param('date_end');
        $student_id = $request->get_param('student_id');
        $currency = $request->get_param('currency');
        $data = [];
        if(empty($course_id)){
            if(empty($paged)){
                $paged = 1;
            }
            $offset= ($paged-1)*$per_page;

            $and_where = "";
            if(!empty($date_start) && !empty($date_end)){
                
                $start_date = date('Y-m-d h:m:s',$date_start);
                $end_date = date('Y-m-d h:m:s',$date_end);
                $and_where  .= " AND activity.date_recorded BETWEEN '$start_date' AND '$end_date' ";
            }
            else{
                $and_where .= ' AND YEAR(activity.date_recorded) = YEAR(CURRENT_TIMESTAMP)';
            }

            if(!empty($currency)) {
                $and_where .= " AND meta2.meta_value = '".$currency."' ";
            }

            
            

            global $wpdb;
            global $bp;
            $results = [];
            if(!empty($count)){
                $count = $wpdb->get_results( "
                              SELECT count(*) as count
                              FROM {$bp->activity->table_name} AS activity 
                              LEFT JOIN {$bp->activity->table_name_meta} as meta ON activity.id = meta.activity_id
                              LEFT JOIN {$bp->activity->table_name_meta} as meta2 ON activity.id = meta2.activity_id
                              WHERE     activity.component     = 'appointment'
                              AND     activity.type     = 'appointment_commission'
                              AND     activity.user_id     = {$user_id}
                              AND     meta.meta_key   LIKE '_commission%'
                              AND     meta2.meta_key   LIKE '_currency%'
                              ".$and_where."
                              ORDER BY activity.date_recorded ASC",ARRAY_A);
                $count[0]['status'] =1;

                $return = $count[0];

            }else{
                $results = $wpdb->get_results( "
                                              SELECT activity.secondary_item_id as order_item_id,activity.item_id as course_id,meta.meta_value as commission,meta2.meta_value as currency,activity.date_recorded as date
                                              FROM {$bp->activity->table_name} AS activity 
                                              LEFT JOIN {$bp->activity->table_name_meta} as meta ON activity.id = meta.activity_id
                                              LEFT JOIN {$bp->activity->table_name_meta} as meta2 ON activity.id = meta2.activity_id
                                              WHERE     activity.component     = 'appointment'
                                              AND     activity.type     = 'appointment_commission'
                                              AND     activity.user_id     = {$user_id}
                                              AND     meta.meta_key   LIKE '_commission%'
                                              AND     meta2.meta_key   LIKE '_currency%'
                                              ".$and_where."
                                              ORDER BY activity.date_recorded ASC
                                              LIMIT ".$offset.", ".$per_page,ARRAY_A);
                
                $data = $results;
                if(!empty($data) && isset($data)) {
                    foreach($data as $key =>$value) {
                        $user_id = $this->get_user_id_by_order_item_id($value['order_item_id']);
                        $results[$key]['user_id'] = $user_id;
                    }
                }
                
            }
            if(!empty($return['data'])){
                $return['data'] = array_merge($return['data'],$results);
            }else{
                $return['data'] =$results;
            }
        }
        return $return;
    }

    function vibe_get_instructor_commissions_chart($return, $request){
        $user_id = $request->get_param('id');
        $course_id =$request->get_param('course_id');   
        $date_start = $request->get_param('date_start');    
        $date_end = $request->get_param('date_end');
        $currency = $request->get_param('currency');
        $chart_data = Array();
        $cdata = Array();

        if(empty($course_id)){

            $months=Array(
                _x('January','api call','vibe-appointments'),
                _x('February','api call','vibe-appointments'),
                _x('March','api call','vibe-appointments'),
                _x('April','api call','vibe-appointments'),
                _x('May','api call','vibe-appointments'),
                _x('June','api call','vibe-appointments'),
                _x('July','api call','vibe-appointments'),
                _x('August','api call','vibe-appointments'),
                _x('September','api call','vibe-appointments'),
                _x('October','api call','vibe-appointments'),
                _x('November','api call','vibe-appointments'),
                _x('December','api call','vibe-appointments')
            );

            foreach($months as $key =>  $value){
                $chart_data[$key+1]['name'] = $value;
                $chart_data[$key+1]['commission'] = 0;

            }

            $and_where = '';
            $start_date = '';
            $end_date = '';
            $group_by = ' GROUP BY select_parameter';
            $select = 'MONTH(activity.date_recorded) as select_parameter';

            if(!empty($date_start) && !empty($date_end)){
                $date_range  = round(($date_end - $date_start)/60/60/24);
                $start_date = date('Y-m-d H:i:s',$date_start);
                $end_date = date('Y-m-d H:i:s',$date_end);
                $and_where  .= " AND activity.date_recorded BETWEEN '$start_date' AND '$end_date' ";

                if($date_range <= 1 && !empty($start_date)){
        //time On Day

                    $chart_data = Array();
                    $group_by = ' GROUP BY select_parameter';
                    $select = 'activity.date_recorded as select_parameter'; 
                }
                if($date_range >= 2 && $date_range <= 7){
        //daily
                    $chart_data = Array();
                    $startDate = (int)date('j', $date_start);
                    $endDate = (int)date('j', $date_end);
                    
                    $date_format = get_option('date_format');   
                    for($i = $date_start; $i <= $date_end; $i+=86400) {

                        $value = date($date_format, $i);
                        $index = date("Y-m-d", $i);
                        $chart_data[$index]['name'] =$value;
                        $chart_data[$index]['commission'] =0;
                    }
                    $group_by = ' GROUP BY select_parameter';
                    $select = 'DATE(activity.date_recorded) as select_parameter';
                }
                if($date_range >= 8 && $date_range <= 30) {
        //weekly

                    $chart_data = Array();
                    $startWeek = (int)date('W', $date_start);
                    $endWeek = (int)date('W', $date_end);
                    for($i = $startWeek; $i <= $endWeek; $i++) {
                        $value = _x('Week','api call','vibe-appointments').($i+1-$startWeek);
                        $chart_data[$i-1]['name'] =$value;
                        $chart_data[$i-1]['commission'] =0;
                    }

                    $group_by = ' GROUP BY select_parameter';
                    $select = 'WEEK(activity.date_recorded) as select_parameter';
                }
                else if($date_range >= 31 && $date_range <= 365) {
        //Monthly
                    $chart_data = Array();
                    $startMonth = (int)date('m', $date_start);
                    $endMonth = (int)date('m', $date_end);
                    for($i = $startMonth; $i <= $endMonth; $i++) {
                        $value = $months[$i-1];
                        $chart_data[$i]['name'] =$value;
                        $chart_data[$i]['commission'] =0;
                    }
                    $group_by = ' GROUP BY select_parameter';
                    $select = 'MONTH(activity.date_recorded) as select_parameter';
                }

                else if($date_range >= 366) {
        //Yearly
                    $chart_data = Array();
                    $startYear = (int)date('Y', $date_start);
                    $endYear = (int)date('Y', $date_end);
                    for($i = $startYear; $i <= $endYear; $i++) {
                        $value = $i;
                        $chart_data[$i-1]['name'] =$value;
                        $chart_data[$i-1]['commission'] =0;
                    }
                    $group_by = ' GROUP BY select_parameter';
                    $select = 'YEAR(activity.date_recorded) as select_parameter';
                }

            }else{
                $and_where .= ' AND YEAR(activity.date_recorded) = YEAR(CURRENT_TIMESTAMP)';
            }
            global $wpdb;
            global $bp;
            $results = $wpdb->get_results( "
                          SELECT ".$select.", sum(meta.meta_value) as commission
                          FROM {$bp->activity->table_name} AS activity 
                          LEFT JOIN {$bp->activity->table_name_meta} as meta ON activity.id = meta.activity_id
                          LEFT JOIN {$bp->activity->table_name_meta} as meta2 ON activity.id = meta2.activity_id
                          WHERE     activity.component     = 'appointment'
                          AND     activity.type     = 'appointment_commission'
                          AND     activity.user_id     = {$user_id}
                          AND     meta.meta_key   LIKE '_commission%'
                          AND     meta2.meta_key   LIKE '_currency%'
                          ".$and_where."
                          ".$group_by,ARRAY_A
                        );

            if(!empty($results)) {
                foreach($results as $result) {
                    $return['data'][($result['select_parameter']-1)]['commission'] = $return['data'][($result['select_parameter']-1)]['commission']+(float)$result['commission'];
                }
            }
            
        }
        return $return;
    }

    function get_user_id_by_order_item_id($order_item_id) {
        global $wpdb;
        $user_id = 0;
        $result = $wpdb->get_results( "
                                      SELECT order_id 
                                      FROM {$wpdb->prefix}woocommerce_order_items 
                                      where order_item_id = $order_item_id", ARRAY_A);

        if(!empty( $result)){
            $order_id = $result[0]['order_id'];
            $order = wc_get_order( $order_id );
            if($order) {
                $user_id = $order->get_user_id();

            }
        }
        
        return $user_id;
    }

    function add_apt_tab($tabs,$group_id,$user_id){
        $db = new VIBE_APPOINTMENTS_DB;
        $args = array('item_id'=>$group_id,'number'=>999,'type'=>'group');
        $count = $db->get_appointments($args,true);

        if(!empty($count)){
            $tabs['vibe_appointments'] =  _x('Appointments','tab batch','vibe-appointments');
        }
        return $tabs;
    }    

    function set_icon($icon,$component_name){
        
        if($component_name == 'appointments'){
            return '<svg width="100%" height="100%" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xml:space="preserve" xmlns:serif="http://www.serif.com/" style="fill-rule:evenodd;clip-rule:evenodd;stroke-linejoin:round;stroke-miterlimit:2;">
    <path d="M18,17L18,14L17,14L17,18L20,18L20,17L18,17ZM13,17.5C13,19.981 15.019,22 17.5,22C19.981,22 22,19.981 22,17.5C22,15.019 19.981,13 17.5,13C15.019,13 13,15.019 13,17.5ZM24,17.5C24,21.09 21.09,24 17.5,24C13.91,24 11,21.09 11,17.5C11,13.91 13.91,11 17.5,11C21.09,11 24,13.91 24,17.5Z" style="fill-opacity:0.71;fill-rule:nonzero;"/>
    <path d="M17,3L17,1C17,0.448 17.447,0 18,0C18.553,0 19,0.448 19,1L19,3C19,3.552 18.553,4 18,4C17.447,4 17,3.552 17,3ZM5,4C5.553,4 6,3.552 6,3L6,1C6,0.448 5.553,0 5,0C4.447,0 4,0.448 4,1L4,3C4,3.552 4.447,4 5,4ZM9.763,21L2,21L2,8L21,8L21,9.763C21.727,10.093 22.399,10.52 23,11.031L23,2L20,2L20,3C20,4.316 18.722,5.339 17.342,4.894C16.511,4.626 16,3.783 16,2.91L16,2L7,2L7,3C7,4.316 5.722,5.339 4.342,4.894C3.511,4.626 3,3.783 3,2.91L3,2L0,2L0,23L11.031,23C10.52,22.399 10.093,21.727 9.763,21Z" style="fill-rule:nonzero;"/>
</svg>';
        }
        return $icon;
    }



    function filter_meta($meta,$post_data = null,$user_id=null){
        if($meta['meta_key'] == 'note'){
            $meta['label']= _x('Note','vibe-appointments');
        }

        if($meta['meta_key'] == 'order_details'){

            $meta['label']= _x('Order Number','vibe-appointments');
            if(!empty($meta['meta_value']) && !empty($meta['meta_value']['order_id'])){
                $meta['value']= '<span>'.$meta['meta_value']['order_id'].'</span>';    
            }
            
        }

        if(strpos($meta['meta_key'], 'order_details_')  !== false){
            if($meta['meta_value']['booker_id'] == $user_id){
                $meta['label']= _x('Order Number','vibe-appointments');
                $meta['value']= '<span>'.$meta['meta_value']['order_id'].'</span>';    
            }else{
                return false;
            }
        }

        if($meta['meta_key'] == 'vibe_bbb'){
            $meta['label']= _x('BBB Meeting','vibe-appointments');
            //get meeting status
            $meta['value']= '<span>'.__('Join Meeting','vibe-appointments').'</span>';
            $meta['action'] = array('component'=>'bbb_meeting','action'=>'shared','id'=>$meta['meta_value']);
        }

        if($meta['meta_key'] == 'vibe_zoom'){
            $meta['label']= _x('Zoom Meeting','vibe-appointments');
            
            if(is_numeric($meta['value']) && class_exists('Vibe_Zoom_API') ){
                $arr = Vibe_Zoom_API::get_meeting_details($meta['value'],$post_data['author_id'],$user_id);
               
                if(!empty($arr['meeting_button_label'])){
                    if(!empty($arr['join_url'])){
                        $meta['value'] = '<a href="'.$arr['join_url'].'">'.$arr['meeting_button_label'].'</span>';
                    }else{
                        if(!empty($arr['changes'])){
                             $meta['change']=$arr['changes'];
                        }
                        
                        $meta['value'] = '<span>'.$arr['meeting_button_label'].'</span>';
                    }
                }
                
            }
            if(is_numeric($meta['value'])){
                $meta['value'] = '<span>'.__('Join Meeting','vibe-appointments').'</span>';    
                $meta['action'] = array('component'=>'zoom_meeting','action'=>'shared','id'=>$meta['meta_value']);
            }
            
            
        }

        if($meta['meta_key'] == 'rating'){

        }

        if($meta['meta_key'] == 'group_id'){
            $meta['label']= _x('Group','vibe-appointments');
            if(bp_is_active('groups') && !empty(vibebp_get_setting('bp_single_page'))){
                $meta['action'] = array('component'=>'groups','action'=>'view','id'=>$meta['meta_value']);
                $meta['value']= '<span>'.esc_html__('View','vibe-appointments').'</span>';
            }
           
        }

        if($meta['meta_key'] == 'additional_slots'){

            $meta['label']= _x('Booked Slots','vibe-appointments');
            $meta['value']= '<span>'.(intval($meta['meta_value']['total'])+1).'</span>';
        }
        return $meta;
    }

    function add_meetings($args){

        $blog_id = '';
        if(function_exists('get_current_blog_id')){
            $blog_id = get_current_blog_id();
        }
        if(function_exists('vibebp_zoom_plugin_update')){
            $args['settings']['fields'][] = array(
                'label'=> __('Zoom Meeting','vibe-appointments' ),
                'type'=> 'selectcpt',
                'cpt'=>'vibe_zoom',
                'value_type'=>'single',
                'id' => 'end',
                'from'=>'meta',
                'meta_key' => 'vibe_zoom',
                'value'=>'',
                'create_label'=>_x('Create Zoom Meeting','vibe-appointments'),
                'create_api_url'=>(defined('VIBE_ZOOM_API_NAMESPACE')?get_rest_url($blog_id,VIBE_ZOOM_API_NAMESPACE).'/user/meetings/new':''),
                'pre'=>array(
                    'api'=>(defined('VIBE_ZOOM_API_NAMESPACE')?get_rest_url($blog_id,VIBE_ZOOM_API_NAMESPACE).'/user/get_new_meeting_pre':''),
                    'values'=>array('hosts'=>'host')
                ),
                'create'=>array(
                    'post_title'=>'',
                    'post_content'=>'',
                    'meta'=>array(
                        'logoutUrl'=>site_url(),
                        'start'=> '',
                        'end'=> '',
                        'start_date'=> '',
                        'start_time'=> '',
                        'host_video' => '',
                        'participant_video' => '',
                        'mute_upon_entry' => '',
                        'enforce_login' => '',
                        'auto_recording' => '',
                        'alternative_hosts' => '',
                        'join_before_host'=> 1,
                        'duration'=> 60,
                        'host'=>'',
                    ),
                    'shared'=>array(
                        'shared_type'=>'shared',
                        'shared_values'=>array()
                    )
                )
            );  
        }
        
        if(function_exists('vibebp_bbb_plugin_update')){
            $args['settings']['fields'][] = array(
                'label'=> __('BBB Meeting','vibe-appointments' ),
                'type'=> 'selectcpt',
                'cpt'=>'bbbhyphenroom',
                'value_type'=>'single',
                'id' => 'end',
                'from'=>'meta',
                'meta_key' => 'vibe_bbb',
                'value'=>'',
                'create_label'=>_x('Create New Meeting','vibe-appointments'),
                'create_api_url'=>get_rest_url($blog_id,VIBE_BBB_API_NAMESPACE).'/user/meetings/new',
                'create'=>array(
                    'post_title'=>'',
                    'post_content'=>'',
                    'meta'=>array(
                        'bbb-room-viewer-code'=> '',
                        'bbb-room-moderator-code'=> '',
                        'logoutUrl'=>site_url(),
                        'start'=> '',
                        'duration'=> 1,
                        'duration_value'=> 60,
                        'bbb-room-recordable'=> true,
                        'bbb-room-wait-for-moderator'=>true,
                    ),
                    'shared'=>array(
                        'shared_type'=>'shared',
                        'shared_values'=>array()
                    )
                )
            );
        }

        return $args;
    }


    function apply_cart_timer($timer){
        $init =WPLMS_Appointments_Init::init();
        $settings = $init->get_global_settings();

        if(!empty($settings) && !empty($settings['appointments_booking_timer'])){
            $timer = $settings['appointments_booking_timer']*60;
        }

        return $timer;
    }

    function add_cart_timer($product_name,$cart_item){


        if(!empty($cart_item['expiry'])){

            $product_name .= '<span class="appointment_info">
            ';
            if(!empty($cart_item['appointment_id'])){
                $product_name .= '<span>['.$cart_item['appointment_id'].']</span>';
            }
            $product_name .='<span class="wplms_appointment_cart_timer" data-expiry="'.$cart_item['expiry'].'"></span></span>';     
        }
       
        return $product_name;
    }

    function remove_product_from_cart(){
        WC()->cart->remove_cart_item( $this->key );
    }



    function appointment_unit_type_block($tabs){

        $tabs['course_curriculum']['fields'][0]['curriculum_elements'][1]['types'][] =array(
                'id'=>'appointment_unit_type',
                'icon'=>'vicon vicon-calendar',
                'label'=>__('Appointment Unit Type','vibe-appointments'),
                'fields'=>array(
                    array(
                        'label'=> __('Unit title','vibe-appointments' ),
                        'type'=> 'title',
                        'id' => 'post_title',
                        'from'=>'post',
                        'value_type'=>'single',
                        'style'=>'full',
                        'default'=> __('Unit Name','vibe-appointments' ),
                        'desc'=> __('This is the title of the unit which is displayed on top of every unit','vibe-appointments' )
                        ),
                    array(
                        'label' => __('Appointment Unit Type Calendar','vibe-appointments'),
                        'desc'  => __('This will display weekly calendar in appointment unit type','vibe-appointments'),
                        'id'    => 'vibe_unit_appointment_calendar', 
                        'type'  => 'appointment_calendar', 
                        'from'=>'meta',
                    ),
                    array(
                        'label'=> __('Unit Tag','vibe-appointments' ),
                        'type'=> 'taxonomy',
                        'taxonomy'=> 'module-tag',
                        'from'=>'taxonomy',
                        'value_type'=>'single',
                        'style'=>'assign_cat',
                        'id' => 'module-tag',
                        'default'=> __('Select a tag','vibe-appointments' ),
                    ),
                    array(
                        'label'=> __('What is the unit about','vibe-appointments' ),
                        'type'=> 'editor',
                        'style'=>'',
                        'value_type'=>'single',
                        'id' => 'post_content',
                        'from'=>'post',
                        'extras' => '',
                        'default'=> __('Enter description about the unit.','vibe-appointments' ),
                        ),
                    array(
                        'label'=> __('Unit duration','vibe-appointments' ),
                        'type'=> 'duration',
                        'style'=>'course_duration_stick_left',
                        'id' => 'vibe_duration',
                        'from'=> 'meta',
                        'default'=> array('value'=>9999,'parameter'=>86400),
                        'from'=>'meta',
                    ),
                    array(
                        'label' => __('Attachments','vibe-appointments'),
                        'desc'  => __('Display these attachments below units to be downloaded by students','vibe-appointments'),
                        'id'    => 'vibe_unit_attachments', 
                        'type'  => 'multiattachments', 
                        'from'=>'meta',
                    ),
                    
                )
            );
        return $tabs;
        ?>
        <?php
        
    }

    function wplms_get_course_tabs($tabs,$course_id,$user_id){
        $tabs['appointments_calendar'] = __('Appointments','vibe-appointments');
        return $tabs;
    }

    function update_unit_meta_component($meta,$course_id,$item_id){

        $type = get_post_meta($item_id,'vibe_type',true);
        if($type == 'appointment_unit_type' ){
            //$meta['unit_type'] = 'appointment_unit_type';
            $post_id = get_post_meta($item_id,'vibe_unit_appointment_calendar',true);
            $meta['unit_type_appointment'] =  get_appointment_slots_by_id($post_id);
            $available_course_slots = $meta['unit_type_appointment']['id'];
            $slots=[];
            $booked_slot=false;
            if(!empty($available_course_slots)){
                foreach($available_course_slots as $slot){
                    $db = new VIBE_APPOINTMENTS_DB;
                    $sslot = $db->get_appointments(array('appointment_id'=>$slot));
                    if(!empty($sslot)){
                        if(!empty($sslot[0])){
                            if(empty($sslot[0]['booker_id'])){
                                $slots[] = $sslot[0];
                            }else{
                                $slots= [];
                                $booked_slot = $sslot[0];
                                break;
                            }
                            
                        }
                    }
                }
                $meta['available_unit_slots'] = $slots;
                $meta['booked_slot'] = $booked_slot;
                
            }
            

        }
        return $meta;
    }


    
    function dispute_action($flag,$body){

        if(empty($flag) && function_exists('wc') && $body['appointment']['appointment_id']){
            global $wpdb;
            $meta = new VIBE_APPOINTMENTS_META_DB;
            
            $order_id = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM {$meta->table_name} WHERE appointment_id = %d AND meta_key=%s",$body['appointment']['appointment_id'],'_wc_order_id_'.$body['appointment']['booker_id']));
            
            
            if(!empty($order_id)){

                $order_details = $wpdb->get_var($wpdb->prepare("SELECT meta_value FROM {$meta->table_name} WHERE appointment_id = %d AND meta_key=%s",$body['appointment']['appointment_id'],'order_details_'.$body['appointment']['booker_id']));
                $order_details = maybe_unserialize($order_details);
                
                $order = wc_get_order($order_id);

                $cap = apply_filters('vibe_appointments_can_instructor_refund',false);

                if($cap){
                    $refund = wc_create_refund( array(
                        'amount'         => $order_details['payment'],
                        'reason'         => _x('Disputed approved.','dispute reason refunds','vibe-appointments'),
                        'order_id'       => $order_details['order_id'],
                        'line_items'     =>  array($order_details['item_id']),
                        'refund_payment' => true
                    ));    
                }else{
                    $order->update_status('wc-admin-approve', _x('Instructor / Admin approved the order for refund.','dispute refund','vibe-appointments') ); 
                }
                

                if(!empty($refund)){
                    
                    if($order){
                        if(is_wp_error($refund)){
                            $order->update_status('wc-admin-approve',_x('Dispute Refund attempted the item','dispute refund','vibe-appointments') );    
                            return $refund->get_error_message();
                        }else{
                            $order->add_order_note(_x('Dispute Refund done the item ','dispute refund','vibe-appointments') );   
                        }    
                    }
                }
            }
        }
    }

}

Vibe_Appointments_Filters::init();