<?php
/**
 * WPLMS Chat functions
 *
 * @author 		VibeThemes
 * @category 	Functions
 * @package 	wplms_chat/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


if(!function_exists('array_find')){
	function array_find($xs, $f) {
	  foreach ($xs as $x) {
	    if (call_user_func($f, $x) === true)
	      return $x;
	  }
	  return -1;
	}
}



function vibe_appointments_get_settings(){
  $init = Vibe_Appointments_Init::init();
  if(!empty($init->settings)){
    return $init->settings;
  }
  $init->settings = get_option(VIBE_APPOINTMENTS_OPTION);

  return $init->settings;
}

class VIBE_Appointments_Functions{


	public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new VIBE_Appointments_Functions();
        return self::$instance;
    }


    function __construct(){
    	$this->pending_bookings= [];
    	$this->pending_appointments= [];
    }


    function get_active_slots(){

    	if(empty($this->slots)){
    		$slots = get_option('vibe_appointments_active_slots');

    		
			if(!empty($slots)){
				$updated = 0;
				if(!is_array($slots)){
	    			$slots = unserialize($slots);	
	    		}
				foreach($slots as $k=>$slot){
					if(!isset($slot['expiry']) || $slot['expiry'] < time()){
						unset($slots[$k]);
						$updated=1;
					}
				}

				if($updated){
					update_option('vibe_appointments_active_slots',$slots);
				}
			}
			$this->slots=$slots;
    	}
    	

		return $this->slots;
    }


	function get_pending_slots($args){
		extract($args);

		if(!empty($booker_id) && !is_numeric($booker_id)){
			$booker_id = 0;
		}

		$buffer_time =apply_filters('vibe_appointments_pending_slots_buffer_time',1800);
		
		if(!empty($instructor_id)){
			if(empty($this->pending_appointments)){
				$pending_appointments = get_user_meta($instructor_id,'pending_appointments',true);	
				if(!empty($pending_appointments)){
					foreach($pending_appointments as $aid=>$app){
						if(!empty($app) && intval($app)+intval($buffer_time) < time()){
							unset($pending_appointments[$aid]);
						}
					}
					$this->pending_appointments=$pending_appointments;
					return $this->pending_appointments;
				}
			}else{
				return $this->pending_appointments;
			}
		} 

		if(!empty($booker_id)){
			
			if(empty($this->pending_bookings)){
				$pending_bookings = get_user_meta($booker_id,'pending_bookings',true);
				
				if(!empty($pending_bookings)){
					foreach($pending_bookings as $aid=>$app){
						if($app+$buffer_time < time()){
							unset($pending_bookings[$aid]);
						}
					}
					$this->pending_bookings=$pending_bookings;
					return $this->pending_bookings;	
				}
			}else{
				return $this->pending_bookings;
			}
		}

		return array();
	}


	function vibeappointments_directory_data($settings=[]){

		
		$member_type_objects = bp_get_member_types(array(),'objects');
	    $member_types=array();
	    if(!empty($member_type_objects) && count($member_type_objects)){
	        foreach($member_type_objects as $member_type=>$mt){
	            $member_types[$member_type]=$mt->labels['singular_name'];
	        }
	    }
	    $blog_id = '';
	    if(function_exists('get_current_blog_id')){
	        $blog_id = get_current_blog_id();
	    }

	    if(empty($this->app_settings)){
	        $this->app_settings = vibe_appointments_get_settings();
	    }
	    if(!empty($settings)){
	    	if(!empty($settings['show_slot_calendar']) && $settings['show_slot_calendar']==1){
	    		$settings['show_slot_calendar'] = true;
	    	}else{
	    		$settings['show_slot_calendar'] = false;
	    	}
	    	if(!empty($settings['show_map'])){

	    	}
	    }

	    
	    
	    $settings['cookiepath']=COOKIEPATH;
	    $settings['buffer_time']=apply_filters('vibe_appointments_pending_slots_buffer_time',1800);
	    $settings['date_format']=convertPhpToJsMomentFormat(get_option('date_format'));
	    $settings['time_format']=convertPhpToJsMomentFormat(get_option('time_format'));

	    $settings['redirect_cart']=(!empty($this->app_settings['redirect_cart_click_slot']));
	    $settings['cart_url']=(function_exists('wc_get_cart_url')?wc_get_cart_url():'');

	    $this->args = array(
	        'api'=>array(
	            'url'=>get_rest_url($blog_id,Vibe_BP_API_NAMESPACE),
	            'appointments_api'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),
	            'client_id'=>vibebp_get_setting('client_id'),
	            'xprofile'=>Vibe_BP_API_XPROFILE_TYPE,
	            'google_maps_api_key'=>vibebp_get_setting('google_maps_api_key','general','misc'),
	            'map_marker'=>plugins_url('../assets/images/marker.png',__FILE__)
	        ),
	        'card_id'=>(!empty($this->app_settings['directory_member_card'])?$this->app_settings['directory_member_card']:''),
	        'coin_image'=> plugins_url( '../assets/images/coin.svg',  __FILE__ ),
	        'settings'=>$settings,
	        'currency'=>function_exists('get_woocommerce_currency_symbol')?get_woocommerce_currency_symbol():'',
	        'dow'=>array(
				  	1=>'MO',
				  	2=>'TU',
				  	3=>'WE',
				  	4=>'TH',
				  	5=>'FR',
				  	6=>'SA',
				  	0=>'SU',
				  ),
				  'date_format' => apply_filters('vibe_appointments_date_format',convertPhpToJsMomentFormat(get_option('date_format'))),
	      	'time_format' => apply_filters('vibe_appointments_time_format',convertPhpToJsMomentFormat(get_option('time_format'))),

	        'services_type_slug'=>VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
	        'services_slug'=>VIBE_APPOINTMENTS_SERVICE_SLUG,
	        'member_types'=>$member_types,
	        'videofield'=>(!empty($this->app_settings['instructor_video_field'])?$this->app_settings['instructor_video_field']:false),
	        'services_enabled'=>(!empty($this->app_settings['appointments_services'])?true:false),
	        'default_avatar'=>plugins_url( '../assets/images/avatar.jpg',  __FILE__ ),
	        'availability'=>get_vibe_appointments_availability_data(),
	        'member_sorters'=>array(
	            'active' =>__('Active','vibe-appointments' ),
	            'newest' =>__('Recently Added','vibe-appointments' ),
	            'alphabetical' =>__('Alphabetical','vibe-appointments' ),
	            'random'=>__('Random','vibe-appointments' ),
	            'popular'=>__('Popular','vibe-appointments' )
	        ),

	        'translations'=>array(
	        	'favourites'=>_x('Favourites','','vibe-appointments'),
	        	'show_favourites'=>_x('Favourites','','vibe-appointments'),
	        	'hide_map'=>_x('Map','directory','vibe-appointments'),
	        	'credits'=>_x('Credits','','vibe-appointments'),
	        	'services'=>_x('Services','','vibe-appointments'),
	        	'slot_added_to_cart'=>_x('Slot added to cart','','vibe-appointments'),
	            'error_loading_data' => _x('Error loading data','','vibe-appointments'),
	            'select_service_type'=>_x('Select Service Type','','vibe-appointments'),
	            'select_service'=>_x('Select Service','','vibe-appointments'),
	            'search_text'=>__('Type to search','vibe-appointments' ),
	            'search_location'=>__('Search location','vibe-apppointments'),
	            'locate_me'=>__('Location me','vibe-apppointments'),
	            'all'=>__('All','vibe-appointments' ),
	            'no_members_found'=>__('No members found !','vibe-appointments' ),
	            'member_types'=>__('Member Type','vibe-appointments' ),
	            'map_search'=>__('Map Search','vibe-appointments' ),
	            'show_filters'=>__('Show Filters','vibe-appointments' ),
	            'close_filters'=>__('Close Filters','vibe-appointments' ),
	            'clear_all'=>__('Clear All','vibe-appointments' ),
	            'price_per_slot'=>__('Price per slot','vibe-appointments' ).(function_Exists('get_woocommerce_currency')?' ['.get_woocommerce_currency().']':''),
	            'show_schedule'=>_x('Show Schedule','','vibe-appointments'),
	            'availability'=>_x('Availability','','vibe-appointments'),
	            'no_bookings_found'=>_X('No bookings found','','vibe-appointments'),
	            'confirm_booking'=>_x('Click Confirm to complete booking.','booking','vibe-appointments'),
	      		'confirm_booking_15_minutes'=>_x('Click Confirm to start booking. Complete payment in 15 minutes.','booking','vibe-appointments'),
	      		'purchase_using_credits'=>_x('Purchase using credits','','vibe-appointments'),
					'purchase'=>_x('Purchase','','vibe-appointments'),
	      		'confirm'=>_x('Confirm','booking','vibe-appointments'),
	      		'cancel'=>_x('Cancel','booking','vibe-appointments'),
	      		'booking_price'=>_x('Price for booking','booking','vibe-appointments'),
	      		'services_under_this_category'=>_x('Services under this category','','vibe-appointments'),
	      		'no_services_under_this_type'=>_x('No services under this service type','','vibe-appointments'),
	      		'find_a_service'=>__('Find a Service','vibe-appointments'),
	      		'select_service_type'=>__('Select a Service Type','vibe-appointments'),
	      		'all_time_local_message'=>__('All Timeslots displayed in local timezone.','vibe-appointments'),
	      		'view_profile'=>__('View Profile','vibe-appointments'),
	      		'time_of_day'=>__('Time of the day, in your time zone','vibe-appointments'),
	      		'dow'=>__('Days of the week','vibe-appointments')
	        )
	    );

		
		return apply_filters('vibeappointments_directory_data',$this->args);
	}
}

add_filter('template_redirect','single_service');
function single_Service($args){
	if(is_singular('service')){
		$args['service'] = get_the_ID();
	}
	return $args;
}
function vibe_appointments_get_slot_price($user_id){
	$product_id = get_user_meta($user_id,'vibe_appointments_slot_product',true);
	if(!empty($product)){
		$type = get_post_type($product_id);
		if($type == 'product' && function_exists('wc')){
			$product = new WC_Product(get_the_ID()); 
  			return array('label'=>$product->get_price_html(),'link'=>'?add-to-cart='.$product_id);
		}
	}
}

function wplms_appointment_get_profile_setting($user_id,$setting){
	$profile = WPLMS_Appointments_Profile::init();
	$settings = $profile->get_user_appointment_settings($user_id);
	return empty($settings[$setting])?0:$settings[$setting];
}


function vibe_appointments_get_active_slots(){
	$functions = VIBE_Appointments_Functions::init();
	return $functions->get_active_slots();
}

function vibe_appointments_remove_active_slot($slot_id,$user_id=null){
	$slots = vibe_appointments_get_active_slots();
	if(empty($slots)){
		$slots= [];
	}
	if(!empty($user_id)){
		foreach($slots as $k=>$aslot){
			if($aslot['appointment_id']==$slot_id && $user_id==$aslot['booker_id']){
				unset($slots[$k]);
			}
		}
	}else{
		$key = array_search($slot_id, array_column($slots, 'appointment_id'));
		if($key !== false){
			unset($slots[$key]);
		}
	}
	
	update_option('vibe_appointments_active_slots',$slots);
}
function vibe_appointments_record_active_slot($slot){
	$slots = vibe_appointments_get_active_slots();
	if(empty($slots)){
		$slots = array();
	}
	$index=-1;
	if(!empty($slot['booker_id'])){
		if(!empty($slots)){
			foreach($slots as $k=>$aslot){
				if($aslot['appointment_id']==$slot['appointment_id'] && $aslot['booker_id']==$slot['booker_id']){
					$index = $k;
				}
			}
		}
		if($index>-1){
			$slots[$index]=$slot;
		}else{
			$slots[]=$slot;
		}
	}
	
	update_option('vibe_appointments_active_slots',$slots);
}

function vibe_appointments_get_pending_slots($args){

	if(empty($args)){
		return array();
	}
	$functions = VIBE_Appointments_Functions::init();
	return $functions->get_pending_slots($args);
}


function vibe_appointments_update_pending_slots($args){

	extract($args);
	if(!empty($instructor_id)){
		$pending_appointments_instructor = vibe_appointments_get_pending_slots(array('instructor_id'=>$instructor_id));	
	}
	if(!empty($booker_id)){
		$pending_appointments_booker = vibe_appointments_get_pending_slots(array('booker_id'=>$booker_id));	
	}
	if(empty($pending_appointments_instructor)){
        $pending_appointments_instructor = array();
    }
    if(empty($pending_appointments_booker)){
        $pending_appointments_booker = array();
    }
    if(is_array($slot_id)){
    	$slot_ids = $slot_id;
    }else{
    	$slot_ids = array($slot_id);
    }

    
    if(!empty($slot_ids)){
        foreach($slot_ids as $sid){
        	if(!in_array($sid,$pending_appointments_instructor)){
        		$pending_appointments_instructor[$sid]=time();	
        	}if(!in_array($sid,$pending_appointments_instructor)){
        		$pending_appointments_booker[$sid]=time();
        	}
        }
    }
    if(!empty($pending_appointments_instructor)){
	    update_user_meta($instructor_id,'pending_appointments',$pending_appointments_instructor);
	}
    if(!empty($pending_appointments_booker)){
    	update_user_meta($booker_id,'pending_bookings',$pending_appointments_booker);	
    }
}

function wplms_appointments_convert_utc_local($utc_date,$utc_time,$user_id=null){

	$user_offset = get_user_meta($user_id,'gmt_offset',true);
	$date_format = get_option('date_format');
	$time_format = get_option('time_format');

	if(empty($user_offset)){
		$offset = get_option('gmt_offset')*3600;
	}else{
		$offset = $user_offset*3600;
	}
	$current_timestamp = strtotime(date('d-m-Y',($utc_date/1000 + 2*$offset))) + ($utc_time*60 + $offset);

	return date($date_format.' '.$time_format,$current_timestamp);


}


function wplms_getdate_appointment_timestamp($appointment){

    $dateObj = explode('T',$appointment['start']);
    $date = $dateObj[0].' '.substr($dateObj[1], 0,5);

    return strtotime($date);
}



if(!function_exists('tofriendlytime')){
  function tofriendlytime($seconds,$force = null) {
  $measures = array(
    array('label'=>__('year','vibe'),'multi'=>__('years','vibe'), 
          'value'=>12*30*24*60*60),
    array('label'=>__('month','vibe'),'multi'=>__('months','vibe'), 
          'value'=>30*24*60*60),
    array('label'=>__('week','vibe'),'multi'=>__('weeks','vibe'), 
          'value'=>7*24*60*60),
    array('label'=>__('day','vibe'),'multi'=>__('days','vibe'), 
          'value'=>24*60*60),
    array('label'=>__('hour','vibe'),'multi'=>__('hours','vibe'), 
          'value'=>60*60),
    array('label'=>__('minute','vibe'),'multi'=>__('minutes','vibe'), 
          'value'=>60),
    array('label'=>__('second','vibe'),'multi'=>__('seconds','vibe'), 
          'value'=>1),
    );

    if($seconds <= 0)
      return __('EXPIRED','vibe');
  
    foreach($measures as $key => $measure){
      if(!empty($force)){
          if($measure['value'] <= $force){
            $count = floor($seconds/$force);
            break;
          }
      }else{
          if($measure['value'] < $seconds && empty($force)){
            $count = floor($seconds/$measure['value']);
            break;
          }
      }
    }

    if(empty($force))
      $time_labels = $count.' '.(($count > 1)?$measure['multi']:$measure['label']);
    else
      $time_labels = (($count > 1)?$count:'').' '.(($count > 1)?$measure['multi']:$measure['label']);

    if($measure['value'] > 1){ // Ensure we're not on last element
      $small_measure = $measures[$key+1];  
      $small_count = floor(($seconds%$measure['value'])/$small_measure['value']);
      if($small_count)
        $time_labels .= ', '.$small_count.' '.(($small_count > 1)?$small_measure['multi']:$small_measure['label']);
    }
    
  return $time_labels;
  } 
}

function get_appointment_slots_by_id($post_id){
    $post = get_post($post_id);
    $meta = get_post_meta($post_id,'vibe_unit_appointment_calendar',true);
    $avatar = get_avatar_url($post->post_author);
    $author_name = get_the_author_meta( 'user_nicename' , $post->post_author);
    $appointment_unit_meta=array(
        'id'=>$post_id,
        'post_title'=>$post->post_title,
        'post_date'=>$post->post_date,
        'post_content'=>$post->post_content,
        'post_author'=>$post->post_author,
        'author_avatar'=>$avatar,
        'author_name'=>$author_name,
        'meta' => $meta,
    );
    return $appointment_unit_meta;
}

function get_vibe_appointments_directory_scripts(){
		return apply_filters('get_vibe_appointments_directory_scripts',array(
			array(
				'id'=>'vibebp-flatpickr',
				'src'=>'',
				'deps'=>array(),
			),
			array(
				'id'=>'nouislider',
				'src'=>plugins_url('../assets/js/nouislider.min.js',__FILE__),
				'deps'=>array(),
			),
			array(
				'id'=>'wNumb',
				'src'=>plugins_url('../assets/js/wNumb.min.js',__FILE__),
				'deps'=>array(),
			),
			array(
				'id'=>'plyr',
				'src'=>VIBEBP_PLUGIN_URL.'/assets/js/plyr.js',
				'deps'=>array(),
			),
			array(
				'id'=>'moment',
				'src'=>plugins_url('../assets/js/moment.min.js',__FILE__),
				'deps'=>array(),
			),
			array(
				'id'=>'vibebp-appointments-directory-js',
				'src'=>plugins_url('../assets/js/directory.js',__FILE__),
				'deps'=>array('wp-element','wp-data'),
			),
			array(
				'id'=>'vibebp-swiper',
				'src'=>'',
				'deps'=>[]
			),
			array(
				'id'=>'moment',
				'src'=>'',
				'deps'=>array(),
			),
			array(
				'id'=>'vibebp-appointments-favourite-js',
				'src'=>plugins_url('../assets/js/favourite.js',__FILE__),
				'deps'=>array('wp-element','wp-data'),
			),

		));
}

function get_vibe_appointments_directory_styles(){
		return apply_filters('get_vibe_appointments_directory_styles',array(
			array(
				'id'=>'nouislider_css',
				'src'=>plugins_url('../assets/css/nouislider.min.css',__FILE__),
				'deps'=>array(),
			),
			array(
				'id'=>'plyr',
				'src'=>VIBEBP_PLUGIN_URL.'/assets/css/plyr.css',
				'deps'=>array(),
			),
			array(
				'id'=>'vibebp-swiper',
				'src'=>'',
				'deps'=>[]
			),
			array(
				'id'=>'vibebp-appointments-directory',
				'src'=>plugins_url('../assets/css/directory.css',__FILE__),
				'deps'=>array('vibebp_main'),
			)
			
		));
}

function enqueue_vibe_appointments_directory_assets(){
	foreach(get_vibe_appointments_directory_scripts() as $k => $script){
		if(empty($script['src'])){
			wp_enqueue_script($script['id']);
		}else{
			wp_enqueue_script($script['id'],$script['src'],$script['deps'],VIBE_APPOINTMENTS_VERSION,true);
		}

		 
	}
	foreach(get_vibe_appointments_directory_styles() as $k => $style){
		
		 wp_enqueue_style($style['id'],$style['src'],$style['deps'],VIBE_APPOINTMENTS_VERSION,false);
	}
}

function get_vibeappointments_directory_data($settings=[]){
	$init = VIBE_Appointments_Functions::init();
	return $init->vibeappointments_directory_data($settings);
}

function get_vibeappointments_script_data($settings=[]){
	$blog_id = '';
  if(function_exists('get_current_blog_id')){
      $blog_id = get_current_blog_id();
  }

  $options = vibe_appointments_get_settings();

  $locale = get_locale();
  $locale_key = explode('_',$locale);
  $locale_key= $locale_key[0];
  if(!function_exists('format_code_lang')){
  	require_once( ABSPATH . 'wp-admin/includes/ms.php' );
  }

  $min_slot =  !empty($options['appointments_slot_time'])?$options['appointments_slot_time']:30;
  $cancel_time =  !empty($options['appointments_buffer_time'])?(int)$options['appointments_buffer_time']:0;
  $course_slots = !empty($options['course_slots'])?$options['course_slots']:null;

  if(empty($settings)){
  	$settings = [
  				'member_directory_filters'=>['availability'],
  				'service_types'=>['all'],
					'search_appointments'=>1,
					'sort_appointments'=>1,
					'inbuilt_services'=>1,
  				'dates'=>[ 
  							['value'=> 7, 'label'=> __('Week','vibe-appointments')],
  							['value'=>30, 'label'=> __('Month','vibe-appointments')],
  							['value'=> 'custom', 'label'=> __('Custom','vibe-appointments')
					]
				],
				'card_style'=>'card',
				'card_id'=>(!empty($options['directory_member_card'])?$options['directory_member_card']:''),
				'show_slot_calendar'=>true,
			];
  }


	return apply_filters('vibeappointments_script_args',array(
	  'api'=>array(
	      'url'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),
	      'appointments_api'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),
	  ),            
	  	'title'=>__('Appointments','vibe-appointments'),
	  	'coin_image'=> plugins_url( '../assets/images/coin.svg',  __FILE__ ),
	  	'gcal_icon'=> plugins_url( '../assets/images/gcalicon.svg',  __FILE__ ),
	  	
	  	'slot_label'=>[
      		'live'=>_x('Live','Slot label','vibe-appointments'),
      		'upcoming'=>_x('Upcoming','Slot label','vibe-appointments'),
      		'finished'=>_x('Finished','Slot label','vibe-appointments'),
      		'disputed'=>_x('Disputed','Slot label','vibe-appointments')
      	],
	  'settings'=>array(
	  		'buffer_time'=>$cancel_time,
	  		'enable_gcal_sync'=>!empty($options['enable_gcal_sync'])?$options['enable_gcal_sync']:false,
	  		'google_calendar_api_key'=>!empty($options['google_calendar_api_key'])?$options['google_calendar_api_key']:false,
	  		'google_calendar_client_id'=>!empty($options['google_calendar_client_id'])?$options['google_calendar_client_id']:false,
	      'default_name'=>_x('NA','','vibe-appointments'),
	      'client_id'=>vibebp_get_setting('client_id'),
	      'default_avatar'=>plugins_url('../assets/images/avatar.jpg',__FILE__),
	      'weekend'=>5,
	      'timeslot'=>15,
	      'date_format' => apply_filters('vibe_appointments_date_format',convertPhpToJsMomentFormat(get_option('date_format'))),
	      'time_format' => apply_filters('vibe_appointments_time_format',convertPhpToJsMomentFormat(get_option('time_format'))),
	      'locale_detection'=>empty($options['locale_detection'])?0:1,
	      'instructor_controls'=>empty($options['instructor_controls'])?0:1,
	      'views'=>array(
	          'month'=>__('Month','vibe-appointments'),
	          'week'=>__('Week','vibe-appointments'),
	          'day'=>__('Day','vibe-appointments')
	      ),
	      'site_langauge'=>array(
				'key'=> $locale_key,
				'label'=>format_code_lang($locale_key)
	      ),
	      'min_slot_minute'=> $min_slot,
	      'course_slots' => $course_slots,
			'languageCode' => apply_filters('vibefullcalendar_locale_languageCode',''),//forcefully set like 'en' for English
	      'timestamp'=>time(),
	      'saved'=>$options,
	      'services'=>(!empty($options['appointments_services'])?true:false),
	      'services_type_slug'=>VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG,
	      'services_slug'=>VIBE_APPOINTMENTS_SERVICE_SLUG,
	      'paid'=>(function_Exists('WC')?1:0),
	      'currency'=>function_exists('get_woocommerce_currency_symbol')?get_woocommerce_currency_symbol():'',
	      'fields'=>array(
	          array(
	              'label'=> __('Note','vibe-appointments' ),
	              'type'=> 'textarea',
	              'style'=>'',
	              'value_type'=>'single',
	              'id' => 'end',
	              'from'=>'meta',
	              'meta_key' => 'note',
	              'value'=>''
	          ),
	      ),
	      'statuses'=>array(
	          'booked'=>_x('Booked','','vibe-appointments'),
	          'complete'=>_x('Completed','','vibe-appointments'),
	          'open'=>_x('Open','','vibe-appointments'),
	          'pending'=>_x('Pending','','vibe-appointments'),
	      ),
	      'cookiepath'=>COOKIEPATH,
	      'redirect_cart'=>(!empty($options['redirect_cart_click_slot'])),
	      'cart_url'=>function_exists('wc_get_cart_url')?wc_get_cart_url():'',
	      'inbuilt_services'=>true,
	  ),
	  'days_of_week'=>array(
	  	array('label'=>_x('Monday','','vibe-appointments'),'value'=>'MO'),
	  	array('label'=>_x('Tuesday','','vibe-appointments'),'value'=>'TU'),
	  	array('label'=>_x('Wednesday','','vibe-appointments'),'value'=>'WE'),
	  	array('label'=>_x('Thursday','','vibe-appointments'),'value'=>'TH'),
	  	array('label'=>_x('Friday','','vibe-appointments'),'value'=>'FR'),
	  	array('label'=>_x('Saturday','','vibe-appointments'),'value'=>'SA'),
	  	array('label'=>_x('Sunday','','vibe-appointments'),'value'=>'SU'),
	  ),
	  'dow'=>array(
	  	1=>'MO',
	  	2=>'TU',
	  	3=>'WE',
	  	4=>'TH',
	  	5=>'FR',
	  	6=>'SA',
	  	0=>'SU',
	  ),
	  'member_sorters'=>array(
	        'active' =>__('Active','vibe-appointments' ),
	        'newest' =>__('Recently Added','vibe-appointments' ),
	        'alphabetical' =>__('Alphabetical','vibe-appointments' ),
	        'random'=>__('Random','vibe-appointments' ),
	        'popular'=>__('Popular','vibe-appointments' )
	    ), 
	  'directory'=>get_vibeappointments_directory_data($settings),
	  'translations'=>array(
	  	'cancel_cancel_request'=>_x('Cancel Request for cancellation?','warning message','vibe-appointments'),
	  	'request_cancellation'=>_x('Request Cancellation','button label','vibe-appointments'),
	  	'request_cancellation_description'=>_x('You can request a cancellation before the booking has commenced.','cancellation request description'),
	  	'sync'=>_x('Sync with google calendar','description on button','vibe-appointments'),
	  	'please_select_weekdays'=>_x('Please select weekdays','search','vibe-appointments'),
	  	'days_of_week'=>_x('Days of week','','vibe-appointments'),
	  	'recurriung_appointment'=>_x('Recurring appointment','','vibe-appointments'),
	  	'favourites'=>_x('Favourites','','vibe-appointments'),
	  	'show_favourites'=>_x('Favourites','directory','vibe-appointments'),
	  	'hide_map'=>_x('Map','directory','directory','vibe-appointments'),
	  	'slot_owner'=>_x('Slot owner','','vibe-appointments'),
	  	'search_instructor'=>_x('Search Instructor','','vibe-appointments'),
	  	'booked'=>_x('Booked','','vibe-appointments'),
	  	'open'=>_x('Open','','vibe-appointments'),
	  	'admin_calendar'=>_x('Admin Calendar','','vibe-appointments'),
	  	'credits'=>_x('Credits','','vibe-appointments'),
      	'purchase_using_credits'=>_x('Purchase using credits','','vibe-appointments'),
      	'purchase'=>_x('Purchase','','vibe-appointments'),
	  		'set_credits'=>_x('Set Credits','','vibe-appointments'),
	      'slot_booked'=>_x('Slot Booked','','vibe-appointments'),
	      'slot_added_to_cart'=>_x('Slot added to cart','','vibe-appointments'),
	      'confirm_booking'=>_x('Click Ok to confirm booking.','booking','vibe-appointments'),
	      'confirm_booking_15_minutes'=>_x('Click Ok to confirm booking. Complete payment in 15 minutes.','booking','vibe-appointments'),

	      'purchase_using_credits'=>_x('Purchase using credits','','vibe-appointments'),
				'purchase'=>_x('Purchase','','vibe-appointments'),
	      'booking_price'=>_x('Price for booking','booking','vibe-appointments'),
	      'booking_underprocessing'=>_x('Processing','booking','vibe-appointments'),
	      'confirm'=>_x('Confirm','booking','vibe-appointments'),
	      'cancel'=>_x('Cancel','booking','vibe-appointments'),
	      'four_days'=>_x('4 days','','vibe-appointments'),
	      'no_slots' => _x('No slots available','','vibe-appointments'),
	      'appointments'=>_x('Appointments','','vibe-appointments'),
	      'find_instructor'=>_x('Find an Instructor','','vibe-appointments'),
	      'select_service' => _x('Select Service','','vibe-appointments'),
	      'enrol_in_services'=>_x('Add New service prices','','vibe-appointments'),
	      'select_service_type'=>_x('Select service type','','vibe-appointments'),
	      'select_service'=>_x('Select service','','vibe-appointments'),
	      'add' => _x('Add','','vibe-appointments'),
	      'enrolled_services' => _x('Enrolled Services','','vibe-appointments'),
	      'enroll_in_service' => _x('Enrol in a Service','','vibe-appointments'),
	      'no_services_enrolled' => _x('No enrolled services found','','vibe-appointments'),
	      'no_service_found'=>_x('No service found!','','vibe-appointments'),
	      'error_loading_data'=>_x('Error loading data','','vibe-appointments'),
	      'save_slots'=>__('Save Slots', 'vibe-appointments'),
	      'add_slots'=>__('Add Slots', 'vibe-appointments'),
	      'remove_slots'=>__('Remove Slots', 'vibe-appointments'),
	      'remove_slots'=>__('Remove Slots', 'vibe-appointments'),
	      'manage_confirmed_bookings'=>__('Confirmed Bookings', 'vibe-appointments'),
	      'manage_slots'=>__('Manage Slots', 'vibe-appointments'),
	      'appointment_booking_for'=>__('Appointment Booking for ', 'vibe-appointments'),
	      'reschedule_appointment' =>__('Reschedule Appointment', 'vibe-appointments'),
	      'cancel_appointment' =>__('Cancel Appointment', 'vibe-appointments'),
	      'send_message' =>__('Send Message', 'vibe-appointments'),
	      'complete_appointment'=>__('Mark Complete', 'vibe-appointments'),
	      'send_email'=>__('Send Email', 'vibe-appointments'),
	      'cancel_slot'=>__('Cancel Slot', 'vibe-appointments'),
	      'send_notification'=>__('Send Notification', 'vibe-appointments'),
	      'slot_details'=>__('Booking Slot details', 'vibe-appointments'),
	      'slot_date_range'=>__('Select Slot date range', 'vibe-appointments'),
	      'slots_to_be_removed'=>__('Slots to be removed.', 'vibe-appointments'),
	      'number_slots'=>__('number of slots', 'vibe-appointments'),
	      'slot_start_time'=>__('Slots Start time everyday', 'vibe-appointments'),
	      'slot_end_time'=>__('Slots End time everyday', 'vibe-appointments'),
	      'break_slots_per_day_timing'=>__('Break Per day slots into sub-slots of duration', 'vibe-appointments'),
	      'full_slot'=>__('Full Slot', 'vibe-appointments'),
	      'repeat_slots'=>__('Repeat Slots pattern', 'vibe-appointments'),
	      'repeat_gap'=>__('Repeat gap', 'vibe-appointments'),
	      'fifteen_minutes'=>__('15 Minutes', 'vibe-appointments'),
	      'thirty_minutes'=>__('30 Minutes', 'vibe-appointments'),
	      'one_hour'=>__('1 Hour', 'vibe-appointments'),
	      'two_hours'=>__('2 Hours', 'vibe-appointments'),
	      'three_hours'=>__('3 Hours', 'vibe-appointments'),
	      'edit_slot'=>__('Edit Slot', 'vibe-appointments'),
	      'add_new'=>__('Add New', 'vibe-appointments'),
	      'start'=>__('Start', 'vibe-appointments'),
	      'end'=>__('Ends', 'vibe-appointments'),
	      'create_event'=>__('Add Slots', 'vibe-appointments'),
	      'save'=>__('Save', 'vibe-appointments'),
	      'cancel'=>__('Cancel', 'vibe-appointments'),
	      'more'=>__('More', 'vibe-appointments'),
	      'search_here'=>__('Search...', 'vibe-appointments'),
	      'search_users'=>__('Search Users', 'vibe-appointments'),
	      'load_more'=>__('Load more', 'vibe-appointments'),
	      'participants'=>__('Participants', 'vibe-appointments'),
	      'starts'=>__('Starts', 'vibe-appointments'),
	      'ends'=>__('Ends', 'vibe-appointments'),
	      'pending_bookings'=>__('Pending Bookings', 'vibe-appointments'),
	      'accepted_bookings'=>__('Accepted Bookings', 'vibe-appointments'),
	      'rejected_bookings'=>__('Rejected Bookings', 'vibe-appointments'),
	      'accept'=>__('Accept', 'vibe-appointments'),
	      'reject'=>__('Reject', 'vibe-appointments'),
	      'delete'=>__('Delete', 'vibe-appointments'),
	      'month'=>__('Month','vibe-appointments'),
	      'week'=>__('Week','vibe-appointments'),
	      'day'=>__('Day','vibe-appointments'),
	      'months'=>__('Months','vibe-appointments'),
	      'weeks'=>__('Weeks','vibe-appointments'),
	      'days'=>__('Days','vibe-appointments'),
	      'today' => __('Today','vibe-appointments'),
	      'list' => __('List','vibe-appointments'),
	      'unlimited' => __('Unlimited','vibe-appointments'),
	      'missing_data' => __('Missing data','vibe-appointments'),
	      'type_here' => __('Type here','vibe-appointments'),
	      'exit_from_event' =>  __('Exit from event','vibe-appointments'),
	      'timezone'=>  __('TimeZone','vibe-appointments'),
	      'add_slot_booking'=>__('Add Booking for Slot','vibe-appointments'),
	      'type_to_search'=>__('Type to search...','vibe-appointments'),
	      'confirm_booking'=>__('Confirm Booking','vibe-appointments'),
	      'booking_note'=>__('Booking Note','vibe-appointments'),
	      'appointment_id'=>__('Appointment ID','vibe-appointments'),
	      'assign_member'=>__('Assign Slot to Member','vibe-appointments'),
	      'assign_group'=>__('Assign Slot to a Member Group','vibe-appointments'),
	      'no_notes'=>__('No notes found.','vibe-appointments'),
	      'event_details'=>__('Details','vibe-appointments'),
	      'event_activity'=>__('Activity','vibe-appointments'),
	      'event_review'=>__('Review','vibe-appointments'),
	      'event_messages'=>__('Messages','vibe-appointments'),
	      'no_activity'=>__('No recorded activity.','vibe-appointments'),
	      'no_details'=>__('No details found.','vibe-appointments'),
	      'set_services_slot_price'=>__('Set Services Slot Price.','vibe-appointments'),
	      'set_slot_price'=>__('Set Slot Price.','vibe-appointments'),
	      
	      'set_price'=>__('Set Price.','vibe-appointments'),
	      'complete_appointment'=>__('Mark Complete.','vibe-appointments'), 
	      'edit_appointment'=>__('Edit Appointment','vibe-appointments'), 
	      'cancel_appointment'=>__('Cancel Appointment.','vibe-appointments'),
	      'notify_user'=>__('Notify User','vibe-appointments'),
	      'remove_slot'=>__('Remove slot','vibe-appointments'),
	      'submit_review'=>__('Submit Review','vibe-appointments'),
	      'edit_review'=>__('Edit Review','vibe-appointments'),
	      'my_bookings'=>__('My Bookings','vibe-appointments'),
	      'completed_bookings'=>__('Completed Bookings','vibe-appointments'),
	      'review_title'=>__('Review Title','vibe-appointments'),
	      'review_content'=>__('Review Content','vibe-appointments'),
	      'year'=>__('year','vibe-appointments'),
	      'years'=>__('years','vibe-appointments'),
	      'month'=>__('month','vibe-appointments'),
	      'months'=>__('months','vibe-appointments'),
	      'day'=>__('day','vibe-appointments'),
	      'days'=>__('days','vibe-appointments'),
	      'hour'=>__('hour','vibe-appointments'),
	      'hours'=>__('hours','vibe-appointments'),
	      'minute'=>__('minute','vibe-appointments'),
	      'minutes'=>__('minutes','vibe-appointments'),
	      'second'=>__('second','vibe-appointments'),
	      'seconds'=>__('seconds','vibe-appointments'),
	      'select_option'=>__('Select option','vibe-appointments'),
	      'add_slot'=>__('Add Slot','vibe-appointments'),
	      'additional_slots'=>__('Additional Slot','vibe-appointments'),
	      'parent_booking'=>__('Main Slot','vibe-appointments'),
	      'connected_bookings'=>__('Connected Slots','vibe-appointments'),
	      'change_to_device_language'=>__('Device','vibe-appointments'),
	      'set_langauge'=>__('Set Language','vibe-appointments'),
	      'selected_events_count'=>__('Number of selected events','vibe-appointments'),
	      'slot_book_requested'=>__('Slot Booking Requested','vibe-appointments'),
	      'okay'=>__('Okay','vibe-appointments'),
	      'appointments_api_key'=>__('Appointments API KEY','vibe-appointments'),
	      'appointments_api_secret'=>__('Appointments API SECRET','vibe-appointments'),
	      'select_course'=>__('Select Course','vibe-appointments'),
	      'open_bookings'=>__('Open Bookings','vibe-appointments'),
	      'book'=>__('Book','vibe-appointments'),
	      'no_bookings_found'=>_x('No bookings found','api','vibe-appointments'),
	      'no_appointments_found'=>_x('No appointments found','api','vibe-appointments'),
	      'show_details'=>_x('Show Details','api','vibe-appointments'),
	      'appointment_id'=>_x('Appointment ID','api','vibe-appointments'),
	      'zoom_meetings_config'=>_x('Zoom Meeting Configuration','api','vibe-appointments'),
	      'zoom_api_key'=>_x('Zoom API Key','api','vibe-appointments'),
	      'zoom_api_secret'=>_x('Zoom API Secret','api','vibe-appointments'),
	      'account_id'=>_x('Zoom account Id','vibe-appointments'),
	      'find_service'=>__('Find a Service','vibe-appointments'),
	      'connect_to_service'=>__('Connect to a Service','vibe-appointments'),
	      'add_to_google_calendar'=>__('Add to Google Calendar','vibe-appointments'), 
				'message_instructor'=>__('Message Instructor','vibe-appointments'),
				'set_reminder'=>__('Set Reminder','vibe-appointments'),
				'review_instructor'=>__('Review Instructor','vibe-appointments'),
				'show_activity'=>__('Show Activity','vibe-appointments'),
				'reply_review'=>__('Reply review','vibe-appointments'),
				'group_booked'=>__('Group Booked','vibe-appointments'),
				'seats_text'=>__('Number of Seats for this slot','vibe-appointments'),
				'additional_bookers'=>__('Additional Bookers','vibe-appointments'),
				'add_100_slots_error'=>__('Saving over 100 slots is not recommended.','vibe-appointments'),
				'slot_status'=>__('Slot status','vibe-appointments'),
				'open'=>__('Open','vibe-appointments'),
				'booked'=>__('Booked','vibe-appointments'),
				'dispute'=>__('Raise a Dispute','vibe-appointments'),
				'dispute_description'=>__('Write a Dispute Description.','vibe-appointments'),
				'dispute_status'=>__('Dispute Status','vibe-appointments'),
				'submit_dispute'=>__('Submit Dispute.','vibe-appointments'),
				'dispute_notice'=>__('Doing this action will mark this Booking as Disputed. Site Administrator will be added to the Message chain. More discussion / details can be added in Messages section.','vibe-appointments'),
				'approve_dispute'=>__('Approve Dispute.','vibe-appointments'),
				'reject_dispute'=>__('Reject Dispute.','vibe-appointments'),
				'event_disputes'=>__('Disputes','vibe-appointments'),
				'no_disputes'=>__('No Disputes','vibe-appointments'),
				'clear_disputes_message'=>__('Booking actions disabled. Please clear the pending disputes before performing action on the booking.','vibe-appointments'),
				'cancellation_requests'=>__('Cancellation Requests','vibe-appointments'),
	      'help_text'=>[
	      	'booked'=>__('This is the place you will see your upcoming confirmed bookings.','vibe-appointments'),
				'previous'=>__('This is your past bookings. All the bookings you attended or missed will be here.','vibe-appointments'),
				'pending'=>__('These are your unconfirmed bookings. Bookings waiting on Instructor\'s approval or payment confirmation.','vibe-appointments'),
				'reviews'=>__('These are reviews posted by you for your bookings.','vibe-appointments'),
				'appointments_booked'=>__('This is the place you will see your upcoming and confirmed appointments.','vibe-appointments'),
				'appointments_previous'=>__('This is your past appointments. All the appointments you attended or missed will be here.','vibe-appointments'),
				'appointments_pending'=>__('These are your unconfirmed appointments. These bookings are awaiting your approval or payment confirmation.','vibe-appointments'),
				'appointments_cancel_requests'=>__('These are your cancellation requests. These bookings are awaiting your cancellation confirmation.','vibe-appointments'),
				]
	  )
	));


}

function get_vibe_appointments_pricing_array($user_id,$service_id=''){
	$data = [];
	$m = get_user_meta($user_id,'vibe_appointments_pricing_array',true);
	if(!empty($m) && is_array($m)){
		$data = $m;
	}
	if(!empty($service_id) && !empty($data[$service_id]) ){
		return $data[$service_id];
	}
	return $data;
}

function update_vibe_appointments_pricing_array($user_id,$service_id,$price_array){
	$data = [];
	$m = get_user_meta($user_id,'vibe_appointments_pricing_array',true);
	if(!empty($m)){
		$data = $m;
	}

	if(!empty($price_array) && !empty($price_array['value'])){
		update_user_meta($user_id,'_appointment_price'.$service_id,$price_array['value']);
	}

	$data[$service_id] = $price_array;
	//$_product = wc_get_product( $data[$service_id]['id'] );

	update_user_meta($user_id,'vibe_appointments_pricing_array',$data);
	return $data;
}


function remove_vibe_appointments_pricing_array($user_id,$service_id=''){
	$data = [];
	$m = get_user_meta($user_id,'vibe_appointments_pricing_array',true);
	if(!empty($m)){
		$data = $m;
	}
	if(!empty($data[$service_id])){
		unset($data[$service_id]);
	}
	delete_user_meta($user_id,'_appointment_price'.$service_id);
	update_user_meta($user_id,'vibe_appointments_pricing_array',$data);
	return $data;
}

function vibe_appointments_record_activity( $args = '' ) {
	global $bp;

	if ( !function_exists( 'bp_activity_add' ) )
		return false;

	$defaults = array(
		'id' => false,
		'user_id' => $bp->loggedin_user->id,
		'action' => 'course',
		'content' => '',
		'primary_link' => '',
		'component' => 'course',
		'type' => false,
		'item_id' => false,
		'secondary_item_id' => false,
		'recorded_time' => gmdate( "Y-m-d H:i:s" ),
		'hide_sitewide' => false
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r );

	return bp_activity_add( apply_filters('vibe_appointments_record_activity',array( 'id' => $id, 'user_id' => $user_id, 'action' => $action, 'content' => $content, 'primary_link' => $primary_link, 'component' => $component, 'type' => $type, 'item_id' => $item_id, 'secondary_item_id' => $secondary_item_id, 'recorded_time' => $recorded_time, 'hide_sitewide' => $hide_sitewide ) ));
}

function vibe_appointments_record_activity_meta($args=''){

	if ( !function_exists( 'bp_activity_update_meta' ) )
		return false;

	$defaults = array(
		'id' => false,
		'meta_key' => '',
		'meta_value' => ''
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r );

	return bp_activity_update_meta($id,$meta_key,$meta_value);
}




function vibe_appointments_add_notification($args =''){
	if ( ! bp_is_active( 'notifications' ) || !function_exists('bp_notifications_add_notification')) 
		return;
	global $bp;
	$defaults = array(
		'user_id' => $bp->loggedin_user->id,
		'item_id' => false,
		'secondary_item_id' => false,
		'component_name' => VIBE_APPOINTMENTS_SLUG,
		'component_action'  => '',
		'date_notified'     => bp_core_current_time(),
		'is_new'            => 1,
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r );

	return  bp_notifications_add_notification( array(
		'user_id'           => $user_id,
		'item_id'           => $item_id,
		'secondary_item_id' => $secondary_item_id,
		'component_name'    => $component_name,
		'component_action'  => $component_action,
		'date_notified'     => $date_notified,
		'is_new'            => $is_new,
	) );
	
}

function vibe_appointments_add_notification_meta($args=''){
	if ( !function_exists( 'bp_activity_update_meta' ) )
		return false;

	$defaults = array(
		'id' => false,
		'meta_key' => '',
		'meta_value' => ''
	);

	$r = wp_parse_args( $args, $defaults );
	extract( $r );
}
function vibe_appointments_messages_new_message($args = null){
	if(!function_exists('bp_is_active') || !bp_is_active('messages') || !function_exists('messages_new_message'))
		return;
	global $bp;
	$defaults = array(
		'sender_id' => $bp->loggedin_user->id,
		'subject' => '',
		'content' => '',
		'recipients' => '',
	);
	$r = wp_parse_args( $args, $defaults );
	extract( $r );
	return  messages_new_message( 
			array('sender_id' =>  $sender_id,
			  'subject' => $subject,
			  'content' => $content,
			  'recipients' => $recipients
			  )
		);
}


function vibe_appointments_get_instructor_service_rating($service_id,$user_id=null,$type = 'html'){

	$html = '';
	global $wpdb;

	if(empty($user_id)){
		$val = $wpdb->get_row($wpdb->prepare("
			SELECT AVG(b.meta_value) as avg, count(b.meta_value) as count
			FROM {$wpdb->commentmeta} as cm
			INNER JOIN {$wpdb->commentmeta} as b ON b.comment_id = cm.comment_id
			WHERE cm.meta_key ='booking_service_id'
			AND cm.meta_value = %d AND b.meta_key = %s
			",$service_id,'appointment_review_rating'),ARRAY_A);
	}else{
		$val = $wpdb->get_row($wpdb->prepare("
			SELECT AVG(b.meta_value) as avg, count(b.meta_value) as count
			FROM {$wpdb->commentmeta} as cm
			INNER JOIN {$wpdb->comments} as c ON cm.comment_id = c.comment_ID
			INNER JOIN {$wpdb->commentmeta} as b ON b.comment_id = cm.comment_id
			WHERE cm.meta_key ='booking_service_id'
			AND cm.meta_value = %d AND c.comment_author = %d 
			AND b.meta_key = %s
		",$service_id,$user_id,'appointment_review_rating'),ARRAY_A);
	}
	

	if(empty($val)){$val=['avg'=>0,'count'=>0];}
	if(!empty($type) && $type == 'html'){
		$html = '<div class="instructor_star_rating_wrapper">
            <strong class="instructor_star_rating">
		    <small class="blank_stars"><small style="width:'.round((100*$val['avg']/5),4).'%;" class="filled_stars"></small></small>
	      	</strong><span>( '.$val['count'].' )</span></div>';
	}else{
		$html = $val;
	}
	return $html;
}

function vibe_appointments_service_booking_count($service_id){

	global $wpdb;
	$db = new VIBE_APPOINTMENTS_DB;
	$count = $wpdb->get_var($wpdb->prepare("SELECT count(*) 
		FROM $db->table_name
		WHERE item_id = %d
		AND status = 'booked'
	",$service_id));

	if(Empty($count)){$count = 0;}

	return $count;
}


function vibe_appointments_is_directory(){

}



function vibe_appointments_bookable_widget_scripts($user_id=null,$type=null){
 	$blog_id = '';
    if(function_exists('get_current_blog_id')){
        $blog_id = get_current_blog_id();
    }
    if(!function_exists('format_code_lang')){
	  	require_once( ABSPATH . 'wp-admin/includes/ms.php' );
	  }
	
	if(empty($settings)){
		$settings=get_option(VIBE_APPOINTMENTS_OPTION);
	}
	$user=$users=[];
	if(!empty($user_id)){
		if(is_array($user_id)){
			foreach($user_id as $id){
                $users[]=[
                    'id'=>$id,
                    'display_name'=>bp_core_get_user_displayname($id),
                    'avatar'=>bp_core_fetch_avatar(array(
                            'item_id' => $id,
                            'object'  => 'user',
                            'type'=> 'thumb',
                            'html'    => false
                        ))
                ];
            }
		}else{
			$user = ['display_name'=>bp_core_get_user_displayname($user_id),'avatar'=>bp_core_fetch_avatar(array(
	                    'item_id' => $user_id,
	                    'object'  => 'user',
	                    'type'=> 'thumb',
	                    'html'    => false
			)),
			'id'=>$user_id,
			];
			$users[]=$user;
		}
	}
   
	$locale = get_locale();
  $locale_key = explode('_',$locale);
  $locale_key= $locale_key[0];
	$vars = apply_filters('vibe_appointments_booking_wdiget_vars',array(
		'user_id'=>empty($user_id)?'':$user_id,
		'user'=>(empty($user_id)?'':$user),
		'users'=>$users,
		'price'=>vibe_appointments_get_slot_price($user_id),
		'api_url'=>get_rest_url($blog_id,VIBE_APPOINTMENTS_API_NAMESPACE),
		'course_api_url'=>(defined('BP_COURSE_API_NAMESPACE')?get_rest_url($blog_id,BP_COURSE_API_NAMESPACE):''),
		'cart_url'=>function_exists('wc_get_cart_url')?wc_get_cart_url():'',
		'cookiepath'=>COOKIEPATH,
		'redirect_cart'=>(!empty($settings['redirect_cart_click_slot'])),
		'client_id'=>vibebp_get_setting('client_id'),
		'coin_image'=> plugins_url( '../assets/images/coin.svg',  __FILE__ ),
		'currency'=>function_exists('get_woocommerce_currency_symbol')?get_woocommerce_currency_symbol():'',
		'settings'=>array(
			'site_langauge'=>array(
				'key'=> $locale_key,
				'label'=>format_code_lang($locale_key)
	      ),
			'languageCode' => apply_filters('vibefullcalendar_locale_languageCode',''),//forcefully set like 'en' for English
		),
		'dow'=>array(
		  	1=>'MO',
		  	2=>'TU',
		  	3=>'WE',
		  	4=>'TH',
		  	5=>'FR',
		  	6=>'SA',
		  	0=>'SU',
		),
		'date_format' => apply_filters('vibe_appointments_date_format',convertPhpToJsMomentFormat(get_option('date_format'))),
		'availability'=>get_vibe_appointments_availability_data(),
	  	'time_format' => apply_filters('vibe_appointments_time_format',convertPhpToJsMomentFormat(get_option('time_format'))),
		'translations'=>array(
			'credits'=>_x('Credits','','vibe-appointments'),
			'confirm_booking'=>_x('Click Ok to confirm booking.','booking','vibe-appointments'),
			'confirm_booking_15_minutes'=>_x('Click Ok to confirm booking. Complete payment in 15 minutes.','booking','vibe-appointments'),
			'purchase_using_credits'=>_x('Purchase using credits','','vibe-appointments'),
			'purchase'=>_x('Purchase','','vibe-appointments'),
			'booking_price'=>_x('Price for booking','booking','vibe-appointments'),
			'booking_underprocessing'=>_x('Processing','booking','vibe-appointments'),
			'confirm'=>_x('Confirm','booking','vibe-appointments'),
			'cancel'=>_x('Cancel','booking','vibe-appointments'),
			'four_days'=>_x('4 days','','vibe-appointments')
		)
	),$type,$user_id);
	wp_enqueue_style('iziToast');
	wp_enqueue_script('iziToast');
	if($type == 'booking'){
    	wp_enqueue_script('vibe-appointments-booking',plugins_url('../assets/js/booking.js',__FILE__),array('wp-element','wp-data','vibebplogin'),VIBE_APPOINTMENTS_VERSION,true);	
    	wp_localize_script('vibe-appointments-booking','booking',$vars);
    	wp_enqueue_style('vibe-appointments-booking',plugins_url('../assets/css/booking.css',__FILE__),array('vibebp_main'),VIBE_APPOINTMENTS_VERSION);
    }

    if($type == 'book_widget_shortcode'){

    	$vibeappointments=get_vibeappointments_script_data();
        wp_enqueue_script('vibebp-flatpickr');
        wp_enqueue_script('moment');

        wp_enqueue_script('vibe-appointments-booking-widget',plugins_url('../assets/js/bookingwidget.js',__FILE__),array('wp-element','wp-data','vibebplogin','vibebp-flatpickr','moment'),VIBE_APPOINTMENTS_VERSION,true);
        
        
        wp_localize_script('vibe-appointments-booking-widget','booking',$vars);

        wp_localize_script('vibe-appointments-booking-widget','vibeappointments',$vibeappointments);
        wp_enqueue_style('vibe-appointments-booking-widget',plugins_url('../assets/css/bookingwidget.css',__FILE__),array('vibebp_main'),VIBE_APPOINTMENTS_VERSION);
        wp_enqueue_style('vibebp-flatpickr');
    }

    if($type == 'course_book_widget_shortcode'){
    	$vibeappointments=get_vibeappointments_script_data();
        wp_enqueue_script('vibebp-flatpickr');
        wp_enqueue_script('moment');
        wp_enqueue_script('vibe-appointments-course-booking-widget',plugins_url('../assets/js/coursebookingwidget.js',__FILE__),array('wp-element','wp-data','vibebplogin','vibebp-flatpickr','moment'),VIBE_APPOINTMENTS_VERSION,true);
        wp_localize_script('vibe-appointments-course-booking-widget','booking',$vars);
        
        wp_localize_script('vibe-appointments-course-booking-widget','vibeappointments',$vibeappointments);
        wp_enqueue_style('vibe-appointments-booking-widget',plugins_url('../assets/css/coursebookingwidget.css',__FILE__),array('vibebp_main'),VIBE_APPOINTMENTS_VERSION);
        wp_enqueue_style('vibebp-flatpickr');
    }
	
 }
function vibe_appointments_instructor_reviews($comment, $args, $depth) {
  	$GLOBALS['comment'] = $comment;

	 ?>
	 <li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">
	   <div id="comment-<?php comment_ID(); ?>" class="comment-body">
	     <div class="comment-body-inner">
	         <div class="comment-avatar">
	           <?php echo  bp_core_fetch_avatar( array( 
	           		'item_id' => $comment->user_id,
	           		'type'=>'thumb'
	           		) );
					?>
	         </div><!-- END avatar -->
	         <div class="comment-body-content">
	           <div class="comment-meta">
	             <?php 

	             	echo '<span>'.bp_core_get_user_displayname($comment->user_id).'</span>';
	               	echo '<span>'.sprintf(__('%1$s at %2$s','vibe-appointments'), get_comment_date(),  get_comment_time()).'</span>'; 
	             ?>
	           </div><!-- END comment-author vcard -->
	           <?php if ($comment->comment_approved == '0') : ?>
	             <em><?php _e('Your review is awaiting moderation.','vibe-appointments') ?></em>
	             <br />
	           <?php endif; ?>
	           <div class="comment-text">
	           <?php
	          $commenttitle = get_comment_meta( $comment->comment_ID, 'appointment_review_title', true );
	          $commentrating = get_comment_meta( $comment->comment_ID, 'appointment_review_rating', true );
	          echo '<h3>'.$commenttitle.'</h3>';

	          echo '<div class="instructor_star_rating_wrapper"><strong class="instructor_star_rating"><small class="blank_stars"><small style="width:'.round(100*$commentrating/5,2).'%;" class="filled_stars"></small></small></strong></div>';
	          comment_text(); ?>
	           </div>
	        </div> 
	     </div>
	   </div>
	 </li>
	 <?php
   

}


function convertPhpToJsMomentFormat(string $phpFormat){
    $replacements = [
        'A' => 'A',      // for the sake of escaping below
        'a' => 'a',      // for the sake of escaping below
        'B' => '',       // Swatch internet time (.beats), no equivalent
        'c' => 'YYYY-MM-DD[T]HH:mm:ssZ', // ISO 8601
        'D' => 'ddd',
        'd' => 'DD',
        'e' => 'zz',     // deprecated since version 1.6.0 of moment.js
        'F' => 'MMMM',
        'G' => 'H',
        'g' => 'h',
        'H' => 'HH',
        'h' => 'hh',
        'I' => '',       // Daylight Saving Time? => moment().isDST();
        'i' => 'mm',
        'j' => 'D',
        'L' => '',       // Leap year? => moment().isLeapYear();
        'l' => 'dddd',
        'M' => 'MMM',
        'm' => 'MM',
        'N' => 'E',
        'n' => 'M',
        'O' => 'ZZ',
        'o' => 'YYYY',
        'P' => 'Z',
        'r' => 'ddd, DD MMM YYYY HH:mm:ss ZZ', // RFC 2822
        'S' => 'o',
        's' => 'ss',
        'T' => 'z',      // deprecated since version 1.6.0 of moment.js
        't' => '',       // days in the month => moment().daysInMonth();
        'U' => 'X',
        'u' => 'SSSSSS', // microseconds
        'v' => 'SSS',    // milliseconds (from PHP 7.0.0)
        'W' => 'W',      // for the sake of escaping below
        'w' => 'e',
        'Y' => 'YYYY',
        'y' => 'YY',
        'Z' => '',       // time zone offset in minutes => moment().zone();
        'z' => 'DDD',
    ];

    // Converts escaped characters.
    foreach ($replacements as $from => $to) {
        $replacements['\\' . $from] = '[' . $from . ']';
    }

    return strtr($phpFormat, $replacements);
}
function get_vibe_appointments_availability_data(){
	return array(
	    'day'=>array(
	        'label'=>_x('Time of Day','availability','vibe-appointments'),
	        'slots'=>array(
	        array(
	            'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M24 23h-24v-2h24v2zm-24-6v2h4.069c-.041-.328-.069-.661-.069-1s.028-.672.069-1h-4.069zm7.103-5.312l-2.881-2.881-1.415 1.414 2.881 2.881c.412-.529.886-1.003 1.415-1.414zm3.897-1.688h2v-5h3l-4-4-4 4h3v5zm8.931 7c.041.328.069.661.069 1s-.028.672-.069 1h4.069v-2h-4.069zm-7.931-5c-3.314 0-6 2.686-6 6 0 .341.035.674.09 1h11.82c.055-.326.09-.659.09-1 0-3.314-2.686-6-6-6zm7.778-3.193l-2.881 2.881c.528.411 1.003.886 1.414 1.414l2.881-2.881-1.414-1.414z"/></svg>',
	            'starttime'=>360,
	            'endtime'=>720,
	            'label'=>_x('6-12','availability','vibe-appointments'),
	            'sub_label'=>_x('Morning','availability','vibe-appointments')
	        ),
	        array(
	            'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M22.088 13.126l1.912-1.126-1.912-1.126c-1.021-.602-1.372-1.91-.788-2.942l1.093-1.932-2.22-.02c-1.185-.01-2.143-.968-2.153-2.153l-.02-2.219-1.932 1.093c-1.031.583-2.34.233-2.941-.788l-1.127-1.913-1.127 1.913c-.602 1.021-1.91 1.372-2.941.788l-1.932-1.093-.02 2.219c-.01 1.185-.968 2.143-2.153 2.153l-2.22.02 1.093 1.932c.584 1.032.233 2.34-.788 2.942l-1.912 1.126 1.912 1.126c1.021.602 1.372 1.91.788 2.942l-1.093 1.932 2.22.02c1.185.01 2.143.968 2.153 2.153l.02 2.219 1.932-1.093c1.031-.583 2.34-.233 2.941.788l1.127 1.913 1.127-1.913c.602-1.021 1.91-1.372 2.941-.788l1.932 1.093.02-2.219c.011-1.185.969-2.143 2.153-2.153l2.22-.02-1.093-1.932c-.584-1.031-.234-2.34.788-2.942zm-10.117 6.874c-4.411 0-8-3.589-8-8s3.588-8 8-8 8 3.589 8 8-3.589 8-8 8zm6.029-8c0 3.313-2.687 6-6 6s-6-2.687-6-6 2.687-6 6-6 6 2.687 6 6z"/></svg>',
	            'starttime'=>720,
	            'endtime'=>1080,
	            'label'=>_x('12-6','availability','vibe-appointments'),
	            'sub_label'=>_x('Afternoon','availability','vibe-appointments')
	        ),
	        array(
	            'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M24 23h-24v-2h24v2zm-24-6v2h4.069c-.041-.328-.069-.661-.069-1s.028-.672.069-1h-4.069zm7.103-5.312l-2.881-2.881-1.415 1.414 2.881 2.881c.412-.529.886-1.003 1.415-1.414zm5.897-10.688h-2v5h-3l4 4 4-4h-3v-5zm6.931 16c.041.328.069.661.069 1s-.028.672-.069 1h4.069v-2h-4.069zm-7.931-5c-3.314 0-6 2.686-6 6 0 .341.035.674.09 1h11.82c.055-.326.09-.659.09-1 0-3.314-2.686-6-6-6zm7.778-3.193l-2.881 2.881c.528.411 1.003.886 1.414 1.414l2.881-2.881-1.414-1.414z"/></svg>',
	            'starttime'=>1080,
	            'endtime'=>1440,
	            'label'=>_x('6-12','availability','vibe-appointments'),
	            'sub_label'=>_x('Evening','availability','vibe-appointments')
	        ),
	        array(
	            'svg'=>'<svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M12 10.999c1.437.438 2.562 1.564 2.999 3.001.44-1.437 1.565-2.562 3.001-3-1.436-.439-2.561-1.563-3.001-3-.437 1.436-1.562 2.561-2.999 2.999zm8.001.001c.958.293 1.707 1.042 2 2.001.291-.959 1.042-1.709 1.999-2.001-.957-.292-1.707-1.042-2-2-.293.958-1.042 1.708-1.999 2zm-1-9c-.437 1.437-1.563 2.562-2.998 3.001 1.438.44 2.561 1.564 3.001 3.002.437-1.438 1.563-2.563 2.996-3.002-1.433-.437-2.559-1.564-2.999-3.001zm-7.001 22c-6.617 0-12-5.383-12-12s5.383-12 12-12c1.894 0 3.63.497 5.37 1.179-2.948.504-9.37 3.266-9.37 10.821 0 7.454 5.917 10.208 9.37 10.821-1.5.846-3.476 1.179-5.37 1.179z"/></svg>',
	            'starttime'=>0,
	            'endtime'=>360,
	            'label'=>_x('12-6','availability','vibe-appointments'),
	            'sub_label'=>_x('Night','availability','vibe-appointments')
	        )
	    ),
	    ),
	    'week'=>array(
	        'label'=>_x('Days of Week','availability','vibe-appointments'),
	        'slots'=>array(
	            array(
	                'label'=>_x('Sun','availability','vibe-appointments'),
	                'weekday'=>0
	            ),
	            array(
	                'label'=>_x('Mon','availability','vibe-appointments'),
	                'weekday'=>1
	            ),
	            array(
	                'label'=>_x('Tue','availability','vibe-appointments'),
	                'weekday'=>2
	            ),
	            array(
	                'label'=>_x('Wed','availability','vibe-appointments'),
	                'weekday'=>3
	            ),
	            array(
	                'label'=>_x('Thu','availability','vibe-appointments'),
	                'weekday'=>4
	            ),
	            array(
	                'label'=>_x('Fri','availability','vibe-appointments'),
	                'weekday'=>5
	            ),
	            array(
	                'label'=>_x('Sat','availability','vibe-appointments'),
	                'weekday'=>6
	            ),
	        )
	    ),
	    'dates'=>array(
	        array('value'=>7,'label'=>_x('Week','','vibe-appointments')),
	        array('value'=>30,'label'=>_x('Month','','vibe-appointments')),
	        array('value'=>'custom','label'=>_x('Custom','','vibe-appointments')),

	    )
	);
}

function vbp_a_get_weekday_to_numeric_value(){
	return array(
		'su'=>0,
		'mo'=>1,
		'tu'=>2,
		'we'=>3,
		'th'=>4,
		'fr'=>5,
		'sa'=>6,
	);
}

function vbp_parse_weekdays_to_numeric_vals($dow){
	$nval = [];
	foreach ($dow as $key => $val) {
		$nval[] = vbp_a_get_weekday_to_numeric_value()[strtolower($val)];
	}
	return $nval;
}

function vibe_appointments_get_next_scheduled_slot($appointment_id,$axis_timestamp=null){
	if($axis_timestamp==null){
		$axis_timestamp = time();
	}
	if(is_array($appointment_id) && !empty($appointment_id['appointment_id'])){
		$appointment =$appointment_id;
		$appointment_id = $appointment_id['appointment_id'];
	}else if(is_numeric($appointment_id)){
		$db = new VIBE_APPOINTMENTS_DB;
    $meta = new VIBE_APPOINTMENTS_META_DB;
		$appointments = $db->get_appointments(array('appointment_id'=>$appointment_id));
		if(empty($appointments)){
			return false;
		}
		$appointment = $appointments[0];
	}else{
		return false;
	}

	

	if(strpos($appointment['type'],'recurring_')!==false){

		$dow = explode('_',str_replace('recurring_', '', $appointment['type']));
		$dow = vbp_parse_weekdays_to_numeric_vals($dow);

		if(!empty($dow)){
			$start_time = intval($appointment['start_date'])/1000;
			$end_time = intval($appointment['end_date'])/1000;
			if($axis_timestamp < $end_time){
				$start_day = $start_time;
				while($start_day < $end_time){
					if($start_day > $axis_timestamp){
						$s_day = date('w',$start_day);
						if(in_array($s_day,$dow)){
							$end_day = strtotime(date('Y-m-d',$start_day).' '.date('H:i:s',$end_time));
							$appointment['start_date'] = $start_day*1000;
							$appointment['end_date'] = $end_day*1000;
							break;
						}
					}
					$start_day += 86400;
				}
			}
		}
	}
	
	return $appointment;
}


function vibe_appointments_class_block($post){
	$avatar = bp_core_fetch_avatar(array(
            'item_id' => $post->id,
            'object'  => 'group',
            'type'=>'full',
            'html'    => false
        ));
  $link = bp_get_group_permalink($post);

  $settings = vibe_appointments_get_settings();

  $average_rating = groups_get_groupmeta($post->id,'appointment_average_rating',true);

  if(empty($average_rating)){$average_rating=5;}

  ?>
  <div class="class_featured_block_wrapper tutorly_class_block class_<?php echo esc_attr($post->id); ?> flex flex-col" >
      <?php

      
     
      ?>
      <a href="<?php echo esc_url($link);?>" class="flex-1">
          <img src="<?php echo esc_url($avatar); ?>" alt="class image" class="class_avatar" />
      </a>
      <div class="class_info flex flex-col gap-6 border p-6 contentbg flex-1">
          <div class="flex gap-4">
              
              <div class="flex flex-col gap-2">
                  <a href="<?php echo esc_url($link);?>" class="flex-col flex">
                      <strong class="text-xl"><?php echo esc_html( $post->name ); ?></strong>
                   </a>
                   <span><?php echo implode(' ', array_slice(str_word_count( strip_tags($post->description),1), 0, 10)); ?></span>
              </div>
          </div>
          <span class="flex-1">
            <?php 
              $avatar = bp_core_fetch_avatar(array(
                  'item_id' => $post->creator_id,
                  'object'  => 'user',
                  'type'=>'thumb',
                  'html'    => false
              ));
              echo '<span class="flex gap-2 align-center class_author">
                  <img src="'.$avatar.'" />
                  <span class="flex flex-col flex-2"><strong>'.bp_core_get_user_displayname($post->creator_id).'</strong>
                  '.(empty($settings['instructor_sub_field'])?'':'<span>'.xprofile_get_field_data($settings['instructor_sub_field'],$post->creator_id).'</span>').'
                  </span>
              </span>';
            ?>
          </span>
          <span class="flex gap-2 items-center justify-between"><?php 
              if(!empty($settings['class_price'])){
                  $pid = groups_get_groupmeta($post->id,$settings['class_price'],true);
                  if(!empty($pid)){
                      $product = wc_get_product($pid);
                      echo '<span>'.$product->get_price_html().'<span class="per_slot">/'.esc_html__('slot','vibe-appointments').'</span></span>';
                  }
              }

          ?>
          <span class="flex gap-2 items-center"><svg xmlns="http://www.w3.org/2000/svg" version="1.0" width="20px" height="20px" viewBox="0 0 36 36"><path fill="currentColor" d="M19.6859343,0.861782958 L24.8136328,8.05088572 C25.0669318,8.40601432 25.4299179,8.6717536 25.8489524,8.80883508 L34.592052,11.6690221 C35.6704701,12.021812 36.2532905,13.1657829 35.8938178,14.2241526 C35.8056709,14.4836775 35.6647294,14.7229267 35.4795411,14.9273903 L29.901129,21.0864353 C29.5299163,21.4962859 29.3444371,22.0366367 29.3872912,22.5833831 L30.1116131,31.8245163 C30.1987981,32.9368499 29.3506698,33.9079379 28.2172657,33.993502 C27.9437428,34.0141511 27.6687736,33.9809301 27.4085205,33.8957918 L18.6506147,31.0307612 C18.2281197,30.8925477 17.7713439,30.8925477 17.3488489,31.0307612 L8.59094317,33.8957918 C7.51252508,34.2485817 6.34688429,33.6765963 5.98741159,32.6182265 C5.90066055,32.3628116 5.86681029,32.0929542 5.88785051,31.8245163 L6.61217242,22.5833831 C6.65502653,22.0366367 6.46954737,21.4962859 6.09833466,21.0864353 L0.519922484,14.9273903 C-0.235294755,14.0935658 -0.158766688,12.8167745 0.690852706,12.0755971 C0.899189467,11.8938516 1.14297067,11.7555303 1.40741159,11.6690221 L10.1505113,8.80883508 C10.5695458,8.6717536 10.9325319,8.40601432 11.1858308,8.05088572 L16.3135293,0.861782958 C16.9654141,-0.0521682813 18.2488096,-0.274439442 19.1800736,0.365326425 C19.3769294,0.500563797 19.5481352,0.668586713 19.6859343,0.861782958 Z"></path></svg>
              <?php
                  $rating = groups_get_groupmeta($post->id,'rating',true);
                  if(empty($rating)){$rating = 'N.A';}

                  echo $rating;
              ?>
           </span>
          </span>
          
      </div>
  </div>
  <?php
}

    

function vibe_appointments_class_block_css(){
    ?>
    <style>.vibe_apppointments_profile_classes{display:grid;grid-template-columns: repeat(auto-fill, minmax(180px, max-content));grid-gap:1rem;} .class_featured_block_wrapper{max-width:320px;} .class_featured_block_wrapper svg{color:#ffae30;}.class_featured_block_wrapper img{width: 100%};.class_featured_block_wrapper .class_author strong+span{font-size: .8em;opacity: 0.9;}.class_featured_block_wrapper .per_slot{opacity: 0.8;font-size: 0.8em;}.class_featured_block_wrapper .class_author img{width: 64px; height: 64px;border: 1px solid var(--border);border-radius: 50%;}.class_featured_block_wrapper .class_info{border-radius: 0 0 1rem 1rem;}.class_featured_block_wrapper img.class_avatar {border-radius: 1rem 1rem 0 0;}
    </style>
    <?php
}


function vibe_appointments_slot_seats($slot_id,$type='total'){

	$appointments_meta_db = new VIBE_APPOINTMENTS_META_DB;
  $seats = $appointments_meta_db->get_appointments_meta(['appointment_id'=>$appointment_id['appointment_id'],'meta_key'=>'seats']);
  if(!empty($seats) && $seats[0]['meta_value'] > 1){


      return $seats[0]['meta_value'];
  }

}