<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class WPLMS_Appointments_BBB_API{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new WPLMS_Appointments_BBB_API();
        return self::$instance;
    }

    function __construct(){
        
        
    }

    function get_server(){

        $init = WPLMS_Appointments_Init::init();
        $init->get_global_settings();

        if(substr($init->settings['bigbluebutton_server'],-1) != '/'){
            $init->settings['bigbluebutton_server'].='/';
        }
        return $init->settings['bigbluebutton_server'];
    }

    function get_salt(){
        
        $init = WPLMS_Appointments_Init::init();
        $init->get_global_settings();
        return $init->settings['bigbluebutton_secret'];
        
    }
    //&meta_endCallbackUrl so that when meeting ends user goes back to the site
    function get_all_meetings(){
        $meetings = get_option('bbb_meetings');
        return $meetings;
    }

    function update_all_meetings($meetingObject){
        $meetings = get_option('bbb_meetings');
        if(empty($meetings)){
            $meetings =array();
        }

        $meetings[$meetingObject['meetingID']] = array('meetingID'=>$meetingObject['meetingID'],'attendeePW'=>$meetingObject['attendeePW'],'moderatorPW'=>$meetingObject['moderatorPW'],'createTime'=>$meetingObject['createTime']);
        update_option('bbb_meetings',$meetings);
    }

    function remove_meeting($meetingID){
        $allmeetings = $this->get_all_meetings();
        if(!empty($allmeetings[$meetingID])){
            if(!empty($allmeetings[$meetingID]->users)){
                foreach($allmeetings[$meetingID]->users as $user){
                    $meetings = $this->get_user_meetings($user_id);
                    unset($meetings[$meetingID]);
                    update_user_meta($user_id,'bbb_meetings',$meetings);
                }
            }
            
        }
    }

    function get_user_meetings($user_id){
        $meetings = get_user_meta($user_id,'bbb_meetings',true);
        return $meetings;
    }

    function update_user_meetings($user_id,$meetingObject){
        $meetings = get_user_meta($user_id,'bbb_meetings',true);
        if(empty($meetings)){
            $meetings =array();
        }
        $meetings[$meetingObject['meetingID']] = array('meetingID'=>$meetingObject['meetingID'],'attendeePW'=>$meetingObject['attendeePW'],'moderatorPW'=>$meetingObject['moderatorPW'],'createTime'=>$meetingObject['createTime']);
        update_user_meta($user_id,'bbb_meetings',$meetings);
    }

    function object2array($object) { return @json_decode(@json_encode($object),1); } 

    function create_meeting($args,$user_id=null){

        $api = WPLMS_Appointments_Api::init();
        $api->debug['create_meeting_bbb_api']='started '.is_user_logged_in().'#';

        // if(!is_user_logged_in() && empty($user_id))
        //     return false;

        if(empty($user_id))
            $user_id = get_current_user_id();

        $api->debug['used_id']=$user_id;
        $init = WPLMS_Appointments_Init::init();
        $init->get_global_settings();
        //if(empty($init->settings['bigbluebutton_default_presentation']))
        
        

        $defaults = array(
            'name' => '',
            'meetingID'=>'',//AppointmentID
            'attendeePW'=>'',//pass the atendee(student) password
            'moderatorPW'=>'',//pass the moderator (instructor) password
            'welcome'=>'',
            'maxParticipants'=>'',
            'record'=>"true",
            'duration'=>'', //(minutes)
            'meta'=>'',//appointmentID
            'allowStartStopRecording'=>"true",
            'webcamsOnlyForModerator'=>'',//boolean
            'logo'=>'',//url
            'bannerText'=>'',
            'bannerColor'=>'',
            'copyright'=>'',
            'meta_endCallbackUrl'=>site_url(), //redirect to this site on meeting end
            'meta_bbb-recording-ready-url'=>'',//notify this url the BBB has finished processing the recorded video
        );

        $args = array_merge($defaults, $args);

        if(!empty($init->settings['appointments_recordings']) ){
            $args['record'] = true;
            $args['meta_bn-recording-ready-url']=urlencode(site_url().'/recordings/'.$args['meetingID']);
        }
        $presentation = '';

        
        if(!empty($args['presentation'])){
            $presentation = $args['presentation'];
            unset($args['presentation']);
        }else if(!empty($init->settings['bigbluebutton_default_presentation'])){
            $presentation = $init->settings['bigbluebutton_default_presentation'];
        }

        foreach($args as $key=>$val){
            if(Empty($val)){
                unset($args[$key]);
            }
        }
        $salt = $this->get_salt();

        $api->debug['salt']=$salt;
        if(empty($salt))
            return;

       
       //change localhost to videoencrypt
        if(strpos($this->get_server(),'videoencrypt')){
            
            $url = $this->get_server().$this->get_salt().'/api/create?'.http_build_query($args);
        }else{
            $url = $this->get_server().'api/create?'.http_build_query($args);
        }
            


            //print_r('create'.http_build_query($args).$salt);
            $checksum = sha1('create'.http_build_query($args).$salt);
            
            $bbb_url = $url.'&checksum='.$checksum;
            
            $api->debug['bbb_url']=$bbb_url;
            if(!empty($presentation)){
                $args =  array('headers'=>array('content-type'=>'text/xml'));
                $args['body'] = '<?xml version="1.0" encoding="UTF-8" ?><modules><module name="presentation"><document url="'.$presentation.'" /></module></modules>';


                $response = wp_remote_post($url,$args); 
            }else{
                //print_r($bbb_url);
                $response = wp_remote_get($bbb_url); 
                
            }

        

        $api->debug['xml']=wp_remote_retrieve_body( $response );
        
        if(wp_remote_retrieve_response_code($response) == 200){

            $xml = wp_remote_retrieve_body( $response );
            
            $xmlObject = simplexml_load_string($xml);
            
            if($xmlObject->returncode == 'SUCCESS'){
                $object = $this->object2array($xmlObject);

                return  $xmlObject;
            }

            if($xmlObject->returncode == 'FAILED'){
                return $xmlObject->message;
            }
        }
    }

    public function getJoinURL( $meetingID, $userName, $PW) {


        $api = WPLMS_Appointments_Api::init();
        $api->debug['getJoinURL']='getJoinURL $meetingID='.$meetingID.' $userName='.$userName.' $PW='.$PW;

        $salt = $this->get_salt();
        $params = 'meetingID='.urlencode($meetingID).'&fullName='.urlencode($userName).'&password='.urlencode($PW);

        if(strpos($this->get_server(), 'videoencrypt') || strpos($this->get_server(), 'localhost')){


            $url = $this->get_server().$salt.'/api/join?'.$params;
            
            $joinurl = wp_remote_get(esc_url_raw($url),array('timeout'=> 120));
            if(wp_remote_retrieve_response_code($joinurl) == 200){
                return esc_url_raw(wp_remote_retrieve_body($joinurl));
            }

        }else{
            
            $url = $this->get_server().'api/join?';


            //$checksum = sha1('join'.http_build_query($args).$salt);
            $checksum = sha1('join'.$params.$salt);
            
            $api->debug['url']=$url.$params.'&checksum='.sha1("join".$params.$salt);

            return ($url.$params.'&checksum='.sha1("join".$params.$salt) );


        }
    }

        
        

    function end_meeting($args){
        $defaults = array(
            'meetingID'=>''
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/end?'.http_build_query($args);
        $checksum = sha1('end'.$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->returncode == 'SUCCESS'){

                $xmlObject->users = array($user_id);
                $this->update_all_meetings($xmlObject);

                return true;
            }
        }
        return false;
    }

    function getMeetings(){
        $salt = $this->get_salt();
        $url = $this->get_server().'api/getMeetings/';
        
        $checksum = sha1('getMeetings'.$salt);

        $response = wp_remote_get($url.'?checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            return $xmlObject;
        }
    }

    function joinMeeting($args){
        $defaults = array(
            'fullName'=>'',
            'meetingID'=>'',
            'password'=>'',
            'createTime'=>'',//Match when the meeting started, pass the timestamp
            'userID'=>'',//WordPress User ID
            'configToken'=>'',
            'defaultLayout'=>'',
            'avatarURL'=>'',
            'redirect'=>true,//redirect or embed the client in the site
            'joinViaHtml5'=>true
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().$salt.'api/join?'.http_build_query($args);

       
        $url_join = $this->get_server()."api/join?";
        $params = 'meetingID='.urlencode($meetingID).'&fullName='.urlencode($userName).'&password='.urlencode($PW);
  
        $response = wp_remote_get($url_join.$params.'&checksum='.sha1("join".$params.$salt));

        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->returncode == 'SUCCESS'){
                $this->update_user_meetings($user_id,$xmlObject);
                $xmlObject->users = array($user_id);
                $this->update_all_meetings($xmlObject);
            }
        }
        /*
        <response>
          <returncode>SUCCESS</returncode>
          <messageKey>successfullyJoined</messageKey>
          <message>You have joined successfully.</message>
          <meeting_id>640ab2bae07bedc4c163f679a746f7ab7fb5d1fa-1531155809613</meeting_id>
          <user_id>w_euxnssffnsbs</user_id>
          <auth_token>14mm5y3eurjw</auth_token>
          <session_token>ai1wqj8wb6s7rnk0</session_token>
          <url>https://yourserver.com/client/BigBlueButton.html?sessionToken=ai1wqj8wb6s7rnk0</url>
        </response>*/
    }

    function isMeetingRunning($args){
        $defaults = array(
            'meetingID'=>''
        );
 
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/isMeetingRunning?'.http_build_query($args);
       
        $checksum = sha1('isMeetingRunning'.$salt);

        $response = wp_remote_get($url.'&checksum='.$checksum);

        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->returncode == 'SUCCESS'){
                return true;
            }
        }
        return false;
    }

    function getMeetingsInfo ($args){
        $defaults = array(
            'meetingID'=>'',
            'password'=>''//Moderator password
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/getMeetingInfo?'.http_build_query($args);

        $checksum = sha1($url.$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->returncode == 'SUCCESS'){
                return $xmlObject;
                /*
                <response>
                  <returncode>SUCCESS</returncode>
                  <meetingName>Demo Meeting</meetingName>
                  <meetingID>Demo Meeting</meetingID>
                  <internalMeetingID>183f0bf3a0982a127bdb8161e0c44eb696b3e75c-1531240585189</internalMeetingID>
                  <createTime>1531240585189</createTime>
                  <createDate>Tue Jul 10 16:36:25 UTC 2018</createDate>
                  <voiceBridge>70066</voiceBridge>
                  <dialNumber>613-555-1234</dialNumber>
                  <attendeePW>ap</attendeePW>
                  <moderatorPW>mp</moderatorPW>
                  <running>true</running>
                  <duration>0</duration>
                  <hasUserJoined>true</hasUserJoined>
                  <recording>false</recording>
                  <hasBeenForciblyEnded>false</hasBeenForciblyEnded>
                  <startTime>1531240585239</startTime>
                  <endTime>0</endTime>
                  <participantCount>2</participantCount>
                  <listenerCount>1</listenerCount>
                  <voiceParticipantCount>1</voiceParticipantCount>
                  <videoCount>1</videoCount>
                  <maxUsers>20</maxUsers>
                  <moderatorCount>1</moderatorCount>
                  <attendees>
                    <attendee>
                      <userID>w_2wzzszfaptsp</userID>
                      <fullName>stu</fullName>
                      <role>VIEWER</role>
                      <isPresenter>false</isPresenter>
                      <isListeningOnly>true</isListeningOnly>
                      <hasJoinedVoice>false</hasJoinedVoice>
                      <hasVideo>false</hasVideo>
                      <clientType>FLASH</clientType>
                    </attendee>
                    <attendee>
                      <userID>w_eo7lxnx3vwuj</userID>
                      <fullName>mod</fullName>
                      <role>MODERATOR</role>
                      <isPresenter>true</isPresenter>
                      <isListeningOnly>false</isListeningOnly>
                      <hasJoinedVoice>true</hasJoinedVoice>
                      <hasVideo>true</hasVideo>
                      <clientType>HTML5</clientType>
                    </attendee>
                  </attendees>
                  <metadata />
                  <isBreakout>false</isBreakout>
                </response>*/
            }
        }
        return false;
    }


    function getMeetingInfo($args){
        $defaults = array(
            'meetingID'=>'',
            'password'=>''//Moderator password
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/getMeetingInfo?'.http_build_query($args);
        $checksum = sha1('getMeetingInfo'.http_build_query($args).$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->returncode == 'SUCCESS'){
                return $xmlObject;
            }
        }
        return false;
    }

    function getRecordings($args){
        
        $defaults = array(
            'meetingID'=>'',
            'recordID'=>'',
            'state'=>'',//recording status [processing|processed|published|unpublished|deleted]
            'meta'=>'',
        );

        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        if(!empty($args)){
            $url = $this->get_server().'api/getRecordings?'.http_build_query($args);
            $checksum = sha1($url.$salt);
            $response = wp_remote_get($url.'&checksum='.$checksum);    
        }else{
            $url = $this->get_server().'api/getRecordings';
            $checksum = sha1($url.$salt);
            $response = wp_remote_get($url.'?checksum='.$checksum);
        }
        
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            return $xmlObject->recordings;
        }

        return '';
    }

    function publishRecordings($args){
        $defaults = array(
            'recordID'=>'',
            'publish'=>''
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/publishRecordings?'.http_build_query($args);
        $checksum = sha1($url.$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->published == 'true' || $xmlObject->published == true){
                return true;
            }
        }
        return false;
    }

    function deleteRecordings($args){
        $defaults = array(
            'recordID'=>'',
        );
        $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/deleteRecordings?'.http_build_query($args);
        $checksum = sha1($url.$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->deleted == 'true' || $xmlObject->deleted == true){
                return true;
            }
        }
        return false;
    }

    function updateRecordings($args){
         $defaults = array(
            'recordID'=>'',
        );
         $args = array_merge($defaults, $args);
        $salt = $this->get_salt();
        $url = $this->get_server().'api/updateRecordings?'.http_build_query($args);
        $checksum = sha1($url.$salt);
        $response = wp_remote_get($url.'&checksum='.$checksum);
        if(wp_remote_retrieve_response_code($response) == 200){
            $xml = wp_remote_retrieve_body( $response );
            $xmlObject = simplexml_load_string($xml);
            if($xmlObject->deleted == 'true' || $xmlObject->deleted == true){
                return true;
            }
        }
        return false;
    }

    function endMeeting($args){
        $defaults = array(
            'meetingID'=>'',
            'password'=>''
        );
        $args = array_merge($defaults, $args);

        $salt = $this->get_salt();
        $url = $this->get_server().'api/end?'.http_build_query($args);

        if(strpos($this->get_server(), 'videoencrypt') || strpos($this->get_server(), 'localhost')){

            $url = $this->get_server().$salt.'/api/end?'.http_build_query($args);
            //print_r($url);
            $joinurl = wp_remote_get(esc_url_raw($url));

            return esc_url_raw($joinurl['body']);

        }else{

            $checksum = sha1('end'.http_build_query($args).$salt);
            $response = wp_remote_get($url.'&checksum='.$checksum);

            if(wp_remote_retrieve_response_code($response) == 200){
                $xml = wp_remote_retrieve_body( $response );
                $xmlObject = simplexml_load_string($xml);
                if($xmlObject->returncode == 'SUCCESS'){
                    return true;
                }
            }
        }

        return false;
    }
}

WPLMS_Appointments_BBB_API::init();