<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class WPLMS_Appointments_Meetings{


    public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new WPLMS_Appointments_Meetings();
        return self::$instance;
    }

    function __construct(){
        
        add_action('wplms_appointment_schedule_id',array($this,'set_meeting'));
        

    }

    function set_meeting($schedule_id,$appointment_id=null){

        $api = WPLMS_Appointments_Api::init();
        $api->debug['appointment_set_meeting']='started';
        $meta_db = new VIBE_APPOINTMENTS_META_DB; 
        
        if(empty($appointment_id)){
            $sq = $meta_db->get_appointments_meta(array('appointment_id' => $schedule_id,'meta_key'=>'schedule_queue'));
            $schedule_queue = unserialize($sq[0]['meta_value']);
            $api->debug['schedule_queue']=$schedule_queue ;
            $appointment_id = 0;

            if(empty($schedule_queue))
                return;


            $meta_db = new VIBE_APPOINTMENTS_META_DB();
            $init = WPLMS_Appointments_Init::init();
            // if(empty($init->settings['meeting_time_buffer']))
            //     return $return;

            if(!empty($schedule_queue)){
                $i=0;
                $timestamp = $schedule_queue[0]['timestamp'] - $init->settings['meeting_time_buffer']*60;
                foreach($schedule_queue as $appointment_data){
                    if($appointment_data['timestamp'] - $init->settings['meeting_time_buffer']*60 > time()){
                        $appointment_id = $appointment_data['appointment_id'];
                        break;
                    }
                }
            }
        }
        

       // print_r($appointment_id);
        $db = new VIBE_APPOINTMENTS_DB;
        $appointments =  $db->get_appointments(Array('appointment_id'=>$appointment_id));
        $appointment = $appointments[0];

       

        $bbb_api = WPLMS_Appointments_BBB_API::init();
        
        

        $bookers = wplms_get_appointment_bookers($appointment['appointment_id']);
        $api->debug['bookers']=$bookers;
        if(empty($bookers))
            return;

        $welcome = $meta_db->get_appointments_meta(array('appointment_id'=>$appointment['appointment_id'],'meta_key'=>'meeting_notes'));
        $welcome = $welcome[0];

        $args = array(
            'name' => bp_core_get_user_displayname(intval($appointment['author_id'])).'_'.$schedule_id.'_'.$appointment['appointment_id'],
            'meetingID'=>$appointment['appointment_id'],//AppointmentID
            'attendeePW'=> wp_generate_password(5,false,false),
            'moderatorPW'=>wp_generate_password(10,false,false),
            'welcome'=>$welcome['meta_value'],
            'maxParticipants'=>count($bookers)+2,
            'record'=>false,
            'duration'=>($appointment['end_time'] - $appointment['start_time']), //(minutes)
            'meta'=>'',//appointmentID
            'allowStartStopRecording'=>false,
            'webcamsOnlyForModerator'=>'',//boolean
            'logo'=>function_exists('vibe_get_option') && vibe_get_option('logo')?vibe_get_option('logo'):wp_get_attachment_image_src( get_theme_mod( 'custom_logo' ) , 'full' ),//url
            'bannerText'=>'',
            'bannerColor'=>'',
            'logoutURL'=>home_url().'/endmeeting/'.$schedule_id,
            'copyright'=>vibe_get_option('copyright'),
            'meta_endCallbackUrl'=>site_url(), //redirect to this site on meeting end
            //'meta_bn-recording-ready-url'=>''
            );

        $meta_db = new VIBE_APPOINTMENTS_META_DB; 
        $meeting_presentation = $meta_db->get_appointments_meta(array('appointment_id' => $schedule_id,'meta_key'=>'meeting_presentation'));
        $meeting_presentation = $meeting_presentation[0]['meta_value'];

        $args['presentation'] = $meeting_presentation;
        
        $api->debug['args']=$args;
        $object = $bbb_api->create_meeting($args,get_current_user_id());
        $api->debug['create_meeting']=$object;
        $result = json_decode($object);

        //print_r($result);
        if (json_last_error() === JSON_ERROR_NONE) {
            // JSON is valid
            if(!$result->status){
                do_action('wplms_appointments_meeting_create_failed',$schedule_id,$appointment['appointment_id']);
            }else{
                $meta_db->update_appointment_meta(array('appointment_id'   => $appointment['appointment_id'],
                    'meta_key'          => 'meeting_args',
                    'meta_value'        => $args,
                    'single'            => 1)
                );
                do_action('wplms_appointments_meeting_created',$schedule_id,$appointment['appointment_id'],$appointment['author_id']);
            }

        }else{
            $meta_db->update_appointment_meta(array('appointment_id'   => $appointment['appointment_id'],
                'meta_key'          => 'meeting_args',
                'meta_value'        => $args,
                'single'            => 1)
            );

            do_action('wplms_appointments_meeting_created',$schedule_id,$appointment['appointment_id'],$appointment['author_id']);
        }

    }


}

WPLMS_Appointments_Meetings::init();