<?php
/**
 * 
 * @author 		VibeThemes
 * @category 	Init
 * @package 	wplms-appointments/Includes
 * @version     1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


class WPLMS_Appointments_Services{


	public static $instance;

    public static function init(){

        if ( is_null( self::$instance ) )
            self::$instance = new WPLMS_Appointments_Services();
        return self::$instance;
    }


    function __construct(){
 		
        add_action('init',array($this,'register_services'));
       	add_action( VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG.'_add_form_fields', array( $this, 'add_category_fields' ));
		add_action(  VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG.'_edit_form_fields', array( $this, 'edit_category_fields' ));
		add_action( 'created_term', array($this,'save_category_meta'), 10, 2 );
		add_action( 'edited_term', array($this,'save_category_meta'), 10, 2 );
		add_action('wp_head',array($this,'add_service_types_taxonomies_json'),99);

		
		add_action( 'template_redirect',array($this, 'service_redirect' ),1);
		add_action('vibe_before_apointment_directory',array($this,'check_content'));
		add_Action('admin_enqueue_scripts','wp_enqueue_media');
    }

    function check_content(){
    	global $post;
    	?>
    	<div class="col-md-12 col-sm-12">
		<div class="content">
			<div class="row">
    	<?php
        if ( (!empty($post) && $post->post_type==VIBE_APPOINTMENTS_SERVICE_SLUG) ){
        	echo the_content();
        }
        ?>
    	</div></div></div>
    	<?php
    }

    function service_redirect( $template ) {
    	if ( '' != locate_template( 'taxonomy-service-type.php' ) ) {
		     return;
		}
        $plugindir = dirname( __FILE__ );
        global $post;
        if(empty($this->settings)){
        	$this->settings=get_option(VIBE_APPOINTMENTS_OPTION);
        }
        if ( (!empty($post) && $post->post_type==VIBE_APPOINTMENTS_SERVICE_SLUG) || is_tax( VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG )) {
            add_action('template_include',function(){
                ob_start();
                if(function_exists('vibe_get_header')){
                	get_header(vibe_get_header());
                }else{
                	get_header();
                }
                ?>
                <section id="title">
					<?php do_action('wplms_before_title'); 
					if(function_exists('vibe_get_container')){
						?><div class="<?php echo vibe_get_container(); ?>"><?php
					}
					?>
				    
				        <div class="row">
				             <div class="col-md-12">
				                <div class="pagetitle">
				                	<?php vibe_breadcrumbs(); ?> 
				                   	<h1><?php single_cat_title(); ?></h1>
				                    <h5><?php echo do_shortcode(category_description()); ?></h5>
				                </div>
				            </div>
				        </div>
				   <?php do_action('wplms_before_title'); 
					if(function_exists('vibe_get_container')){
						?></div><?php
					}
					?>
				</section>
				<section id="content">
				<div id="buddypress">
			    <?php do_action('wplms_before_title'); 
				if(function_exists('vibe_get_container')){
					?><div class="<?php echo vibe_get_container(); ?>"><?php
				}
				?>
					<div class="padder">
						<?php do_action( 'vibe_before_apointment_directory' ); ?>	
						<div class="row">
							<div class="col-md-12 col-sm-12">
								<div class="content">
					                <?php
					               	$layout = new WP_Query(apply_filters('vbp_single_service_layout',array(
					                    'post_type'=>'page',
					                    'posts_per_page'=>1,
					                    'post__in'=>array($this->settings['appointments_directory_page']),
					                )));
					                if($layout->have_posts()){
					                    while($layout->have_posts()){
					                        $layout->the_post();
					                        global $post;
					                        setup_postdata($post);
					                        $content=$post->post_content;
					                        the_content();
					                        if(class_exists('\Elementor\Frontend')){
					                            $elementorFrontend = new \Elementor\Frontend();
					                            $elementorFrontend->enqueue_scripts();
					                            $elementorFrontend->enqueue_styles();
					                        }
					                        
					                    }
					                }
					                ?>
	                					
								</div>
								</div>	
						</div>	
						<?php do_action( 'bp_after_directory_course' ); ?>

					</div><!-- .padder -->
					
					<?php do_action( 'bp_after_directory_course_page' ); ?>
				<?php do_action('wplms_before_title'); 
				if(function_exists('vibe_get_container')){
					?></div><?php
				}
				?>
				</div>
				</section>
                <?php
               	if(function_exists('vibe_get_footer')){
                	get_footer(vibe_get_footer());
                }else{
                	get_footer();
                }
                echo ob_get_clean();
                exit();
            });
        }
        return $template;
    }

    function register_services(){
    	$options = vibe_appointments_get_settings();
    	if(empty($options['appointments_services'])){
    		return;
    	}
    	register_taxonomy( VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG, array( VIBE_APPOINTMENTS_SERVICE_SLUG),
			array(
				'labels' => array(
					'name' => __('Service Type','vibe-appointments'),
					'menu_name' => __('Service Type','vibe-appointments'),
					'singular_name' => __('Service Type','vibe-appointments'),
					'add_new_item' => __('Add New Service Type','vibe-appointments'),
					'all_items' => __('All Service Types','vibe-appointments')
				),
				'public' => true,
				'hierarchical' => true,
				'show_ui' => true,
				'show_admin_column' => true,
		        'query_var' => 'service-type',           
				'show_in_nav_menus' => true,
				'rewrite' => array( 
					'slug' => 'service-type',
					'hierarchical' => true, 
					'with_front' => false ),
			)
		);

		register_post_type( VIBE_APPOINTMENTS_SERVICE_SLUG,
			array(
				'labels' => array(
					'name' => __('Services','vibe-appointments'),
					'menu_name' => __('Services','vibe-appointments'),
					'singular_name' => __('Service','vibe-appointments'),
					'add_new_item' => __('Add New Service','vibe-appointments'),
					'all_items' => __('All Services','vibe-appointments')
				),
				'public' => true,
				'publicly_queryable' => true,
				'show_ui' => true,
				'menu_icon'           => 'dashicons-admin-site-alt2',
				'capability_type' => 'post',
	            'has_archive' => false,
				'show_in_admin_bar' => true,
				'show_in_nav_menus' => true,
				'taxonomies' => array( VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG),
				'supports' => array( 'title','editor','thumbnail','author','comments','excerpt','revisions','custom-fields', 'page-attributes'),
				'hierarchical' => true,
				'rewrite' => array( 'slug' => VIBE_APPOINTMENTS_SERVICE_SLUG, 'hierarchical' => true, 'with_front' => false )
			)
		);
    }

    function add_category_fields(){
    	
    	$default = plugins_url('../../assets/images/avatar.jpg',__FILE__);

    	?>
    	<div class="form-field">
    	<label><?php _e( 'Display Order', 'vibe-appointments' ); ?></label>
    	<input type="number" name="service_type_order" id="service_type_order" value="" />
    	</div>
    	<div class="form-field">
			<label><?php _e( 'Thumbnail', 'vibe-appointments' ); ?></label>
			<div id="service_type_thumbnail" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $default ); ?>" width="60px" height="60px" /></div>
			<div style="line-height: 60px;">
				<input type="hidden" id="service_type_thumbnail_id" name="service_type_thumbnail_id" />
				<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'vibe-appointments' ); ?></button>
				<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'vibe-appointments' ); ?></button>
			</div>
			<script type="text/javascript">
				if ( ! jQuery( '#service_type_thumbnail_id' ).val() ) {
					jQuery( '.remove_image_button' ).hide();
				}
				// Uploading files
				var file_frame;

				jQuery( document ).on( 'click', '.upload_image_button', function( event ) {
					event.preventDefault();
					// If the media frame already exists, reopen it.
					if ( file_frame ) {
						file_frame.open();
						return;
					}

					// Create the media frame.
					file_frame = wp.media.frames.downloadable_file = wp.media({
						title: '<?php _e( "Choose an image", "vibe" ); ?>',
						button: {
							text: '<?php _e( "Use image", "vibe" ); ?>'
						},
						multiple: false
					});
					file_frame.on( 'select', function() {
						var attachment = file_frame.state().get( 'selection' ).first().toJSON();
						jQuery( '#service_type_thumbnail_id' ).val( attachment.id );
						if( attachment.sizes){
						    if(   attachment.sizes.thumbnail !== undefined  ) url_image=attachment.sizes.thumbnail.url; 
						    else if( attachment.sizes.medium !== undefined ) url_image=attachment.sizes.medium.url;
						    else url_image=attachment.sizes.full.url;
						}

						jQuery( '#service_type_thumbnail' ).find( 'img' ).attr( 'src', url_image );
						
						jQuery( '.remove_image_button' ).show();
					});
					file_frame.open();
				});

				jQuery( document ).on( 'click', '.remove_image_button', function() {
					jQuery( '#service_type_thumbnail' ).find( 'img' ).attr( 'src', '<?php echo esc_js( $default ); ?>' );
					jQuery( '#service_type_thumbnail_id' ).val( '' );
					jQuery( '.remove_image_button' ).hide();
					return false;
				});

			</script>

			<div class="clear"></div>
		</div>
		<?php
		
    }
    /*
    *	Edit Course Category Featured thubmanils
    *	Use WP 4.4 Term meta for storing information
    * 	@reference : WooCommerce (GPLv2)
    */
    function edit_category_fields($term){


    	$thumbnail_id = absint( get_term_meta( $term->term_id, 'service_type_thumbnail_id', true ) );
    	$order = get_term_meta( $term->term_id, 'service_type_order', true ); 
		if ( $thumbnail_id ) {
			$image = wp_get_attachment_thumb_url( $thumbnail_id );
		} else {
			$image = plugins_url('../../assets/images/avatar.jpg',__FILE);
		}

    	?>
    	<tr class="form-field">
    		<th scope="row" valign="top"><label><?php _e( 'Display Order', 'vibe-appointments' ); ?></label></th>
			<td><input type="number" name="service_type_order" id="service_type_order" value="<?php echo (empty($order)?0:$order); ?>" /></td>
    	</tr>
    	<tr class="form-field">
			<th scope="row" valign="top"><label><?php _e( 'Thumbnail', 'vibe-appointments' ); ?></label></th>
			<td>
				<div id="service_type_thumbnail" style="float: left; margin-right: 10px;"><img src="<?php echo esc_url( $image ); ?>" width="60px" height="60px" /></div>
				<div style="line-height: 60px;">
					<input type="hidden" id="service_type_thumbnail_id" name="service_type_thumbnail_id" value="<?php echo vibe_sanitizer($thumbnail_id,'text'); ?>" />
					<button type="button" class="upload_image_button button"><?php _e( 'Upload/Add image', 'vibe-appointments' ); ?></button>
					<button type="button" class="remove_image_button button"><?php _e( 'Remove image', 'vibe-appointments' ); ?></button>
				</div>
				<script type="text/javascript">

					// Only show the "remove image" button when needed
					if ( '0' === jQuery( '#service_type_thumbnail_id' ).val() ) {
						jQuery( '.remove_image_button' ).hide();
					}

					// Uploading files
					var file_frame;

					jQuery( document ).on( 'click', '.upload_image_button', function( event ) {

						event.preventDefault();

						// If the media frame already exists, reopen it.
						if ( file_frame ) {
							file_frame.open();
							return;
						}

						// Create the media frame.
						file_frame = wp.media.frames.downloadable_file = wp.media({
							title: '<?php _e( "Choose an image", "vibe" ); ?>',
							button: {
								text: '<?php _e( "Use image", "vibe" ); ?>'
							},
							multiple: false
						});

						// When an image is selected, run a callback.
						file_frame.on( 'select', function() {
							var attachment = file_frame.state().get( 'selection' ).first().toJSON();

							jQuery( '#service_type_thumbnail_id' ).val( attachment.id );
							let url_image = '';
							if( attachment.sizes){
							    if(   attachment.sizes.thumbnail !== undefined  ) url_image=attachment.sizes.thumbnail.url; 
							    else if( attachment.sizes.medium !== undefined ) url_image=attachment.sizes.medium.url;
							    else url_image=attachment.sizes.full.url;
							}else{
								url_image = attachment.url;
							}

							jQuery( '#service_type_thumbnail' ).find( 'img' ).attr( 'src', url_image );
							jQuery( '.remove_image_button' ).show();
						});

						// Finally, open the modal.
						file_frame.open();
					});

					jQuery( document ).on( 'click', '.remove_image_button', function() {
						jQuery( '#service_type_thumbnail' ).find( 'img' ).attr( 'src', '<?php echo esc_js( $image ); ?>' );
						jQuery( '#service_type_thumbnail_id' ).val( '' );
						jQuery( '.remove_image_button' ).hide();
						return false;
					});

				</script>
				<div class="clear"></div>
			</td>
		</tr>
		<?php
		wp_enqueue_script('media');
    }


	function save_category_meta( $term_id, $tt_id ){
		global $wpdb;
	    if( isset( $_POST['service_type_thumbnail_id'] )){
	        $thumb_id = intval( $_POST['service_type_thumbnail_id'] );
	        update_term_meta( $term_id, 'service_type_thumbnail_id', $thumb_id );
	    }
	    if( isset( $_POST['service_type_order'] ) &&is_numeric($_POST['service_type_order'])){
	        update_term_meta( $term_id, 'service_type_order', $_POST['service_type_order'] );
	        $wpdb->update($wpdb->terms, array('term_group' => $_POST['service_type_order']), array('term_id'=>$term_id));
	    }
	}

	function add_service_types_taxonomies_json(){


        $taxonomies = get_taxonomies( [ 'object_type' => [ VIBE_APPOINTMENTS_SERVICE_SLUG ] ] );
        $course_taxonomies = $stype_taxonomies = [];
        foreach ($taxonomies as $key => $tax) {
            $stype_taxonomies[] = $tax;
        }
        $stype_taxonomies = apply_filters('vibe_appointments_services_taxonomies',$stype_taxonomies);
        $object = get_queried_object();
        if(!empty($object) && !empty($object->taxonomy) && in_array($object->taxonomy, $stype_taxonomies)){
            ?>
            <script>
                window.vibeappointments_service_type = <?php echo (int)$object->term_id;?>;
            </script>
            <?php
            
        }else{
        	global $post;
	        if(!empty($post) && $post->post_type==VIBE_APPOINTMENTS_SERVICE_SLUG){
	        	global $post;
	        	?>
	            <script>
	                window.vibeappointments_service = <?php echo (int)$post->ID;?>;
	            </script>
	            <?php
	     
	        }
        }
        

    }

}

WPLMS_Appointments_Services::init();
