<?php
/*
Plugin Name: Vibe Appointments
Plugin URI: https://wplms.io
Description: Vibe Appointments
Author: VibeThemes
Version: 1.9.7.6
Author URI: https://www.wplms.io
Text Domain: vibe-appointments
Domain Path: /languages/
*/

if ( ! defined( 'ABSPATH' ) ) exit;

if( !defined('VIBE_APPOINTMENTS_VERSION')){
    define('VIBE_APPOINTMENTS_VERSION','1.9.7.6');
}

defined('VIBE_APPOINTMENTS_PRE_ACTIVATED_THEMES') or define('VIBE_APPOINTMENTS_PRE_ACTIVATED_THEMES', ['38109296']);

if( !defined('VIBE_PLUGIN_URL')){
    define('VIBE_PLUGIN_URL',plugins_url());
}

if( !defined('APPOINTMENTS_UPDATE_URL')){
    define( 'APPOINTMENTS_UPDATE_URL', 'https://wplms.io' ); 
    define( 'APPOINTMENTS_UPDATE_ITEM_ID', 64307 );
}


if( !defined('VIBE_APPOINTMENTS_SLUG')){
    define('VIBE_APPOINTMENTS_SLUG','appointments');
}
if( !defined('VIBE_APPOINTMENTS_OPTION')){
    define('VIBE_APPOINTMENTS_OPTION','vibe_appointments');
}

if( !defined('VIBE_APPOINTMENTS_API_NAMESPACE')){
    define('VIBE_APPOINTMENTS_API_NAMESPACE','vibeappointments/v1');
}


if ( ! defined( 'VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG' ) ) {
    define( 'VIBE_APPOINTMENTS_SERVICE_TYPE_SLUG', 'service-type' );
}

if ( ! defined( 'VIBE_APPOINTMENTS_SERVICE_SLUG' ) ) {
    define( 'VIBE_APPOINTMENTS_SERVICE_SLUG', 'service' );
}

if ( ! defined( 'VIBE_APPOINTMENTS_PLUGIN_DIR' ) ) {
    define( 'VIBE_APPOINTMENTS_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
}



include_once 'includes/appointments.component.php';
add_action('plugins_loaded',function(){
    if(defined('Vibe_BP_API_NAMESPACE')){

        include_once 'includes/admin/class.admin.php';
        include_once 'includes/admin/class.settings.php';
        //include_once 'includes/admin/class.widgets.php';
        include_once 'includes/services/class.init.php';
        include_once 'includes/db/db.php';
        include_once 'includes/db/class.appointments-db.php';
        include_once 'includes/db/class.appointments-meta-db.php';
        include_once 'includes/functions.php';
        include_once 'includes/meetings/class.bbb-api.php';
        include_once 'includes/meetings/class.meetings.php';


        include_once 'includes/api/api.appointments.php';
        include_once 'includes/api/api.booking.php';
        include_once 'includes/api/api.appointments.new.php';
        include_once 'includes/api/api.classes.php';

        include_once 'includes/class.init.php';

        include_once 'includes/actions.php';
        include_once 'includes/filters.php';

        include_once 'includes/activity.php';
        include_once 'includes/admin/blocks.php';
        include_once 'includes/class.touchpoints.php';
        
        
        include_once 'includes/class.scheduler.php';
        include_once 'includes/class.shortcodes.php';
    }

});


add_action('plugins_loaded','vibe_appointments_translations');
function vibe_appointments_translations(){
    $locale = apply_filters("plugin_locale", get_locale(), 'vibe-appointments');
    $lang_dir = dirname( __FILE__ ) . '/languages/';
    $mofile        = sprintf( '%1$s-%2$s.mo', 'vibe-appointments', $locale );
    $mofile_local  = $lang_dir . $mofile;
    $mofile_global = WP_LANG_DIR . '/plugins/' . $mofile;

    if ( file_exists( $mofile_global ) ) {
        load_textdomain( 'vibe-appointments', $mofile_global );
    } else {
        load_textdomain( 'vibe-appointments', $mofile_local );
    }  
}



//UPDATER
function Vibe_Appointments_Plugin_updater() {
    
    $purchase_code = trim( get_option('item_purchase_code'));
    if(!empty($purchase_code)){
        require_once( trailingslashit( plugin_dir_path( __FILE__ ) ) . 'includes/config/autoupdate.php' );

        /* Updater Config */
        $config = array(
            'base'      => plugin_basename( __FILE__ ), //required
            'dashboard' => true,
            'repo_uri'  => 'https://wpappointify.com/',  //required
            'repo_slug' => 'vibe-appointments',  //required
        );

        /* Load Updater Class */
        new Vibe_Appointments_Auto_Update( $config );
    }else{
        $license_key = trim( get_option( 'vibe_appointments_license_key' ) );
       // if(!empty($license_key)){
            include_once 'includes/config/class.config.php';
            include_once 'includes/config/class.updater.php';
            $edd_updater = new Vibe_Appointments_Plugin_updater( APPOINTMENTS_UPDATE_URL, __FILE__, array(
                    'version'   => VIBE_APPOINTMENTS_VERSION,               
                    'license'   => $license_key,        
                    'item_id' => APPOINTMENTS_UPDATE_ITEM_ID,    
                    'author'    => 'VibeThemes' 
                )
            );
        //}
    }
}
add_action( 'admin_init', 'Vibe_Appointments_Plugin_updater', 0 );


